/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.value.DfaInstanceofValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ExpressionTypeMemoryState
extends DfaMemoryStateImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.guess.impl.ExpressionTypeMemoryState");
    public static final TObjectHashingStrategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new TObjectHashingStrategy<PsiExpression>(){

        public int computeHashCode(PsiExpression object) {
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent(o1, o2)) {
                if (this.computeHashCode(o1) != this.computeHashCode(o2)) {
                    LOG.error("different hashCodes: " + o1 + "; " + o2 + "; " + this.computeHashCode(o1) + "!=" + this.computeHashCode(o2));
                }
                return true;
            }
            return false;
        }
    };
    private final Map<PsiExpression, PsiType> myStates = new THashMap(EXPRESSION_HASHING_STRATEGY);

    public ExpressionTypeMemoryState(DfaValueFactory factory) {
        super(factory);
    }

    private ExpressionTypeMemoryState(DfaMemoryStateImpl toCopy) {
        super(toCopy);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        ExpressionTypeMemoryState copy = new ExpressionTypeMemoryState(this);
        copy.myStates.putAll(this.myStates);
        ExpressionTypeMemoryState expressionTypeMemoryState = copy;
        if (expressionTypeMemoryState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState", "createCopy"));
        }
        return expressionTypeMemoryState;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        DfaInstanceofValue value;
        if (dfaCond instanceof DfaInstanceofValue && !(value = (DfaInstanceofValue)dfaCond).isNegated()) {
            this.setExpressionType(value.getExpression(), value.getCastType());
        }
        return super.applyCondition(dfaCond);
    }

    public Map<PsiExpression, PsiType> getStates() {
        return this.myStates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpressionTypeMemoryState that = (ExpressionTypeMemoryState)o;
        return this.myStates.equals(that.myStates);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStates.hashCode();
        return result2;
    }

    @Override
    public String toString() {
        return super.toString() + " states=[" + new HashMap(this.myStates) + "]";
    }

    public void setExpressionType(PsiExpression expression, @NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/guess/impl/ExpressionTypeMemoryState", "setExpressionType"));
        }
        PsiType prev = this.myStates.get(expression);
        if (prev == null || !type.isAssignableFrom(prev)) {
            this.myStates.put(expression, type);
        }
    }
}

