/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterInLineCommentHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        CodeDocumentationAwareCommenter commenter;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "preprocessEnter"));
        }
        Language language = EnterHandler.getLanguage(dataContext);
        if (language == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Commenter languageCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        CodeDocumentationAwareCommenter codeDocumentationAwareCommenter = commenter = languageCommenter instanceof CodeDocumentationAwareCommenter ? (CodeDocumentationAwareCommenter)languageCommenter : null;
        if (commenter == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        if (EnterInLineCommentHandler.isInLineComment(editor, caretOffset, commenter.getLineCommentTokenType())) {
            String text;
            int offset;
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
            PsiElement psiAtOffset = file2.findElementAt(caretOffset);
            if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset && (offset = CharArrayUtil.shiftForward((CharSequence)(text = document.getText()), (int)caretOffset, (String)" \t")) < document.getTextLength() && text.charAt(offset) != '\n') {
                String prefix = commenter.getLineCommentPrefix();
                assert (prefix != null) : "Line Comment type is set but Line Comment Prefix is null!";
                if (!StringUtil.startsWith((CharSequence)text, (int)offset, (CharSequence)prefix)) {
                    if (text.charAt(caretOffset) != ' ' && !prefix.endsWith(" ")) {
                        prefix = prefix + " ";
                    }
                    document.insertString(caretOffset, (CharSequence)prefix);
                    return EnterHandlerDelegate.Result.Default;
                }
                int afterPrefix = offset + prefix.length();
                if (afterPrefix < document.getTextLength() && text.charAt(afterPrefix) != ' ') {
                    document.insertString(afterPrefix, (CharSequence)" ");
                }
                caretOffsetRef.set((Object)offset);
                return EnterHandlerDelegate.Result.Default;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isInLineComment(@NotNull Editor editor, int offset, IElementType lineCommentType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/EnterInLineCommentHandler", "isInLineComment"));
        }
        if (offset < 1) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        return iterator.getTokenType() == lineCommentType;
    }
}

