/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapExpressionFix
implements IntentionAction {
    private final PsiExpression myExpression;
    private final PsiClassType myExpectedType;
    private final boolean myPrimitiveExpected;

    public WrapExpressionFix(@NotNull PsiType expectedType, @NotNull PsiExpression expression) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "<init>"));
        }
        this.myExpression = expression;
        this.myExpectedType = WrapExpressionFix.getClassType(expectedType, (PsiElement)expression);
        this.myPrimitiveExpected = expectedType instanceof PsiPrimitiveType;
    }

    @Nullable
    private static PsiClassType getClassType(PsiType type, PsiElement place) {
        if (type instanceof PsiClassType) {
            return (PsiClassType)type;
        }
        if (type instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type).getBoxedType(place.getManager(), GlobalSearchScope.allScope((Project)place.getProject()));
        }
        return null;
    }

    @NotNull
    public String getText() {
        PsiType type = this.myExpression.getType();
        PsiMethod wrapper = this.myExpression.isValid() && this.myExpectedType != null && type != null ? WrapExpressionFix.findWrapper(type, this.myExpectedType, this.myPrimitiveExpected) : null;
        String methodPresentation = wrapper != null ? wrapper.getContainingClass().getName() + "." + wrapper.getName() : "";
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.text", methodPresentation);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "getText"));
        }
        return string;
    }

    @Nullable
    private static PsiMethod findWrapper(@NotNull PsiType type, @NotNull PsiClassType expectedType, boolean primitiveExpected) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "findWrapper"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "findWrapper"));
        }
        PsiClass aClass = expectedType.resolve();
        if (aClass != null) {
            PsiClassType expectedReturnType = expectedType;
            if (primitiveExpected) {
                expectedReturnType = PsiPrimitiveType.getUnboxedType((PsiType)expectedType);
            }
            if (expectedReturnType == null) {
                return null;
            }
            PsiMethod[] methods = aClass.getMethods();
            LinkedHashSet<PsiMethod> wrapperMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod method2 : methods) {
                if (!method2.hasModifierProperty("static") || method2.getParameterList().getParametersCount() != 1 || !method2.getParameterList().getParameters()[0].getType().isAssignableFrom(type) || method2.getReturnType() == null || !expectedReturnType.equals(method2.getReturnType())) continue;
                String methodName = method2.getName();
                if (methodName.startsWith("parse") || methodName.equals("valueOf")) {
                    return method2;
                }
                wrapperMethods.add(method2);
            }
            if (!wrapperMethods.isEmpty()) {
                return (PsiMethod)wrapperMethods.iterator().next();
            }
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.expression.using.static.accessor.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "isAvailable"));
        }
        return this.myExpression.isValid() && this.myExpression.getManager().isInProject((PsiElement)this.myExpression) && this.myExpectedType != null && this.myExpectedType.isValid() && this.myExpression.getType() != null && WrapExpressionFix.findWrapper(this.myExpression.getType(), this.myExpectedType, this.myPrimitiveExpected) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapExpressionFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiType type = this.myExpression.getType();
        assert (type != null);
        PsiMethod wrapper = WrapExpressionFix.findWrapper(type, this.myExpectedType, this.myPrimitiveExpected);
        assert (wrapper != null);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory();
        String methodCallText = "Foo." + wrapper.getName() + "()";
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
        call.getArgumentList().add((PsiElement)this.myExpression);
        ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)wrapper.getContainingClass());
        this.myExpression.replace((PsiElement)call);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void registerWrapAction(JavaResolveResult[] candidates, PsiExpression[] expressions, HighlightInfo highlightInfo) {
        PsiType expectedType = null;
        PsiExpression expr = null;
        block0: for (int i2 = 0; i2 < candidates.length && expectedType == null; ++i2) {
            JavaResolveResult candidate = candidates[i2];
            PsiSubstitutor substitutor = candidate.getSubstitutor();
            PsiElement element = candidate.getElement();
            assert (element != null);
            PsiMethod method2 = (PsiMethod)element;
            PsiParameter[] parameters = method2.getParameterList().getParameters();
            if (!method2.isVarArgs() && parameters.length != expressions.length) continue;
            for (int j = 0; j < expressions.length; ++j) {
                PsiExpression expression = expressions[j];
                PsiType exprType = expression.getType();
                if (exprType == null) continue;
                PsiType paramType = parameters[Math.min(j, parameters.length - 1)].getType();
                if (paramType instanceof PsiEllipsisType) {
                    paramType = ((PsiEllipsisType)paramType).getComponentType();
                }
                PsiType psiType = paramType = substitutor != null ? substitutor.substitute(paramType) : paramType;
                if (paramType.isAssignableFrom(exprType)) continue;
                PsiClassType classType = WrapExpressionFix.getClassType(paramType, (PsiElement)expression);
                if (expectedType == null && classType != null && WrapExpressionFix.findWrapper(exprType, classType, paramType instanceof PsiPrimitiveType) != null) {
                    expectedType = paramType;
                    expr = expression;
                    continue;
                }
                expectedType = null;
                expr = null;
                continue block0;
            }
        }
        if (expectedType != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, expr.getTextRange(), new WrapExpressionFix(expectedType, expr));
        }
    }
}

