/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceIteratorForEachLoopWithIteratorForLoopFix
implements IntentionAction {
    private final PsiForeachStatement myStatement;

    public ReplaceIteratorForEachLoopWithIteratorForLoopFix(@NotNull PsiForeachStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix", "<init>"));
        }
        this.myStatement = statement2;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Replace 'for each' loop with iterator 'for' loop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix", "getFamilyName"));
        }
        return "Replace 'for each' loop with iterator 'for' loop";
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix", "isAvailable"));
        }
        return this.myStatement.isValid() && this.myStatement.getManager().isInProject((PsiElement)this.myStatement);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiModifierList modifierList;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceIteratorForEachLoopWithIteratorForLoopFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiExpression iteratedValue = this.myStatement.getIteratedValue();
        if (iteratedValue == null) {
            return;
        }
        PsiType iteratedValueType = iteratedValue.getType();
        if (iteratedValueType == null) {
            return;
        }
        PsiParameter iterationParameter = this.myStatement.getIterationParameter();
        String iterationParameterName = iterationParameter.getName();
        if (iterationParameterName == null) {
            return;
        }
        PsiStatement forEachBody = this.myStatement.getBody();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String name = javaStyleManager.suggestUniqueVariableName("it", (PsiElement)this.myStatement, true);
        PsiForStatement newForLoop = (PsiForStatement)elementFactory.createStatementFromText("for (Iterator " + name + " = initializer; " + name + ".hasNext();) { Object next = " + name + ".next(); }", (PsiElement)this.myStatement);
        PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)newForLoop.getInitialization();
        if (newDeclaration == null) {
            return;
        }
        PsiLocalVariable newIteratorVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
        PsiTypeElement newIteratorTypeElement = elementFactory.createTypeElement(iteratedValueType);
        newIteratorVariable.getTypeElement().replace((PsiElement)newIteratorTypeElement);
        newIteratorVariable.setInitializer(iteratedValue);
        PsiBlockStatement newBody = (PsiBlockStatement)newForLoop.getBody();
        if (newBody == null) {
            return;
        }
        PsiCodeBlock newBodyBlock = newBody.getCodeBlock();
        PsiDeclarationStatement newFirstStatement = (PsiDeclarationStatement)newBodyBlock.getStatements()[0];
        PsiLocalVariable newItemVariable = (PsiLocalVariable)newFirstStatement.getDeclaredElements()[0];
        PsiTypeElement newItemTypeElement = elementFactory.createTypeElement(iterationParameter.getType());
        newItemVariable.getTypeElement().replace((PsiElement)newItemTypeElement);
        newItemVariable.setName(iterationParameterName);
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
        if (codeStyleSettings.GENERATE_FINAL_LOCALS && (modifierList = newItemVariable.getModifierList()) != null) {
            modifierList.setModifierProperty("final", true);
        }
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project2);
        newForLoop = (PsiForStatement)javaStyleManager.shortenClassReferences((PsiElement)newForLoop);
        newForLoop = (PsiForStatement)styleManager.reformat((PsiElement)newForLoop);
        if (forEachBody instanceof PsiBlockStatement) {
            PsiCodeBlock bodyCodeBlock = ((PsiBlockStatement)forEachBody).getCodeBlock();
            PsiElement firstBodyElement = bodyCodeBlock.getFirstBodyElement();
            PsiElement lastBodyElement = bodyCodeBlock.getLastBodyElement();
            if (firstBodyElement != null && lastBodyElement != null) {
                newBodyBlock.addRangeAfter(firstBodyElement, lastBodyElement, (PsiElement)newFirstStatement);
            }
        } else if (forEachBody != null && !(forEachBody instanceof PsiEmptyStatement)) {
            newBodyBlock.addAfter((PsiElement)forEachBody, (PsiElement)newFirstStatement);
        }
        this.myStatement.replace((PsiElement)newForLoop);
    }
}

