/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFix");
    private final PsiType myParameterType;
    private final int myIndex;
    private final boolean myFixWholeHierarchy;
    private final String myName;

    public MethodParameterFix(PsiMethod method2, PsiType type, int index, boolean fixWholeHierarchy) {
        super((PsiElement)method2);
        this.myParameterType = type;
        this.myIndex = index;
        this.myFixWholeHierarchy = fixWholeHierarchy;
        this.myName = method2.getName();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("fix.parameter.type.text", this.myName, this.myParameterType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.parameter.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "isAvailable"));
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        return myMethod.isValid() && myMethod.getManager().isInProject((PsiElement)myMethod) && this.myParameterType != null && !TypeConversionUtil.isNullType((PsiType)this.myParameterType) && myMethod.getReturnType() != null && !Comparing.equal((Object)this.myParameterType, (Object)myMethod.getReturnType());
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MethodParameterFix", "invoke"));
        }
        PsiMethod myMethod = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myMethod.getContainingFile())) {
            return;
        }
        try {
            PsiMethod method2 = myMethod;
            if (this.myFixWholeHierarchy && (method2 = myMethod.findDeepestSuperMethod()) == null) {
                method2 = myMethod;
            }
            PsiMethod finalMethod = method2;
            ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project2, finalMethod, false, null, finalMethod.getName(), finalMethod.getReturnType(), this.getNewParametersInfo(finalMethod));
            processor2.run();
            UndoUtil.markPsiFileForUndo((PsiFile)file2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private ParameterInfoImpl[] getNewParametersInfo(PsiMethod method2) throws IncorrectOperationException {
        ArrayList<ParameterInfoImpl> result2 = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters = method2.getParameterList().getParameters();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method2.getProject()).getElementFactory();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)method2.getProject());
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, this.myParameterType);
        PsiParameter newParameter = factory.createParameter(nameInfo.names[0], this.myParameterType);
        if (method2.getContainingClass().isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)newParameter, (String)"final", (boolean)false);
        }
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            PsiParameter parameter = parameters[i2];
            if (i2 == this.myIndex) {
                newParameter.setName(parameter.getName());
                parameter = newParameter;
            }
            result2.add(new ParameterInfoImpl(i2, parameter.getName(), parameter.getType()));
        }
        if (parameters.length == this.myIndex) {
            result2.add(new ParameterInfoImpl(-1, newParameter.getName(), newParameter.getType()));
        }
        return result2.toArray(new ParameterInfoImpl[result2.size()]);
    }
}

