/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoToSymbolFix
implements IntentionAction {
    private final SmartPsiElementPointer<NavigatablePsiElement> myPointer;
    private final String myMessage;

    public GoToSymbolFix(@NotNull NavigatablePsiElement symbol, @NotNull @Nls String message) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance((Project)symbol.getProject()).createSmartPsiElementPointer((PsiElement)symbol);
        this.myMessage = message;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "isAvailable"));
        }
        return this.myPointer.getElement() != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "invoke"));
        }
        NavigatablePsiElement e = (NavigatablePsiElement)this.myPointer.getElement();
        if (e != null && e.isValid()) {
            e.navigate(true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

