/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefineParamsDefaultValueAction
extends PsiElementBaseIntentionAction
implements Iconable,
LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(DefineParamsDefaultValueAction.class);

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Generate overloaded method with default parameter values" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction", "getFamilyName"));
        }
        return "Generate overloaded method with default parameter values";
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.RefactoringBulb;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction", "isAvailable"));
        }
        if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiCodeBlock.class});
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)parent;
        PsiParameterList parameterList = method2.getParameterList();
        if (parameterList.getParametersCount() == 0) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null || containingClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)method2)) {
            return false;
        }
        this.setText("Generate overloaded " + (method2.isConstructor() ? "constructor" : "method") + " with default parameter values");
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction", "invoke"));
        }
        PsiParameter[] parameters = this.getParams(element);
        if (parameters == null || parameters.length == 0) {
            return;
        }
        PsiMethod method2 = (PsiMethod)parameters[0].getDeclarationScope();
        PsiMethod methodPrototype = DefineParamsDefaultValueAction.generateMethodPrototype(method2, parameters);
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiMethod existingMethod = containingClass.findMethodBySignature(methodPrototype, false);
        if (existingMethod != null) {
            editor.getCaretModel().moveToOffset(existingMethod.getTextOffset());
            HintManager.getInstance().showErrorHint(editor, (existingMethod.isConstructor() ? "Constructor" : "Method") + " with the chosen signature already exists");
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        Runnable runnable2 = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DefineParamsDefaultValueAction", "lambda$invoke$1"));
            }
            PsiMethod prototype = (PsiMethod)containingClass.addBefore((PsiElement)methodPrototype, (PsiElement)method2);
            RefactoringUtil.fixJavadocsForParams(prototype, new HashSet<PsiParameter>(Arrays.asList(prototype.getParameterList().getParameters())));
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)prototype);
            PsiCodeBlock body = prototype.getBody();
            String callArgs = "(" + StringUtil.join((Object[])method2.getParameterList().getParameters(), psiParameter -> {
                if (ArrayUtil.find((Object[])parameters, (Object)psiParameter) > -1) {
                    return "IntelliJIDEARulezzz";
                }
                return psiParameter.getName();
            }, (String)",") + ");";
            String methodCall = method2.getReturnType() == null ? "this" : (!PsiType.VOID.equals((Object)method2.getReturnType()) ? "return " + method2.getName() : method2.getName());
            LOG.assertTrue(body != null);
            body.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createStatementFromText(methodCall + callArgs, (PsiElement)method2));
            body = (PsiCodeBlock)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)body);
            PsiStatement stmt = body.getStatements()[0];
            PsiExpression expr = null;
            if (stmt instanceof PsiReturnStatement) {
                expr = ((PsiReturnStatement)stmt).getReturnValue();
            } else if (stmt instanceof PsiExpressionStatement) {
                expr = ((PsiExpressionStatement)stmt).getExpression();
            }
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExp = (PsiMethodCallExpression)expr;
                RangeMarker rangeMarker = editor.getDocument().createRangeMarker(prototype.getTextRange());
                for (PsiParameter parameter : parameters) {
                    PsiExpression exprToBeDefault = methodCallExp.getArgumentList().getExpressions()[method2.getParameterList().getParameterIndex(parameter)];
                    builder.replaceElement((PsiElement)exprToBeDefault, (Expression)new TextExpression(""));
                }
                Template template = builder.buildTemplate();
                editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
                PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                editor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
                rangeMarker.dispose();
                CreateFromUsageBaseFix.startTemplate(editor, template, project2);
            }
        };
        if (this.startInWriteAction()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable2);
        }
    }

    @Nullable
    protected PsiParameter[] getParams(PsiElement element) {
        List elements;
        int idx;
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        assert (method2 != null);
        Object[] parameters = method2.getParameterList().getParameters();
        if (parameters.length == 1) {
            return parameters;
        }
        ClassMember[] members = new ParameterClassMember[parameters.length];
        for (int i2 = 0; i2 < members.length; ++i2) {
            members[i2] = new ParameterClassMember(parameters[i2]);
        }
        PsiParameter selectedParam = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        int n = idx = selectedParam != null ? ArrayUtil.find((Object[])parameters, (Object)selectedParam) : -1;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiParameter[] psiParameterArray;
            if (idx >= 0) {
                PsiParameter[] psiParameterArray2 = new PsiParameter[1];
                psiParameterArray = psiParameterArray2;
                psiParameterArray2[0] = selectedParam;
            } else {
                psiParameterArray = null;
            }
            return psiParameterArray;
        }
        MemberChooser chooser = new MemberChooser(members, false, true, element.getProject());
        if (idx >= 0) {
            chooser.selectElements(new ClassMember[]{members[idx]});
        } else {
            chooser.selectElements(members);
        }
        chooser.setTitle("Choose Default Value Parameters");
        chooser.setCopyJavadocVisible(false);
        if (chooser.showAndGet() && (elements = chooser.getSelectedElements()) != null) {
            PsiParameter[] params = new PsiParameter[elements.size()];
            for (int i3 = 0; i3 < params.length; ++i3) {
                params[i3] = ((ParameterClassMember)elements.get(i3)).getParameter();
            }
            return params;
        }
        return null;
    }

    private static PsiMethod generateMethodPrototype(PsiMethod method2, PsiParameter ... params) {
        PsiMethod prototype = (PsiMethod)method2.copy();
        PsiCodeBlock body = prototype.getBody();
        PsiCodeBlock emptyBody = JavaPsiFacade.getElementFactory((Project)method2.getProject()).createMethodFromText("void foo(){}", (PsiElement)prototype).getBody();
        assert (emptyBody != null);
        if (body != null) {
            body.replace((PsiElement)emptyBody);
        } else {
            prototype.getModifierList().setModifierProperty("abstract", false);
            prototype.addBefore((PsiElement)emptyBody, null);
        }
        PsiClass aClass = method2.getContainingClass();
        if (aClass != null && aClass.isInterface() && !method2.hasModifierProperty("static")) {
            prototype.getModifierList().setModifierProperty("default", true);
        }
        PsiParameterList parameterList = method2.getParameterList();
        Arrays.sort(params, (p1, p2) -> {
            int parameterIndex2;
            int parameterIndex1 = parameterList.getParameterIndex(p1);
            return parameterIndex1 > (parameterIndex2 = parameterList.getParameterIndex(p2)) ? -1 : 1;
        });
        for (PsiParameter param : params) {
            int parameterIndex = parameterList.getParameterIndex(param);
            prototype.getParameterList().getParameters()[parameterIndex].delete();
        }
        return prototype;
    }
}

