/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.AddOrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddExternalLibraryToDependenciesQuickFix
extends AddOrderEntryFix {
    private final Module myCurrentModule;
    private final ExternalLibraryDescriptor myLibraryDescriptor;
    private final String myQualifiedClassName;

    public AddExternalLibraryToDependenciesQuickFix(@NotNull Module currentModule, @NotNull ExternalLibraryDescriptor libraryDescriptor, @NotNull PsiReference reference, @Nullable String qualifiedClassName) {
        if (currentModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "<init>"));
        }
        if (libraryDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescriptor", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "<init>"));
        }
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibraryDescriptor = libraryDescriptor;
        this.myQualifiedClassName = qualifiedClassName;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = "Add '" + this.myLibraryDescriptor.getPresentableName() + "' to classpath";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "isAvailable"));
        }
        return !project2.isDisposed() && !this.myCurrentModule.isDisposed();
    }

    public void invoke(@NotNull Project project2, final Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix", "invoke"));
        }
        DependencyScope scope = AddExternalLibraryToDependenciesQuickFix.suggestScopeByLocation(this.myCurrentModule, this.myReference.getElement());
        JavaProjectModelModificationService.getInstance(project2).addDependency(this.myCurrentModule, this.myLibraryDescriptor, scope).done(aVoid -> new WriteAction(){

            protected void run(@NotNull Result result2) {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/AddExternalLibraryToDependenciesQuickFix$1", "run"));
                }
                OrderEntryFix.importClass(AddExternalLibraryToDependenciesQuickFix.this.myCurrentModule, editor, AddExternalLibraryToDependenciesQuickFix.this.myReference, AddExternalLibraryToDependenciesQuickFix.this.myQualifiedClassName);
            }
        }.execute());
    }
}

