/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightRangeExtension;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.CustomHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralHighlightingPass
extends ProgressableTextEditorHighlightingPass
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass");
    private static final String PRESENTABLE_NAME = DaemonBundle.message((String)"pass.syntax", (Object[])new Object[0]);
    private static final Key<Boolean> HAS_ERROR_ELEMENT = Key.create((String)"HAS_ERROR_ELEMENT");
    static final Condition<PsiFile> SHOULD_HIGHLIGHT_FILTER = file2 -> HighlightingLevelManager.getInstance(file2.getProject()).shouldHighlight((PsiElement)file2);
    private static final Random RESTART_DAEMON_RANDOM = new Random();
    final boolean myUpdateAll;
    final ProperTextRange myPriorityRange;
    final List<HighlightInfo> myHighlights;
    protected volatile boolean myHasErrorElement;
    private volatile boolean myErrorFound;
    final EditorColorsScheme myGlobalScheme;
    private volatile NotNullProducer<HighlightVisitor[]> myHighlightVisitorProducer;
    private static final Key<AtomicInteger> HIGHLIGHT_VISITOR_INSTANCE_COUNT = new Key("HIGHLIGHT_VISITOR_INSTANCE_COUNT");
    private static final int POST_UPDATE_ALL = 5;

    public GeneralHighlightingPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "<init>"));
        }
        super(project2, document, PRESENTABLE_NAME, file2, editor, TextRange.create((int)startOffset, (int)endOffset), true, highlightInfoProcessor);
        this.myHighlights = new ArrayList<HighlightInfo>();
        this.myHighlightVisitorProducer = this::cloneHighlightVisitors;
        this.myUpdateAll = updateAll;
        this.myPriorityRange = priorityRange;
        PsiUtilCore.ensureValid((PsiElement)file2);
        boolean wholeFileHighlighting = this.isWholeFileHighlighting();
        this.myHasErrorElement = !wholeFileHighlighting && Boolean.TRUE.equals(this.getFile().getUserData(HAS_ERROR_ELEMENT));
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        this.myErrorFound = !wholeFileHighlighting && fileStatusMap.wasErrorFound(this.getDocument());
        this.setProgressLimit(document.getTextLength() / 2);
        this.myGlobalScheme = editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = super.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getDocument"));
        }
        return document;
    }

    @NotNull
    private HighlightVisitor[] cloneHighlightVisitors() {
        int oldCount = this.incVisitorUsageCount(1);
        HighlightVisitor[] highlightVisitors = (HighlightVisitor[])Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject);
        if (oldCount != 0) {
            HighlightVisitor[] clones = new HighlightVisitor[highlightVisitors.length];
            for (int i2 = 0; i2 < highlightVisitors.length; ++i2) {
                HighlightVisitor highlightVisitor = highlightVisitors[i2];
                HighlightVisitor cloned = highlightVisitor.clone();
                assert (cloned.getClass() == highlightVisitor.getClass()) : highlightVisitor.getClass() + ".clone() must return a copy of " + highlightVisitor.getClass() + "; but got: " + cloned + " of " + cloned.getClass();
                clones[i2] = cloned;
            }
            highlightVisitors = clones;
        }
        if (highlightVisitors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cloneHighlightVisitors"));
        }
        return highlightVisitors;
    }

    @NotNull
    private HighlightVisitor[] filterVisitors(@NotNull HighlightVisitor[] highlightVisitors, @NotNull PsiFile psiFile) {
        if (highlightVisitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightVisitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        ArrayList<HighlightVisitor> visitors = new ArrayList<HighlightVisitor>(highlightVisitors.length);
        List<HighlightVisitor> list = Arrays.asList(highlightVisitors);
        for (HighlightVisitor visitor : DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(list)) {
            if (visitor instanceof RainbowVisitor && !RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)this.getColorsScheme(), psiFile.getLanguage()) || !visitor.suitableForFile(psiFile)) continue;
            visitors.add(visitor);
        }
        if (visitors.isEmpty()) {
            LOG.error("No visitors registered. list=" + list + "; all visitors are:" + Arrays.asList(Extensions.getExtensions(HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)this.myProject)));
        }
        HighlightVisitor[] highlightVisitorArray = visitors.toArray(new HighlightVisitor[visitors.size()]);
        if (highlightVisitorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "filterVisitors"));
        }
        return highlightVisitorArray;
    }

    void setHighlightVisitorProducer(@NotNull NotNullProducer<HighlightVisitor[]> highlightVisitorProducer) {
        if (highlightVisitorProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightVisitorProducer", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "setHighlightVisitorProducer"));
        }
        this.myHighlightVisitorProducer = highlightVisitorProducer;
    }

    @NotNull
    HighlightVisitor[] getHighlightVisitors(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getHighlightVisitors"));
        }
        HighlightVisitor[] highlightVisitorArray = this.filterVisitors((HighlightVisitor[])this.myHighlightVisitorProducer.produce(), psiFile);
        if (highlightVisitorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getHighlightVisitors"));
        }
        return highlightVisitorArray;
    }

    int incVisitorUsageCount(int delta) {
        AtomicInteger count = (AtomicInteger)this.myProject.getUserData(HIGHLIGHT_VISITOR_INSTANCE_COUNT);
        if (count == null) {
            count = (AtomicInteger)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(HIGHLIGHT_VISITOR_INSTANCE_COUNT, (Object)new AtomicInteger(0));
        }
        int old = count.getAndAdd(delta);
        assert (old + delta >= 0) : old + ";" + delta;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectInformationWithProgress"));
        }
        ArrayList<HighlightInfo> outsideResult = new ArrayList<HighlightInfo>(100);
        ArrayList<HighlightInfo> insideResult = new ArrayList<HighlightInfo>(100);
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        HighlightVisitor[] filteredVisitors = this.getHighlightVisitors(this.getFile());
        try {
            boolean success;
            ArrayList dividedElements = new ArrayList();
            Divider.divideInsideAndOutsideAllRoots(this.getFile(), this.myRestrictRange, (TextRange)this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, (Processor<Divider.DividedElements>)new CommonProcessors.CollectProcessor(dividedElements));
            List allInsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<PsiElement> inside = dividedForRoot.inside;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? inside.subList(0, inside.size() - 1) : inside;
            }));
            List allInsideRanges = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List<ProperTextRange> insideRanges = dividedForRoot.insideRanges;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? insideRanges.subList(0, insideRanges.size() - 1) : insideRanges;
            }));
            List allOutsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List outside = dividedForRoot.outside;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outside, (Object[])new PsiElement[]{lastInside}) : outside;
            }));
            List allOutsideRanges = ContainerUtil.concat((Iterable)ContainerUtil.map(dividedElements, dividedForRoot -> {
                List outsideRanges = dividedForRoot.outsideRanges;
                PsiElement lastInside = (PsiElement)ContainerUtil.getLastItem(dividedForRoot.inside);
                ProperTextRange lastInsideRange = (ProperTextRange)ContainerUtil.getLastItem(dividedForRoot.insideRanges);
                return lastInside instanceof PsiFile && !(lastInside instanceof PsiCodeFragment) ? ContainerUtil.append(outsideRanges, (Object[])new ProperTextRange[]{lastInsideRange}) : outsideRanges;
            }));
            this.setProgressLimit(allInsideElements.size() + allOutsideElements.size());
            boolean forceHighlightParents = this.forceHighlightParents();
            if (!this.isDumbMode()) {
                GeneralHighlightingPass.highlightTodos(this.getFile(), this.getDocument().getCharsSequence(), this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), progress, this.myPriorityRange, insideResult, outsideResult);
            }
            if (success = this.collectHighlights(allInsideElements, allInsideRanges, allOutsideElements, allOutsideRanges, progress, filteredVisitors, insideResult, outsideResult, forceHighlightParents)) {
                this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, outsideResult, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
                if (this.myUpdateAll) {
                    daemonCodeAnalyzer.getFileStatusMap().setErrorFoundFlag(this.myProject, this.getDocument(), this.myErrorFound);
                }
            } else {
                GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject);
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
            this.myHighlights.addAll(insideResult);
            this.myHighlights.addAll(outsideResult);
        }
    }

    boolean isFailFastOnAcquireReadAction() {
        return true;
    }

    private boolean isWholeFileHighlighting() {
        return this.myUpdateAll && this.myRestrictRange.equalsToRange(0, this.getDocument().getTextLength());
    }

    @Override
    protected void applyInformationWithProgress() {
        this.getFile().putUserData(HAS_ERROR_ELEMENT, (Object)this.myHasErrorElement);
        if (this.myUpdateAll) {
            this.reportErrorsToWolf();
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        ArrayList<HighlightInfo> arrayList = new ArrayList<HighlightInfo>(this.myHighlights);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "getInfos"));
        }
        return arrayList;
    }

    private boolean collectHighlights(@NotNull List<PsiElement> elements1, @NotNull List<ProperTextRange> ranges1, @NotNull List<PsiElement> elements2, @NotNull List<ProperTextRange> ranges2, @NotNull ProgressIndicator progress, @NotNull HighlightVisitor[] visitors, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents) {
        if (elements1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (ranges1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "collectHighlights"));
        }
        THashSet skipParentsSet = new THashSet();
        HighlightInfoHolder holder = this.createInfoHolder(this.getFile());
        int chunkSize = Math.max(1, (elements1.size() + elements2.size()) / 100);
        boolean success = this.analyzeByVisitors(visitors, holder, 0, () -> this.lambda$collectHighlights$5(elements1, ranges1, chunkSize, progress, (Set)skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors, elements2, ranges2));
        ArrayList<HighlightInfo> postInfos = new ArrayList<HighlightInfo>(holder.size());
        for (int j = 0; j < holder.size(); ++j) {
            HighlightInfo info = holder.get(j);
            assert (info != null);
            postInfos.add(info);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, postInfos, this.getFile().getTextRange(), this.getFile().getTextRange(), 5);
        return success;
    }

    private boolean analyzeByVisitors(@NotNull HighlightVisitor[] visitors, @NotNull HighlightInfoHolder holder, int i2, @NotNull Runnable action) {
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "analyzeByVisitors"));
        }
        boolean[] success = new boolean[]{true};
        if (i2 == visitors.length) {
            action.run();
        } else if (!visitors[i2].analyze(this.getFile(), this.myUpdateAll, holder, () -> {
            if (visitors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$analyzeByVisitors$6"));
            }
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$analyzeByVisitors$6"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$analyzeByVisitors$6"));
            }
            success[0] = this.analyzeByVisitors(visitors, holder, i2 + 1, action);
        })) {
            success[0] = false;
        }
        return success[0];
    }

    private void runVisitors(@NotNull List<PsiElement> elements, @NotNull List<ProperTextRange> ranges, int chunkSize, @NotNull ProgressIndicator progress, @NotNull Set<PsiElement> skipParentsSet, @NotNull HighlightInfoHolder holder, @NotNull List<HighlightInfo> insideResult, @NotNull List<HighlightInfo> outsideResult, boolean forceHighlightParents, @NotNull HighlightVisitor[] visitors) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (skipParentsSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipParentsSet", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "runVisitors"));
        }
        Stack nestedRange = new Stack();
        Stack nestedInfos = new Stack();
        boolean failed = false;
        int nextLimit = chunkSize;
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            PsiElement element = elements.get(i2);
            progress.checkCanceled();
            PsiElement parent = element.getParent();
            if (element != this.getFile() && !skipParentsSet.isEmpty() && element.getFirstChild() != null && skipParentsSet.contains(element)) {
                skipParentsSet.add(parent);
                continue;
            }
            boolean isErrorElement = element instanceof PsiErrorElement;
            if (isErrorElement) {
                this.myHasErrorElement = true;
            }
            for (HighlightVisitor visitor : visitors) {
                try {
                    visitor.visit(element);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!failed) {
                        LOG.error("In file: " + this.myFile.getViewProvider().getVirtualFile(), (Throwable)e);
                    }
                    failed = true;
                }
            }
            if (i2 == nextLimit) {
                this.advanceProgress(chunkSize);
                nextLimit = i2 + chunkSize;
            }
            TextRange elementRange = (TextRange)ranges.get(i2);
            List<HighlightInfo> infosForThisRange = holder.size() == 0 ? null : new ArrayList<HighlightInfo>(holder.size());
            for (int j = 0; j < holder.size(); ++j) {
                boolean isError;
                List<HighlightInfo> result2;
                HighlightInfo info = holder.get(j);
                if (!this.myRestrictRange.containsRange(info.getStartOffset(), info.getEndOffset())) continue;
                List<HighlightInfo> list = result2 = this.myPriorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) && !(element instanceof PsiFile) ? insideResult : outsideResult;
                if (!result2.add(info)) continue;
                boolean bl = isError = info.getSeverity() == HighlightSeverity.ERROR;
                if (isError) {
                    if (!forceHighlightParents) {
                        skipParentsSet.add(parent);
                    }
                    this.myErrorFound = true;
                }
                info.setBijective(elementRange.equalsToRange(info.startOffset, info.endOffset) || isErrorElement);
                this.myHighlightInfoProcessor.infoIsAvailable(this.myHighlightingSession, info, (TextRange)this.myPriorityRange, this.myRestrictRange, 4);
                infosForThisRange.add(info);
            }
            holder.clear();
            while (!nestedRange.isEmpty() && elementRange.contains((TextRange)nestedRange.peek())) {
                TextRange oldRange = (TextRange)nestedRange.pop();
                List oldInfos = (List)nestedInfos.pop();
                if (!elementRange.equals((Object)oldRange)) continue;
                if (infosForThisRange == null) {
                    infosForThisRange = oldInfos;
                    continue;
                }
                if (oldInfos == null) continue;
                infosForThisRange.addAll(oldInfos);
            }
            nestedRange.push((Object)elementRange);
            nestedInfos.push(infosForThisRange);
            if (parent != null && Comparing.equal((Object)elementRange, (Object)parent.getTextRange())) continue;
            this.myHighlightInfoProcessor.allHighlightsForRangeAreProduced(this.myHighlightingSession, elementRange, infosForThisRange);
        }
        this.advanceProgress(elements.size() - (nextLimit - chunkSize));
    }

    private static void cancelAndRestartDaemonLater(@NotNull ProgressIndicator progress, @NotNull Project project2) throws ProcessCanceledException {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "cancelAndRestartDaemonLater"));
        }
        progress.cancel();
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$cancelAndRestartDaemonLater$7"));
            }
            Application application = ApplicationManager.getApplication();
            if (!(project2.isDisposed() || application.isDisposed() || application.isUnitTestMode())) {
                DaemonCodeAnalyzer.getInstance((Project)project2).restart();
            }
        }, (long)RESTART_DAEMON_RANDOM.nextInt(100), TimeUnit.MILLISECONDS);
        throw new ProcessCanceledException();
    }

    private boolean forceHighlightParents() {
        boolean forceHighlightParents = false;
        for (HighlightRangeExtension extension : (HighlightRangeExtension[])Extensions.getExtensions(HighlightRangeExtension.EP_NAME)) {
            if (!extension.isForceHighlightParents(this.getFile())) continue;
            forceHighlightParents = true;
            break;
        }
        return forceHighlightParents;
    }

    protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "createInfoHolder"));
        }
        HighlightInfoFilter[] filters = (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions();
        return new CustomHighlightInfoHolder(file2, this.getColorsScheme(), filters);
    }

    static void highlightTodos(@NotNull PsiFile file2, @NotNull CharSequence text, int startOffset, int endOffset, @NotNull ProgressIndicator progress, @NotNull ProperTextRange priorityRange, @NotNull Collection<HighlightInfo> insideResult, @NotNull Collection<HighlightInfo> outsideResult) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "highlightTodos"));
        }
        PsiTodoSearchHelper helper = PsiTodoSearchHelper.SERVICE.getInstance((Project)file2.getProject());
        if (helper == null) {
            return;
        }
        TodoItem[] todoItems = helper.findTodoItems(file2, startOffset, endOffset);
        if (todoItems.length == 0) {
            return;
        }
        for (TodoItem todoItem : todoItems) {
            progress.checkCanceled();
            TextRange range = todoItem.getTextRange();
            TextAttributes attributes = todoItem.getPattern().getAttributes().getTextAttributes();
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.TODO).range(range);
            builder.textAttributes(attributes);
            String description = text.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
            builder.description(description);
            builder.unescapedToolTip(StringUtil.shortenPathWithEllipsis((String)description, (int)1024));
            HighlightInfo info = builder.createUnconditionally();
            (priorityRange.containsRange(info.getStartOffset(), info.getEndOffset()) ? insideResult : outsideResult).add(info);
        }
    }

    private void reportErrorsToWolf() {
        if (!this.getFile().getViewProvider().isPhysical()) {
            return;
        }
        Project project2 = this.getFile().getProject();
        if (!PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.getFile())) {
            return;
        }
        VirtualFile file2 = this.getFile().getVirtualFile();
        if (file2 == null) {
            return;
        }
        List<Problem> problems = GeneralHighlightingPass.convertToProblems(this.getInfos(), file2, this.myHasErrorElement);
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)project2);
        boolean hasErrors = DaemonCodeAnalyzerEx.hasErrors(project2, this.getDocument());
        if (!hasErrors || this.isWholeFileHighlighting()) {
            wolf.reportProblems(file2, problems);
        } else {
            wolf.weHaveGotProblems(file2, problems);
        }
    }

    @Override
    public double getProgress() {
        return this.myUpdateAll ? super.getProgress() : -1.0;
    }

    private static List<Problem> convertToProblems(@NotNull Collection<HighlightInfo> infos, @NotNull VirtualFile file2, boolean hasErrorElement) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "convertToProblems"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "convertToProblems"));
        }
        SmartList problems = new SmartList();
        for (HighlightInfo info : infos) {
            if (info.getSeverity() != HighlightSeverity.ERROR) continue;
            ProblemImpl problem = new ProblemImpl(file2, info, hasErrorElement);
            problems.add(problem);
        }
        return problems;
    }

    @Override
    public String toString() {
        return super.toString() + " updateAll=" + this.myUpdateAll + " range= " + this.myRestrictRange;
    }

    private /* synthetic */ void lambda$collectHighlights$5(@NotNull List elements1, @NotNull List ranges1, int chunkSize, @NotNull ProgressIndicator progress, Set skipParentsSet, HighlightInfoHolder holder, @NotNull List insideResult, @NotNull List outsideResult, boolean forceHighlightParents, @NotNull HighlightVisitor[] visitors, @NotNull List elements2, @NotNull List ranges2) {
        if (elements1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (ranges1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges1", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (insideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (outsideResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outsideResult", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (visitors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitors", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        if (ranges2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges2", "com/intellij/codeInsight/daemon/impl/GeneralHighlightingPass", "lambda$collectHighlights$5"));
        }
        this.runVisitors(elements1, ranges1, chunkSize, progress, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors);
        ProperTextRange priorityIntersection = this.myPriorityRange.intersection(this.myRestrictRange);
        if (!(elements1.isEmpty() && insideResult.isEmpty() || priorityIntersection == null)) {
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, insideResult, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        }
        this.runVisitors(elements2, ranges2, chunkSize, progress, skipParentsSet, holder, insideResult, outsideResult, forceHighlightParents, visitors);
    }
}

