/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightUtil {
    @Nullable
    public static PsiExpression findExpressionInRange(PsiFile file2, int startOffset, int endOffset) {
        int newEndOffset;
        PsiElement element;
        PsiJavaToken token;
        IElementType tokenType;
        PsiElement element2;
        if (!file2.getViewProvider().getLanguages().contains(StdLanguages.JAVA)) {
            return null;
        }
        PsiExpression expression = CodeInsightUtil.findElementInRange(file2, startOffset, endOffset, PsiExpression.class);
        if (expression == null && CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset).length == 0 && (element2 = file2.getViewProvider().findElementAt(endOffset - 1, StdLanguages.JAVA)) instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)element2).getTokenType()).equals(JavaTokenType.SEMICOLON)) {
            expression = CodeInsightUtil.findElementInRange(file2, startOffset, element2.getTextRange().getStartOffset(), PsiExpression.class);
        }
        if (expression == null && CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset).length == 0 && (element = PsiTreeUtil.skipSiblingsBackward((PsiElement)file2.findElementAt(endOffset), (Class[])new Class[]{PsiWhiteSpace.class})) != null && (element = PsiTreeUtil.skipSiblingsBackward((PsiElement)element.getLastChild(), (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) != null && (newEndOffset = element.getTextRange().getEndOffset()) < endOffset) {
            expression = CodeInsightUtil.findExpressionInRange(file2, startOffset, newEndOffset);
        }
        if (expression instanceof PsiReferenceExpression && expression.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return expression;
    }

    public static <T extends PsiElement> T findElementInRange(PsiFile file2, int startOffset, int endOffset, Class<T> klass) {
        return CodeInsightUtilCore.findElementInRange(file2, startOffset, endOffset, klass, StdLanguages.JAVA);
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(@NotNull PsiFile file2, int startOffset, int endOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
        }
        Language language = CodeInsightUtil.findJavaOrLikeLanguage(file2);
        if (language == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement element1 = viewProvider.findElementAt(startOffset, language);
        PsiElement element2 = viewProvider.findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (parent instanceof PsiStatement) {
                if (element1 instanceof PsiComment) break;
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PsiCodeBlock || FileTypeUtils.isInServerPageFile((PsiElement)parent) && parent instanceof PsiFile || parent instanceof PsiCodeFragment) break;
            if (parent == null || parent instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent instanceof PsiCodeBlock && parent.getParent() instanceof PsiBlockStatement && element1 == ((PsiCodeBlock)parent).getLBrace() && element2 == ((PsiCodeBlock)parent).getRBrace()) {
            PsiElement[] psiElementArray = new PsiElement[]{parent.getParent()};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return psiElementArray;
        }
        PsiElement[] children2 = parent.getChildren();
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children2) {
            if (child.equals(element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals(element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof PsiStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightUtil", "findStatementsInRange"));
        }
        return psiElementArray;
    }

    @Nullable
    public static Language findJavaOrLikeLanguage(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/CodeInsightUtil", "findJavaOrLikeLanguage"));
        }
        Set languages = file2.getViewProvider().getLanguages();
        for (Language language : languages) {
            if (language != StdLanguages.JAVA) continue;
            return language;
        }
        for (Language language : languages) {
            if (!language.isKindOf(StdLanguages.JAVA)) continue;
            return language;
        }
        return null;
    }

    public static <T extends PsiMember & PsiDocCommentOwner> void sortIdenticalShortNamedMembers(T[] members, @NotNull PsiReference context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/CodeInsightUtil", "sortIdenticalShortNamedMembers"));
        }
        if (members.length <= 1) {
            return;
        }
        PsiElement leaf = context.getElement().getFirstChild();
        Comparator<T> comparator2 = CodeInsightUtil.createSortIdenticalNamedMembersComparator(leaf);
        Arrays.sort(members, comparator2);
    }

    public static <T extends PsiMember & PsiDocCommentOwner> Comparator<T> createSortIdenticalNamedMembersComparator(PsiElement place) {
        PsiProximityComparator proximityComparator = new PsiProximityComparator(place);
        return (o1, o2) -> {
            String qname2;
            boolean deprecated1 = JavaCompletionUtil.isEffectivelyDeprecated((PsiDocCommentOwner)o1);
            boolean deprecated2 = JavaCompletionUtil.isEffectivelyDeprecated((PsiDocCommentOwner)o2);
            if (deprecated1 && !deprecated2) {
                return 1;
            }
            if (!deprecated1 && deprecated2) {
                return -1;
            }
            int compare = proximityComparator.compare(o1, o2);
            if (compare != 0) {
                return compare;
            }
            String qname1 = o1 instanceof PsiClass ? ((PsiClass)o1).getQualifiedName() : null;
            String string = qname2 = o2 instanceof PsiClass ? ((PsiClass)o2).getQualifiedName() : null;
            if (qname1 == null || qname2 == null) {
                return 0;
            }
            return qname1.compareToIgnoreCase(qname2);
        };
    }

    public static PsiExpression[] findExpressionOccurrences(PsiElement scope, PsiExpression expr) {
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        CodeInsightUtil.addExpressionOccurrences(RefactoringUtil.unparenthesizeExpression(expr), array, scope);
        if (expr.isPhysical()) {
            boolean found = false;
            for (PsiExpression psiExpression : array) {
                if (!PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)psiExpression, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)psiExpression, (PsiElement)expr, (boolean)false)) continue;
                found = true;
                break;
            }
            if (!found) {
                array.add(expr);
            }
        }
        return array.toArray(new PsiExpression[array.size()]);
    }

    private static void addExpressionOccurrences(PsiExpression expr, List<PsiExpression> array, PsiElement scope) {
        PsiElement[] children2;
        for (PsiElement child : children2 = scope.getChildren()) {
            if (child instanceof PsiExpression && JavaPsiEquivalenceUtil.areExpressionsEquivalent(RefactoringUtil.unparenthesizeExpression((PsiExpression)child), expr)) {
                array.add((PsiExpression)child);
                continue;
            }
            CodeInsightUtil.addExpressionOccurrences(expr, array, child);
        }
    }

    public static PsiExpression[] findReferenceExpressions(PsiElement scope, PsiElement referee) {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (scope != null) {
            CodeInsightUtil.addReferenceExpressions(array, scope, referee);
        }
        return array.toArray(new PsiExpression[array.size()]);
    }

    private static void addReferenceExpressions(ArrayList<PsiElement> array, PsiElement scope, PsiElement referee) {
        PsiElement[] children2;
        for (PsiElement child : children2 = scope.getChildren()) {
            PsiElement ref;
            if (child instanceof PsiReferenceExpression && (ref = ((PsiReferenceExpression)child).resolve()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)ref, (PsiElement)referee)) {
                array.add(child);
            }
            CodeInsightUtil.addReferenceExpressions(array, child, referee);
        }
    }

    public static Editor positionCursorAtLBrace(Project project2, PsiFile targetFile, @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/CodeInsightUtil", "positionCursorAtLBrace"));
        }
        PsiElement lBrace = psiClass.getLBrace();
        return CodeInsightUtil.positionCursor(project2, targetFile, (PsiElement)(lBrace != null ? lBrace : psiClass));
    }

    public static Editor positionCursor(Project project2, PsiFile targetFile, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/CodeInsightUtil", "positionCursor"));
        }
        TextRange range = element.getTextRange();
        int textOffset = range.getStartOffset();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, targetFile.getVirtualFile(), textOffset);
        return FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
    }

    public static boolean preparePsiElementsForWrite(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/CodeInsightUtil", "preparePsiElementsForWrite"));
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public static void processSubTypes(PsiType psiType, PsiElement context, boolean getRawSubtypes, @NotNull PrefixMatcher matcher, Consumer<PsiType> consumer) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/CodeInsightUtil", "processSubTypes"));
        }
        int arrayDim = psiType.getArrayDimensions();
        if (!((psiType = psiType.getDeepComponentType()) instanceof PsiClassType)) {
            return;
        }
        PsiClassType baseType = JavaCompletionUtil.originalize((PsiClassType)psiType);
        PsiClassType.ClassResolveResult baseResult = baseType.resolveGenerics();
        PsiClass baseClass = baseResult.getElement();
        PsiSubstitutor baseSubstitutor = baseResult.getSubstitutor();
        if (baseClass == null) {
            return;
        }
        GlobalSearchScope scope = context.getResolveScope();
        Processor<PsiClass> inheritorsProcessor = CodeInsightUtil.createInheritorsProcessor(context, baseType, arrayDim, getRawSubtypes, consumer, baseClass, baseSubstitutor);
        CodeInsightUtil.addContextTypeArguments(context, baseType, inheritorsProcessor);
        if (baseClass.hasModifierProperty("final")) {
            return;
        }
        if (matcher.getPrefix().length() > 2) {
            JBTreeTraverser traverser = new JBTreeTraverser(c -> Arrays.asList(c.getInnerClasses()));
            AllClassesGetter.processJavaClasses(matcher, context.getProject(), scope, (Processor<PsiClass>)((Processor)psiClass -> {
                FilteredTraverserBase inheritors = ((JBTreeTraverser)traverser.withRoot(psiClass)).filter(c -> c.isInheritor(baseClass, true));
                return ContainerUtil.process((Iterable)inheritors, (Processor)inheritorsProcessor);
            }));
        } else {
            Query baseQuery = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false);
            FilteredQuery query = new FilteredQuery(baseQuery, psiClass -> {
                if (matcher == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/CodeInsightUtil", "lambda$processSubTypes$4"));
                }
                if (psiClass instanceof PsiTypeParameter) return false;
                if (!ContainerUtil.exists(JavaCompletionUtil.getAllLookupStrings((PsiMember)psiClass), arg_0 -> ((PrefixMatcher)matcher).prefixMatches(arg_0))) return false;
                return true;
            });
            query.forEach(inheritorsProcessor);
        }
    }

    private static void addContextTypeArguments(PsiElement context, PsiClassType baseType, Processor<PsiClass> inheritorsProcessor) {
        PsiTypeParameterListOwner typed;
        HashSet usedNames = ContainerUtil.newHashSet();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        PsiElement each = context;
        while ((typed = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)each, PsiTypeParameterListOwner.class)) != null) {
            for (PsiTypeParameter parameter : typed.getTypeParameters()) {
                if (!baseType.isAssignableFrom((PsiType)factory.createType((PsiClass)parameter)) || !usedNames.add(parameter.getName())) continue;
                inheritorsProcessor.process((Object)CompletionUtil.getOriginalOrSelf(parameter));
            }
            each = typed;
        }
    }

    public static Processor<PsiClass> createInheritorsProcessor(PsiElement context, PsiClassType baseType, int arrayDim, boolean getRawSubtypes, Consumer<PsiType> result2, @NotNull PsiClass baseClass, PsiSubstitutor baseSubstitutor) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/codeInsight/CodeInsightUtil", "createInheritorsProcessor"));
        }
        PsiManager manager = context.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        return inheritor -> {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/codeInsight/CodeInsightUtil", "lambda$createInheritorsProcessor$5"));
            }
            ProgressManager.checkCanceled();
            if (!facade.getResolveHelper().isAccessible((PsiMember)inheritor, context, null)) {
                return true;
            }
            if (inheritor.getQualifiedName() == null && !manager.areElementsEquivalent((PsiElement)inheritor.getContainingFile(), (PsiElement)context.getContainingFile().getOriginalFile())) {
                return true;
            }
            if (JavaCompletionUtil.isInExcludedPackage((PsiMember)inheritor, false)) {
                return true;
            }
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            if (superSubstitutor == null) {
                return true;
            }
            if (getRawSubtypes) {
                result2.consume((Object)CodeInsightUtil.createType(inheritor, facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor), arrayDim));
                return true;
            }
            PsiSubstitutor inheritorSubstitutor = PsiSubstitutor.EMPTY;
            block0: for (PsiTypeParameter inheritorParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)inheritor)) {
                for (PsiTypeParameter baseParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)baseClass)) {
                    PsiType substitution;
                    PsiType substituted = superSubstitutor.substitute(baseParameter);
                    PsiType arg = baseSubstitutor.substitute(baseParameter);
                    if (arg instanceof PsiWildcardType) {
                        PsiType bound = ((PsiWildcardType)arg).getBound();
                        PsiType psiType = arg = bound != null ? bound : ((PsiWildcardType)arg).getExtendsBound();
                    }
                    if (PsiType.NULL.equals((Object)(substitution = resolveHelper.getSubstitutionForTypeParameter(inheritorParameter, substituted, arg, true, PsiUtil.getLanguageLevel((PsiElement)context)))) || substitution != null && substitution.equalsToText("java.lang.Object") || substitution instanceof PsiWildcardType) continue;
                    if (substitution == null) {
                        result2.consume((Object)CodeInsightUtil.createType(inheritor, facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor), arrayDim));
                        return true;
                    }
                    inheritorSubstitutor = inheritorSubstitutor.put(inheritorParameter, substitution);
                    continue block0;
                }
            }
            PsiType toAdd = CodeInsightUtil.createType(inheritor, inheritorSubstitutor, arrayDim);
            if (baseType.isAssignableFrom(toAdd)) {
                result2.consume((Object)toAdd);
            }
            return true;
        };
    }

    private static PsiType createType(PsiClass cls, PsiSubstitutor currentSubstitutor, int arrayDim) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)cls.getProject()).getElementFactory();
        PsiClassType newType = elementFactory.createType(cls, currentSubstitutor);
        for (int i2 = 0; i2 < arrayDim; ++i2) {
            newType = newType.createArrayType();
        }
        return newType;
    }
}

