/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CodeInsightSettings", storages={@Storage(value="editor.codeinsight.xml")})
public class CodeInsightSettings
implements PersistentStateComponent<Element>,
Cloneable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.CodeInsightSettings");
    public boolean AUTO_POPUP_PARAMETER_INFO = true;
    public int PARAMETER_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_JAVADOC_INFO;
    public int JAVADOC_INFO_DELAY = 1000;
    public boolean AUTO_POPUP_COMPLETION_LOOKUP = true;
    public int COMPLETION_CASE_SENSITIVE = 3;
    public static final int ALL = 1;
    public static final int NONE = 2;
    public static final int FIRST_LETTER = 3;
    public boolean SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS;
    public boolean AUTOCOMPLETE_ON_CODE_COMPLETION = true;
    public boolean AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = true;
    @Deprecated
    public boolean AUTOCOMPLETE_ON_CLASS_NAME_COMPLETION;
    public boolean AUTOCOMPLETE_COMMON_PREFIX = true;
    @Deprecated
    public boolean SHOW_STATIC_AFTER_INSTANCE;
    public boolean SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO;
    public boolean SHOW_SOURCE_INFERRED_ANNOTATIONS = true;
    @OptionTag(value="SMART_BACKSPACE")
    private int SMART_BACKSPACE = SmartBackspaceMode.AUTOINDENT.ordinal();
    public boolean SMART_INDENT_ON_ENTER = true;
    public boolean INSERT_BRACE_ON_ENTER = true;
    public boolean INSERT_SCRIPTLET_END_ON_ENTER = true;
    public boolean JAVADOC_STUB_ON_ENTER = true;
    public boolean SMART_END_ACTION = true;
    public boolean JAVADOC_GENERATE_CLOSING_TAG = true;
    public boolean SURROUND_SELECTION_ON_QUOTE_TYPED;
    public boolean AUTOINSERT_PAIR_BRACKET = true;
    public boolean AUTOINSERT_PAIR_QUOTE = true;
    public boolean REFORMAT_BLOCK_ON_RBRACE = true;
    public int REFORMAT_ON_PASTE = 3;
    public static final int NO_REFORMAT = 1;
    public static final int INDENT_BLOCK = 2;
    public static final int INDENT_EACH_LINE = 3;
    public static final int REFORMAT_BLOCK = 4;
    public boolean INDENT_TO_CARET_ON_PASTE;
    public int ADD_IMPORTS_ON_PASTE = 3;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int ASK = 3;
    public boolean HIGHLIGHT_BRACES = true;
    public boolean HIGHLIGHT_SCOPE;
    public boolean USE_INSTANCEOF_ON_EQUALS_PARAMETER;
    public boolean USE_ACCESSORS_IN_EQUALS_HASHCODE;
    public boolean HIGHLIGHT_IDENTIFIER_UNDER_CARET = true;
    public boolean OPTIMIZE_IMPORTS_ON_THE_FLY;
    public boolean ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    public boolean ADD_MEMBER_IMPORTS_ON_THE_FLY = true;
    public boolean JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="EXCLUDED_PACKAGE", elementValueAttribute="NAME")
    public String[] EXCLUDED_PACKAGES = ArrayUtil.EMPTY_STRING_ARRAY;

    public static CodeInsightSettings getInstance() {
        return (CodeInsightSettings)ServiceManager.getService(CodeInsightSettings.class);
    }

    @Nullable
    public CodeInsightSettings clone() {
        try {
            return (CodeInsightSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Transient
    @NotNull
    public SmartBackspaceMode getBackspaceMode() {
        SmartBackspaceMode[] values = SmartBackspaceMode.values();
        SmartBackspaceMode smartBackspaceMode = this.SMART_BACKSPACE >= 0 && this.SMART_BACKSPACE < values.length ? values[this.SMART_BACKSPACE] : SmartBackspaceMode.OFF;
        if (smartBackspaceMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeInsightSettings", "getBackspaceMode"));
        }
        return smartBackspaceMode;
    }

    @Transient
    public void setBackspaceMode(@NotNull SmartBackspaceMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/codeInsight/CodeInsightSettings", "setBackspaceMode"));
        }
        this.SMART_BACKSPACE = mode.ordinal();
    }

    public void loadState(Element state) {
        try {
            XmlSerializer.deserializeInto((Object)this, (Element)state);
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        this.writeExternal(element);
        return element;
    }

    public void writeExternal(Element element) {
        try {
            XmlSerializer.serializeInto((Object)this, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
        }
    }
}

