/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ConsoleFontOptions;
import com.intellij.application.options.colors.CustomizedSwitcherPanel;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;

public class NewColorAndFontPanel
extends JPanel {
    private final ColorSettingsPage mySettingsPage;
    private final SchemesPanel mySchemesPanel;
    private final OptionsPanel myOptionsPanel;
    private final PreviewPanel myPreviewPanel;
    private final AbstractAction myCopyAction;
    private final String myCategory;
    private final Collection<String> myOptionList;

    public NewColorAndFontPanel(SchemesPanel schemesPanel, final OptionsPanel optionsPanel, final PreviewPanel previewPanel, String category, Collection<String> optionList, ColorSettingsPage page) {
        super(new BorderLayout(0, 10));
        this.mySchemesPanel = schemesPanel;
        this.myOptionsPanel = optionsPanel;
        this.myPreviewPanel = previewPanel;
        this.myCategory = category;
        this.myOptionList = optionList;
        this.mySettingsPage = page;
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)this.mySchemesPanel, "North");
        top.add((Component)this.myOptionsPanel.getPanel(), "Center");
        if (optionsPanel instanceof ConsoleFontOptions) {
            JPanel wrapper = new JPanel(new FlowLayout(4));
            this.myCopyAction = new AbstractAction(ApplicationBundle.message((String)"action.apply.editor.font.settings", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorColorsScheme scheme2 = ((ConsoleFontOptions)NewColorAndFontPanel.this.myOptionsPanel).getCurrentScheme();
                    scheme2.setConsoleFontName(scheme2.getEditorFontName());
                    scheme2.setConsoleFontPreferences(scheme2.getFontPreferences());
                    scheme2.setConsoleFontSize(scheme2.getEditorFontSize());
                    scheme2.setConsoleLineSpacing(scheme2.getLineSpacing());
                    NewColorAndFontPanel.this.myOptionsPanel.updateOptionsList();
                    NewColorAndFontPanel.this.myPreviewPanel.updateView();
                }
            };
            wrapper.add(new JButton(this.myCopyAction));
            top.add((Component)wrapper, "South");
        } else {
            this.myCopyAction = null;
        }
        if (!(this.myPreviewPanel.getPanel() == null || page != null && StringUtil.isEmptyOrSpaces((String)page.getDemoText()))) {
            JSplitPane splitPane = new JSplitPane(0, top, this.myPreviewPanel.getPanel());
            splitPane.setBorder(BorderFactory.createEmptyBorder());
            splitPane.setContinuousLayout(true);
            this.add(splitPane);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)splitPane);
        } else {
            this.add((Component)top, "Center");
        }
        previewPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void selectionInPreviewChanged(String typeToSelect) {
                optionsPanel.selectOption(typeToSelect);
            }
        });
        optionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void settingsChanged() {
                optionsPanel.applyChangesToScheme();
                previewPanel.updateView();
            }

            @Override
            public void selectedOptionChanged(Object selected) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    NewColorAndFontPanel.this.myPreviewPanel.blinkSelectedHighlightType(selected);
                }
            }
        });
        this.mySchemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(Object source) {
                NewColorAndFontPanel.this.myOptionsPanel.updateOptionsList();
                NewColorAndFontPanel.this.myPreviewPanel.updateView();
                if (optionsPanel instanceof ConsoleFontOptions) {
                    ConsoleFontOptions options = (ConsoleFontOptions)optionsPanel;
                    boolean readOnly = ColorAndFontOptions.isReadOnly(options.getCurrentScheme());
                    NewColorAndFontPanel.this.myCopyAction.setEnabled(!readOnly);
                }
            }
        });
    }

    public static NewColorAndFontPanel create(PreviewPanel previewPanel, String category, ColorAndFontOptions options, Collection<String> optionList, ColorSettingsPage page) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, category, new CustomizedSwitcherPanel(previewPanel, page));
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, category, optionList, page);
    }

    public Runnable showOption(String option) {
        return this.myOptionsPanel.showOption(option);
    }

    @NotNull
    public Set<String> processListOptions() {
        if (this.myOptionList == null) {
            Set<String> set2 = this.myOptionsPanel.processListOptions();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/NewColorAndFontPanel", "processListOptions"));
            }
            return set2;
        }
        HashSet<String> hashSet = new HashSet<String>(this.myOptionList);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/NewColorAndFontPanel", "processListOptions"));
        }
        return hashSet;
    }

    public String getDisplayName() {
        return this.myCategory;
    }

    public void reset(Object source) {
        this.resetSchemesCombo(source);
    }

    public void disposeUIResources() {
        this.myPreviewPanel.disposeUIResources();
    }

    public void addSchemesListener(ColorAndFontSettingsListener schemeListener) {
        this.mySchemesPanel.addListener(schemeListener);
    }

    private void resetSchemesCombo(Object source) {
        this.mySchemesPanel.resetSchemesCombo(source);
    }

    public boolean contains(EditorSchemeAttributeDescriptor descriptor) {
        return descriptor.getGroup().equals(this.myCategory);
    }

    public JComponent getPanel() {
        return this;
    }

    public void updatePreview() {
        this.myPreviewPanel.updateView();
    }

    public void addDescriptionListener(ColorAndFontSettingsListener listener2) {
        this.myOptionsPanel.addListener(listener2);
    }

    public boolean containsFontOptions() {
        return false;
    }

    public ColorSettingsPage getSettingsPage() {
        return this.mySettingsPage;
    }
}

