/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class RightMarginForm {
    private JTextField myRightMarginField;
    private JCheckBox myDefaultGeneralCheckBox;
    private JPanel myTopPanel;
    private JComboBox myWrapOnTypingCombo;
    private final Language myLanguage;
    private final int myDefaultRightMargin;

    public RightMarginForm(@NotNull Language language, @NotNull CodeStyleSettings settings) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/RightMarginForm", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "<init>"));
        }
        this.myLanguage = language;
        this.$$$setupUI$$$();
        this.myDefaultRightMargin = settings.getDefaultRightMargin();
        this.myDefaultGeneralCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RightMarginForm.this.myDefaultGeneralCheckBox.isSelected()) {
                    RightMarginForm.this.myRightMarginField.setText(Integer.toString(RightMarginForm.this.myDefaultRightMargin));
                    RightMarginForm.this.myRightMarginField.setEnabled(false);
                } else {
                    RightMarginForm.this.myRightMarginField.setEnabled(true);
                }
            }
        });
        this.myWrapOnTypingCombo.setModel(new DefaultComboBoxModel<String>(CodeStyleSettingsCustomizable.WRAP_ON_TYPING_OPTIONS));
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "reset"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        if (langSettings != settings && langSettings.RIGHT_MARGIN >= 0) {
            this.myDefaultGeneralCheckBox.setSelected(false);
            this.myRightMarginField.setText(Integer.toString(langSettings.RIGHT_MARGIN));
        } else {
            this.myDefaultGeneralCheckBox.setSelected(true);
            this.myRightMarginField.setText(Integer.toString(settings.getDefaultRightMargin()));
            if (langSettings == settings) {
                this.myDefaultGeneralCheckBox.setEnabled(false);
                this.myRightMarginField.setEnabled(false);
            }
        }
        for (int i2 = 0; i2 < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES.length; ++i2) {
            if (langSettings.WRAP_ON_TYPING != CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES[i2]) continue;
            this.myWrapOnTypingCombo.setSelectedIndex(i2);
            break;
        }
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "apply"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        if (langSettings != settings) {
            langSettings.RIGHT_MARGIN = this.myDefaultGeneralCheckBox.isSelected() ? -1 : this.getFieldRightMargin(settings.getDefaultRightMargin());
        }
        langSettings.WRAP_ON_TYPING = this.getSelectedWrapOnTypingValue();
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/RightMarginForm", "isModified"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        boolean rightMarginModified = this.myDefaultGeneralCheckBox.isSelected() ? langSettings.RIGHT_MARGIN >= 0 : langSettings.RIGHT_MARGIN != this.getFieldRightMargin(settings.getDefaultRightMargin());
        return rightMarginModified || langSettings.WRAP_ON_TYPING != this.getSelectedWrapOnTypingValue();
    }

    private int getFieldRightMargin(int fallBackValue) {
        String strValue = this.myRightMarginField.getText();
        if (!strValue.trim().isEmpty()) {
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                this.myRightMarginField.setText(Integer.toString(fallBackValue));
            }
        }
        return fallBackValue;
    }

    private int getSelectedWrapOnTypingValue() {
        int i2 = this.myWrapOnTypingCombo.getSelectedIndex();
        if (i2 >= 0 && i2 < CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES.length) {
            return CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES[i2];
        }
        return CommonCodeStyleSettings.WrapOnTyping.DEFAULT.intValue;
    }

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("wrapping.wrap.on.typing"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWrapOnTypingCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDefaultGeneralCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.default.general"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRightMarginField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(2);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

