/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.google.common.base.MoreObjects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAuthData;

public class AuthLevel {
    public static final AuthLevel ANY = new AuthLevel(null, null);
    public static final AuthLevel TOKEN = new AuthLevel(null, GithubAuthData.AuthType.TOKEN);
    public static final AuthLevel BASIC = new AuthLevel(null, GithubAuthData.AuthType.BASIC);
    public static final AuthLevel LOGGED = new AuthLevel(null, null){

        @Override
        public boolean accepts(@NotNull GithubAuthData auth) {
            if (auth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/AuthLevel$1", "accepts"));
            }
            return auth.getAuthType() != GithubAuthData.AuthType.ANONYMOUS;
        }

        @Override
        public String toString() {
            return "Not anonymous";
        }
    };
    @Nullable
    private final String myHost;
    @Nullable
    private final GithubAuthData.AuthType myAuthType;

    @NotNull
    public static AuthLevel basicOnetime(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/util/AuthLevel", "basicOnetime"));
        }
        AuthLevel authLevel = new AuthLevel(host, GithubAuthData.AuthType.BASIC){

            @Override
            public boolean isOnetime() {
                return true;
            }
        };
        if (authLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/AuthLevel", "basicOnetime"));
        }
        return authLevel;
    }

    private AuthLevel(@Nullable String host, @Nullable GithubAuthData.AuthType authType) {
        this.myHost = host;
        this.myAuthType = authType;
    }

    @Nullable
    public String getHost() {
        return this.myHost;
    }

    @Nullable
    public GithubAuthData.AuthType getAuthType() {
        return this.myAuthType;
    }

    public boolean accepts(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/AuthLevel", "accepts"));
        }
        if (this.myHost != null && !this.myHost.equals(auth.getHost())) {
            return false;
        }
        return this.myAuthType == null || this.myAuthType.equals((Object)auth.getAuthType());
    }

    public boolean isOnetime() {
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authType", (Object)this.myAuthType).add("host", (Object)this.myHost).toString();
    }
}

