/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubPullRequest {
    @Mandatory
    private Long number;
    @Mandatory
    private String state;
    @Mandatory
    private String title;
    private String body;
    private String bodyHtml;
    private String url;
    @Mandatory
    private String htmlUrl;
    @Mandatory
    private String diffUrl;
    @Mandatory
    private String patchUrl;
    @Mandatory
    private String issueUrl;
    private Boolean merged;
    private Boolean mergeable;
    private Integer comments;
    private Integer commits;
    private Integer additions;
    private Integer deletions;
    private Integer changedFiles;
    @Mandatory
    private Date createdAt;
    @Mandatory
    private Date updatedAt;
    private Date closedAt;
    private Date mergedAt;
    @Mandatory
    private GithubUser user;
    @Mandatory
    private Link head;
    @Mandatory
    private Link base;

    public long getNumber() {
        return this.number;
    }

    @NotNull
    public String getState() {
        String string = this.state;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getState"));
        }
        return string;
    }

    @NotNull
    public String getTitle() {
        String string = this.title;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getBodyHtml() {
        String string = StringUtil.notNullize((String)this.bodyHtml);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getBodyHtml"));
        }
        return string;
    }

    @NotNull
    public String getHtmlUrl() {
        String string = this.htmlUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getHtmlUrl"));
        }
        return string;
    }

    @NotNull
    public String getDiffUrl() {
        String string = this.diffUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getDiffUrl"));
        }
        return string;
    }

    @NotNull
    public String getPatchUrl() {
        String string = this.patchUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getPatchUrl"));
        }
        return string;
    }

    @NotNull
    public String getIssueUrl() {
        String string = this.issueUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getIssueUrl"));
        }
        return string;
    }

    @NotNull
    public Date getCreatedAt() {
        Date date = this.createdAt;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getCreatedAt"));
        }
        return date;
    }

    @NotNull
    public Date getUpdatedAt() {
        Date date = this.updatedAt;
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getUpdatedAt"));
        }
        return date;
    }

    @Nullable
    public Date getClosedAt() {
        return this.closedAt;
    }

    @Nullable
    public Date getMergedAt() {
        return this.mergedAt;
    }

    @NotNull
    public GithubUser getUser() {
        GithubUser githubUser = this.user;
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getUser"));
        }
        return githubUser;
    }

    @NotNull
    public Link getHead() {
        Link link = this.head;
        if (link == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getHead"));
        }
        return link;
    }

    @NotNull
    public Link getBase() {
        Link link = this.base;
        if (link == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest", "getBase"));
        }
        return link;
    }

    @RestModel
    public static class Link {
        @Mandatory
        private String label;
        @Mandatory
        private String ref;
        @Mandatory
        private String sha;
        private GithubRepo repo;
        @Mandatory
        private GithubUser user;

        @NotNull
        public String getLabel() {
            String string = this.label;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest$Link", "getLabel"));
            }
            return string;
        }

        @NotNull
        public String getRef() {
            String string = this.ref;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest$Link", "getRef"));
            }
            return string;
        }

        @NotNull
        public String getSha() {
            String string = this.sha;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest$Link", "getSha"));
            }
            return string;
        }

        @Nullable
        public GithubRepo getRepo() {
            return this.repo;
        }

        @NotNull
        public GithubUser getUser() {
            GithubUser githubUser = this.user;
            if (githubUser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubPullRequest$Link", "getUser"));
            }
            return githubUser;
        }
    }
}

