/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GithubIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.requests.GithubGistRequest;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String FAILED_TO_CREATE_GIST = "Can't create Gist";

    protected GithubCreateGistAction() {
        super("Create Gist...", "Create GitHub Gist", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null || editor != null && editor.getDocument().getTextLength() == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, file, files);
    }

    static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final @Nullable VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "createGistAction"));
        }
        final GithubCreateGistDialog dialog = new GithubCreateGistDialog(project, editor, files, file);
        if (!dialog.showAndGet()) {
            return;
        }
        final GithubAuthDataHolder authHolder = GithubCreateGistAction.getValidAuthData(project, dialog.isAnonymous());
        if (authHolder == null) {
            return;
        }
        final Ref url = new Ref();
        new Task.Backgroundable(project, "Creating Gist..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreateGistAction$1", "run"));
                }
                List<GithubGistRequest.FileContent> contents = GithubCreateGistAction.collectContents(project, editor, file, files);
                if (contents.isEmpty()) {
                    return;
                }
                String gistUrl = GithubCreateGistAction.createGist(project, authHolder, indicator, contents, dialog.isPrivate(), dialog.getDescription(), dialog.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "Gist Created Successfully", "Your gist url", (String)url.get());
                }
            }
        }.queue();
    }

    @Nullable
    private static GithubAuthDataHolder getValidAuthData(@NotNull Project project, boolean isAnonymous) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "getValidAuthData"));
        }
        if (isAnonymous) {
            return new GithubAuthDataHolder(GithubAuthData.createAnonymous());
        }
        try {
            return (GithubAuthDataHolder)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "lambda$getValidAuthData$0"));
                }
                return GithubUtil.getValidAuthDataHolderFromConfig(project, AuthLevel.LOGGED, indicator);
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Can't create gist", e);
            return null;
        }
    }

    @NotNull
    static List<GithubGistRequest.FileContent> collectContents(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, @Nullable VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "collectContents"));
        }
        if (editor != null) {
            String content = GithubCreateGistAction.getContentFromEditor(editor);
            if (content == null) {
                List<GithubGistRequest.FileContent> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "collectContents"));
                }
                return list;
            }
            if (file != null) {
                List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent(file.getName(), content));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "collectContents"));
                }
                return list;
            }
            List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent("", content));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "collectContents"));
            }
            return list;
        }
        if (files != null) {
            ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
            for (VirtualFile vf : files) {
                contents.addAll(GithubCreateGistAction.getContentFromFile(vf, project, null));
            }
            ArrayList<GithubGistRequest.FileContent> arrayList = contents;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "collectContents"));
            }
            return arrayList;
        }
        if (file != null) {
            List<GithubGistRequest.FileContent> list = GithubCreateGistAction.getContentFromFile(file, project, null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "collectContents"));
            }
            return list;
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    static String createGist(@NotNull Project project, @NotNull GithubAuthDataHolder auth, @NotNull ProgressIndicator indicator, @NotNull List<GithubGistRequest.FileContent> contents, boolean isPrivate, @NotNull String description, @Nullable String filename) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "createGist"));
        }
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/GithubCreateGistAction", "createGist"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreateGistAction", "createGist"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "org/jetbrains/plugins/github/GithubCreateGistAction", "createGist"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/GithubCreateGistAction", "createGist"));
        }
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't create empty gist");
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGistRequest.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGistRequest.FileContent(filename, entry.getContent()));
        }
        try {
            List<GithubGistRequest.FileContent> finalContents = contents;
            return ((GithubGist)GithubUtil.runTask(project, auth, indicator, AuthLevel.ANY, connection -> {
                if (description == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/GithubCreateGistAction", "lambda$createGist$1"));
                }
                return GithubApiUtil.createGist(connection, finalContents, description, isPrivate);
            })).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, FAILED_TO_CREATE_GIST, e);
            return null;
        }
    }

    @Nullable
    private static String getContentFromEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromEditor"));
        }
        String text = (String)ReadAction.compute(() -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/github/GithubCreateGistAction", "lambda$getContentFromEditor$2"));
            }
            return editor.getSelectionModel().getSelectedText();
        });
        if (text == null) {
            text = editor.getDocument().getText();
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return text;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromFile(@NotNull VirtualFile file, @NotNull Project project, @Nullable String prefix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
        }
        if (file.isDirectory()) {
            List<GithubGistRequest.FileContent> list = GithubCreateGistAction.getContentFromDirectory(file, project, prefix);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
            }
            return list;
        }
        if (file.getFileType().isBinary()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't upload binary file: " + file);
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
            }
            return list;
        }
        String content = (String)ReadAction.compute(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/github/GithubCreateGistAction", "lambda$getContentFromFile$3"));
            }
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    return document.getText();
                }
                return new String(file.contentsToByteArray(), file.getCharset());
            }
            catch (IOException e) {
                LOG.info("Couldn't read contents of the file " + file, (Throwable)e);
                return null;
            }
        });
        if (content == null) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Couldn't read the contents of the file " + file);
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
            }
            return list;
        }
        if (StringUtil.isEmptyOrSpaces((String)content)) {
            List<GithubGistRequest.FileContent> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
            }
            return list;
        }
        String filename = GithubCreateGistAction.addPrefix(file.getName(), prefix, false);
        List<GithubGistRequest.FileContent> list = Collections.singletonList(new GithubGistRequest.FileContent(filename, content));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromFile"));
        }
        return list;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromDirectory(@NotNull VirtualFile dir, @NotNull Project project, @Nullable String prefix) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromDirectory"));
        }
        ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
        for (VirtualFile file : dir.getChildren()) {
            if (GithubCreateGistAction.isFileIgnored(file, project)) continue;
            String pref = GithubCreateGistAction.addPrefix(dir.getName(), prefix, true);
            contents.addAll(GithubCreateGistAction.getContentFromFile(file, project, pref));
        }
        ArrayList<GithubGistRequest.FileContent> arrayList = contents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreateGistAction", "getContentFromDirectory"));
        }
        return arrayList;
    }

    private static String addPrefix(@NotNull String name, @Nullable String prefix, boolean addTrailingSlash) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/github/GithubCreateGistAction", "addPrefix"));
        }
        String pref = prefix == null ? "" : prefix;
        pref = pref + name;
        if (addTrailingSlash) {
            pref = pref + "_";
        }
        return pref;
    }

    private static boolean isFileIgnored(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/github/GithubCreateGistAction", "isFileIgnored"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreateGistAction", "isFileIgnored"));
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        return manager.isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }
}

