/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.google.common.base.Predicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

public class RepositoryLibrarySynchronizer
implements StartupActivity,
DumbAware {
    private static boolean isLibraryNeedToBeReloaded(LibraryEx library, RepositoryLibraryProperties properties) {
        String version = properties.getVersion();
        if (version == null) {
            return false;
        }
        if (version.equals("LATEST") || version.equals("RELEASE") || version.endsWith("-SNAPSHOT")) {
            return true;
        }
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            if (library.getFiles(orderRootType).length == library.getUrls(orderRootType).length) continue;
            return true;
        }
        return false;
    }

    private static Collection<Library> collectLibraries(@NotNull Project project, @NotNull Predicate<Library> predicate) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "collectLibraries"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "collectLibraries"));
        }
        HashSet result = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "lambda$collectLibraries$1"));
            }
            if (predicate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "lambda$collectLibraries$1"));
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                OrderEnumerator.orderEntries((Module)module).withoutSdk().forEachLibrary(library -> {
                    if (predicate == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "lambda$null$0"));
                    }
                    if (predicate.apply(library)) {
                        result.add(library);
                    }
                    return true;
                });
            }
            for (Module module : ProjectLibraryTable.getInstance((Project)project).getLibraries()) {
                if (!predicate.apply((Object)module)) continue;
                result.add((Object)module);
            }
        });
        return result;
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibrarySynchronizer", "runActivity"));
        }
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        Collection libraries = RepositoryLibrarySynchronizer.collectLibraries(project, (Predicate<Library>)((Predicate)new Predicate<Library>(){

                            public boolean apply(Library library) {
                                if (!(library instanceof LibraryEx)) {
                                    return false;
                                }
                                LibraryEx libraryEx = (LibraryEx)library;
                                return libraryEx.getKind() == RepositoryLibraryType.REPOSITORY_LIBRARY_KIND && libraryEx.getProperties() instanceof RepositoryLibraryProperties && RepositoryLibrarySynchronizer.isLibraryNeedToBeReloaded(libraryEx, (RepositoryLibraryProperties)libraryEx.getProperties());
                            }
                        }));
                        for (Library library : libraries) {
                            LibraryEx libraryEx = (LibraryEx)library;
                            RepositoryUtils.reloadDependencies(project, libraryEx);
                        }
                    }
                }, project.getDisposed());
            }
        });
    }
}

