/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorReadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsManagerWatcher {
    private static final Key<ConcurrentMap<Project, Long>> CRC_WITHOUT_SPACES = Key.create((String)"MavenProjectsManagerWatcher.CRC_WITHOUT_SPACES");
    public static final Key<Boolean> FORCE_IMPORT_AND_RESOLVE_ON_REFRESH = Key.create((String)(MavenProjectsManagerWatcher.class + "FORCE_IMPORT_AND_RESOLVE_ON_REFRESH"));
    private static final int DOCUMENT_SAVE_DELAY = 1000;
    private final Project myProject;
    private final MavenProjectsManager myManager;
    private final MavenProjectsTree myProjectsTree;
    private final MavenGeneralSettings myGeneralSettings;
    private final MavenProjectsProcessor myReadingProcessor;
    private final MavenEmbeddersManager myEmbeddersManager;
    private final List<VirtualFilePointer> mySettingsFilesPointers = new ArrayList<VirtualFilePointer>();
    private final List<LocalFileSystem.WatchRequest> myWatchedRoots = new ArrayList<LocalFileSystem.WatchRequest>();
    private final Set<Document> myChangedDocuments = new THashSet();
    private final MavenMergingUpdateQueue myChangedDocumentsQueue;

    public MavenProjectsManagerWatcher(Project project, MavenProjectsManager manager, MavenProjectsTree projectsTree, MavenGeneralSettings generalSettings, MavenProjectsProcessor readingProcessor, MavenEmbeddersManager embeddersManager) {
        this.myProject = project;
        this.myManager = manager;
        this.myProjectsTree = projectsTree;
        this.myGeneralSettings = generalSettings;
        this.myReadingProcessor = readingProcessor;
        this.myEmbeddersManager = embeddersManager;
        this.myChangedDocumentsQueue = new MavenMergingUpdateQueue(this.getClass() + ": Document changes queue", 1000, false, (Disposable)this.myProject);
    }

    public synchronized void start() {
        MessageBusConnection myBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myChangedDocumentsQueue);
        myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener());
        myBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootChangesListener());
        this.myChangedDocumentsQueue.makeUserAware(this.myProject);
        this.myChangedDocumentsQueue.activate();
        myBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$1", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$1", "moduleRemoved"));
                }
                MavenProject mavenProject = MavenProjectsManagerWatcher.this.myManager.findProject(module);
                if (mavenProject != null && !MavenProjectsManagerWatcher.this.myManager.isIgnored(mavenProject)) {
                    VirtualFile file = mavenProject.getFile();
                    if (MavenProjectsManagerWatcher.this.myManager.isManagedFile(file) && MavenProjectsManagerWatcher.this.myManager.getModules(mavenProject).isEmpty()) {
                        MavenProjectsManagerWatcher.this.myManager.removeManagedFiles(Collections.singletonList(file));
                    } else {
                        MavenProjectsManagerWatcher.this.myManager.setIgnoredState(Collections.singletonList(mavenProject), true);
                    }
                }
            }

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                MavenProject mavenProject;
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$1", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$1", "moduleAdded"));
                }
                if (MavenProjectsManagerWatcher.this.myManager.isMavenizedModule(module) && (mavenProject = MavenProjectsManagerWatcher.this.myManager.findProject(module)) != null) {
                    MavenProjectsManagerWatcher.this.myManager.setIgnoredState(Collections.singletonList(mavenProject), false);
                }
            }
        });
        DocumentAdapter myDocumentListener = new DocumentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                boolean isMavenFile;
                Document doc = event.getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(doc);
                if (file == null) {
                    return;
                }
                String fileName = file.getName();
                boolean bl = isMavenFile = fileName.equals("pom.xml") || fileName.equals("profiles.xml") || MavenProjectsManagerWatcher.this.isSettingsFile(file) || fileName.startsWith("pom.");
                if (!isMavenFile) {
                    return;
                }
                Set set = MavenProjectsManagerWatcher.this.myChangedDocuments;
                synchronized (set) {
                    MavenProjectsManagerWatcher.this.myChangedDocuments.add(doc);
                }
                MavenProjectsManagerWatcher.this.myChangedDocumentsQueue.queue(new Update(MavenProjectsManagerWatcher.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Document[] copy;
                        Set set = MavenProjectsManagerWatcher.this.myChangedDocuments;
                        synchronized (set) {
                            copy = MavenProjectsManagerWatcher.this.myChangedDocuments.toArray(new Document[MavenProjectsManagerWatcher.this.myChangedDocuments.size()]);
                            MavenProjectsManagerWatcher.this.myChangedDocuments.clear();
                        }
                        MavenUtil.invokeLater(MavenProjectsManagerWatcher.this.myProject, () -> new WriteAction(){

                            protected void run(@NotNull Result result) throws Throwable {
                                if (result == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$2$1$1", "run"));
                                }
                                for (Document each : copy) {
                                    PsiDocumentManager.getInstance((Project)MavenProjectsManagerWatcher.this.myProject).commitDocument(each);
                                    ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveDocument(each, false);
                                }
                            }
                        }.execute());
                    }
                });
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)myDocumentListener, (Disposable)myBusConnection);
        final MavenGeneralSettings.Listener mySettingsPathsChangesListener = new MavenGeneralSettings.Listener(){

            @Override
            public void changed() {
                MavenProjectsManagerWatcher.this.updateSettingsFilePointers();
                MavenProjectsManagerWatcher.this.onSettingsChange();
            }
        };
        this.myGeneralSettings.addListener(mySettingsPathsChangesListener);
        Disposer.register((Disposable)this.myChangedDocumentsQueue, (Disposable)new Disposable(){

            public void dispose() {
                MavenProjectsManagerWatcher.this.myGeneralSettings.removeListener(mySettingsPathsChangesListener);
                MavenProjectsManagerWatcher.this.mySettingsFilesPointers.clear();
            }
        });
        this.updateSettingsFilePointers();
    }

    private void updateSettingsFilePointers() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedRoots);
        this.mySettingsFilesPointers.clear();
        this.addFilePointer(this.myGeneralSettings.getEffectiveUserSettingsIoFile(), this.myGeneralSettings.getEffectiveGlobalSettingsIoFile());
    }

    private void addFilePointer(File ... settingsFiles) {
        ArrayList<String> pathsToWatch = new ArrayList<String>(settingsFiles.length);
        for (File settingsFile : settingsFiles) {
            String path;
            if (settingsFile == null) continue;
            File parentFile = settingsFile.getParentFile();
            if (parentFile != null && (path = MavenProjectsManagerWatcher.getNormalizedPath(parentFile)) != null) {
                pathsToWatch.add(path);
            }
            if ((path = MavenProjectsManagerWatcher.getNormalizedPath(settingsFile)) == null) continue;
            String url = VfsUtilCore.pathToUrl((String)path);
            this.mySettingsFilesPointers.add(VirtualFilePointerManager.getInstance().create(url, (Disposable)this.myChangedDocumentsQueue, new VirtualFilePointerListener(){

                public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
                    if (pointers == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$5", "beforeValidityChanged"));
                    }
                }

                public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                    if (pointers == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$5", "validityChanged"));
                    }
                }
            }));
        }
        this.myWatchedRoots.addAll(LocalFileSystem.getInstance().addRootsToWatch(pathsToWatch, false));
    }

    @Nullable
    private static String getNormalizedPath(@NotNull File settingsFile) {
        if (settingsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsFile", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher", "getNormalizedPath"));
        }
        String canonized = PathUtil.getCanonicalPath((String)settingsFile.getAbsolutePath());
        return canonized == null ? null : FileUtil.toSystemIndependentName((String)canonized);
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myChangedDocumentsQueue);
    }

    public synchronized void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myProjectsTree.addManagedFilesWithProfiles(files, explicitProfiles);
        this.scheduleUpdateAll(false, true);
    }

    public synchronized void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myProjectsTree.resetManagedFilesAndProfiles(files, explicitProfiles);
        this.scheduleUpdateAll(false, true);
    }

    public synchronized void removeManagedFiles(List<VirtualFile> files) {
        this.myProjectsTree.removeManagedFiles(files);
        this.scheduleUpdateAll(false, true);
    }

    public synchronized void setExplicitProfiles(MavenExplicitProfiles profiles) {
        this.myProjectsTree.setExplicitProfiles(profiles);
        this.scheduleUpdateAll(false, false);
    }

    public Promise<Void> scheduleUpdateAll(boolean force, boolean forceImportAndResolve) {
        AsyncPromise promise = new AsyncPromise();
        Runnable onCompletion = this.createScheduleImportAction(forceImportAndResolve, (AsyncPromise<Void>)promise);
        this.myReadingProcessor.scheduleTask(new MavenProjectsProcessorReadingTask(force, this.myProjectsTree, this.myGeneralSettings, onCompletion));
        return promise;
    }

    public Promise<Void> scheduleUpdate(List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, boolean force, boolean forceImportAndResolve) {
        AsyncPromise promise = new AsyncPromise();
        Runnable onCompletion = this.createScheduleImportAction(forceImportAndResolve, (AsyncPromise<Void>)promise);
        this.myReadingProcessor.scheduleTask(new MavenProjectsProcessorReadingTask(filesToUpdate, filesToDelete, force, this.myProjectsTree, this.myGeneralSettings, onCompletion));
        return promise;
    }

    @NotNull
    private Runnable createScheduleImportAction(boolean forceImportAndResolve, AsyncPromise<Void> promise) {
        Runnable runnable = () -> {
            if (this.myProject.isDisposed()) {
                promise.setError("Project disposed");
                return;
            }
            if (forceImportAndResolve || this.myManager.getImportingSettings().isImportAutomatically()) {
                this.myManager.scheduleImportAndResolve().done(modules -> promise.setResult(null));
            } else {
                promise.setResult(null);
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher", "createScheduleImportAction"));
        }
        return runnable;
    }

    private void onSettingsChange() {
        this.myEmbeddersManager.reset();
        this.scheduleUpdateAll(true, false);
    }

    private void onSettingsXmlChange() {
        this.myGeneralSettings.changed();
    }

    private boolean isPomFile(String path) {
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((File)new File(path));
        if (!"pom".equals(nameWithoutExtension)) {
            return false;
        }
        return this.myProjectsTree.isPotentialProject(path);
    }

    private boolean isProfilesFile(String path) {
        if (!path.endsWith("/profiles.xml")) {
            return false;
        }
        return this.myProjectsTree.isPotentialProject(path.substring(0, path.length() - "profiles.xml".length()) + "pom.xml");
    }

    private boolean isSettingsFile(String path) {
        for (VirtualFilePointer each : this.mySettingsFilesPointers) {
            VirtualFile f = each.getFile();
            if (f == null || !FileUtil.pathsEqual((String)path, (String)f.getPath())) continue;
            return true;
        }
        return false;
    }

    private boolean isSettingsFile(VirtualFile f) {
        for (VirtualFilePointer each : this.mySettingsFilesPointers) {
            if (!Comparing.equal((Object)each.getFile(), (Object)f)) continue;
            return true;
        }
        return false;
    }

    private static abstract class MyFileChangeListenerBase
    implements BulkFileListener {
        private MyFileChangeListenerBase() {
        }

        protected abstract boolean isRelevant(String var1);

        protected abstract void updateFile(VirtualFile var1, VFileEvent var2);

        protected abstract void deleteFile(VirtualFile var1, VFileEvent var2);

        protected abstract void apply();

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MyFileChangeListenerBase", "before"));
            }
            for (VFileEvent vFileEvent : events) {
                VFileMoveEvent moveEvent;
                String newPath;
                if (vFileEvent instanceof VFileDeleteEvent) {
                    this.deleteRecursively(vFileEvent.getFile(), vFileEvent);
                    continue;
                }
                if (!this.isRelevant(vFileEvent.getPath())) continue;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!MyFileChangeListenerBase.isRenamed(vFileEvent)) continue;
                    this.deleteRecursively(vFileEvent.getFile(), vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent) || this.isRelevant(newPath = (moveEvent = (VFileMoveEvent)vFileEvent).getNewParent().getPath() + "/" + moveEvent.getFile().getName())) continue;
                this.deleteRecursively(moveEvent.getFile(), vFileEvent);
            }
        }

        private void deleteRecursively(VirtualFile f, final VFileEvent event) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile f) {
                    if (f == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MyFileChangeListenerBase$1", "visitFile"));
                    }
                    if (this.isRelevant(f.getPath())) {
                        this.deleteFile(f, event);
                    }
                    return true;
                }

                @Nullable
                public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                    if (f == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MyFileChangeListenerBase$1", "getChildrenIterable"));
                    }
                    return f.isDirectory() && f instanceof NewVirtualFile ? ((NewVirtualFile)f).iterInDbChildren() : null;
                }
            });
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MyFileChangeListenerBase", "after"));
            }
            for (VFileEvent vFileEvent : events) {
                VirtualFile newChild;
                if (!this.isRelevant(vFileEvent.getPath())) continue;
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    newChild = createEvent.getParent().findChild(createEvent.getChildName());
                    if (newChild == null) continue;
                    this.updateFile(newChild, vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    newChild = copyEvent.getNewParent().findChild(copyEvent.getNewChildName());
                    if (newChild == null) continue;
                    this.updateFile(newChild, vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileContentChangeEvent) {
                    this.updateFile(vFileEvent.getFile(), vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!MyFileChangeListenerBase.isRenamed(vFileEvent)) continue;
                    this.updateFile(vFileEvent.getFile(), vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                this.updateFile(vFileEvent.getFile(), vFileEvent);
            }
            this.apply();
        }

        private static boolean isRenamed(VFileEvent each) {
            return ((VFilePropertyChangeEvent)each).getPropertyName().equals("name") && !Comparing.equal((Object)((VFilePropertyChangeEvent)each).getOldValue(), (Object)((VFilePropertyChangeEvent)each).getNewValue());
        }
    }

    private class MyFileChangeListener
    extends MyFileChangeListenerBase {
        private List<VirtualFile> filesToUpdate;
        private List<VirtualFile> filesToRemove;
        private boolean settingsHaveChanged;
        private boolean forceImportAndResolve;

        private MyFileChangeListener() {
        }

        @Override
        protected boolean isRelevant(String path) {
            return MavenProjectsManagerWatcher.this.isPomFile(path) || MavenProjectsManagerWatcher.this.isProfilesFile(path) || MavenProjectsManagerWatcher.this.isSettingsFile(path);
        }

        @Override
        protected void updateFile(VirtualFile file, VFileEvent event) {
            this.doUpdateFile(file, event, false);
        }

        @Override
        protected void deleteFile(VirtualFile file, VFileEvent event) {
            this.doUpdateFile(file, event, true);
        }

        private void doUpdateFile(VirtualFile file, VFileEvent event, boolean remove) {
            VirtualFile pom;
            this.initLists();
            if (MavenProjectsManagerWatcher.this.isSettingsFile(file)) {
                this.settingsHaveChanged = true;
                return;
            }
            if (file.getUserData(FORCE_IMPORT_AND_RESOLVE_ON_REFRESH) == Boolean.TRUE) {
                this.forceImportAndResolve = true;
            }
            if ((pom = this.getPomFileProfilesFile(file)) != null) {
                if (remove || this.fileWasChanged(pom, event)) {
                    this.filesToUpdate.add(pom);
                }
                return;
            }
            if (remove) {
                this.filesToRemove.add(file);
            } else if (this.fileWasChanged(file, event)) {
                this.filesToUpdate.add(file);
            }
        }

        private boolean fileWasChanged(VirtualFile file, VFileEvent event) {
            Long newCrc;
            if (!file.isValid() || !(event instanceof VFileContentChangeEvent)) {
                return true;
            }
            ConcurrentMap map = (ConcurrentMap)file.getUserData(CRC_WITHOUT_SPACES);
            if (map == null) {
                ConcurrentMap value = ContainerUtil.createConcurrentWeakMap();
                map = (ConcurrentMap)file.putUserDataIfAbsent(CRC_WITHOUT_SPACES, (Object)value);
            }
            Long crc = (Long)map.get(MavenProjectsManagerWatcher.this.myProject);
            PsiFile psiFile = PsiManager.getInstance((Project)MavenProjectsManagerWatcher.this.myProject).findFile(file);
            if (psiFile instanceof XmlFile) {
                try {
                    newCrc = MavenUtil.crcWithoutSpaces(file);
                }
                catch (IOException ignored) {
                    return true;
                }
            } else {
                newCrc = file.getModificationStamp();
            }
            if (newCrc == -1L || newCrc.equals(crc)) {
                return false;
            }
            map.put(MavenProjectsManagerWatcher.this.myProject, newCrc);
            return true;
        }

        @Nullable
        private VirtualFile getPomFileProfilesFile(VirtualFile f) {
            if (!f.getName().equals("profiles.xml")) {
                return null;
            }
            return f.getParent().findChild("pom.xml");
        }

        @Override
        protected void apply() {
            if (this.areFileSetsInitialised()) {
                if (this.settingsHaveChanged) {
                    MavenProjectsManagerWatcher.this.onSettingsXmlChange();
                } else {
                    this.filesToUpdate.removeAll(this.filesToRemove);
                    MavenProjectsManagerWatcher.this.scheduleUpdate(this.filesToUpdate, this.filesToRemove, false, this.forceImportAndResolve);
                }
            }
            this.clearLists();
        }

        private boolean areFileSetsInitialised() {
            return this.filesToUpdate != null;
        }

        private void initLists() {
            if (this.areFileSetsInitialised()) {
                return;
            }
            this.filesToUpdate = new ArrayList<VirtualFile>();
            this.filesToRemove = new ArrayList<VirtualFile>();
            this.settingsHaveChanged = false;
            this.forceImportAndResolve = false;
        }

        private void clearLists() {
            this.filesToUpdate = null;
            this.filesToRemove = null;
        }
    }

    private class MyRootChangesListener
    extends ModuleRootAdapter {
        private MyRootChangesListener() {
        }

        public void rootsChanged(ModuleRootEvent event) {
            List<VirtualFile> existingFiles = MavenProjectsManagerWatcher.this.myProjectsTree.getProjectsFiles();
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> deletedFiles = new ArrayList<VirtualFile>();
            for (VirtualFile f : MavenProjectsManagerWatcher.this.myProjectsTree.getExistingManagedFiles()) {
                if (existingFiles.contains(f)) continue;
                newFiles.add(f);
            }
            for (VirtualFile f : existingFiles) {
                if (f.isValid()) continue;
                deletedFiles.add(f);
            }
            MavenProjectsManagerWatcher.this.scheduleUpdate(newFiles, deletedFiles, false, false);
        }
    }
}

