/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailcapCommandMap
extends CommandMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static boolean debug = false;
    private static final int NORMAL = 0;
    private static final int FALLBACK = 1;
    private Map<String, Map<String, List<String>>>[][] mailcaps;

    static {
        try {
            String d = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(d);
        }
        catch (SecurityException securityException) {}
    }

    public MailcapCommandMap() {
        this.init(null);
    }

    public MailcapCommandMap(String fileName) throws IOException {
        FileReader in = null;
        try {
            in = new FileReader(fileName);
        }
        catch (IOException iOException) {}
        this.init(in);
        if (in != null) {
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public MailcapCommandMap(InputStream is) {
        this.init(new InputStreamReader(is));
    }

    private void init(Reader in) {
        List<URL> systemResources;
        int len;
        this.mailcaps = new Map[5][2];
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 2) {
                this.mailcaps[i][j] = new LinkedHashMap<String, Map<String, List<String>>>();
                ++j;
            }
            ++i;
        }
        if (in != null) {
            if (debug) {
                System.out.println("MailcapCommandMap: load PROG");
            }
            try {
                this.parse(0, in);
            }
            catch (IOException iOException) {}
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load HOME");
        }
        try {
            String home = System.getProperty("user.home");
            if (home != null) {
                this.parseFile(1, new CPStringBuilder(home).append(File.separatorChar).append(".mailcap").toString());
            }
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MailcapCommandMap: load SYS");
        }
        try {
            this.parseFile(2, new CPStringBuilder(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mailcap").toString());
        }
        catch (SecurityException securityException) {}
        if (debug) {
            System.out.println("MailcapCommandMap: load JAR");
        }
        if ((len = (systemResources = this.getSystemResources("META-INF/mailcap")).size()) > 0) {
            int i2 = 0;
            while (i2 < len) {
                block34: {
                    Reader urlIn = null;
                    URL url = systemResources.get(i2);
                    try {
                        try {
                            if (debug) {
                                System.out.println("\t" + url.toString());
                            }
                            urlIn = new InputStreamReader(url.openStream());
                            this.parse(3, urlIn);
                        }
                        catch (IOException e) {
                            if (debug) {
                                System.out.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                            }
                            if (urlIn != null) {
                                try {
                                    urlIn.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        if (urlIn != null) {
                            try {
                                urlIn.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (urlIn != null) {
                        try {
                            urlIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++i2;
            }
        } else {
            this.parseResource(3, "/META-INF/mailcap");
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        this.parseResource(4, "/META-INF/mailcap.default");
    }

    @Override
    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        ArrayList<String> verbList = new ArrayList<String>();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 5) {
                Map<String, List<String>> map = this.getCommands(this.mailcaps[j][i], mimeType);
                if (map != null) {
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        String verb = entry.getKey();
                        if (verbList.contains(verb)) continue;
                        List<String> classNames = entry.getValue();
                        String className = classNames.get(0);
                        CommandInfo cmd = new CommandInfo(verb, className);
                        cmdList.add(cmd);
                        verbList.add(verb);
                    }
                }
                ++j;
            }
            ++i;
        }
        CommandInfo[] cmds = new CommandInfo[cmdList.size()];
        cmdList.toArray(cmds);
        return cmds;
    }

    @Override
    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 5) {
                Map<String, List<String>> map = this.getCommands(this.mailcaps[j][i], mimeType);
                if (map != null) {
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        String verb = entry.getKey();
                        List<String> classNames = entry.getValue();
                        int len = classNames.size();
                        int l = 0;
                        while (l < len) {
                            String className = classNames.get(l);
                            CommandInfo cmd = new CommandInfo(verb, className);
                            cmdList.add(cmd);
                            ++l;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        CommandInfo[] cmds = new CommandInfo[cmdList.size()];
        cmdList.toArray(cmds);
        return cmds;
    }

    @Override
    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 5) {
                Map<String, List<String>> map = this.getCommands(this.mailcaps[j][i], mimeType);
                if (map != null) {
                    List<String> classNames = map.get(cmdName);
                    if (classNames == null) {
                        classNames = map.get("x-java-" + cmdName);
                    }
                    if (classNames != null) {
                        String className = classNames.get(0);
                        return new CommandInfo(cmdName, className);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public synchronized void addMailcap(String mailcap) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        try {
            this.parse(0, new StringReader(mailcap));
        }
        catch (IOException iOException) {}
    }

    @Override
    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + mimeType);
        }
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 5) {
                block14: {
                    Map<String, List<String>> map;
                    if (debug) {
                        System.out.println("  search DB #" + i);
                    }
                    if ((map = this.getCommands(this.mailcaps[j][i], mimeType)) != null) {
                        List<String> classNames = map.get("content-handler");
                        if (classNames == null) {
                            classNames = map.get("x-java-content-handler");
                        }
                        if (classNames != null) {
                            String className = classNames.get(0);
                            if (debug) {
                                System.out.println("  In " + MailcapCommandMap.nameOf(j) + ", content-handler=" + className);
                            }
                            try {
                                Class<?> clazz = Class.forName(className);
                                return (DataContentHandler)clazz.newInstance();
                            }
                            catch (IllegalAccessException e) {
                                if (debug) {
                                    e.printStackTrace();
                                }
                            }
                            catch (ClassNotFoundException e) {
                                if (debug) {
                                    e.printStackTrace();
                                }
                            }
                            catch (InstantiationException e) {
                                if (!debug) break block14;
                                e.printStackTrace();
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public String[] getNativeCommands(String mimeType) {
        ArrayList<String> acc = new ArrayList<String>();
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 5) {
                this.addNativeCommands(acc, this.mailcaps[j][i], mimeType);
                ++j;
            }
            ++i;
        }
        String[] ret = new String[acc.size()];
        acc.toArray(ret);
        return ret;
    }

    private void addNativeCommands(List<String> acc, Map<String, Map<String, List<String>>> mailcap, String mimeType) {
        for (Map.Entry<String, Map<String, List<String>>> mEntry : mailcap.entrySet()) {
            Map<String, List<String>> commands;
            String viewCommand;
            String entryMimeType = mEntry.getKey();
            if (!entryMimeType.equals(mimeType) || (viewCommand = (commands = mEntry.getValue()).get("view-command").get(0)) == null) continue;
            CPStringBuilder buf = new CPStringBuilder();
            buf.append(mimeType);
            buf.append(';');
            buf.append(' ');
            buf.append(viewCommand);
            for (Map.Entry<String, List<String>> cEntry : commands.entrySet()) {
                String verb = cEntry.getKey();
                List<String> classNames = cEntry.getValue();
                if ("view-command".equals(verb)) continue;
                for (String command : classNames) {
                    buf.append(';');
                    buf.append(' ');
                    buf.append(verb);
                    buf.append('=');
                    buf.append(command);
                }
            }
            if (buf.length() <= 0) continue;
            acc.add(buf.toString());
        }
    }

    private static String nameOf(int mailcap) {
        switch (mailcap) {
            case 0: {
                return "PROG";
            }
            case 1: {
                return "HOME";
            }
            case 2: {
                return "SYS";
            }
            case 3: {
                return "JAR";
            }
            case 4: {
                return "DEF";
            }
        }
        return "ERR";
    }

    private void parseFile(int index, String filename) {
        block16: {
            Reader in = null;
            try {
                try {
                    if (debug) {
                        System.out.println("\t" + filename);
                    }
                    in = new FileReader(filename);
                    this.parse(index, in);
                }
                catch (IOException e) {
                    if (debug) {
                        System.out.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseResource(int index, String name) {
        block17: {
            Reader in = null;
            try {
                try {
                    InputStream is = this.getClass().getResourceAsStream(name);
                    if (is != null) {
                        if (debug) {
                            System.out.println("\t" + name);
                        }
                        in = new InputStreamReader(is);
                        this.parse(index, in);
                    }
                }
                catch (IOException e) {
                    if (debug) {
                        System.out.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parse(int index, Reader in) throws IOException {
        BufferedReader br = new BufferedReader(in);
        CPStringBuilder buf = null;
        String line = br.readLine();
        while (line != null) {
            int len = (line = line.trim()).length();
            if (len != 0 && line.charAt(0) != '#') {
                if (line.charAt(len - 1) == '\\') {
                    if (buf == null) {
                        buf = new CPStringBuilder();
                    }
                    buf.append(line.substring(0, len - 1));
                } else if (buf != null) {
                    buf.append(line);
                    this.parseEntry(index, buf.toString());
                    buf = null;
                } else {
                    this.parseEntry(index, line);
                }
            }
            line = br.readLine();
        }
    }

    private void parseEntry(int index, String line) {
        char[] chars = line.toCharArray();
        int len = chars.length;
        boolean inQuotedString = false;
        boolean fallback = false;
        CPStringBuilder buffer = new CPStringBuilder();
        ArrayList<String> fields = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char c = chars[i];
            if (c == '\\') {
                c = chars[++i];
            }
            if (c == ';' && !inQuotedString) {
                String field = buffer.toString().trim();
                if ("x-java-fallback-entry".equals(field)) {
                    fallback = true;
                }
                fields.add(field);
                buffer.setLength(0);
            } else {
                if (c == '\"') {
                    inQuotedString = !inQuotedString;
                }
                buffer.append(c);
            }
            ++i;
        }
        String field = buffer.toString().trim();
        if ("x-java-fallback-entry".equals(field)) {
            fallback = true;
        }
        fields.add(field);
        len = fields.size();
        if (len < 2) {
            if (debug) {
                System.err.println("Invalid mailcap entry: " + line);
            }
            return;
        }
        Map<String, Map<String, List<String>>> mailcap = fallback ? this.mailcaps[index][1] : this.mailcaps[index][0];
        String mimeType = (String)fields.get(0);
        this.addField(mailcap, mimeType, "view-command", (String)fields.get(1));
        int i2 = 2;
        while (i2 < len) {
            this.addField(mailcap, mimeType, null, (String)fields.get(i2));
            ++i2;
        }
    }

    private void addField(Map<String, Map<String, List<String>>> mailcap, String mimeType, String verb, String command) {
        List<String> classNames;
        int ei;
        if (verb == null && (ei = command.indexOf(61)) != -1) {
            verb = command.substring(0, ei);
            command = command.substring(ei + 1);
        }
        if (command.length() == 0 || verb == null || verb.length() == 0) {
            return;
        }
        Map<String, List<String>> commands = mailcap.get(mimeType);
        if (commands == null) {
            commands = new LinkedHashMap<String, List<String>>();
            mailcap.put(mimeType, commands);
        }
        if ((classNames = commands.get(verb)) == null) {
            classNames = new ArrayList<String>();
            commands.put(verb, classNames);
        }
        classNames.add(command);
    }

    private Map<String, List<String>> getCommands(Map<String, Map<String, List<String>>> mailcap, String mimeType) {
        int si = mimeType.indexOf(47);
        String genericMimeType = new CPStringBuilder(mimeType.substring(0, si)).append('/').append('*').toString();
        Map<String, List<String>> specific = mailcap.get(mimeType);
        Map<String, List<String>> generic = mailcap.get(genericMimeType);
        if (generic == null) {
            return specific;
        }
        if (specific == null) {
            return generic;
        }
        LinkedHashMap<String, List<String>> combined = new LinkedHashMap<String, List<String>>();
        combined.putAll(specific);
        for (String verb : generic.keySet()) {
            List<String> genericClassNames = generic.get(verb);
            List classNames = (List)combined.get(verb);
            if (classNames == null) {
                combined.put(verb, genericClassNames);
                continue;
            }
            classNames.addAll(genericClassNames);
        }
        return combined;
    }

    private List<URL> getSystemResources(String name) {
        ArrayList<URL> acc = new ArrayList<URL>();
        try {
            Enumeration<URL> i = ClassLoader.getSystemResources(name);
            while (i.hasMoreElements()) {
                acc.add(i.nextElement());
            }
        }
        catch (IOException iOException) {}
        return acc;
    }
}

