/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<T>
extends AbstractSequentialList<T>
implements List<T>,
Deque<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    transient Entry<T> first;
    transient Entry<T> last;
    transient int size = 0;

    Entry<T> getEntry(int n) {
        Entry<T> e;
        if (n < this.size / 2) {
            e = this.first;
            while (n-- > 0) {
                e = e.next;
            }
        } else {
            e = this.last;
            while (++n < this.size) {
                e = e.previous;
            }
        }
        return e;
    }

    void removeEntry(Entry<T> e) {
        ++this.modCount;
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        } else if (e == this.first) {
            this.first = e.next;
            e.next.previous = null;
        } else if (e == this.last) {
            this.last = e.previous;
            e.previous.next = null;
        } else {
            e.next.previous = e.previous;
            e.previous.next = e.next;
        }
    }

    private void checkBoundsInclusive(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    public LinkedList() {
    }

    public LinkedList(Collection<? extends T> c) {
        this.addAll(c);
    }

    @Override
    public T getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.data;
    }

    @Override
    public T getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.last.data;
    }

    @Override
    public T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object r = this.first.data;
        if (this.first.next != null) {
            this.first.next.previous = null;
        } else {
            this.last = null;
        }
        this.first = this.first.next;
        return r;
    }

    @Override
    public T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object r = this.last.data;
        if (this.last.previous != null) {
            this.last.previous.next = null;
        } else {
            this.first = null;
        }
        this.last = this.last.previous;
        return r;
    }

    @Override
    public void addFirst(T o) {
        Entry<T> e = new Entry<T>(o);
        ++this.modCount;
        if (this.size == 0) {
            this.last = e;
            this.first = this.last;
        } else {
            e.next = this.first;
            this.first.previous = e;
            this.first = e;
        }
        ++this.size;
    }

    @Override
    public void addLast(T o) {
        this.addLastEntry(new Entry<T>(o));
    }

    private void addLastEntry(Entry<T> e) {
        ++this.modCount;
        if (this.size == 0) {
            this.last = e;
            this.first = this.last;
        } else {
            e.previous = this.last;
            this.last.next = e;
            this.last = e;
        }
        ++this.size;
    }

    @Override
    public boolean contains(Object o) {
        Entry<T> e = this.first;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T o) {
        this.addLastEntry(new Entry<T>(o));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Entry<T> e = this.first;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                this.removeEntry(e);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.checkBoundsInclusive(index);
        int csize = c.size();
        if (csize == 0) {
            return false;
        }
        Iterator<T> itr = c.iterator();
        Entry<T> after = null;
        Entry<T> before = null;
        if (index != this.size) {
            after = this.getEntry(index);
            before = after.previous;
        } else {
            before = this.last;
        }
        Entry<T> e = new Entry<T>(itr.next());
        e.previous = before;
        Entry<T> prev = e;
        Entry<T> firstNew = e;
        int pos = 1;
        while (pos < csize) {
            e = new Entry<T>(itr.next());
            e.previous = prev;
            prev.next = e;
            prev = e;
            ++pos;
        }
        ++this.modCount;
        this.size += csize;
        prev.next = after;
        if (after != null) {
            after.previous = e;
        } else {
            this.last = e;
        }
        if (before != null) {
            before.next = firstNew;
        } else {
            this.first = firstNew;
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.first = null;
            this.last = null;
            this.size = 0;
        }
    }

    @Override
    public T get(int index) {
        this.checkBoundsExclusive(index);
        return this.getEntry((int)index).data;
    }

    @Override
    public T set(int index, T o) {
        this.checkBoundsExclusive(index);
        Entry<T> e = this.getEntry(index);
        Object old = e.data;
        e.data = o;
        return old;
    }

    @Override
    public void add(int index, T o) {
        this.checkBoundsInclusive(index);
        Entry<T> e = new Entry<T>(o);
        if (index < this.size) {
            ++this.modCount;
            Entry<T> after = this.getEntry(index);
            e.next = after;
            e.previous = after.previous;
            if (after.previous == null) {
                this.first = e;
            } else {
                after.previous.next = e;
            }
            after.previous = e;
            ++this.size;
        } else {
            this.addLastEntry(e);
        }
    }

    @Override
    public T remove(int index) {
        this.checkBoundsExclusive(index);
        Entry<T> e = this.getEntry(index);
        this.removeEntry(e);
        return e.data;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        Entry<T> e = this.first;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size - 1;
        Entry<T> e = this.last;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                return index;
            }
            --index;
            e = e.previous;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.checkBoundsInclusive(index);
        return new LinkedListItr(index);
    }

    public Object clone() {
        LinkedList copy = null;
        try {
            copy = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        copy.clear();
        copy.addAll(this);
        return copy;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        Entry<T> e = this.first;
        int i = 0;
        while (i < this.size) {
            array[i] = e.data;
            e = e.next;
            ++i;
        }
        return array;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        } else if (a.length > this.size) {
            a[this.size] = null;
        }
        Entry<T> e = this.first;
        int i = 0;
        while (i < this.size) {
            a[i] = e.data;
            e = e.next;
            ++i;
        }
        return a;
    }

    @Override
    public boolean offer(T value) {
        return this.add(value);
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    public T peek() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Entry<T> e = this.first;
        while (e != null) {
            s.writeObject(e.data);
            e = e.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int i = s.readInt();
        while (--i >= 0) {
            this.addLastEntry(new Entry<Object>(s.readObject()));
        }
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new Iterator<T>(){
            private int knownMod;
            private Entry<T> next;
            private Entry<T> lastReturned;
            private int position;
            {
                this.knownMod = LinkedList.this.modCount;
                this.next = LinkedList.this.last;
                this.position = LinkedList.this.size() - 1;
            }

            private void checkMod() {
                if (this.knownMod != LinkedList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                this.checkMod();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                --this.position;
                this.lastReturned = this.next;
                this.next = this.lastReturned.previous;
                return this.lastReturned.data;
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                LinkedList.this.removeEntry(this.lastReturned);
                this.lastReturned = null;
                ++this.knownMod;
            }
        };
    }

    @Override
    public boolean offerFirst(T value) {
        this.addFirst(value);
        return true;
    }

    @Override
    public boolean offerLast(T value) {
        return this.add(value);
    }

    @Override
    public T peekFirst() {
        return this.peek();
    }

    @Override
    public T peekLast() {
        if (this.size == 0) {
            return null;
        }
        return this.getLast();
    }

    @Override
    public T pollFirst() {
        return this.poll();
    }

    @Override
    public T pollLast() {
        if (this.size == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public void push(T value) {
        this.addFirst(value);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Entry<T> e = this.last;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                this.removeEntry(e);
                return true;
            }
            e = e.previous;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<T> {
        T data;
        Entry<T> next;
        Entry<T> previous;

        Entry(T data) {
            this.data = data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LinkedListItr<I>
    implements ListIterator<I> {
        private int knownMod;
        private Entry<I> next;
        private Entry<I> previous;
        private Entry<I> lastReturned;
        private int position;

        LinkedListItr(int index) {
            this.knownMod = LinkedList.this.modCount;
            if (index == LinkedList.this.size) {
                this.next = null;
                this.previous = LinkedList.this.last;
            } else {
                this.next = LinkedList.this.getEntry(index);
                this.previous = this.next.previous;
            }
            this.position = index;
        }

        private void checkMod() {
            if (this.knownMod != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int nextIndex() {
            return this.position;
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        public I next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.previous = this.next;
            this.lastReturned = this.previous;
            this.next = this.lastReturned.next;
            return (I)this.lastReturned.data;
        }

        @Override
        public I previous() {
            this.checkMod();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            --this.position;
            this.next = this.previous;
            this.lastReturned = this.next;
            this.previous = this.lastReturned.previous;
            return (I)this.lastReturned.data;
        }

        @Override
        public void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                --this.position;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            LinkedList.this.removeEntry(this.lastReturned);
            ++this.knownMod;
            this.lastReturned = null;
        }

        @Override
        public void add(I o) {
            this.checkMod();
            ++LinkedList.this.modCount;
            ++this.knownMod;
            ++LinkedList.this.size;
            ++this.position;
            Entry<I> e = new Entry<I>(o);
            e.previous = this.previous;
            e.next = this.next;
            if (this.previous != null) {
                this.previous.next = e;
            } else {
                LinkedList.this.first = e;
            }
            if (this.next != null) {
                this.next.previous = e;
            } else {
                LinkedList.this.last = e;
            }
            this.previous = e;
            this.lastReturned = null;
        }

        @Override
        public void set(I o) {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.data = o;
        }
    }
}

