/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;
    private byte[] buf;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int value) throws IOException {
        this.out.write(value);
        ++this.written;
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        this.out.write(buf, offset, len);
        this.written += len;
    }

    public final void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public final void writeByte(int value) throws IOException {
        this.write(value & 0xFF);
    }

    public final synchronized void writeShort(int value) throws IOException {
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value));
    }

    public final synchronized void writeChar(int value) throws IOException {
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value));
    }

    public final synchronized void writeInt(int value) throws IOException {
        this.write((byte)(0xFF & value >> 24));
        this.write((byte)(0xFF & value >> 16));
        this.write((byte)(0xFF & value >> 8));
        this.write((byte)(0xFF & value));
    }

    public final synchronized void writeLong(long value) throws IOException {
        this.write((byte)(0xFFL & value >> 56));
        this.write((byte)(0xFFL & value >> 48));
        this.write((byte)(0xFFL & value >> 40));
        this.write((byte)(0xFFL & value >> 32));
        this.write((byte)(0xFFL & value >> 24));
        this.write((byte)(0xFFL & value >> 16));
        this.write((byte)(0xFFL & value >> 8));
        this.write((byte)(0xFFL & value));
    }

    public final void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public final void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public final void writeBytes(String value) throws IOException {
        int len = value.length();
        int i = 0;
        while (i < len) {
            this.writeByte(value.charAt(i));
            ++i;
        }
    }

    public final void writeChars(String value) throws IOException {
        int len = value.length();
        int i = 0;
        while (i < len) {
            this.writeChar(value.charAt(i));
            ++i;
        }
    }

    long getUTFlength(String value, int start, long sum) {
        int len = value.length();
        int i = start;
        while (i < len) {
            char c = value.charAt(i);
            sum = c >= '\u0001' && c <= '\u007f' ? ++sum : (c == '\u0000' || c >= '\u0080' && c <= '\u07ff' ? (sum += 2L) : (sum += 3L));
            ++i;
        }
        return sum;
    }

    public final synchronized void writeUTF(String value) throws IOException {
        long l = this.getUTFlength(value, 0, 0L);
        if (l > 65535L) {
            throw new UTFDataFormatException();
        }
        this.writeUTFShort(value, (int)l);
    }

    final synchronized void writeUTFShort(String value, int bytelen) throws IOException {
        this.writeShort(bytelen);
        this.writeUTFBytes(value);
    }

    final synchronized void writeUTFLong(String value, long bytelen) throws IOException {
        this.writeLong(bytelen);
        this.writeUTFBytes(value);
    }

    private final synchronized void writeUTFBytes(String value) throws IOException {
        int len = value.length();
        int i = 0;
        int pos = 0;
        if (this.buf == null) {
            this.buf = new byte[512];
        }
        while (true) {
            if (i < len && pos < this.buf.length - 3) {
                char c;
                if ((c = value.charAt(i++)) >= '\u0001' && c <= '\u007f') {
                    this.buf[pos++] = (byte)c;
                    continue;
                }
                if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                    this.buf[pos++] = (byte)(0xC0 | 0x1F & c >> 6);
                    this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                    continue;
                }
                this.buf[pos++] = (byte)(0xE0 | 0xF & c >> 12);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c >> 6);
                this.buf[pos++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            this.write(this.buf, 0, pos);
            pos = 0;
            if (i >= len) break;
        }
    }
}

