/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.classpath.SystemProperties;
import gnu.java.awt.ClasspathToolkit;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Locale;

public abstract class GraphicsEnvironment {
    private static GraphicsEnvironment localGraphicsEnvironment;

    protected GraphicsEnvironment() {
    }

    public static GraphicsEnvironment getLocalGraphicsEnvironment() {
        if (localGraphicsEnvironment != null) {
            return localGraphicsEnvironment;
        }
        String graphicsenv = SystemProperties.getProperty("java.awt.graphicsenv", null);
        if (graphicsenv != null) {
            try {
                localGraphicsEnvironment = (GraphicsEnvironment)Class.forName(graphicsenv).newInstance();
                return localGraphicsEnvironment;
            }
            catch (Exception x) {
                throw (InternalError)new InternalError("Unable to instantiate java.awt.graphicsenv").initCause(x);
            }
        }
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        localGraphicsEnvironment = tk.getLocalGraphicsEnvironment();
        return localGraphicsEnvironment;
    }

    public static boolean isHeadless() {
        String headless = SystemProperties.getProperty("java.awt.headless", null);
        return "true".equalsIgnoreCase(headless);
    }

    public boolean isHeadlessInstance() {
        return GraphicsEnvironment.isHeadless();
    }

    public abstract GraphicsDevice[] getScreenDevices();

    public abstract GraphicsDevice getDefaultScreenDevice();

    public abstract Graphics2D createGraphics(BufferedImage var1);

    public abstract Font[] getAllFonts();

    public abstract String[] getAvailableFontFamilyNames();

    public abstract String[] getAvailableFontFamilyNames(Locale var1);

    public Point getCenterPoint() {
        Rectangle r = this.getMaximumWindowBounds();
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public Rectangle getMaximumWindowBounds() {
        return this.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }
}

