/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

public class DCT {
    public double[][] c = new double[8][8];
    public double[][] cT = new double[8][8];

    public DCT() {
        this.initMatrix();
    }

    public static double C(int u) {
        return u == 0 ? 1.0 / Math.sqrt(2.0) : 1.0;
    }

    private void initMatrix() {
        int j = 0;
        while (j < 8) {
            double nn = 8.0;
            this.c[0][j] = 1.0 / Math.sqrt(nn);
            this.cT[j][0] = this.c[0][j];
            ++j;
        }
        int i = 1;
        while (i < 8) {
            int j2 = 0;
            while (j2 < 8) {
                double jj = j2;
                double ii = i;
                this.c[i][j2] = Math.sqrt(0.25) * Math.cos((2.0 * jj + 1.0) * ii * Math.PI / 16.0);
                this.cT[j2][i] = this.c[i][j2];
                ++j2;
            }
            ++i;
        }
    }

    public static double[][] slow_idct(double[][] matrix) {
        double[][] output = new double[matrix.length][matrix.length];
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 8) {
                double val = 0.0;
                double v = 0.0;
                while (v < 8.0) {
                    double innerloop = 0.0;
                    double u = 0.0;
                    while (u < 8.0) {
                        innerloop += DCT.C((int)u) / 2.0 * matrix[(int)v][(int)u] * Math.cos((double)(2 * x + 1) * u * Math.PI / 16.0) * Math.cos((double)(2 * y + 1) * v * Math.PI / 16.0);
                        u += 1.0;
                    }
                    val += DCT.C((int)v) / 2.0 * innerloop;
                    v += 1.0;
                }
                output[y][x] = val + 128.0;
                ++x;
            }
            ++y;
        }
        return output;
    }

    public static float[][] slow_fdct(float[][] value) {
        float[][] buffer = new float[8][8];
        int u = 0;
        while (u < 8) {
            int v = 0;
            while (v < 8) {
                buffer[u][v] = 0.0f * (float)DCT.C(u) * (float)DCT.C(v);
                float innerval = 0.0f;
                int x = 0;
                while (x < 8) {
                    int y = 0;
                    while (y < 8) {
                        innerval = (float)((double)innerval + (double)value[y][x] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0) * Math.cos((double)((2 * y + 1) * v) * Math.PI / 16.0));
                        ++y;
                    }
                    ++x;
                }
                float[] fArray = buffer[u];
                int n = v++;
                fArray[n] = fArray[n] * innerval;
            }
            ++u;
        }
        return buffer;
    }

    public float[][] fast_fdct(float[][] input) {
        int k;
        int j;
        float[][] output = new float[8][8];
        double[][] temp = new double[8][8];
        int i = 0;
        while (i < 8) {
            j = 0;
            while (j < 8) {
                temp[i][j] = 0.0;
                k = 0;
                while (k < 8) {
                    double[] dArray = temp[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)((int)input[i][k] - 128) * this.cT[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            j = 0;
            while (j < 8) {
                double temp1 = 0.0;
                k = 0;
                while (k < 8) {
                    temp1 += this.c[i][k] * temp[k][j];
                    ++k;
                }
                output[i][j] = (int)Math.round(temp1) * 8;
                ++j;
            }
            ++i;
        }
        return output;
    }

    public double[][] fast_idct(double[][] input) {
        int k;
        int j;
        double[][] output = new double[8][8];
        double[][] temp = new double[8][8];
        int i = 0;
        while (i < 8) {
            j = 0;
            while (j < 8) {
                temp[i][j] = 0.0;
                k = 0;
                while (k < 8) {
                    double[] dArray = temp[i];
                    int n = j;
                    dArray[n] = dArray[n] + input[i][k] * this.c[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            j = 0;
            while (j < 8) {
                double temp1 = 0.0;
                k = 0;
                while (k < 8) {
                    temp1 += this.cT[i][k] * temp[k][j];
                    ++k;
                }
                output[i][j] = (temp1 += 128.0) < 0.0 ? 0.0 : (temp1 > 255.0 ? 255.0 : (double)((int)Math.round(temp1)));
                ++j;
            }
            ++i;
        }
        return output;
    }

    public double[][] idj_fast_fdct(float[][] input) {
        double z13;
        double z11;
        double z3;
        double z4;
        double z2;
        double z5;
        double z1;
        double tmp12;
        double tmp11;
        double tmp13;
        double tmp10;
        double tmp4;
        double tmp3;
        double tmp5;
        double tmp2;
        double tmp6;
        double tmp1;
        double tmp7;
        double tmp0;
        double[][] output = new double[8][8];
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                output[i][j] = (double)input[i][j] - 128.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            tmp0 = output[i][0] + output[i][7];
            tmp7 = output[i][0] - output[i][7];
            tmp1 = output[i][1] + output[i][6];
            tmp6 = output[i][1] - output[i][6];
            tmp2 = output[i][2] + output[i][5];
            tmp5 = output[i][2] - output[i][5];
            tmp3 = output[i][3] + output[i][4];
            tmp4 = output[i][3] - output[i][4];
            tmp10 = tmp0 + tmp3;
            tmp13 = tmp0 - tmp3;
            tmp11 = tmp1 + tmp2;
            tmp12 = tmp1 - tmp2;
            output[i][0] = tmp10 + tmp11;
            output[i][4] = tmp10 - tmp11;
            z1 = (tmp12 + tmp13) * 0.707106781;
            output[i][2] = tmp13 + z1;
            output[i][6] = tmp13 - z1;
            tmp10 = tmp4 + tmp5;
            tmp11 = tmp5 + tmp6;
            tmp12 = tmp6 + tmp7;
            z5 = (tmp10 - tmp12) * 0.382683433;
            z2 = 0.5411961 * tmp10 + z5;
            z4 = 1.306562965 * tmp12 + z5;
            z3 = tmp11 * 0.707106781;
            z11 = tmp7 + z3;
            z13 = tmp7 - z3;
            output[i][5] = z13 + z2;
            output[i][3] = z13 - z2;
            output[i][1] = z11 + z4;
            output[i][7] = z11 - z4;
            ++i;
        }
        i = 0;
        while (i < 8) {
            tmp0 = output[0][i] + output[7][i];
            tmp7 = output[0][i] - output[7][i];
            tmp1 = output[1][i] + output[6][i];
            tmp6 = output[1][i] - output[6][i];
            tmp2 = output[2][i] + output[5][i];
            tmp5 = output[2][i] - output[5][i];
            tmp3 = output[3][i] + output[4][i];
            tmp4 = output[3][i] - output[4][i];
            tmp10 = tmp0 + tmp3;
            tmp13 = tmp0 - tmp3;
            tmp11 = tmp1 + tmp2;
            tmp12 = tmp1 - tmp2;
            output[0][i] = tmp10 + tmp11;
            output[4][i] = tmp10 - tmp11;
            z1 = (tmp12 + tmp13) * 0.707106781;
            output[2][i] = tmp13 + z1;
            output[6][i] = tmp13 - z1;
            tmp10 = tmp4 + tmp5;
            tmp11 = tmp5 + tmp6;
            tmp12 = tmp6 + tmp7;
            z5 = (tmp10 - tmp12) * 0.382683433;
            z2 = 0.5411961 * tmp10 + z5;
            z4 = 1.306562965 * tmp12 + z5;
            z3 = tmp11 * 0.707106781;
            z11 = tmp7 + z3;
            z13 = tmp7 - z3;
            output[5][i] = z13 + z2;
            output[3][i] = z13 - z2;
            output[1][i] = z11 + z4;
            output[7][i] = z11 - z4;
            ++i;
        }
        return output;
    }
}

