/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMMemoryPoolMXBeanImpl;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import javax.management.NotCompliantMBeanException;

public final class MemoryPoolMXBeanImpl
extends BeanImpl
implements MemoryPoolMXBean {
    private String name;
    private static final String COLLECTION_USAGE_THRESHOLD = "gnu.java.lang.management.CollectionUsageThresholdSupport";
    private static final String USAGE_THRESHOLD = "gnu.java.lang.management.UsageThresholdSupport";

    public MemoryPoolMXBeanImpl(String name) throws NotCompliantMBeanException {
        super((Class)MemoryPoolMXBean.class);
        this.name = name;
    }

    public MemoryUsage getCollectionUsage() {
        return VMMemoryPoolMXBeanImpl.getCollectionUsage(this.name);
    }

    public long getCollectionUsageThreshold() {
        if (this.isCollectionUsageThresholdSupported()) {
            return VMMemoryPoolMXBeanImpl.getCollectionUsageThreshold(this.name);
        }
        throw new UnsupportedOperationException("A collection usage threshold is not supported.");
    }

    public long getCollectionUsageThresholdCount() {
        if (this.isCollectionUsageThresholdSupported()) {
            return VMMemoryPoolMXBeanImpl.getCollectionUsageThresholdCount(this.name);
        }
        throw new UnsupportedOperationException("A collection usage threshold is not supported.");
    }

    public String[] getMemoryManagerNames() {
        return VMMemoryPoolMXBeanImpl.getMemoryManagerNames(this.name);
    }

    public String getName() {
        return this.name;
    }

    public MemoryUsage getPeakUsage() {
        if (this.isValid()) {
            return VMMemoryPoolMXBeanImpl.getPeakUsage(this.name);
        }
        return null;
    }

    public MemoryType getType() {
        return MemoryType.valueOf(VMMemoryPoolMXBeanImpl.getType(this.name));
    }

    public MemoryUsage getUsage() {
        if (this.isValid()) {
            return VMMemoryPoolMXBeanImpl.getUsage(this.name);
        }
        return null;
    }

    public long getUsageThreshold() {
        if (this.isUsageThresholdSupported()) {
            return VMMemoryPoolMXBeanImpl.getUsageThreshold(this.name);
        }
        throw new UnsupportedOperationException("A usage threshold is not supported.");
    }

    public long getUsageThresholdCount() {
        if (this.isUsageThresholdSupported()) {
            return VMMemoryPoolMXBeanImpl.getUsageThresholdCount(this.name);
        }
        throw new UnsupportedOperationException("A usage threshold is not supported.");
    }

    public boolean isCollectionUsageThresholdExceeded() {
        return this.getCollectionUsage().getUsed() >= this.getCollectionUsageThreshold();
    }

    public boolean isCollectionUsageThresholdSupported() {
        return SystemProperties.getProperty(COLLECTION_USAGE_THRESHOLD) != null;
    }

    public boolean isUsageThresholdExceeded() {
        return this.getUsage().getUsed() >= this.getUsageThreshold();
    }

    public boolean isUsageThresholdSupported() {
        return SystemProperties.getProperty(USAGE_THRESHOLD) != null;
    }

    public boolean isValid() {
        return VMMemoryPoolMXBeanImpl.isValid(this.name);
    }

    public void resetPeakUsage() {
        this.checkControlPermissions();
        VMMemoryPoolMXBeanImpl.resetPeakUsage(this.name);
    }

    public void setCollectionUsageThreshold(long threshold) {
        this.checkControlPermissions();
        if (threshold < 0L) {
            throw new IllegalArgumentException("Threshold of " + threshold + "is less than zero.");
        }
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("A collection usage threshold is not supported.");
        }
        VMMemoryPoolMXBeanImpl.setCollectionUsageThreshold(this.name, threshold);
    }

    public void setUsageThreshold(long threshold) {
        this.checkControlPermissions();
        if (threshold < 0L) {
            throw new IllegalArgumentException("Threshold of " + threshold + "is less than zero.");
        }
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("A usage threshold is not supported.");
        }
        VMMemoryPoolMXBeanImpl.setUsageThreshold(this.name, threshold);
    }
}

