/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import gnu.classpath.ServiceProviderLoadingAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceFactory {
    private static final Logger LOGGER = Logger.getLogger("gnu.classpath");

    private ServiceFactory() {
    }

    public static <P> Iterator<P> lookupProviders(Class<P> spi, ClassLoader loader) {
        return ServiceFactory.lookupProviders(spi, loader, false);
    }

    public static <P> Iterator<P> lookupProviders(Class<P> spi, ClassLoader loader, boolean error) {
        Enumeration<URL> urls;
        if (spi == null) {
            throw new IllegalArgumentException();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String resourceName = "META-INF/services/" + spi.getName();
        try {
            urls = loader.getResources(resourceName);
        }
        catch (IOException ioex) {
            ServiceFactory.log(Level.WARNING, "cannot access {0}", resourceName, ioex);
            if (error) {
                throw new ServiceConfigurationError("Failed to access + " + resourceName, ioex);
            }
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        return new ServiceIterator<P>(spi, urls, loader, error, AccessController.getContext());
    }

    public static <P> Iterator<P> lookupProviders(Class<P> spi) {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        return ServiceFactory.lookupProviders(spi, ctxLoader);
    }

    static void log(Level level, String msg, Object param, Throwable t) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        LogRecord rec = new LogRecord(level, msg);
        if (param != null && param.getClass().isArray()) {
            rec.setParameters((Object[])param);
        } else {
            rec.setParameters(new Object[]{param});
        }
        rec.setThrown(t);
        rec.setSourceClassName(ServiceFactory.class.getName());
        rec.setSourceMethodName("lookupProviders");
        LOGGER.log(rec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServiceIterator<P>
    implements Iterator<P> {
        private final Class<P> spi;
        private final Enumeration<URL> urls;
        private final ClassLoader loader;
        private final AccessControlContext securityContext;
        private BufferedReader reader;
        private URL currentURL;
        private P nextProvider;
        private boolean error;

        ServiceIterator(Class<P> spi, Enumeration<URL> urls, ClassLoader loader, boolean error, AccessControlContext securityContext) {
            this.spi = spi;
            this.urls = urls;
            this.loader = loader;
            this.securityContext = securityContext;
            this.error = error;
            this.nextProvider = this.loadNextServiceProvider();
        }

        @Override
        public P next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            P result = this.nextProvider;
            this.nextProvider = this.loadNextServiceProvider();
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.nextProvider != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private P loadNextServiceProvider() {
            if (this.reader == null) {
                this.advanceReader();
            }
            while (true) {
                String line;
                block9: {
                    if (this.reader == null) {
                        return null;
                    }
                    try {
                        line = this.reader.readLine();
                    }
                    catch (IOException readProblem) {
                        ServiceFactory.log(Level.WARNING, "IOException upon reading {0}", this.currentURL, readProblem);
                        line = null;
                        if (!this.error) break block9;
                        throw new ServiceConfigurationError("Error reading " + this.currentURL, readProblem);
                    }
                }
                if (line == null) {
                    this.advanceReader();
                    continue;
                }
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                try {
                    ServiceFactory.log(Level.FINE, "Loading service provider \"{0}\", specified by \"META-INF/services/{1}\" in {2}.", new Object[]{line, this.spi.getName(), this.currentURL}, null);
                    return AccessController.doPrivileged(new ServiceProviderLoadingAction<P>(this.spi, line, this.loader), this.securityContext);
                }
                catch (Exception ex) {
                    String msg = "Cannot load service provider class \"{0}\", specified by \"META-INF/services/{1}\" in {2}";
                    if (ex instanceof PrivilegedActionException && ex.getCause() instanceof ClassCastException) {
                        msg = "Service provider class \"{0}\" is not an instance of \"{1}\". Specified by \"META-INF/services/{1}\" in {2}.";
                    }
                    ServiceFactory.log(Level.WARNING, msg, new Object[]{line, this.spi.getName(), this.currentURL}, ex);
                    if (this.error) throw new ServiceConfigurationError("Cannot load service provider class " + line + " specified by " + "\"META-INF/services/" + this.spi.getName() + "\" in " + this.currentURL, ex);
                    continue;
                }
                break;
            }
        }

        private void advanceReader() {
            do {
                if (this.reader != null) {
                    block7: {
                        try {
                            this.reader.close();
                            ServiceFactory.log(Level.FINE, "closed {0}", this.currentURL, null);
                        }
                        catch (Exception ex) {
                            ServiceFactory.log(Level.WARNING, "cannot close {0}", this.currentURL, ex);
                            if (!this.error) break block7;
                            throw new ServiceConfigurationError("Cannot close " + this.currentURL, ex);
                        }
                    }
                    this.reader = null;
                    this.currentURL = null;
                }
                if (!this.urls.hasMoreElements()) {
                    return;
                }
                this.currentURL = this.urls.nextElement();
                try {
                    this.reader = new BufferedReader(new InputStreamReader(this.currentURL.openStream(), "UTF-8"));
                    ServiceFactory.log(Level.FINE, "opened {0}", this.currentURL, null);
                }
                catch (Exception ex) {
                    ServiceFactory.log(Level.WARNING, "cannot open {0}", this.currentURL, ex);
                    if (!this.error) continue;
                    throw new ServiceConfigurationError("Cannot open " + this.currentURL, ex);
                }
            } while (this.reader == null);
        }
    }
}

