/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.geobounds;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBoundsAggregator;
import org.elasticsearch.search.aggregations.metrics.geobounds.GeoBoundsAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class GeoBoundsAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoBoundsAggregationBuilder> {
    public static final String NAME = "geo_bounds";
    private static final InternalAggregation.Type TYPE = new InternalAggregation.Type("geo_bounds");
    private static final ObjectParser<GeoBoundsAggregationBuilder, QueryParseContext> PARSER = new ObjectParser("geo_bounds");
    private boolean wrapLongitude = true;

    public static AggregationBuilder parse(String aggregationName, QueryParseContext context) throws IOException {
        return PARSER.parse(context.parser(), new GeoBoundsAggregationBuilder(aggregationName), context);
    }

    public GeoBoundsAggregationBuilder(String name) {
        super(name, TYPE, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
    }

    public GeoBoundsAggregationBuilder(StreamInput in) throws IOException {
        super(in, TYPE, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.wrapLongitude);
    }

    public GeoBoundsAggregationBuilder wrapLongitude(boolean wrapLongitude) {
        this.wrapLongitude = wrapLongitude;
        return this;
    }

    public boolean wrapLongitude() {
        return this.wrapLongitude;
    }

    protected GeoBoundsAggregatorFactory innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new GeoBoundsAggregatorFactory(this.name, this.type, config, this.wrapLongitude, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(GeoBoundsAggregator.WRAP_LONGITUDE_FIELD.getPreferredName(), this.wrapLongitude);
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.wrapLongitude);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        GeoBoundsAggregationBuilder other = (GeoBoundsAggregationBuilder)obj;
        return Objects.equals(this.wrapLongitude, other.wrapLongitude);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareGeoFields(PARSER, false, false);
        PARSER.declareBoolean(GeoBoundsAggregationBuilder::wrapLongitude, GeoBoundsAggregator.WRAP_LONGITUDE_FIELD);
    }
}

