/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.repositories.blobstore.BlobStoreFormat;

public class LegacyBlobStoreFormat<T extends ToXContent>
extends BlobStoreFormat<T> {
    public LegacyBlobStoreFormat(String blobNameFormat, NamedXContentRegistry.FromXContent<T> reader, NamedXContentRegistry namedXContentRegistry) {
        super(blobNameFormat, reader, namedXContentRegistry);
    }

    @Override
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        try (InputStream inputStream = blobContainer.readBlob(blobName);){
            BytesStreamOutput out = new BytesStreamOutput();
            Streams.copy(inputStream, (OutputStream)out);
            Object t = this.read(out.bytes());
            return t;
        }
    }
}

