/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;

public final class floor
extends Primitive {
    private static final Primitive FLOOR = new floor();

    private floor() {
        super("floor", "number &optional divisor");
    }

    public LispObject execute(LispObject number) {
        LispObject quotient = number.truncate(Fixnum.ONE);
        LispThread thread = LispThread.currentThread();
        LispObject remainder = thread._values[1];
        if (!remainder.zerop() && number.minusp()) {
            quotient = quotient.decr();
            remainder = remainder.incr();
            thread._values[0] = quotient;
            thread._values[1] = remainder;
        }
        return quotient;
    }

    public LispObject execute(LispObject number, LispObject divisor) {
        LispObject quotient = number.truncate(divisor);
        LispThread thread = LispThread.currentThread();
        LispObject remainder = thread._values[1];
        boolean adjust = false;
        if (!remainder.zerop()) {
            if (divisor.minusp()) {
                if (number.plusp()) {
                    adjust = true;
                }
            } else if (number.minusp()) {
                adjust = true;
            }
        }
        if (adjust) {
            quotient = quotient.decr();
            remainder = remainder.add(divisor);
            thread._values[0] = quotient;
            thread._values[1] = remainder;
        }
        return quotient;
    }
}

