/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Date;
import java.util.TimeZone;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class Time {
    private static final Primitive _TIME = new Primitive("%time", Lisp.PACKAGE_SYS, false){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LispObject execute(LispObject arg) {
            LispObject lispObject;
            Cons.setCount(0L);
            long realStart = System.currentTimeMillis();
            try {
                lispObject = arg.execute();
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                long realElapsed = System.currentTimeMillis() - realStart;
                long count = Cons.getCount();
                Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
                out.freshLine();
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf((float)realElapsed / 1000.0f));
                sb.append(" seconds real time");
                sb.append(System.getProperty("line.separator"));
                sb.append(count);
                sb.append(" cons cell");
                if (count != 1L) {
                    sb.append('s');
                }
                sb.append(System.getProperty("line.separator"));
                out._writeString(sb.toString());
                out._finishOutput();
                throw throwable;
            }
            long realElapsed = System.currentTimeMillis() - realStart;
            long count = Cons.getCount();
            Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
            out.freshLine();
            StringBuilder sb = new StringBuilder();
            sb.append(String.valueOf((float)realElapsed / 1000.0f));
            sb.append(" seconds real time");
            sb.append(System.getProperty("line.separator"));
            sb.append(count);
            sb.append(" cons cell");
            if (count != 1L) {
                sb.append('s');
            }
            sb.append(System.getProperty("line.separator"));
            out._writeString(sb.toString());
            out._finishOutput();
            return lispObject;
        }
    };
    private static final Primitive GET_INTERNAL_REAL_TIME = new Primitive("get-internal-real-time", ""){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis());
        }
    };
    private static final Primitive GET_INTERNAL_RUN_TIME = new Primitive("get-internal-run-time", ""){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis());
        }
    };
    private static final Primitive GET_UNIVERSAL_TIME = new Primitive("get-universal-time", ""){

        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis() / 1000L + 2208988800L);
        }
    };
    public static final Primitive DEFAULT_TIME_ZONE = new pf_default_time_zone();
    public static final Primitive GET_TIME_ZONE = new pf_get_time_zone();

    @DocString(name="get-time-zone", args="time-in-millis", returns="timezone", doc="Return the timezone difference in hours for TIME-IN-MILLIS via the Daylight assumptions that were in place at its occurance. i.e. implement 'time of the time semantics'.")
    public static final class pf_get_time_zone
    extends Primitive {
        pf_get_time_zone() {
            super("get-time-zone", Lisp.PACKAGE_EXT, true, "time-in-millis");
        }

        public LispObject execute(LispObject unixTimeMillis) {
            TimeZone tz = TimeZone.getDefault();
            int rawOffset = tz.getRawOffset();
            boolean inDaylightTime = tz.inDaylightTime(new Date(unixTimeMillis.longValue()));
            if (inDaylightTime) {
                rawOffset += tz.getDSTSavings();
            }
            return LispThread.currentThread().setValues(Fixnum.getInstance(-rawOffset).divideBy(Fixnum.getInstance(3600000)), inDaylightTime ? Lisp.T : Lisp.NIL);
        }
    }

    @DocString(name="default-time-zone", args="", returns="offset daylight-p", doc="Returns the OFFSET of the default time zone for this instance of the implementation, and as a second value the state of the DAYLIGHT-P predicate.")
    public static final class pf_default_time_zone
    extends Primitive {
        pf_default_time_zone() {
            super("default-time-zone", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute() {
            return GET_TIME_ZONE.execute(LispInteger.getInstance(System.currentTimeMillis()));
        }
    }
}

