/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Arrays;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class StringFunctions {
    private static final Primitive __STRING_EQUAL = new pf___string_equal();
    private static final Primitive _STRING_EQUAL = new pf__string_equal();
    static final Primitive _STRING_NOT_EQUAL = new pf__string_not_equal();
    private static final Primitive _STRING_EQUAL_IGNORE_CASE = new pf__string_equal_ignore_case();
    static final Primitive _STRING_NOT_EQUAL_IGNORE_CASE = new pf__string_not_equal_ignore_case();
    private static final Primitive _STRING_LESS_THAN = new pf__string_less_than();
    private static final Primitive _STRING_GREATER_THAN = new pf__string_greater_than();
    private static final Primitive _STRING_LE = new pf__string_le();
    private static final Primitive _STRING_GE = new pf__string_ge();
    private static final Primitive _STRING_LESSP = new pf__string_lessp();
    private static final Primitive _STRING_GREATERP = new pf__string_greaterp();
    private static final Primitive _STRING_NOT_LESSP = new pf__string_not_lessp();
    private static final Primitive _STRING_NOT_GREATERP = new pf__string_not_greaterp();
    private static final Primitive _STRING_UPCASE = new pf__string_upcase();
    private static final Primitive _STRING_DOWNCASE = new pf__string_downcase();
    private static final Primitive _STRING_CAPITALIZE = new pf__string_capitalize();
    private static final Primitive _NSTRING_UPCASE = new pf__nstring_upcase();
    private static final Primitive _NSTRING_DOWNCASE = new pf__nstring_downcase();
    private static final Primitive _NSTRING_CAPITALIZE = new pf__nstring_capitalize();
    public static final Primitive STRINGP = new pf_stringp();
    public static final Primitive SIMPLE_STRING_P = new pf_simple_string_p();
    private static final Primitive _MAKE_STRING = new pf__make_string();
    private static final Primitive CHAR = new pf_char();
    private static final Primitive SCHAR = new pf_schar();
    private static final Primitive SET_CHAR = new pf_set_char();
    private static final Primitive SET_SCHAR = new pf_set_schar();
    private static final Primitive STRING_POSITION = new pf_string_position();
    private static final Primitive STRING_FIND = new pf_string_find();
    private static final Primitive SIMPLE_STRING_SEARCH = new pf_simple_string_search();
    private static final Primitive STRING_FILL = new pf_string_fill();

    private static final void checkParams(StringIndicesAndChars indicesAndChars) {
        if (indicesAndChars.start1 < 0 || indicesAndChars.start1 > indicesAndChars.array1.length) {
            Lisp.error(new TypeError("Invalid start position " + indicesAndChars.start1 + "."));
        }
        if (indicesAndChars.end1 < 0 || indicesAndChars.end1 > indicesAndChars.array1.length) {
            Lisp.error(new TypeError("Invalid end position " + indicesAndChars.end1 + "."));
        }
        if (indicesAndChars.start1 > indicesAndChars.end1) {
            Lisp.error(new TypeError("Start (" + indicesAndChars.start1 + ") is greater than end (" + indicesAndChars.end1 + ")."));
        }
        if (indicesAndChars.array2 != null) {
            if (indicesAndChars.start2 < 0 || indicesAndChars.start2 > indicesAndChars.array2.length) {
                Lisp.error(new TypeError("Invalid start2 position " + indicesAndChars.start2 + "."));
            }
            if (indicesAndChars.end2 < 0 || indicesAndChars.end2 > indicesAndChars.array2.length) {
                Lisp.error(new TypeError("Invalid end2 position " + indicesAndChars.end2 + "."));
            }
            if (indicesAndChars.start2 > indicesAndChars.end2) {
                Lisp.error(new TypeError("Start2 (" + indicesAndChars.start2 + ") is greater than end2 (" + indicesAndChars.end2 + ")."));
            }
        }
    }

    private static final char upcaseIfNeeded(char c, boolean convert) {
        return convert ? LispCharacter.toUpperCase(c) : c;
    }

    static final StringIndicesAndChars stringIndicesAndChars(LispObject ... params) {
        StringIndicesAndChars retVal = new StringIndicesAndChars();
        retVal.string1 = Lisp.checkString(params[0].STRING());
        retVal.array1 = retVal.string1.getStringChars();
        retVal.end1 = retVal.array1.length;
        if (params.length == 3) {
            if (params[1] != Lisp.NIL) {
                retVal.start1 = Fixnum.getValue(params[1]);
            }
            if (params[2] != Lisp.NIL) {
                retVal.end1 = Fixnum.getValue(params[2]);
            }
        } else {
            retVal.array2 = params[1].STRING().getStringChars();
            retVal.end2 = retVal.array2.length;
            if (params.length > 2) {
                if (params[2] != Lisp.NIL) {
                    retVal.start1 = Fixnum.getValue(params[2]);
                }
                if (params[3] != Lisp.NIL) {
                    retVal.end1 = Fixnum.getValue(params[3]);
                }
                if (params[4] != Lisp.NIL) {
                    retVal.start2 = Fixnum.getValue(params[4]);
                }
                if (params[5] != Lisp.NIL) {
                    retVal.end2 = Fixnum.getValue(params[5]);
                }
            }
        }
        StringFunctions.checkParams(retVal);
        return retVal;
    }

    static final int notEqual(StringIndicesAndChars indicesAndChars) {
        int i = indicesAndChars.start1;
        int j = indicesAndChars.start2;
        while (true) {
            if (i == indicesAndChars.end1) {
                if (j == indicesAndChars.end2) {
                    return -1;
                }
                return i;
            }
            if (j == indicesAndChars.end2) {
                return i;
            }
            if (StringFunctions.upcaseIfNeeded(indicesAndChars.array1[i], indicesAndChars.convertCase) != StringFunctions.upcaseIfNeeded(indicesAndChars.array2[j], indicesAndChars.convertCase)) {
                return i;
            }
            ++i;
            ++j;
        }
    }

    static final int lessThan(StringIndicesAndChars indicesAndChars) {
        char c2;
        char c1;
        int i = indicesAndChars.start1;
        int j = indicesAndChars.start2;
        while (true) {
            if (i == indicesAndChars.end1) {
                if (j == indicesAndChars.end2) {
                    return -1;
                }
                return i;
            }
            if (j == indicesAndChars.end2) {
                return -1;
            }
            c1 = StringFunctions.upcaseIfNeeded(indicesAndChars.array1[i], indicesAndChars.convertCase);
            if (c1 != (c2 = StringFunctions.upcaseIfNeeded(indicesAndChars.array2[j], indicesAndChars.convertCase))) break;
            ++i;
            ++j;
        }
        if (c1 < c2) {
            return i;
        }
        return -1;
    }

    static LispObject swapReturnValue(int original, StringIndicesAndChars indicesAndChars) {
        if (original < 0) {
            return Lisp.NIL;
        }
        int delta = original - indicesAndChars.start1;
        int retVal = indicesAndChars.start2 + delta;
        return Fixnum.getInstance(retVal);
    }

    static final int lessThanOrEqual(StringIndicesAndChars indicesAndChars) {
        char c2;
        char c1;
        int i = indicesAndChars.start1;
        int j = indicesAndChars.start2;
        while (true) {
            if (i == indicesAndChars.end1) {
                return i;
            }
            if (j == indicesAndChars.end2) {
                return -1;
            }
            c1 = StringFunctions.upcaseIfNeeded(indicesAndChars.array1[i], indicesAndChars.convertCase);
            if (c1 != (c2 = StringFunctions.upcaseIfNeeded(indicesAndChars.array2[j], indicesAndChars.convertCase))) break;
            ++i;
            ++j;
        }
        if (c1 > c2) {
            return -1;
        }
        return i;
    }

    private static final class pf_string_fill
    extends Primitive {
        pf_string_fill() {
            super("simple-string-fill", Lisp.PACKAGE_EXT, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof AbstractString) {
                AbstractString s = (AbstractString)first;
                s.fill(LispCharacter.getValue(second));
                return first;
            }
            return Lisp.type_error(first, Symbol.SIMPLE_STRING);
        }
    }

    private static final class pf_simple_string_search
    extends Primitive {
        pf_simple_string_search() {
            super("simple-string-search", Lisp.PACKAGE_EXT, true);
        }

        public LispObject execute(LispObject first, LispObject second) {
            int index = second.getStringValue().indexOf(first.getStringValue());
            return index >= 0 ? Fixnum.getInstance(index) : Lisp.NIL;
        }
    }

    private static final class pf_string_find
    extends Primitive {
        pf_string_find() {
            super("string-find", Lisp.PACKAGE_EXT, true, "char string");
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (first instanceof LispCharacter) {
                char c = ((LispCharacter)first).value;
                AbstractString string = Lisp.checkString(second);
                int limit = string.length();
                for (int i = 0; i < limit; ++i) {
                    if (string.charAt(i) != c) continue;
                    return first;
                }
            }
            return Lisp.NIL;
        }
    }

    private static final class pf_string_position
    extends Primitive {
        pf_string_position() {
            super("string-position", Lisp.PACKAGE_EXT, true);
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            int start;
            char c = LispCharacter.getValue(first);
            AbstractString string = Lisp.checkString(second);
            int limit = string.length();
            for (int i = start = Fixnum.getValue(third); i < limit; ++i) {
                if (string.charAt(i) != c) continue;
                return Lisp.number(i);
            }
            return Lisp.NIL;
        }
    }

    private static final class pf_set_schar
    extends Primitive {
        pf_set_schar() {
            super(Symbol.SET_SCHAR, "string index character");
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first instanceof SimpleString) {
                ((SimpleString)first).setCharAt(Fixnum.getValue(second), LispCharacter.getValue(third));
                return third;
            }
            return Lisp.type_error(first, Symbol.SIMPLE_STRING);
        }
    }

    private static final class pf_set_char
    extends Primitive {
        pf_set_char() {
            super(Symbol.SET_CHAR, "string index character");
        }

        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Lisp.checkString(first).setCharAt(Fixnum.getValue(second), LispCharacter.getValue(third));
            return third;
        }
    }

    private static final class pf_schar
    extends Primitive {
        pf_schar() {
            super(Symbol.SCHAR, "string index");
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.SCHAR(Fixnum.getValue(second));
        }
    }

    private static final class pf_char
    extends Primitive {
        pf_char() {
            super(Symbol.CHAR, "string index");
        }

        public LispObject execute(LispObject first, LispObject second) {
            return first.CHAR(Fixnum.getValue(second));
        }
    }

    private static final class pf__make_string
    extends Primitive {
        pf__make_string() {
            super("%make-string", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject size, LispObject initialElement, LispObject elementType) {
            int n = Fixnum.getValue(size);
            if (n < 0 || n >= Integer.MAX_VALUE) {
                StringBuilder sb = new StringBuilder();
                sb.append("The size specified for this string (");
                sb.append(n);
                sb.append(')');
                if (n >= Integer.MAX_VALUE) {
                    sb.append(" is >= ARRAY-DIMENSION-LIMIT (");
                    sb.append(Integer.MAX_VALUE);
                    sb.append(").");
                } else {
                    sb.append(" is negative.");
                }
                return Lisp.error(new LispError(sb.toString()));
            }
            SimpleString string = new SimpleString(n);
            if (initialElement != Lisp.NIL) {
                char c = Lisp.checkCharacter(initialElement).getValue();
                string.fill(c);
            }
            return string;
        }
    }

    private static final class pf_simple_string_p
    extends Primitive {
        pf_simple_string_p() {
            super("simple-string-p", "object");
        }

        public LispObject execute(LispObject arg) {
            return arg.SIMPLE_STRING_P();
        }
    }

    private static final class pf_stringp
    extends Primitive {
        pf_stringp() {
            super("stringp", "object");
        }

        public LispObject execute(LispObject arg) {
            return arg.STRINGP();
        }
    }

    private static final class pf__nstring_capitalize
    extends Primitive {
        pf__nstring_capitalize() {
            super("%nstring-capitalize", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string, LispObject start, LispObject end) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string, start, end);
            boolean lastCharWasAlphanumeric = false;
            AbstractString retString = indicesAndChars.string1;
            for (int i = indicesAndChars.start1; i < indicesAndChars.end1; ++i) {
                char c = retString.charAt(i);
                if (Character.isLowerCase(c)) {
                    if (!lastCharWasAlphanumeric) {
                        retString.setCharAt(i, LispCharacter.toUpperCase(c));
                    }
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    if (lastCharWasAlphanumeric) {
                        retString.setCharAt(i, LispCharacter.toLowerCase(c));
                    }
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                lastCharWasAlphanumeric = Character.isDigit(c);
            }
            return retString;
        }
    }

    private static final class pf__nstring_downcase
    extends Primitive {
        pf__nstring_downcase() {
            super("%nstring-downcase", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string, LispObject start, LispObject end) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string, start, end);
            AbstractString retString = indicesAndChars.string1;
            for (int i = indicesAndChars.start1; i < indicesAndChars.end1; ++i) {
                retString.setCharAt(i, LispCharacter.toLowerCase(retString.charAt(i)));
            }
            return retString;
        }
    }

    private static final class pf__nstring_upcase
    extends Primitive {
        pf__nstring_upcase() {
            super("%nstring-upcase", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string, LispObject start, LispObject end) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string, start, end);
            AbstractString retString = indicesAndChars.string1;
            for (int i = indicesAndChars.start1; i < indicesAndChars.end1; ++i) {
                retString.setCharAt(i, LispCharacter.toUpperCase(retString.charAt(i)));
            }
            return retString;
        }
    }

    private static final class pf__string_capitalize
    extends Primitive {
        pf__string_capitalize() {
            super("%string-capitalize", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string, LispObject start, LispObject end) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string, start, end);
            char[] array = new char[indicesAndChars.array1.length];
            boolean lastCharWasAlphanumeric = false;
            System.arraycopy(indicesAndChars.array1, 0, array, 0, indicesAndChars.start1);
            for (int i = indicesAndChars.start1; i < indicesAndChars.end1; ++i) {
                char c = indicesAndChars.array1[i];
                if (Character.isLowerCase(c)) {
                    array[i] = lastCharWasAlphanumeric ? c : LispCharacter.toUpperCase(c);
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                if (Character.isUpperCase(c)) {
                    array[i] = lastCharWasAlphanumeric ? LispCharacter.toLowerCase(c) : c;
                    lastCharWasAlphanumeric = true;
                    continue;
                }
                array[i] = c;
                lastCharWasAlphanumeric = Character.isDigit(c);
            }
            System.arraycopy(indicesAndChars.array1, indicesAndChars.end1, array, indicesAndChars.end1, indicesAndChars.array1.length - indicesAndChars.end1);
            return new SimpleString(array);
        }
    }

    private static final class pf__string_downcase
    extends Primitive {
        pf__string_downcase() {
            super("%string-downcase", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string, LispObject start, LispObject end) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string, start, end);
            char[] array = new char[indicesAndChars.array1.length];
            System.arraycopy(indicesAndChars.array1, 0, array, 0, indicesAndChars.start1);
            for (int i = indicesAndChars.start1; i < indicesAndChars.end1; ++i) {
                array[i] = LispCharacter.toLowerCase(indicesAndChars.array1[i]);
            }
            System.arraycopy(indicesAndChars.array1, indicesAndChars.end1, array, indicesAndChars.end1, indicesAndChars.array1.length - indicesAndChars.end1);
            return new SimpleString(array);
        }
    }

    private static final class pf__string_upcase
    extends Primitive {
        pf__string_upcase() {
            super("%string-upcase", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string, LispObject start, LispObject end) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string, start, end);
            char[] array = new char[indicesAndChars.array1.length];
            System.arraycopy(indicesAndChars.array1, 0, array, 0, indicesAndChars.start1);
            for (int i = indicesAndChars.start1; i < indicesAndChars.end1; ++i) {
                array[i] = LispCharacter.toUpperCase(indicesAndChars.array1[i]);
            }
            System.arraycopy(indicesAndChars.array1, indicesAndChars.end1, array, indicesAndChars.end1, indicesAndChars.array1.length - indicesAndChars.end1);
            return new SimpleString(array);
        }
    }

    private static final class pf__string_not_greaterp
    extends Primitive {
        pf__string_not_greaterp() {
            super("%string-not-greaterp", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string1, string2, start1, end1, start2, end2);
            indicesAndChars.convertCase = true;
            int tmp = StringFunctions.lessThanOrEqual(indicesAndChars);
            return tmp >= 0 ? Fixnum.getInstance(tmp) : Lisp.NIL;
        }
    }

    private static final class pf__string_not_lessp
    extends Primitive {
        pf__string_not_lessp() {
            super("%string-not-lessp", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string2, string1, start2, end2, start1, end1);
            indicesAndChars.convertCase = true;
            int tmp = StringFunctions.lessThanOrEqual(indicesAndChars);
            return StringFunctions.swapReturnValue(tmp, indicesAndChars);
        }
    }

    private static final class pf__string_greaterp
    extends Primitive {
        pf__string_greaterp() {
            super("%string-greaterp", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string2, string1, start2, end2, start1, end1);
            indicesAndChars.convertCase = true;
            int tmp = StringFunctions.lessThan(indicesAndChars);
            return StringFunctions.swapReturnValue(tmp, indicesAndChars);
        }
    }

    private static final class pf__string_lessp
    extends Primitive {
        pf__string_lessp() {
            super("%string-lessp", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string1, string2, start1, end1, start2, end2);
            indicesAndChars.convertCase = true;
            int retVal = StringFunctions.lessThan(indicesAndChars);
            return retVal >= 0 ? Fixnum.getInstance(retVal) : Lisp.NIL;
        }
    }

    private static final class pf__string_ge
    extends Primitive {
        pf__string_ge() {
            super("%string>=", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string2, string1, start2, end2, start1, end1);
            int tmp = StringFunctions.lessThanOrEqual(indicesAndChars);
            return StringFunctions.swapReturnValue(tmp, indicesAndChars);
        }
    }

    private static final class pf__string_le
    extends Primitive {
        pf__string_le() {
            super("%string<=", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string1, string2, start1, end1, start2, end2);
            int retVal = StringFunctions.lessThanOrEqual(indicesAndChars);
            return retVal >= 0 ? Fixnum.getInstance(retVal) : Lisp.NIL;
        }
    }

    private static final class pf__string_greater_than
    extends Primitive {
        pf__string_greater_than() {
            super("%string>", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string2, string1, start2, end2, start1, end1);
            int tmp = StringFunctions.lessThan(indicesAndChars);
            return StringFunctions.swapReturnValue(tmp, indicesAndChars);
        }
    }

    private static final class pf__string_less_than
    extends Primitive {
        pf__string_less_than() {
            super("%string<", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string1, string2, start1, end1, start2, end2);
            int retVal = StringFunctions.lessThan(indicesAndChars);
            return retVal >= 0 ? Fixnum.getInstance(retVal) : Lisp.NIL;
        }
    }

    private static final class pf__string_not_equal_ignore_case
    extends Primitive {
        pf__string_not_equal_ignore_case() {
            super("%string-not-equal", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string1, string2, start1, end1, start2, end2);
            indicesAndChars.convertCase = true;
            int tmp = StringFunctions.notEqual(indicesAndChars);
            return tmp >= 0 ? Fixnum.getInstance(tmp) : Lisp.NIL;
        }
    }

    private static final class pf__string_equal_ignore_case
    extends Primitive {
        pf__string_equal_ignore_case() {
            super("%string-equal", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            return _STRING_NOT_EQUAL_IGNORE_CASE.execute(string1, string2, start1, end1, start2, end2) == Lisp.NIL ? Lisp.T : Lisp.NIL;
        }
    }

    private static final class pf__string_not_equal
    extends Primitive {
        pf__string_not_equal() {
            super("%string/=", Lisp.PACKAGE_SYS, true);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            StringIndicesAndChars indicesAndChars = StringFunctions.stringIndicesAndChars(string1, string2, start1, end1, start2, end2);
            int tmp = StringFunctions.notEqual(indicesAndChars);
            return tmp >= 0 ? Fixnum.getInstance(tmp) : Lisp.NIL;
        }
    }

    private static final class pf__string_equal
    extends Primitive {
        pf__string_equal() {
            super("%string=", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject string1, LispObject string2, LispObject start1, LispObject end1, LispObject start2, LispObject end2) {
            return _STRING_NOT_EQUAL.execute(string1, string2, start1, end1, start2, end2) == Lisp.NIL ? Lisp.T : Lisp.NIL;
        }
    }

    private static final class pf___string_equal
    extends Primitive {
        pf___string_equal() {
            super("%%string=", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute(LispObject string1, LispObject string2) {
            StringIndicesAndChars chars = StringFunctions.stringIndicesAndChars(string1, string2);
            return Arrays.equals(chars.array1, chars.array2) ? Lisp.T : Lisp.NIL;
        }
    }

    static final class StringIndicesAndChars {
        public AbstractString string1;
        public boolean convertCase = false;
        public char[] array1;
        public char[] array2;
        public int start1 = 0;
        public int end1 = 0;
        public int start2 = 0;
        public int end2 = 0;

        StringIndicesAndChars() {
        }
    }
}

