#!/usr/bin/env python

# Demonstrates Optik's help-formatting capabilities:
#   - option groups
#   - ability to select different help-formatting objects

from optik import OptionParser, OptionGroup
from optik.help import IndentedHelpFormatter, TitledHelpFormatter

if 0:
    formatter = IndentedHelpFormatter()
else:
    formatter = TitledHelpFormatter()

usage = "%prog [options] [filename ...]"
description = """\
This is a brief paragraph describing what this program does.
Since this program doesn't do anything, this paragraph doesn't
say much.
"""
parser = OptionParser(usage=usage,
                      version="%prog 0.0",
                      formatter=formatter,
                      description=description,
                      epilog="Please report bugs to /dev/null@example.com.",
                     )

group = parser.add_option_group("Basic options",
                                description="These are not very advanced.")
group.add_option("-l", "--local", action="store_true", dest="local",
                 help="show only files in the current directory")
group.add_option("-R", "--recursive", action="store_false", dest="local",
                 help="recurse into subdirectories [default]")
group.add_option("-f", dest='filename', metavar="FILE",
                 help="read CVS history from FILE, not from running "
                 "\"cvs log\"")

group = parser.add_option_group("Revision selection options")
group.add_option("-r", dest='revisions',
                 metavar="REVISIONS",
                 help="pass directly to CVS")
group.add_option("-s", "--since", dest='since_tag',
                 metavar="TAG",
                 help="show only revisions after TAG")
group.add_option("--range", nargs=2,
                 metavar="TAG1 TAG2",
                 help=("show only revisions since TAG1, up to and "
                       "including TAG2"))

parser.parse_args(["--help"])
