# Copyright 2015 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""The main command group for cloud source command group."""

from googlecloudsdk.api_lib.source import source
from googlecloudsdk.api_lib.sourcerepo import sourcerepo
from googlecloudsdk.calliope import base
from googlecloudsdk.core import properties
from googlecloudsdk.core import resolvers
from googlecloudsdk.core import resources
from googlecloudsdk.core.credentials import store as c_store


@base.ReleaseTracks(base.ReleaseTrack.ALPHA, base.ReleaseTrack.BETA,
                    base.ReleaseTrack.GA)
class Source(base.Group):
  """Cloud git repository commands.

  The {command} group lets you manipulate git repositories within a Google
  Cloud project.
  """

  def Filter(self, context, args):
    """Initialize context for source commands.

    Args:
      context: The current context.
      args: The argparse namespace that was specified on the CLI or API.

    Returns:
      The updated context.
    """
    resources.REGISTRY.SetParamDefault(
        api='source', collection=None, param='projectId',
        resolver=resolvers.FromProperty(properties.VALUES.core.project))
    resources.REGISTRY.SetParamDefault(
        api='sourcerepo', collection=None, param='projectId',
        resolver=resolvers.FromProperty(properties.VALUES.core.project))

    source.Source.SetResourceParser(resources.REGISTRY)
    source.Source.SetApiEndpoint()
    sourcerepo.Source.SetResourceParser(resources.REGISTRY)
    sourcerepo.Source.SetApiEndpoint()
