"""Generated client library for cloudresourcemanager version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.cloudresourcemanager.v1 import cloudresourcemanager_v1_messages as messages


class CloudresourcemanagerV1(base_api.BaseApiClient):
  """Generated client library for service cloudresourcemanager version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://cloudresourcemanager.googleapis.com/'

  _PACKAGE = u'cloudresourcemanager'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'CloudresourcemanagerV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None):
    """Create a new cloudresourcemanager handle."""
    url = url or self.BASE_URL
    super(CloudresourcemanagerV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers)
    self.liens = self.LiensService(self)
    self.operations = self.OperationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects = self.ProjectsService(self)

  class LiensService(base_api.BaseApiService):
    """Service class for the liens resource."""

    _NAME = u'liens'

    def __init__(self, client):
      super(CloudresourcemanagerV1.LiensService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      """Create a Lien which applies to the resource denoted by the `parent` field.

Callers of this method will require permission on the `parent` resource.
For example, applying to `projects/1234` requires permission
`resourcemanager.projects.updateLiens`.

NOTE: Some resources may limit the number of Liens which may be applied.

      Args:
        request: (Lien) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Lien) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.liens.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/liens',
        request_field='<request>',
        request_type_name=u'Lien',
        response_type_name=u'Lien',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Delete a Lien by `name`.

Callers of this method will require permission on the `parent` resource.
For example, a Lien with a `parent` of `projects/1234` requires permission
`resourcemanager.projects.updateLiens`.

      Args:
        request: (CloudresourcemanagerLiensDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'cloudresourcemanager.liens.delete',
        ordered_params=[u'liensId'],
        path_params=[u'liensId'],
        query_params=[],
        relative_path=u'v1/liens/{liensId}',
        request_field='',
        request_type_name=u'CloudresourcemanagerLiensDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """List all Liens applied to the `parent` resource.

Callers of this method will require permission on the `parent` resource.
For example, a Lien with a `parent` of `projects/1234` requires permission
`resourcemanager.projects.get`.

      Args:
        request: (CloudresourcemanagerLiensListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLiensResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudresourcemanager.liens.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'parent'],
        relative_path=u'v1/liens',
        request_field='',
        request_type_name=u'CloudresourcemanagerLiensListRequest',
        response_type_name=u'ListLiensResponse',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(CloudresourcemanagerV1.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      """Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (CloudresourcemanagerOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudresourcemanager.operations.get',
        ordered_params=[u'operationsId'],
        path_params=[u'operationsId'],
        query_params=[],
        relative_path=u'v1/operations/{operationsId}',
        request_field='',
        request_type_name=u'CloudresourcemanagerOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(CloudresourcemanagerV1.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def ClearOrgPolicy(self, request, global_params=None):
      """Clears a `Policy` from a resource.

      Args:
        request: (CloudresourcemanagerOrganizationsClearOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ClearOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    ClearOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.clearOrgPolicy',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:clearOrgPolicy',
        request_field=u'clearOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsClearOrgPolicyRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Fetches an Organization resource identified by the specified resource name.

      Args:
        request: (CloudresourcemanagerOrganizationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Organization) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudresourcemanager.organizations.get',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}',
        request_field='',
        request_type_name=u'CloudresourcemanagerOrganizationsGetRequest',
        response_type_name=u'Organization',
        supports_download=False,
    )

    def GetEffectiveOrgPolicy(self, request, global_params=None):
      """Gets the effective `Policy` on a resource. This is the result of merging.
`Policies` in the resource hierarchy. The returned `Policy` will not have
an `etag`set because it is a computed `Policy` across multiple resources.

      Args:
        request: (CloudresourcemanagerOrganizationsGetEffectiveOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.getEffectiveOrgPolicy',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:getEffectiveOrgPolicy',
        request_field=u'getEffectiveOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsGetEffectiveOrgPolicyRequest',
        response_type_name=u'OrgPolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """Gets the access control policy for an Organization resource. May be empty.
if no such policy or resource exists. The `resource` field should be the
organization's resource name, e.g. "organizations/123".

      Args:
        request: (CloudresourcemanagerOrganizationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.getIamPolicy',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def GetOrgPolicy(self, request, global_params=None):
      """Gets a `Policy` on a resource.

If no `Policy` is set on the resource, a `Policy` is returned with default
values including `POLICY_TYPE_NOT_SET` for the `policy_type oneof`. The
`etag` value can be used with `SetOrgPolicy()` to create or update a
`Policy` during read-modify-write.

      Args:
        request: (CloudresourcemanagerOrganizationsGetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.getOrgPolicy',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:getOrgPolicy',
        request_field=u'getOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsGetOrgPolicyRequest',
        response_type_name=u'OrgPolicy',
        supports_download=False,
    )

    def ListAvailableOrgPolicyConstraints(self, request, global_params=None):
      """Lists `Constraints` that could be applied on the specified resource.

      Args:
        request: (CloudresourcemanagerOrganizationsListAvailableOrgPolicyConstraintsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAvailableOrgPolicyConstraintsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableOrgPolicyConstraints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableOrgPolicyConstraints.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.listAvailableOrgPolicyConstraints',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:listAvailableOrgPolicyConstraints',
        request_field=u'listAvailableOrgPolicyConstraintsRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsListAvailableOrgPolicyConstraintsRequest',
        response_type_name=u'ListAvailableOrgPolicyConstraintsResponse',
        supports_download=False,
    )

    def ListOrgPolicies(self, request, global_params=None):
      """Lists all the `Policies` set for a particular resource.

      Args:
        request: (CloudresourcemanagerOrganizationsListOrgPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOrgPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('ListOrgPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListOrgPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.listOrgPolicies',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:listOrgPolicies',
        request_field=u'listOrgPoliciesRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsListOrgPoliciesRequest',
        response_type_name=u'ListOrgPoliciesResponse',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      """Searches Organization resources that are visible to the user and satisfy.
the specified filter. This method returns Organizations in an unspecified
order. New Organizations do not necessarily appear at the end of the
results.

      Args:
        request: (SearchOrganizationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchOrganizationsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/organizations:search',
        request_field='<request>',
        request_type_name=u'SearchOrganizationsRequest',
        response_type_name=u'SearchOrganizationsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """Sets the access control policy on an Organization resource. Replaces any.
existing policy. The `resource` field should be the organization's resource
name, e.g. "organizations/123".

      Args:
        request: (CloudresourcemanagerOrganizationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.setIamPolicy',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetOrgPolicy(self, request, global_params=None):
      """Updates the specified `Policy` on the resource. Creates a new `Policy` for.
that `Constraint` on the resource if one does not exist.

Not supplying an `etag` on the request `Policy` results in an unconditional
write of the `Policy`.

      Args:
        request: (CloudresourcemanagerOrganizationsSetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('SetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.setOrgPolicy',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:setOrgPolicy',
        request_field=u'setOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsSetOrgPolicyRequest',
        response_type_name=u'OrgPolicy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      """Returns permissions that a caller has on the specified Organization.
The `resource` field should be the organization's resource name,
e.g. "organizations/123".

      Args:
        request: (CloudresourcemanagerOrganizationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.organizations.testIamPermissions',
        ordered_params=[u'organizationsId'],
        path_params=[u'organizationsId'],
        query_params=[],
        relative_path=u'v1/organizations/{organizationsId}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'CloudresourcemanagerOrganizationsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(CloudresourcemanagerV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def ClearOrgPolicy(self, request, global_params=None):
      """Clears a `Policy` from a resource.

      Args:
        request: (CloudresourcemanagerProjectsClearOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('ClearOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    ClearOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.clearOrgPolicy',
        ordered_params=[u'projectsId'],
        path_params=[u'projectsId'],
        query_params=[],
        relative_path=u'v1/projects/{projectsId}:clearOrgPolicy',
        request_field=u'clearOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerProjectsClearOrgPolicyRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      """Request that a new Project be created. The result is an Operation which.
can be used to track the creation process. It is automatically deleted
after a few hours, so there is no need to call DeleteOperation.

Our SLO permits Project creation to take up to 30 seconds at the 90th
percentile. As of 2016-08-29, we are observing 6 seconds 50th percentile
latency. 95th percentile latency is around 11 seconds. We recommend
polling at the 5th second with an exponential backoff.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/projects',
        request_field='<request>',
        request_type_name=u'Project',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      """Marks the Project identified by the specified.
`project_id` (for example, `my-project-123`) for deletion.
This method will only affect the Project if the following criteria are met:

+ The Project does not have a billing account associated with it.
+ The Project has a lifecycle state of
ACTIVE.

This method changes the Project's lifecycle state from
ACTIVE
to DELETE_REQUESTED.
The deletion starts at an unspecified time,
at which point the Project is no longer accessible.

Until the deletion completes, you can check the lifecycle state
checked by retrieving the Project with GetProject,
and the Project remains visible to ListProjects.
However, you cannot update the project.

After the deletion completes, the Project is not retrievable by
the  GetProject and
ListProjects methods.

The caller must have modify permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'cloudresourcemanager.projects.delete',
        ordered_params=[u'projectId'],
        path_params=[u'projectId'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}',
        request_field='',
        request_type_name=u'CloudresourcemanagerProjectsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      """Retrieves the Project identified by the specified.
`project_id` (for example, `my-project-123`).

The caller must have read permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudresourcemanager.projects.get',
        ordered_params=[u'projectId'],
        path_params=[u'projectId'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}',
        request_field='',
        request_type_name=u'CloudresourcemanagerProjectsGetRequest',
        response_type_name=u'Project',
        supports_download=False,
    )

    def GetEffectiveOrgPolicy(self, request, global_params=None):
      """Gets the effective `Policy` on a resource. This is the result of merging.
`Policies` in the resource hierarchy. The returned `Policy` will not have
an `etag`set because it is a computed `Policy` across multiple resources.

      Args:
        request: (CloudresourcemanagerProjectsGetEffectiveOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetEffectiveOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetEffectiveOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.getEffectiveOrgPolicy',
        ordered_params=[u'projectsId'],
        path_params=[u'projectsId'],
        query_params=[],
        relative_path=u'v1/projects/{projectsId}:getEffectiveOrgPolicy',
        request_field=u'getEffectiveOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerProjectsGetEffectiveOrgPolicyRequest',
        response_type_name=u'OrgPolicy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      """Returns the IAM access control policy for the specified Project.
Permission is denied if the policy or the resource does not exist.

      Args:
        request: (CloudresourcemanagerProjectsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/projects/{resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'CloudresourcemanagerProjectsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def GetOrgPolicy(self, request, global_params=None):
      """Gets a `Policy` on a resource.

If no `Policy` is set on the resource, a `Policy` is returned with default
values including `POLICY_TYPE_NOT_SET` for the `policy_type oneof`. The
`etag` value can be used with `SetOrgPolicy()` to create or update a
`Policy` during read-modify-write.

      Args:
        request: (CloudresourcemanagerProjectsGetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('GetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.getOrgPolicy',
        ordered_params=[u'projectsId'],
        path_params=[u'projectsId'],
        query_params=[],
        relative_path=u'v1/projects/{projectsId}:getOrgPolicy',
        request_field=u'getOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerProjectsGetOrgPolicyRequest',
        response_type_name=u'OrgPolicy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      """Lists Projects that are visible to the user and satisfy the.
specified filter. This method returns Projects in an unspecified order.
New Projects do not necessarily appear at the end of the list.

      Args:
        request: (CloudresourcemanagerProjectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListProjectsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'cloudresourcemanager.projects.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/projects',
        request_field='',
        request_type_name=u'CloudresourcemanagerProjectsListRequest',
        response_type_name=u'ListProjectsResponse',
        supports_download=False,
    )

    def ListAvailableOrgPolicyConstraints(self, request, global_params=None):
      """Lists `Constraints` that could be applied on the specified resource.

      Args:
        request: (CloudresourcemanagerProjectsListAvailableOrgPolicyConstraintsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAvailableOrgPolicyConstraintsResponse) The response message.
      """
      config = self.GetMethodConfig('ListAvailableOrgPolicyConstraints')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListAvailableOrgPolicyConstraints.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.listAvailableOrgPolicyConstraints',
        ordered_params=[u'projectsId'],
        path_params=[u'projectsId'],
        query_params=[],
        relative_path=u'v1/projects/{projectsId}:listAvailableOrgPolicyConstraints',
        request_field=u'listAvailableOrgPolicyConstraintsRequest',
        request_type_name=u'CloudresourcemanagerProjectsListAvailableOrgPolicyConstraintsRequest',
        response_type_name=u'ListAvailableOrgPolicyConstraintsResponse',
        supports_download=False,
    )

    def ListOrgPolicies(self, request, global_params=None):
      """Lists all the `Policies` set for a particular resource.

      Args:
        request: (CloudresourcemanagerProjectsListOrgPoliciesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOrgPoliciesResponse) The response message.
      """
      config = self.GetMethodConfig('ListOrgPolicies')
      return self._RunMethod(
          config, request, global_params=global_params)

    ListOrgPolicies.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.listOrgPolicies',
        ordered_params=[u'projectsId'],
        path_params=[u'projectsId'],
        query_params=[],
        relative_path=u'v1/projects/{projectsId}:listOrgPolicies',
        request_field=u'listOrgPoliciesRequest',
        request_type_name=u'CloudresourcemanagerProjectsListOrgPoliciesRequest',
        response_type_name=u'ListOrgPoliciesResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      """Sets the IAM access control policy for the specified Project. Replaces.
any existing policy.

The following constraints apply when using `setIamPolicy()`:

+ Project does not support `allUsers` and `allAuthenticatedUsers` as
`members` in a `Binding` of a `Policy`.

+ The owner role can be granted only to `user` and `serviceAccount`.

+ Service accounts can be made owners of a project directly
without any restrictions. However, to be added as an owner, a user must be
invited via Cloud Platform console and must accept the invitation.

+ A user cannot be granted the owner role using `setIamPolicy()`. The user
must be granted the owner role using the Cloud Platform Console and must
explicitly accept the invitation.

+ Invitations to grant the owner role cannot be sent using
`setIamPolicy()`;
they must be sent only using the Cloud Platform Console.

+ Membership changes that leave the project without any owners that have
accepted the Terms of Service (ToS) will be rejected.

+ There must be at least one owner who has accepted the Terms of
Service (ToS) agreement in the policy. Calling `setIamPolicy()` to
to remove the last ToS-accepted owner from the policy will fail. This
restriction also applies to legacy projects that no longer have owners
who have accepted the ToS. Edits to IAM policies will be rejected until
the lack of a ToS-accepting owner is rectified.

+ Calling this method requires enabling the App Engine Admin API.

Note: Removing service accounts from policies or changing their roles
can render services completely inoperable. It is important to understand
how the service account is being used before removing or updating its
roles.

      Args:
        request: (CloudresourcemanagerProjectsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/projects/{resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'CloudresourcemanagerProjectsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetOrgPolicy(self, request, global_params=None):
      """Updates the specified `Policy` on the resource. Creates a new `Policy` for.
that `Constraint` on the resource if one does not exist.

Not supplying an `etag` on the request `Policy` results in an unconditional
write of the `Policy`.

      Args:
        request: (CloudresourcemanagerProjectsSetOrgPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (OrgPolicy) The response message.
      """
      config = self.GetMethodConfig('SetOrgPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetOrgPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.setOrgPolicy',
        ordered_params=[u'projectsId'],
        path_params=[u'projectsId'],
        query_params=[],
        relative_path=u'v1/projects/{projectsId}:setOrgPolicy',
        request_field=u'setOrgPolicyRequest',
        request_type_name=u'CloudresourcemanagerProjectsSetOrgPolicyRequest',
        response_type_name=u'OrgPolicy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      """Returns permissions that a caller has on the specified Project.

      Args:
        request: (CloudresourcemanagerProjectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/projects/{resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'CloudresourcemanagerProjectsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      """Restores the Project identified by the specified.
`project_id` (for example, `my-project-123`).
You can only use this method for a Project that has a lifecycle state of
DELETE_REQUESTED.
After deletion starts, the Project cannot be restored.

The caller must have modify permissions for this Project.

      Args:
        request: (CloudresourcemanagerProjectsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'cloudresourcemanager.projects.undelete',
        ordered_params=[u'projectId'],
        path_params=[u'projectId'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}:undelete',
        request_field=u'undeleteProjectRequest',
        request_type_name=u'CloudresourcemanagerProjectsUndeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      """Updates the attributes of the Project identified by the specified.
`project_id` (for example, `my-project-123`).

The caller must have modify permissions for this Project.

      Args:
        request: (Project) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Project) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'cloudresourcemanager.projects.update',
        ordered_params=[u'projectId'],
        path_params=[u'projectId'],
        query_params=[],
        relative_path=u'v1/projects/{projectId}',
        request_field='<request>',
        request_type_name=u'Project',
        response_type_name=u'Project',
        supports_download=False,
    )
