<?php

# This file is a part of RackTables, a datacenter and server room management
# framework. See accompanying file "COPYING" for the full copyright and
# licensing information.

function reloadDictionary ($release = NULL)
{
	global $dictionary;
	// Not only update existing stuff, but make sure all obsolete records are gone.
	$ret = array ("DELETE FROM Dictionary WHERE dict_key BETWEEN 1 AND 49999");
	$buffered = 0;
	# Iterating through 50K possible valid indices is way too slow in PHP and
	# is likely to hit the default execution time limit of 30 seconds.
	foreach ($dictionary as $dict_key => $record)
	{
		if (! $buffered)
		{
			$insert = 'INSERT INTO Dictionary (dict_key, chapter_id, dict_value, dict_sticky) VALUES (' .
				"${dict_key}, ${record['chapter_id']}, '${record['dict_value']}', 'yes')";
			$buffered = 1;
			continue;
		}
		$insert .= ", (${dict_key}, ${record['chapter_id']}, '${record['dict_value']}', 'yes')";
		if (++$buffered == 25)
		{
			$ret[] = $insert;
			$buffered = 0;
		}
	}
	if ($buffered)
		$ret[] = $insert;
	return $ret;
}

function isInnoDBSupported ()
{
	global $dbxlink;
	// create a temp table and a trigger
	$dbxlink->query("DROP TABLE IF EXISTS `innodb_test`");
	$dbxlink->query("CREATE TABLE `innodb_test` (`id` int) ENGINE=InnoDB");
	$innodb_row = $dbxlink->query("SHOW TABLE STATUS LIKE 'innodb_test'")->fetch(PDO::FETCH_ASSOC);
	$dbxlink->query("CREATE TRIGGER `trigger_test` BEFORE INSERT ON `innodb_test` FOR EACH ROW BEGIN END");
	$trigger_row = $dbxlink->query("SELECT COUNT(*) AS count FROM information_schema.TRIGGERS WHERE TRIGGER_SCHEMA = SCHEMA() AND TRIGGER_NAME = 'trigger_test'")->fetch(PDO::FETCH_ASSOC);
	$dbxlink->query("DROP TABLE `innodb_test`");
	return $innodb_row['Engine'] == 'InnoDB' && $trigger_row['count'] == 1;
}

function platform_function_test ($funcname, $extname, $what_if_not = 'not found', $error_class = 'trerror')
{
	return platform_generic_test (function_exists ($funcname), $extname, 'NOT PRESENT', $error_class);
}

function platform_generic_test ($is_ok, $topic, $what_if_not = 'FAILED', $error_class = 'trerror')
{
	echo "<tr><th class=tdleft>${topic}</th>";
	if ($is_ok)
	{
		echo '<td class="trok tdleft">PASSED</td></tr>';
		return 0;
	}
	echo "<td class='${error_class} tdleft'>${what_if_not}</td></tr>";
	return 1;
}

function pcre8_with_properties()
{
	return FALSE === @preg_match ('/\p{L}/u', 'a') ? FALSE : TRUE;
}

// Check for PHP extensions.
function platform_is_ok ()
{
	$nerrs = 0;
	echo "<table border=1 cellpadding=5>\n";
	$nerrs += platform_generic_test (version_compare (PHP_VERSION, '5.2.10', '>='), 'PHP version >= 5.2.10');
	$nerrs += platform_generic_test (class_exists ('PDO'), 'PDO extension');
	$nerrs += platform_generic_test (in_array  ('pdo_mysql', get_loaded_extensions()), 'PDO-MySQL extension');
	$nerrs += platform_function_test ('preg_match', 'PCRE extension');
	$nerrs += platform_generic_test (pcre8_with_properties(), 'PCRE compiled with<br>--enable-unicode-properties');
	platform_function_test ('snmpwalk', 'SNMP extension', 'Not found, Live SNMP feature will not work.', 'trwarning');
	$nerrs += platform_function_test ('gd_info', 'GD extension');
	$nerrs += platform_function_test ('mb_strlen', 'Multibyte string extension');
	platform_function_test ('ldap_connect', 'LDAP extension', 'Not found, LDAP authentication will not work.', 'trwarning');
	platform_function_test ('pcntl_waitpid', 'PCNTL extension', '802.1Q parallel sync is unavailable.', 'trwarning');
	$nerrs += platform_function_test ('json_encode', 'JSON extension', 'JavaScript interface bits may fail.');
	platform_generic_test (in_array  ('curl', get_loaded_extensions()), 'cURL extension', 'Not found, Cacti Graph integration is unavailable.', 'trwarning');
	$nerrs += platform_function_test ('bcmul', 'BC Math extension');
	platform_generic_test
	(
		(! empty ($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off'),
		'accessed over HTTPS',
		'No! (all your passwords will be transmitted in cleartext)',
		'trwarning'
	);
	echo "</table>\n";
	return !$nerrs;
}

$dictionary = array
(
	1 => array ('chapter_id' => 1, 'dict_value' => 'BlackBox'),
	2 => array ('chapter_id' => 1, 'dict_value' => 'PDU'),
	3 => array ('chapter_id' => 1, 'dict_value' => 'Shelf'),
	4 => array ('chapter_id' => 1, 'dict_value' => 'Server'),
	5 => array ('chapter_id' => 1, 'dict_value' => 'DiskArray'),
	6 => array ('chapter_id' => 1, 'dict_value' => 'TapeLibrary'),
	7 => array ('chapter_id' => 1, 'dict_value' => 'Router'),
	8 => array ('chapter_id' => 1, 'dict_value' => 'Network switch'),
	9 => array ('chapter_id' => 1, 'dict_value' => 'PatchPanel'),
	10 => array ('chapter_id' => 1, 'dict_value' => 'CableOrganizer'),
	11 => array ('chapter_id' => 1, 'dict_value' => 'spacer'),
	12 => array ('chapter_id' => 1, 'dict_value' => 'UPS'),
	13 => array ('chapter_id' => 1, 'dict_value' => 'Modem'),
	14 => array ('chapter_id' => 1, 'dict_value' => 'MediaConverter'),
	15 => array ('chapter_id' => 1, 'dict_value' => 'console'),
	42 => array ('chapter_id' => 11, 'dict_value' => 'noname/unknown'),
	43 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%305'),
	44 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%306'),
	45 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%306m'),
	46 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%326m'),
	47 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%330'),
	48 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%335'),
	49 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Ultra 10'),
	50 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Enterprise 420R'),
	51 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X2100'),
	52 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire E4900'),
	53 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Netra X1'),
	54 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%346'),
	55 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%1650'),
	56 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2850'),
	57 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V210'),
	58 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V240'),
	59 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%326'),
	60 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Netra t1 105'),
	61 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Enterprise 4500'),
	62 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%1950'),
	63 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%1550'),
	64 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Ultra 5'),
	65 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2950'),
	66 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%650'),
	67 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%4600'),
	68 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3250'),
	69 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3455'),
	70 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3550'),
	71 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3650'),
	72 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3655'),
	73 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3650 T'),
	74 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3755'),
	75 => array ('chapter_id' => 11, 'dict_value' => 'IBM xSeries%GPASS%3850'),
	76 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X4600'),
	77 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X4500'),
	78 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X4200'),
	79 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X4100'),
	80 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X2100 M2'),
	81 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire X2200 M2'),
	82 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V40z'),
	83 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V125'),
	84 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V215'),
	85 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V245'),
	86 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V445'),
	87 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V440'),
	88 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V490'),
	89 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V890'),
	90 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire E2900'),
	91 => array ('chapter_id' => 11, 'dict_value' => 'Sun%GPASS%Fire V1280'),
	92 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%185'),
	93 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%505'),
	94 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%505Q'),
	95 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%510'),
	96 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%510Q'),
	97 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%520'),
	98 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%520Q'),
	99 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%550'),
	100 => array ('chapter_id' => 11, 'dict_value' => 'IBM pSeries%GPASS%550Q'),
	101 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL140'),
	102 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL145'),
	103 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL320'),
	104 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL360'),
	105 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL380'),
	106 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL385'),
	107 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL580'),
	108 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL585'),
	109 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML110'),
	110 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML150'),
	111 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML310'),
	112 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML350'),
	113 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML370'),
	114 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML570'),
	115 => array ('chapter_id' => 12, 'dict_value' => 'noname/unknown'),
	116 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron WorkGroup'),
	117 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron II'),
	118 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron'),
	119 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron XL'),
	120 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron 350'),
	121 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 2402'),
	122 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 4802'),
	123 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge X424'),
	124 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2924XL'),
	125 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron SuperX'),
	126 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2912XL'),
	127 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron GS 648P'),
	128 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 2402-PREM'),
	129 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron GS 624P'),
	130 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron GS 624P-POE'),
	131 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron GS 648P-POE'),
	132 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron 4G'),
	133 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron 4G-SSL'),
	134 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge X448'),
	135 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge X424HF'),
	136 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge X424-POE'),
	137 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron SX 800'),
	138 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron SX 1600'),
	139 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst WS-C3560-8PC'),
	140 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-48TC-S'),
	141 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560-E'),
	142 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst Express 500-24LC'),
	143 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-24TS'),
	144 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-E'),
	145 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 4503'),
	146 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 6513'),
	147 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst 4948 | http://www.cisco.com/en/US/products/ps6026/index.html]]'),
	148 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6509-E%L9,1H%'),
	149 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6509-NEB-A%L9,1H%'),
	150 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6506-E%L6,1H%'),
	151 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6504-E%L4,1H%'),
	152 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6503-E%L3,1H%'),
	153 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6503%L3,1H%'),
	154 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6506%L6,1H%'),
	155 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6509-NEB%L9,1H%'),
	156 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 4506%L6,1H%'),
	157 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 4507R%L7,1H%'),
	158 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 4510R%L10,1H%'),
	159 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst Express 500-24PC'),
	160 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst Express 500-24TT'),
	161 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst Express 500G-12TC'),
// 1572 duplicated 162 later, so 162 isn't here any more
// 1710 duplicated 163 later, so 163 isn't here any more
	164 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24TT-L'),
	165 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-8TC-L'),
	166 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960G-48TC-L'),
	167 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960G-24TC-L'),
	168 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960G-8TC-L'),
	169 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560-24TS'),
	170 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560-48TS'),
	171 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560-24PS'),
	172 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560-48PS'),
	173 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560G-24TS'),
	174 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560G-48TS'),
	175 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560G-24PS'),
	176 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560G-48PS'),
	177 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-48TS'),
	178 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-24PS'),
	179 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-48PS'),
	180 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-24FS'),
	181 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-24T'),
	182 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-24TS'),
	183 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-24TS-1U'),
	184 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-48TS'),
	185 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-24PS'),
	186 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-48PS'),
	187 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-16TD'),
	188 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-12S'),
	189 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750G-24WS'),
	190 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 2402CF'),
	191 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 24G'),
	192 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 4802CF'),
	193 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 48G'),
	194 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 24GS'),
	195 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 48GS'),
	196 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%EdgeIron 8X10G'),
	197 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 4802-PREM'),
	198 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 12GCF'),
	199 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 12GCF-PREM'),
	200 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 9604'),
	201 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 9604-PREM'),
	202 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 2402-POE'),
	203 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Edge 4802-POE'),
	204 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Workgroup X424'),
	205 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron Workgroup X448'),
	206 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron 450'),
	207 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron 850'),
	208 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron GT C'),
	209 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%ServerIron GT E'),
	210 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2970G-24T'),
	211 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2970G-24TS'),
	212 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora C1'),
	213 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora C2'),
	214 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora C3'),
	215 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora C4'),
	216 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora C5'),
	217 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora C6'),
	218 => array ('chapter_id' => 13, 'dict_value' => 'Solaris%GSKIP%Solaris 8'),
	219 => array ('chapter_id' => 13, 'dict_value' => 'Solaris%GSKIP%Solaris 9'),
	220 => array ('chapter_id' => 13, 'dict_value' => 'Solaris%GSKIP%Solaris 10'),
	221 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows 2000'),
	222 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows XP'),
	223 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows 2003'),
	224 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows Vista'),
	225 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V1'),
	226 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V2'),
	227 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V3'),
	228 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V4'),
	229 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux Master 2.0'),
	230 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux Master 2.2'),
	231 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux Master 2.4'),
	232 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora 7'),
	233 => array ('chapter_id' => 13, 'dict_value' => 'SUSE Enterprise%GSKIP%SLES10'),
	234 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 3.0 (woody) | http://debian.org/releases/woody/]]'),
	235 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 3.1 (sarge) | http://debian.org/releases/sarge/]]'),
	236 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 1.x'),
	237 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 2.x'),
	238 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 3.x'),
	239 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 4.x'),
	240 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 5.x'),
	241 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 6.x'),
	242 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora 8'),
	243 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux Master 4.0'),
	244 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 12.0'),
	245 => array ('chapter_id' => 14, 'dict_value' => 'Foundry SLB'),
	246 => array ('chapter_id' => 14, 'dict_value' => 'Foundry WXM'),
	247 => array ('chapter_id' => 14, 'dict_value' => 'Foundry L2'),
	248 => array ('chapter_id' => 14, 'dict_value' => 'Foundry full L3'),
	249 => array ('chapter_id' => 14, 'dict_value' => 'Foundry basic L3'),
	250 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 11.2'),
	251 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 12.1'),
	252 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 12.2'),
	253 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 11.3'),
	254 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 12.0'),
	255 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 12.1'),
	256 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 12.2'),
	257 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 12.3'),
	258 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 12.4'),
	259 => array ('chapter_id' => 16, 'dict_value' => 'Foundry L3'),
	260 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 11.2'),
	261 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 11.3'),
	262 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron 4000'),
	263 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7609'),
	264 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2610XM'),
	265 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2611XM'),
	266 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%3620'),
	267 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%3640'),
	268 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2621XM'),
	269 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7206VXR'),
	270 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2651XM'),
	271 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7204VXR'),
	272 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2612'),
	273 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2620XM'),
	274 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2650XM'),
	275 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2691'),
	276 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7603'),
	277 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7606'),
	278 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7613'),
	279 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2801'),
	280 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2811'),
	281 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2821'),
	282 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%2851'),
	283 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%3725'),
	284 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%3745'),
	285 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%3825'),
	286 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%3845'),
	287 => array ('chapter_id' => 24, 'dict_value' => 'Juniper%GPASS%NetScreen 100'),
	288 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron MLX-4'),
	289 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron MLX-8'),
	290 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron MLX-16'),
	291 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron MLX-32'),
	292 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron XMR 4000'),
	293 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron XMR 8000'),
	294 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron XMR 16000'),
	295 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%NetIron XMR 32000'),
	296 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron RX-4'),
	297 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron RX-8'),
	298 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron RX-16'),
	299 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%1841'),
	300 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%1812'),
	301 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%1811'),
	302 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%1803'),
	303 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%1802'),
	304 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%1801'),
	305 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7202'),
	306 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7204'),
	307 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7206'),
	308 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%7604'),
	309 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%OSR-7609'),
	310 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron 8000'),
	311 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron 15000'),
	312 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorEdge A1000'),
	313 => array ('chapter_id' => 18, 'dict_value' => 'Dell/EMC AX150'),
	314 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX600'),
	315 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorEdge D240'),
	316 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX300'),
	317 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorageTek 6140'),
	318 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorageTek 3511'),
	319 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorageTek 3510'),
	320 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorageTek 3320'),
	321 => array ('chapter_id' => 18, 'dict_value' => 'Sun%GPASS%StorageTek 3120'),
	322 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%NX1950'),
	323 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%220S'),
	324 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%MD3000'),
	325 => array ('chapter_id' => 19, 'dict_value' => 'Dell PowerVault%GPASS%136T'),
	326 => array ('chapter_id' => 19, 'dict_value' => 'Sun%GPASS%StorageTek SL500'),
	327 => array ('chapter_id' => 19, 'dict_value' => 'Sun%GPASS%StorageTek L1400'),
	328 => array ('chapter_id' => 19, 'dict_value' => 'Sun%GPASS%StorageTek SL8500'),
	329 => array ('chapter_id' => 19, 'dict_value' => 'Sun%GPASS%StorageTek C4'),
	330 => array ('chapter_id' => 19, 'dict_value' => 'Dell PowerVault%GPASS%ML6000'),
	331 => array ('chapter_id' => 19, 'dict_value' => 'Dell PowerVault%GPASS%132T'),
	332 => array ('chapter_id' => 19, 'dict_value' => 'Dell PowerVault%GPASS%TL4000'),
	333 => array ('chapter_id' => 19, 'dict_value' => 'Dell PowerVault%GPASS%TL2000'),
	334 => array ('chapter_id' => 19, 'dict_value' => 'Dell PowerVault%GPASS%124T'),
	335 => array ('chapter_id' => 19, 'dict_value' => 'Sun%GPASS%StorageTek C2'),
	338 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2216'),
	339 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2224'),
	340 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2324'),
	341 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2708'),
	342 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2716'),
	343 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2724'),
	344 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2748'),
	345 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3424'),
	346 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3424P'),
	347 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3448'),
	348 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3448P'),
	349 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%5324'),
	350 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%6224'),
	351 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%6224P'),
	352 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%6224F'),
	353 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%6248'),
	354 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%6248P'),
	355 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%6850'),
	356 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%6950'),
	357 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R900'),
	358 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%4400'),
	359 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2650'),
	360 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2550'),
	361 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%750'),
	362 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2450'),
	363 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%850'),
	364 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%1850'),
	365 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%860'),
	366 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2900'),
	367 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%2970'),
	368 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%SC1435'),
	369 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6509%L9,1H%'),
	370 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 6524GS-8S'),
	371 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 6524GT-8S'),
	372 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 4503-E'),
	373 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 4506-E'),
	374 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 4507R-E'),
	375 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 4510R-E'),
	376 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750-24TE-M'),
	377 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst 4948-10GE | http://www.cisco.com/en/US/products/ps6230/index.html]]'),
	378 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 4924-10GE'),
	379 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24-S'),
	380 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950-24'),
	381 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst WS-C2950-12'),
	382 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950C-24'),
	383 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst WS-C2950G-24-DC'),
	384 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950SX-48'),
	385 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst WS-C2950SX-24'),
	386 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950T-24'),
	387 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950T-48'),
	388 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950G-12'),
	389 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950G-24'),
	390 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2950G-48'),
	391 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3508G XL'),
	392 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3512 XL'),
	393 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst WS-C3524-XL'),
	394 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3524 PWR XL'),
	395 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3548 XL'),
	396 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 2400-24TS-A'),
	397 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 2400-24TS-D'),
	398 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-12T'),
	399 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-12G'),
	400 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-24'),
	401 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-24 FX'),
	402 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-24 DC'),
	403 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-24 PWR'),
	404 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3550-48'),
	405 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3400G-12CS-A'),
	406 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3400G-12CS-D'),
	407 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3400G-2CS-A'),
	408 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3400-24TS-A'),
	409 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3400-24TS-D'),
	410 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3400-24FS-A'),
	411 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron GS 624XGP'),
	412 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron GS 624XGP-POE'),
	413 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron LS 624'),
	414 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%FastIron LS 648'),
	415 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%NetIron M2404F'),
	416 => array ('chapter_id' => 12, 'dict_value' => 'Foundry%GPASS%NetIron M2404C'),
	417 => array ('chapter_id' => 17, 'dict_value' => 'Foundry%GPASS%BigIron RX-32'),
	418 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 2.0 (hamm) | http://debian.org/releases/hamm/]]'),
	419 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 2.1 (slink) | http://debian.org/releases/slink/]]'),
	420 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 2.2 (potato) | http://debian.org/releases/potato/]]'),
	421 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 4.0 (etch) | http://debian.org/releases/etch/]]'),
	422 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux Server 4.0'),
	423 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux Sisyphus'),
	424 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 10.0'),
	425 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 10.1'),
	426 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 10.2'),
	427 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 10.3'),
	428 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 4.10'),
	429 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 5.04'),
	430 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 5.10'),
	431 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 6.06 LTS'),
	432 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 6.10'),
	433 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 7.04'),
	434 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 7.10'),
	435 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 8.04 LTS'),
	436 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V5'),
	437 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%210S'),
	438 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%221S'),
	441 => array ('chapter_id' => 13, 'dict_value' => '[[CentOS%GSKIP%CentOS V2 | http://www.centos.org/]]'),
	442 => array ('chapter_id' => 13, 'dict_value' => '[[CentOS%GSKIP%CentOS V3 | http://www.centos.org/]]'),
	443 => array ('chapter_id' => 13, 'dict_value' => '[[CentOS%GSKIP%CentOS V4 | http://www.centos.org/]]'),
	444 => array ('chapter_id' => 13, 'dict_value' => '[[CentOS%GSKIP%CentOS V5 | http://www.centos.org/]]'),
	445 => array ('chapter_id' => 1, 'dict_value' => 'KVM switch'),
	447 => array ('chapter_id' => 1, 'dict_value' => 'multiplexer'),
	448 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR1021'),
	449 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR1022'),
	450 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR1024'),
	451 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR1031 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	452 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR1020'),
	453 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR2020'),
	454 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR4020'),
	455 => array ('chapter_id' => 21, 'dict_value' => 'Avocent DSR8020'),
	456 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR1030 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	457 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR2030 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	458 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR2035 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	459 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR4030 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	460 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR8030 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	461 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent DSR8035 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentDSRAppliances.aspx]]'),
	462 => array ('chapter_id' => 21, 'dict_value' => 'Avocent AutoView 1415'),
	463 => array ('chapter_id' => 21, 'dict_value' => 'Avocent AutoView 1515'),
	464 => array ('chapter_id' => 21, 'dict_value' => 'Avocent AutoView 2015'),
	465 => array ('chapter_id' => 21, 'dict_value' => 'Avocent AutoView 2020'),
	466 => array ('chapter_id' => 21, 'dict_value' => 'Avocent AutoView 2030'),
	467 => array ('chapter_id' => 21, 'dict_value' => 'Avocent AutoView 3100'),
	468 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent AutoView 3200 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentAutoViewAppliances.aspx]]'),
	469 => array ('chapter_id' => 21, 'dict_value' => 'Avocent SwitchView 1000 4-port'),
	470 => array ('chapter_id' => 21, 'dict_value' => 'Avocent SwitchView 1000 8-port'),
	471 => array ('chapter_id' => 21, 'dict_value' => 'Avocent SwitchView 1000 16-port'),
	472 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-4E1 | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	473 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-4E1/ETS | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	474 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-4E1/M | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	475 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-8E1 | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	476 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-8E1/ETS | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	477 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-8E1/M | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	478 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-16E1 | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	479 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-16E1/ETS | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	480 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/S-16E1/M | http://www.cronyx.ru/hardware/fmux-ring.html]]'),
	481 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%E1-XL/S | http://www.cronyx.ru/hardware/e1xl-s.html]]'),
	482 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%E1-DXC/S | http://www.cronyx.ru/hardware/e1dxc-s.html]]'),
	483 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX-4-E2 | http://www.cronyx.ru/hardware/fmux4-e2.html]]'),
	484 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX-16-E3 | http://www.cronyx.ru/hardware/fmux16-e3.html]]'),
	485 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%FMUX/SAT | http://www.cronyx.ru/hardware/fmux-sat.html]]'),
	486 => array ('chapter_id' => 9999, 'dict_value' => '[[Cronyx%GPASS%E1-XL/S-IP | http://www.cronyx.ru/hardware/e1xl-ip.html]]'),
	487 => array ('chapter_id' => 17, 'dict_value' => '[[RAD%GPASS%FCD-IPM | http://www.rad.com/Article/0,6583,36426-E1_T1_or_Fractional_E1_T1_Modular_Access_Device_with_Integrated_Router,00.html]]'),
	488 => array ('chapter_id' => 9999, 'dict_value' => '[[RAD%GPASS%FCD-E1M | http://www.rad.com/Article/0,6583,36723-E1_T1_Modular_Access_Multiplexer,00.html]]'),
	489 => array ('chapter_id' => 9999, 'dict_value' => '[[RAD%GPASS%FCD-T1M | http://www.rad.com/Article/0,6583,36723-E1_T1_Modular_Access_Multiplexer,00.html]]'),
	490 => array ('chapter_id' => 9999, 'dict_value' => '[[RAD%GPASS%FCD-155E | http://www.rad.com/Article/0,6583,36276-Ethernet_over_SDH_SONET_ADM,00.html]]'),
	491 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS78 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20070319151852001&layerid=subClass2]]'),
	492 => array ('chapter_id' => 21, 'dict_value' => '[[Aten ACS1208A | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224111025006&layerid=subClass2]]'),
	493 => array ('chapter_id' => 21, 'dict_value' => '[[Aten ACS1216A | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224111953008&layerid=subClass2]]'),
	494 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS1754 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050217161051008&layerid=subClass2]]'),
	495 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS1758 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224093143008&layerid=subClass2]]'),
	496 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS9134 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20070130133658002&pid=20050217172845005&layerid=subClass2]]'),
	497 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS9138 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224094519006&layerid=subClass2]]'),
	498 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS1708 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=2005022410563008&layerid=subClass2]]'),
	499 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS1716 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224110022008&layerid=subClass2]]'),
	500 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS1004 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224100546008&layerid=subClass2]]'),
	501 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS228 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224114323008&layerid=subClass2]]'),
	502 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS428 | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224114721008&layerid=subClass2]]'),
	503 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS138A | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=20050224111458007&layerid=subClass2]]'),
	504 => array ('chapter_id' => 21, 'dict_value' => '[[Aten CS88A | http://www.aten.com/products/productItem.php?pcid=20070130111936003&psid=20070130133658002&pid=2005022411042006&layerid=subClass2]]'),
	505 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KM0832 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131626002&pid=20060628154826001&layerid=subClass1]]'),
	506 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KM0216 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411131626002&pid=20060417153950007&layerid=subClass1]]'),
	507 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KM0432 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411131626002&pid=2006041715359007&layerid=subClass1]]'),
	508 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KH1508 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411130954001&pid=20061101174038001&layerid=subClass1]]'),
	509 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KH1516 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411130954001&pid=20061101175320001&layerid=subClass1]]'),
	510 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KH0116 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411130954001&pid=20060411145734003&layerid=subClass1]]'),
	511 => array ('chapter_id' => 21, 'dict_value' => '[[Aten KH98 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=2007012911116003&pid=20061221104352001&layerid=subClass1]]'),
	512 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL1100 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=20071225113046001&layerid=subClass1]]'),
	513 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL1508 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411131050002&pid=20070710020717009&layerid=subClass1]]'),
	514 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL1516 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411131050002&pid=20070716232614001&layerid=subClass1]]'),
	515 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL9108 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=20060811153413009&layerid=subClass1]]'),
	516 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL9116 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411131050002&pid=2006081115384001&layerid=subClass1]]'),
	517 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL3116 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=20060913162532009&layerid=subClass1]]'),
	518 => array ('chapter_id' => 23, 'dict_value' => '[[Aten KL1116 | http://www.aten.com/products/productItem.php?pcid=2006041110563001&psid=20060411131050002&pid=20060420101520005&layerid=subClass1]]'),
	519 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CS1208DL | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=2005022413505007&layerid=subClass1]]'),
	520 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CS1216DL | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=2005022413505007&layerid=subClass1]]'),
	521 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CS1200L | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=20050224140854008&layerid=subClass1]]'),
	522 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CL1758 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=20051229164553003&layerid=subClass1]]'),
	523 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CL1208 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=2005072215482&layerid=subClass1]]'),
	524 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CL1216 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=2005072215482&layerid=subClass1]]'),
	525 => array ('chapter_id' => 23, 'dict_value' => '[[Aten CL1200 | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=20050722165040002&layerid=subClass1]]'),
	526 => array ('chapter_id' => 23, 'dict_value' => '[[Aten ACS1208AL | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=2005022413597003&layerid=subClass1]]'),
	527 => array ('chapter_id' => 23, 'dict_value' => '[[Aten ACS1216AL | http://www.aten.com/products/productItem.php?pcid=2005010513171002&psid=20060411131050002&pid=2005022413597003&layerid=subClass1]]'),
	528 => array ('chapter_id' => 9999, 'dict_value' => '[[Tainet%GPASS%MUXpro 8216 | http://www.tainet.net/Product/muxpro820_8216.htm]]'),
	529 => array ('chapter_id' => 9999, 'dict_value' => 'Tainet%GPASS%Mercury 3600+'),
	530 => array ('chapter_id' => 9999, 'dict_value' => 'Tainet%GPASS%Mercury 3820'),
	531 => array ('chapter_id' => 9999, 'dict_value' => 'Tainet%GPASS%Mercury 3630'),
	532 => array ('chapter_id' => 9999, 'dict_value' => 'Tainet%GPASS%Mercury 3630E'),
	533 => array ('chapter_id' => 9999, 'dict_value' => 'Tainet%GPASS%DSD-08A'),
	534 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL160'),
	535 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL180'),
	536 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL185'),
	537 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL365'),
	538 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL320s'),
	539 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL320p'),
	540 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%ML115'),
	541 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%S2410CP'),
	542 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%S50N'),
	543 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%S50V'),
	544 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%S25P'),
	545 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%C150'),
	546 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%C300'),
	547 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%E300'),
	548 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%E600'),
	549 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%E1200'),
	550 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%JGS524F'),
	551 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%JGS516'),
	552 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%JFS524'),
	553 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%JFS524F'),
	554 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%JGS524'),
	555 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS524'),
	556 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%JFS516'),
	557 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7224R'),
	558 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7248'),
	559 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7212'),
	560 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM726S'),
	561 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7248R'),
	562 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7224v1'),
	563 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM750S'),
	564 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM726'),
	565 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS724TP'),
	566 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS748TS'),
	567 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS724T'),
	568 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS728TP'),
	569 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS752TS'),
	570 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS728TS'),
	571 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS726T'),
	572 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS748TP'),
	573 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS724TS'),
	574 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS748T'),
	575 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GS716T'),
	576 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS752TPS'),
	577 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS750T2'),
	578 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FS726TP'),
	579 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM7328PS'),
	580 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7352S'),
	581 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7324'),
	582 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM7326P'),
	583 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM7352PS'),
	584 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7328FS'),
	585 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7328Sv1'),
	586 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7312'),
	587 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM7328S'),
	588 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%FSM7352S'),
	589 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-6500 | http://www.dlink.com/products/?sec=0&pid=341]]'),
	590 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DWS-3227 | http://www.dlink.com/products/?sec=0&pid=506]]'),
	591 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DWS-3227P | http://www.dlink.com/products/?sec=0&pid=507]]'),
	592 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DWS-3250 | http://www.dlink.com/products/?sec=0&pid=468]]'),
	593 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DWS-1008 | http://www.dlink.com/products/?sec=0&pid=434]]'),
	594 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3612G | http://www.dlink.com/products/?sec=0&pid=557]]'),
	595 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3627 | http://www.dlink.com/products/?sec=0&pid=639]]'),
	596 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3650 | http://www.dlink.com/products/?sec=0&pid=640]]'),
	597 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3324SR | http://www.dlink.com/products/?sec=0&pid=294]]'),
	598 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3324SRi | http://www.dlink.com/products/?sec=0&pid=309]]'),
	599 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DXS-3326GSR | http://www.dlink.com/products/?sec=0&pid=339]]'),
	600 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DXS-3350SR | http://www.dlink.com/products/?sec=0&pid=340]]'),
	601 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3828 | http://www.dlink.com/products/?sec=0&pid=439]]'),
	602 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3828P | http://www.dlink.com/products/?sec=0&pid=440]]'),
	603 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3100-24 | http://www.dlink.com/products/?sec=0&pid=635]]'),
	604 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3100-24P | http://www.dlink.com/products/?sec=0&pid=636]]'),
	605 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3100-48 | http://www.dlink.com/products/?sec=0&pid=637]]'),
	606 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3100-48P | http://www.dlink.com/products/?sec=0&pid=638]]'),
	607 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DXS-3227 | http://www.dlink.com/products/?sec=0&pid=483]]'),
	608 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DXS-3227P | http://www.dlink.com/products/?sec=0&pid=497]]'),
	609 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DXS-3250 | http://www.dlink.com/products/?sec=0&pid=443]]'),
	610 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3024 | http://www.dlink.com/products/?sec=0&pid=404]]'),
	611 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3224TGR | http://www.dlink.com/products/?sec=0&pid=269]]'),
	612 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-3048 | http://www.dlink.com/products/?sec=0&pid=496]]'),
	613 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3228PA | http://www.dlink.com/products/?sec=0&pid=644]]'),
	614 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3028 | http://www.dlink.com/products/?sec=0&pid=630]]'),
	615 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3028P | http://www.dlink.com/products/?sec=0&pid=631]]'),
	616 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3052 | http://www.dlink.com/products/?sec=0&pid=632]]'),
	617 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3052P | http://www.dlink.com/products/?sec=0&pid=633]]'),
	618 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3010FA | http://www.dlink.com/products/?sec=0&pid=423]]'),
	619 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3010GA | http://www.dlink.com/products/?sec=0&pid=424]]'),
	620 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3010PA | http://www.dlink.com/products/?sec=0&pid=469]]'),
	621 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3226L | http://www.dlink.com/products/?sec=0&pid=298]]'),
	622 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3526 | http://www.dlink.com/products/?sec=0&pid=330]]'),
	623 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-3550 | http://www.dlink.com/products/?sec=0&pid=331]]'),
	624 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-1216T | http://www.dlink.com/products/?sec=0&pid=324]]'),
	625 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-1224T | http://www.dlink.com/products/?sec=0&pid=329]]'),
	626 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-1248T | http://www.dlink.com/products/?sec=0&pid=367]]'),
	627 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-1316 | http://www.dlink.com/products/?sec=0&pid=353]]'),
	628 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-1228 | http://www.dlink.com/products/?sec=0&pid=540]]'),
	629 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-1228P | http://www.dlink.com/products/?sec=0&pid=541]]'),
	630 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-1252 | http://www.dlink.com/products/?sec=0&pid=555]]'),
	631 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-1016D | http://www.dlink.com/products/?sec=0&pid=337]]'),
	632 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DGS-1024D | http://www.dlink.com/products/?sec=0&pid=338]]'),
	633 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DSS-24+ | http://www.dlink.com/products/?sec=0&pid=73]]'),
	634 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-1024D | http://www.dlink.com/products/?sec=0&pid=75]]'),
	635 => array ('chapter_id' => 12, 'dict_value' => '[[D-Link%GPASS%DES-1026G | http://www.dlink.com/products/?sec=0&pid=76]]'),
	636 => array ('chapter_id' => 21, 'dict_value' => '[[D-Link%GPASS%DKVM-16 | http://www.dlink.com/products/?sec=0&pid=228]]'),
	637 => array ('chapter_id' => 21, 'dict_value' => '[[D-Link%GPASS%DKVM-8E | http://www.dlink.com/products/?sec=0&pid=161]]'),
	638 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC702'),
	639 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC702-GE'),
	640 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%ISCOM4300'),
	641 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953-FE4E1'),
	642 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953-FX4E1'),
	643 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953-FE8E1'),
	644 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953-FX8E1'),
	645 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953-8FE16E1'),
	646 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953E-3FE16E1'),
	647 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC953-GESTM1'),
	648 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%OPCOM3100-155'),
	649 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%OPCOM3101-155'),
	650 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC831-120'),
	651 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC831-120-BL'),
	652 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC831-240'),
	653 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC831-240E'),
	654 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2801-480GE-BL'),
	655 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2801-120FE'),
	656 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2801-120FE-BL'),
	657 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2801-240FE'),
	658 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2801-240FE-BL'),
	659 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2801-240EFE'),
	660 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2811-120FE'),
	661 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2811-240FE'),
	662 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2811-240FE-BL'),
	663 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2811-480FE'),
	664 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2811-480FE-BL'),
	665 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2811-240EFE'),
	666 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2104-120'),
	667 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2304-120'),
	668 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2504-120'),
	669 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2104-240'),
	670 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2304-240'),
	671 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RCMS2504-240'),
	672 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC801-120B'),
	673 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC801-240B'),
	674 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC801-480B'),
	675 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC803-120B'),
	676 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC803-240B'),
	677 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC803-480B'),
	678 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC805-120B'),
	679 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC805-240B'),
	680 => array ('chapter_id' => 9999, 'dict_value' => 'Raisecom%GPASS%RC805-480B'),
	683 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%S2410P'),
	684 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X150-24t | http://www.extremenetworks.com/products/summit-x150.aspx]]'),
	685 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X150-48t | http://www.extremenetworks.com/products/summit-x150.aspx]]'),
	686 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X150-24p | http://www.extremenetworks.com/products/summit-x150.aspx]]'),
	687 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X250e-24t | http://www.extremenetworks.com/products/summit-x250e.aspx]]'),
	688 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X250e-48t | http://www.extremenetworks.com/products/summit-x250e.aspx]]'),
	689 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X250e-24p | http://www.extremenetworks.com/products/summit-x250e.aspx]]'),
	690 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X250e-48p | http://www.extremenetworks.com/products/summit-x250e.aspx]]'),
	691 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X250e-24x | http://www.extremenetworks.com/products/summit-x250e.aspx]]'),
	692 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450-24t | http://www.extremenetworks.com/products/summit-x450.aspx]]'),
	693 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450-24x | http://www.extremenetworks.com/products/summit-x450.aspx]]'),
	694 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450a-24t | http://www.extremenetworks.com/products/summit-x450a.aspx]]'),
	695 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450a-48t | http://www.extremenetworks.com/products/summit-x450a.aspx]]'),
	696 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450a-24x | http://www.extremenetworks.com/products/summit-x450a.aspx]]'),
	697 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450e-24p | http://www.extremenetworks.com/products/summit-x450e.aspx]]'),
	698 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X450e-48p | http://www.extremenetworks.com/products/summit-x450e.aspx]]'),
	699 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 200-24fx | http://www.extremenetworks.com/products/summit-200.aspx]]'),
	700 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 200-24 | http://www.extremenetworks.com/products/summit-200.aspx]]'),
	701 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 200-48 | http://www.extremenetworks.com/products/summit-200.aspx]]'),
	702 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 300-24 | http://www.extremenetworks.com/products/summit-300.aspx]]'),
	703 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 300-48 | http://www.extremenetworks.com/products/summit-300.aspx]]'),
	704 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 400-24p | http://www.extremenetworks.com/products/summit-400-24p.aspx]]'),
	705 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 400-24t | http://www.extremenetworks.com/products/summit-400-24t.aspx]]'),
	706 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit 400-48t | http://www.extremenetworks.com/products/summit-400-48t.aspx]]'),
	707 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit48si | http://www.extremenetworks.com/products/summit-48si.aspx]]'),
	708 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Alpine 3804 | http://www.extremenetworks.com/products/Alpine-3800.aspx]]'),
	709 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Alpine 3808 | http://www.extremenetworks.com/products/Alpine-3800.aspx]]'),
	710 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 6808 | http://www.extremenetworks.com/products/blackdiamond-6800.aspx]]'),
	711 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 8806 | http://www.extremenetworks.com/products/blackdiamond-8800.aspx]]'),
	712 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 8810 | http://www.extremenetworks.com/products/blackdiamond-8800.aspx]]'),
	713 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 10808 | http://www.extremenetworks.com/products/blackdiamond-10808.aspx]]'),
	714 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 12802R | http://www.extremenetworks.com/products/blackdiamond-12800r.aspx]]'),
	715 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 12804R | http://www.extremenetworks.com/products/blackdiamond-12800r.aspx]]'),
	716 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%BlackDiamond 12804C | http://www.extremenetworks.com/products/blackdiamond-12804c.aspx]]'),
	717 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%ASR 1002 | http://cisco.com/en/US/products/ps9436/index.html]]'),
	718 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%ASR 1004 | http://cisco.com/en/US/products/ps9437/index.html]]'),
	719 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%ASR 1006 | http://cisco.com/en/US/products/ps9438/index.html]]'),
	720 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.3 | http://www.openbsd.org/33.html]]'),
	721 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.4 | http://www.openbsd.org/34.html]]'),
	722 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.5 | http://www.openbsd.org/35.html]]'),
	723 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.6 | http://www.openbsd.org/36.html]]'),
	724 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.7 | http://www.openbsd.org/37.html]]'),
	725 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.8 | http://www.openbsd.org/38.html]]'),
	726 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 3.9 | http://www.openbsd.org/39.html]]'),
	727 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.0 | http://www.openbsd.org/40.html]]'),
	728 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.1 | http://www.openbsd.org/41.html]]'),
	729 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.2 | http://www.openbsd.org/42.html]]'),
	730 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.3 | http://www.openbsd.org/43.html]]'),
// 1018 duplicated 731 later, so 731 isn't here any more
	732 => array ('chapter_id' => 13, 'dict_value' => '[[FreeBSD%GSKIP%FreeBSD 7.0 | http://www.freebsd.org/releases/7.0R/announce.html]]'),
	733 => array ('chapter_id' => 13, 'dict_value' => '[[NetBSD%GSKIP%NetBSD 2.0 | http://netbsd.org/releases/formal-2.0/]]'),
	734 => array ('chapter_id' => 13, 'dict_value' => '[[NetBSD%GSKIP%NetBSD 2.1 | http://netbsd.org/releases/formal-2.0/NetBSD-2.1.html]]'),
	735 => array ('chapter_id' => 13, 'dict_value' => '[[NetBSD%GSKIP%NetBSD 3.0 | http://netbsd.org/releases/formal-3/]]'),
	736 => array ('chapter_id' => 13, 'dict_value' => '[[NetBSD%GSKIP%NetBSD 3.1 | http://netbsd.org/releases/formal-3/NetBSD-3.1.html]]'),
	737 => array ('chapter_id' => 13, 'dict_value' => '[[NetBSD%GSKIP%NetBSD 4.0 | http://netbsd.org/releases/formal-4/NetBSD-4.0.html]]'),
	738 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2016'),
	739 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2024'),
	740 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2126-G'),
	741 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2816'),
	742 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2824'),
	743 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2226 Plus'),
	744 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2426-PWR Plus'),
	745 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2250 Plus'),
	746 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2916-SFP Plus'),
	747 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2924-SFP Plus'),
	748 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2924-PWR Plus'),
	749 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%Baseline 2948-SFP Plus'),
	750 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%3870 24-port'),
	751 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%3870 48-port'),
	752 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200 26-port'),
	753 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200 28-port'),
	754 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200 50-port'),
	755 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200G 12-port'),
	756 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200G 24-port'),
	757 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200G PWR 24-port'),
	758 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4200G 48-port'),
	759 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4210 26-port'),
	760 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4210 52-port'),
	761 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4210 26-port PWR'),
	762 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%SS3 4400 48-port'),
	763 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%SS3 4400 24-port'),
	764 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%SS3 4400 PWR'),
	765 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%SS3 4400 SE 24-port'),
	766 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500 26-port'),
	767 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500 50-port'),
	768 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500 PWR 26-port'),
	769 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500 PWR 50-port'),
	770 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500G 24-port'),
	771 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500G 48-port'),
	772 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500G PWR 24-port'),
	773 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4500G PWR 48-port'),
	774 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500-EI 28-port'),
	775 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500-EI 52-port'),
	776 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500-EI 28-port PWR'),
	777 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500-EI 52-port PWR'),
	778 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500-EI 28-port FX'),
	779 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500G-EI 24-port'),
	780 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500G-EI 48-port'),
	781 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500G-EI PWR 24-port'),
	782 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500G-EI 48-port PWR'),
	783 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%5500G-EI 24-port SFP'),
	784 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%7754'),
	785 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%7757'),
	786 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%7758'),
	787 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%8807'),
	788 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%8810'),
	789 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%8814'),
	790 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora 9'),
	791 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 11.x'),
	792 => array ('chapter_id' => 11, 'dict_value' => 'SGI%GPASS%Altix XE250'),
	793 => array ('chapter_id' => 11, 'dict_value' => 'SGI%GPASS%Altix XE310'),
	794 => array ('chapter_id' => 11, 'dict_value' => 'SGI%GPASS%Altix XE320'),
	795 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco (blade)%GPASS%Catalyst 3032-DEL | http://www.cisco.com/en/US/products/ps8772/index.html]]'),
	796 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 8.10'),
	797 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.4 | http://www.openbsd.org/44.html]]'),
	798 => array ('chapter_id' => 1, 'dict_value' => 'Network security'),
	799 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5505'),
	800 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5510'),
	801 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5520'),
	802 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5540'),
	803 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5550'),
	804 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5580-20'),
	805 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5580-40'),
	806 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%IDS 4215 | http://www.cisco.com/en/US/products/hw/vpndevc/ps4077/ps5367/index.html]]'),
	807 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%IDS 4240 | http://www.cisco.com/en/US/products/ps5768/index.html]]'),
	808 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%IDS 4255 | http://www.cisco.com/en/US/products/ps5769/index.html]]'),
	809 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%IDS 4260 | http://www.cisco.com/en/US/products/ps6751/index.html]]'),
	810 => array ('chapter_id' => 24, 'dict_value' => '[[Cisco%GPASS%IDS 4270 | http://www.cisco.com/en/US/products/ps9157/index.html]]'),
	811 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIron 100'),
	812 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIron 100C'),
	813 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIron 300'),
	814 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIron 300C'),
	815 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIronLS 100-4802'),
	816 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIronLS 300-32GC02'),
	817 => array ('chapter_id' => 24, 'dict_value' => 'Foundry%GPASS%SecureIronLS 300-32GC10G'),
	818 => array ('chapter_id' => 24, 'dict_value' => '[[D-Link%GPASS%DFL-1600 | http://www.dlink.com/products/?sec=0&pid=454]]'),
	819 => array ('chapter_id' => 24, 'dict_value' => '[[D-Link%GPASS%DFL-M510 | http://www.dlink.com/products/?sec=0&pid=455]]'),
	820 => array ('chapter_id' => 24, 'dict_value' => '[[Extreme Networks%GPASS%Sentriant AG200 | http://www.extremenetworks.com/products/sentriant-ag200.aspx]]'),
	821 => array ('chapter_id' => 24, 'dict_value' => '[[Extreme Networks%GPASS%Sentriant NG300 | http://www.extremenetworks.com/products/sentriant-ng300.aspx]]'),
	822 => array ('chapter_id' => 24, 'dict_value' => 'Force10%GPASS%P-Series'),
	823 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SSG 140 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/ssg_140/index.html]]'),
	824 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SSG 320 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/ssg_300_series/index.html]]'),
	825 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SSG 350 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/ssg_300_series/index.html]]'),
	826 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SSG 520 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/ssg_500_series/index.html]]'),
	827 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SSG 550 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/ssg_500_series/index.html]]'),
	828 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%ISG 1000 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/isg_series_slash_gprs/index.html]]'),
	829 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%ISG 2000 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/isg_series_slash_gprs/index.html]]'),
	830 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%NetScreen 5200 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/isg_series_slash_gprs/index.html]]'),
	831 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%NetScreen 5400 | http://www.juniper.net/products_and_services/firewall_slash_ipsec_vpn/isg_series_slash_gprs/index.html]]'),
	832 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SRX 5600 | http://www.juniper.net/products_and_services/srx_series/index.html]]'),
	833 => array ('chapter_id' => 24, 'dict_value' => '[[Juniper%GPASS%SRX 5800 | http://www.juniper.net/products_and_services/srx_series/index.html]]'),
	834 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%PRO 1260 | http://www.sonicwall.com/us/products/PRO_1260.html]]'),
	835 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%PRO 2040 | http://www.sonicwall.com/us/products/PRO_2040.html]]'),
	836 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%PRO 3060 | http://www.sonicwall.com/us/products/PRO_3060.html]]'),
	837 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%PRO 4060 | http://www.sonicwall.com/us/products/PRO_4060.html]]'),
	838 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%PRO 4100 | http://www.sonicwall.com/us/products/PRO_4100.html]]'),
	839 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%PRO 5060 | http://www.sonicwall.com/us/products/PRO_5060.html]]'),
	840 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA 240 | http://www.sonicwall.com/us/products/NSA_240.html]]'),
	841 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA 2400 | http://www.sonicwall.com/us/products/NSA_2400.html]]'),
	842 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA 3500 | http://www.sonicwall.com/us/products/NSA_3500.html]]'),
	843 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA 4500 | http://www.sonicwall.com/us/products/NSA_4500.html]]'),
	844 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA 5000 | http://www.sonicwall.com/us/products/NSA_5000.html]]'),
	845 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA E5500 | http://www.sonicwall.com/us/products/NSA_E5500.html]]'),
	846 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA E6500 | http://www.sonicwall.com/us/products/NSA_E6500.html]]'),
	847 => array ('chapter_id' => 24, 'dict_value' => '[[SonicWall%GPASS%NSA E7500 | http://www.sonicwall.com/us/products/NSA_E7500.html]]'),
	848 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%1400-24G'),
	849 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%1700-24'),
	850 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%1800-24G'),
	851 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2124'),
	852 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2312'),
	853 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2324'),
	854 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2510-24'),
	855 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2510-48'),
	856 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2510G-24'),
	857 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2510G-48'),
	858 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2512'),
	859 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2524'),
	860 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2610-24 J9085A'),
	861 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2610-24-PoE J9087A'),
	862 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2610-48 J9088A'),
	863 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2610-48-PoE J9089A'),
	864 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2626'),
	865 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2626-PWR'),
	866 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2650'),
	867 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2650-PWR'),
	868 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2810-24G'),
	869 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2810-48G J9022A'),
	870 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2824'),
	871 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2848'),
	872 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2900-24G'),
	873 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2900-48G'),
	874 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%3400cl-24G'),
	875 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%3400cl-48G'),
	876 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%3500yl-24G-PWR'),
	877 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%3500yl-48G-PWR'),
	878 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4202vl-72'),
	879 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4204vl'),
	880 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4204vl-48GS'),
	881 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4208vl'),
	882 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4208vl-72GS'),
	883 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4208vl-96'),
	884 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%5304xl'),
	885 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%5308xl'),
	886 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%5348xl'),
	887 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%5372xl'),
	888 => array ('chapter_id' => 30, 'dict_value' => 'HP ProCurve%GPASS%5406zl J8697A%L4,2H%'),
	889 => array ('chapter_id' => 30, 'dict_value' => 'HP ProCurve%GPASS%5406zl-48G J8699A%L4,2H%'),
	890 => array ('chapter_id' => 30, 'dict_value' => 'HP ProCurve%GPASS%5412zl J8698A%L7,2H%'),
	891 => array ('chapter_id' => 30, 'dict_value' => 'HP ProCurve%GPASS%5412zl-96G J8700A%L7,2H%'),
	892 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6108'),
	893 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6200yl-24G-mGBIC'),
	894 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6400cl'),
	895 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6410cl'),
	896 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%8108fl'),
	897 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%8116fl'),
	898 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%8212zl'),
	899 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX3200-24P | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	900 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX3200-24T | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	901 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX3200-48P | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	902 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX3200-48T | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	903 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-24F | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	904 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-24P | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	905 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-24T | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	906 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-48P | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	907 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-48T | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	908 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX8208 | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	909 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%E120 BSR | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	910 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%E320 BSR | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	911 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%ERX-310 | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	912 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%ERX-705 | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	913 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%ERX-710 | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	914 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%ERX-1410 | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	915 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%ERX-1440 | http://www.juniper.net/products_and_services/e_series_broadband_service/index.html]]'),
	916 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%J2320 | http://www.juniper.net/products_and_services/j_series_services_routers/index.html]]'),
	917 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%J2350 | http://www.juniper.net/products_and_services/j_series_services_routers/index.html]]'),
	918 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%J4350 | http://www.juniper.net/products_and_services/j_series_services_routers/index.html]]'),
	919 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%J6350 | http://www.juniper.net/products_and_services/j_series_services_routers/index.html]]'),
	920 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%M7i | http://www.juniper.net/products_and_services/m_series_routing_portfolio/index.html]]'),
	921 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%M10i | http://www.juniper.net/products_and_services/m_series_routing_portfolio/index.html]]'),
	922 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%M40e | http://www.juniper.net/products_and_services/m_series_routing_portfolio/index.html]]'),
	923 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%M120 | http://www.juniper.net/products_and_services/m_series_routing_portfolio/index.html]]'),
	924 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%M320 | http://www.juniper.net/products_and_services/m_series_routing_portfolio/index.html]]'),
	925 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX240 | http://www.juniper.net/products-services/routing/mx-series/mx240]]'),
	926 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX480 | http://www.juniper.net/products-services/routing/mx-series/mx480]]'),
	927 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX960 | http://www.juniper.net/products-services/routing/mx-series/mx960]]'),
	928 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%T320 | http://www.juniper.net/products_and_services/t_series_core_platforms/index.html]]'),
	929 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%T640 | http://www.juniper.net/products_and_services/t_series_core_platforms/index.html]]'),
	930 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%T1600 | http://www.juniper.net/products_and_services/t_series_core_platforms/index.html]]'),
	931 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%TX Matrix | http://www.juniper.net/products_and_services/t_series_core_platforms/index.html]]'),
	932 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora 10'),
	933 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 11.1'),
	934 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP WebAccelerator 4500 | http://www.f5.com/pdf/products/big-ip-webaccelerator-ds.pdf]]'),
	935 => array ('chapter_id' => 30, 'dict_value' => 'F5%GPASS%VIPRION 2400%L2,2H%'),
	936 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 1500 | http://www.f5.com/pdf/products/big-ip-platforms-2007-ds.pdf]]'),
	937 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 1600 | http://www.f5.com/pdf/products/big-ip-platforms-ds.pdf]]'),
	938 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 3400 | http://www.f5.com/pdf/products/big-ip-platforms-2007-ds.pdf]]'),
	939 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 3600 | http://www.f5.com/pdf/products/big-ip-platforms-ds.pdf]]'),
	940 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 6400 | http://www.f5.com/pdf/products/big-ip-platforms-2007-ds.pdf]]'),
	941 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 6800 | http://www.f5.com/pdf/products/big-ip-platforms-2007-ds.pdf]]'),
	942 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 6900 | http://www.f5.com/pdf/products/big-ip-platforms-ds.pdf]]'),
	943 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 8400 | http://www.f5.com/pdf/products/big-ip-platforms-ds.pdf]]'),
	944 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 8800 | http://www.f5.com/pdf/products/big-ip-platforms-ds.pdf]]'),
	945 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%ARX 500 | http://www.f5.com/pdf/products/arx-series-ds.pdf]]'),
	946 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%ARX 1000 | http://www.f5.com/pdf/products/arx-series-ds.pdf]]'),
	947 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%ARX 4000 | http://www.f5.com/pdf/products/arx-series-ds.pdf]]'),
	948 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%ARX 6000 | http://www.f5.com/pdf/products/arx-series-ds.pdf]]'),
	949 => array ('chapter_id' => 17, 'dict_value' => '[[F5%GPASS%WANJet 300 | http://www.f5.com/pdf/products/wanjet-hardware-ds.pdf]]'),
	950 => array ('chapter_id' => 17, 'dict_value' => '[[F5%GPASS%WANJet 500 | http://www.f5.com/pdf/products/wanjet-hardware-ds.pdf]]'),
	951 => array ('chapter_id' => 24, 'dict_value' => '[[F5%GPASS%FirePass 1200 | http://www.f5.com/pdf/products/firepass-hardware-ds.pdf]]'),
	952 => array ('chapter_id' => 24, 'dict_value' => '[[F5%GPASS%FirePass 4100 | http://www.f5.com/pdf/products/firepass-hardware-ds.pdf]]'),
	953 => array ('chapter_id' => 24, 'dict_value' => '[[F5%GPASS%FirePass 4300 | http://www.f5.com/pdf/products/firepass-hardware-ds.pdf]]'),
	954 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 5.0 (lenny) | http://debian.org/releases/lenny/]]'),
	955 => array ('chapter_id' => 11, 'dict_value' => 'SGI%GPASS%Altix XE270'),
	956 => array ('chapter_id' => 11, 'dict_value' => 'SGI%GPASS%Altix XE340'),
	957 => array ('chapter_id' => 11, 'dict_value' => 'SGI%GPASS%Altix XE500'),
	958 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 2148T | http://cisco.com/en/US/products/ps10118/index.html]]'),
	959 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 5010 | http://cisco.com/en/US/products/ps9711/index.html]]'),
	960 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 5020 | http://cisco.com/en/US/products/ps9710/index.html]]'),
	961 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 7010 | http://cisco.com/en/US/products/ps9512/index.html]]'),
	962 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 7018 | http://cisco.com/en/US/products/ps10098/index.html]]'),
	963 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 4.0'),
	964 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 4.1'),
	965 => array ('chapter_id' => 1, 'dict_value' => 'Wireless'),
	966 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%2106'),
	967 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%2112'),
	968 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%2125'),
	969 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%4402'),
	970 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%4404'),
	971 => array ('chapter_id' => 25, 'dict_value' => '[[Cisco%GPASS%Aironet 1140 | http://cisco.com/en/US/products/ps10092/index.html]]'),
	972 => array ('chapter_id' => 25, 'dict_value' => '[[Cisco%GPASS%Aironet 1200 | http://cisco.com/en/US/products/hw/wireless/ps430/ps4076/index.html]]'),
	973 => array ('chapter_id' => 25, 'dict_value' => '[[Cisco%GPASS%Aironet 1230 AG | http://cisco.com/en/US/products/ps6132/index.html]]'),
	974 => array ('chapter_id' => 25, 'dict_value' => '[[Cisco%GPASS%Aironet 1240 AG | http://cisco.com/en/US/products/ps6521/index.html]]'),
	975 => array ('chapter_id' => 25, 'dict_value' => '[[Cisco%GPASS%Aironet 1250 | http://cisco.com/en/US/products/ps8382/index.html]]'),
	976 => array ('chapter_id' => 25, 'dict_value' => '[[Cisco%GPASS%Aironet 1520 | http://cisco.com/en/US/products/ps8368/index.html]]'),
	977 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%AP150'),
	978 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%OAP180'),
	979 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%AP201'),
	980 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%AP208'),
	981 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%AP250'),
	982 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%AP300'),
	983 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%RS4000'),
	984 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%MC500'),
	985 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%MC1000'),
	986 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%MC3000'),
	987 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%MC4100'),
	988 => array ('chapter_id' => 25, 'dict_value' => 'Foundry%GPASS%MC5000'),
	989 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R410'),
	990 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R610'),
	991 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R710'),
	992 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R805'),
	993 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R905'),
	994 => array ('chapter_id' => 31, 'dict_value' => 'Dell PowerEdge%GPASS%M1000e%L2,8V%'),
	995 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%MD1000'),
	996 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%MD1120'),
	997 => array ('chapter_id' => 18, 'dict_value' => 'Dell EqualLogic PS5000'),
	998 => array ('chapter_id' => 18, 'dict_value' => 'Dell EqualLogic PS6000'),
	999 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX4-120 SPE'),
	1000 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX4-240 SPE'),
	1001 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX4-480 SPE'),
	1002 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX4-960 SPE'),
	1003 => array ('chapter_id' => 18, 'dict_value' => 'EMC CLARiiON CX4 DAE'),
	1004 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%300'),
	1005 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%4900'),
	1006 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%5000'),
	1007 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%5100'),
	1008 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%5300'),
	1009 => array ('chapter_id' => 26, 'dict_value' => '[[Cisco%GPASS%MDS 9124 | http://www.cisco.com/en/US/products/ps7079/index.html]]'),
	1010 => array ('chapter_id' => 26, 'dict_value' => '[[Cisco%GPASS%MDS 9134 | http://www.cisco.com/en/US/products/ps8414/index.html]]'),
	1011 => array ('chapter_id' => 26, 'dict_value' => 'QLogic%GPASS%1400'),
	1012 => array ('chapter_id' => 26, 'dict_value' => 'QLogic%GPASS%3800'),
	1013 => array ('chapter_id' => 26, 'dict_value' => 'QLogic%GPASS%5600Q'),
	1014 => array ('chapter_id' => 26, 'dict_value' => 'QLogic%GPASS%5800V'),
	1015 => array ('chapter_id' => 26, 'dict_value' => 'QLogic%GPASS%9000'),
	1016 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%ASR 9006 | http://cisco.com/en/US/products/ps10075/index.html]]'),
	1017 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%ASR 9010 | http://cisco.com/en/US/products/ps10076/index.html]]'),
	1018 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst 4900M | http://www.cisco.com/en/US/products/ps9310/index.html]]'),
	1019 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst 4928-10GE | http://www.cisco.com/en/US/products/ps9903/index.html]]'),
	1022 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron CX 624S | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-cx-series/overview.page]]'),
	1023 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron CX 624S-HPOE | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-cx-series/overview.page]]'),
	1024 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron CX 648S | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-cx-series/overview.page]]'),
	1025 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron CX 648S-HPOE | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-cx-series/overview.page]]'),
	1026 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 624 | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1027 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 624-POE | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1028 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 624G | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1029 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 624G-POE | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1030 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 648 | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1031 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 648-POE | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1032 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 648G | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1033 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FastIron WS 648G-POE | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fastiron-ws-series/overview.page]]'),
	1034 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%NetIron CES 2024C | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/service-provider/product-details/netiron-ces-2000-series/overview.page]]'),
	1035 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%NetIron CES 2024F | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/service-provider/product-details/netiron-ces-2000-series/overview.page]]'),
	1036 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%NetIron CES 2048C | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/service-provider/product-details/netiron-ces-2000-series/overview.page]]'),
	1037 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%NetIron CES 2048F | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/service-provider/product-details/netiron-ces-2000-series/overview.page]]'),
	1038 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%NetIron CES 2048CX | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/service-provider/product-details/netiron-ces-2000-series/overview.page]]'),
	1039 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%NetIron CES 2048FX | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/service-provider/product-details/netiron-ces-2000-series/overview.page]]'),
	1040 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ServerIron ADX 1000 | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/application-switching/product-details/serveriron-adx-series/overview.page]]'),
	1041 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ServerIron ADX 4000 | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/application-switching/product-details/serveriron-adx-series/overview.page]]'),
	1042 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ServerIron ADX 8000 | http://www.brocade.com/products-solutions/products/ethernet-switches-routers/application-switching/product-details/serveriron-adx-series/overview.page]]'),
	1043 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ServerIron 4G-SSL-FIPS | http://www.brocade.com/sites/dotcom/products-solutions/products/ethernet-switches-routers/application-switching/product-details/serveriron-4g-application-switches/index.page]]'),
	1044 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%TurboIron 24X | http://www.brocade.com/sites/dotcom/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/turboiron-24x-switch/index.page]]'),
	1045 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora 11'),
	1046 => array ('chapter_id' => 13, 'dict_value' => '[[NetBSD%GSKIP%NetBSD 5.0 | http://netbsd.org/releases/formal-5/NetBSD-5.0.html]]'),
	1047 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.5 | http://www.openbsd.org/45.html]]'),
	1048 => array ('chapter_id' => 13, 'dict_value' => '[[Solaris%GSKIP%OpenSolaris 2008.05 | http://opensolaris.org/os/project/indiana/resources/relnotes/200805/x86/]]'),
	1049 => array ('chapter_id' => 13, 'dict_value' => '[[Solaris%GSKIP%OpenSolaris 2008.11 | http://opensolaris.org/os/project/indiana/resources/relnotes/200811/x86/]]'),
	1050 => array ('chapter_id' => 13, 'dict_value' => '[[Solaris%GSKIP%OpenSolaris 2009.06 | http://opensolaris.org/os/project/indiana/resources/relnotes/200906/x86/]]'),
	1051 => array ('chapter_id' => 13, 'dict_value' => '[[Gentoo%GSKIP%Gentoo 2006.0 | http://www.gentoo.org/proj/en/releng/release/2006.0/2006.0.xml]]'),
	1052 => array ('chapter_id' => 13, 'dict_value' => '[[Gentoo%GSKIP%Gentoo 2007.0 | http://www.gentoo.org/proj/en/releng/release/2007.0/2007.0-press-release.txt]]'),
	1053 => array ('chapter_id' => 13, 'dict_value' => '[[Gentoo%GSKIP%Gentoo 2008.0 | http://www.gentoo.org/proj/en/releng/release/2008.0/index.xml]]'),
	1054 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 9.04'),
	1055 => array ('chapter_id' => 1, 'dict_value' => 'FC switch'),
	1056 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst CBS3030-DEL'),
	1057 => array ('chapter_id' => 13, 'dict_value' => '[[FreeBSD%GSKIP%FreeBSD 7.1 | http://www.freebsd.org/releases/7.1R/relnotes.html]]'),
	1058 => array ('chapter_id' => 13, 'dict_value' => '[[FreeBSD%GSKIP%FreeBSD 7.2 | http://www.freebsd.org/releases/7.2R/relnotes.html]]'),
	1059 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R200'),
	1060 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R300'),
	1061 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2808'),
	1062 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2816'),
	1063 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2824'),
	1064 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%2848'),
	1065 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3524'),
	1066 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3524P'),
	1067 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3548'),
	1068 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3548P'),
	1069 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%5424'),
	1070 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%5448'),
	1071 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%Silkworm 2400'),
	1072 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%Silkworm 2800'),
	1073 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%Silkworm 3200'),
	1074 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%Silkworm 3800'),
	1075 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%Silkworm 3900'),
	1076 => array ('chapter_id' => 26, 'dict_value' => 'Brocade%GPASS%Silkworm 4100'),
	1085 => array ('chapter_id' => 12, 'dict_value' => 'Nortel%GPASS%BES50GE-12T PWR'),
	1086 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%4000M'),
	1088 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS2020 | http://www.netapp.com/us/products/storage-systems/fas2000/]]'),
	1089 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS2050 | http://www.netapp.com/us/products/storage-systems/fas2000/]]'),
	1090 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3020'),
	1091 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3040'),
	1092 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3050'),
	1093 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3070'),
	1094 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS3140 | http://www.netapp.com/us/products/storage-systems/fas3100/]]'),
	1095 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS3160 | http://www.netapp.com/us/products/storage-systems/fas3100/]]'),
	1096 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS3170 | http://www.netapp.com/us/products/storage-systems/fas3100/]]'),
	1097 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS6030'),
	1098 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS6040 | http://www.netapp.com/us/products/storage-systems/fas6000/]]'),
	1099 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS6070'),
	1100 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%FAS6080 | http://www.netapp.com/us/products/storage-systems/fas6000/]]'),
	1101 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V3140 | http://www.netapp.com/us/products/storage-systems/v3100/]]'),
	1102 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V3160 | http://www.netapp.com/us/products/storage-systems/v3100/]]'),
	1103 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V3170 | http://www.netapp.com/us/products/storage-systems/v3100/]]'),
	1104 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V6030 | http://www.netapp.com/us/products/storage-systems/v6000/]]'),
	1105 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V6040 | http://www.netapp.com/us/products/storage-systems/v6000/]]'),
	1106 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V6070 | http://www.netapp.com/us/products/storage-systems/v6000/]]'),
	1107 => array ('chapter_id' => 18, 'dict_value' => '[[NetApp%GPASS%V6080 | http://www.netapp.com/us/products/storage-systems/v6000/]]'),
	1108 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%DS14mk2 AT'),
	1109 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%DS14mk2 FC'),
	1110 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%DS14mk4 FC'),
	1111 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7152 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7152]]'),
	1112 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7155 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7155]]'),
	1113 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7175 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7175]]'),
	1114 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7526 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7526]]'),
	1115 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7551 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7551]]'),
	1116 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7552 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7552]]'),
	1117 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7553 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7553]]'),
	1118 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7554 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7554]]'),
	1119 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7555 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7555]]'),
	1120 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7557 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7557]]'),
	1121 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7585 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7585]]'),
	1122 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7586 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7586]]'),
	1123 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7611 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7611]]'),
	1124 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7631 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7631]]'),
	1125 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7820 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7820]]'),
	1126 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7821 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7821]]'),
	1127 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7822 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7822]]'),
	1128 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7850 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7850]]'),
	1129 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7851 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7851]]'),
	1130 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7852 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7852]]'),
	1131 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7853 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7853]]'),
	1132 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7854 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7854]]'),
	1133 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7855A | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7855A]]'),
	1134 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7856 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7856]]'),
	1135 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7856A | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7856A]]'),
	1136 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7857 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7857]]'),
	1137 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7920 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7920]]'),
	1138 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7921 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7921]]'),
	1139 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7922 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7922]]'),
	1140 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7950 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7950]]'),
	1141 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7951 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7951]]'),
	1142 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7952 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7952]]'),
	1143 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7953 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7953]]'),
	1144 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7954 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7954]]'),
	1145 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7957 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7957]]'),
	1146 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP9559 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP9559]]'),
	1147 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP9565 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP9565]]'),
	1148 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP9568 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP9568]]'),
	1149 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP9572 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP9572]]'),
	1150 => array ('chapter_id' => 30, 'dict_value' => '[[Cisco%GPASS%Catalyst 6509-V-E%L1,9V% | http://www.cisco.com/en/US/products/ps9306/index.html]]'),
	1151 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7902J | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7902J]]'),
	1152 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7930J | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7930J]]'),
	1153 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7932J | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7932J]]'),
	1154 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7900 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7900]]'),
	1155 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7901 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7901]]'),
	1156 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7902 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7902]]'),
	1157 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7930 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7930]]'),
	1158 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7931 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7931]]'),
	1159 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7932 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7932]]'),
	1160 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7911 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7911]]'),
	1161 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7940 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7940]]'),
	1162 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7941 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7941]]'),
	1163 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7960 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7960]]'),
	1164 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7961 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7961]]'),
	1165 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7968 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7968]]'),
	1166 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7990 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7990]]'),
	1167 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7991 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7991]]'),
	1168 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP7998 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP7998]]'),
	1169 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3108FG2'),
	1170 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3124GT-HR2'),
	1171 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia4348GT'),
	1172 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia4348GT-PSR'),
	1173 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia4328GT'),
	1174 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia4224GT-PSR'),
	1175 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia2248G2'),
	1176 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia2124GT2'),
	1177 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia2124GT-SS2'),
	1178 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia2124-SS2'),
	1179 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia13000-24GX-PSR'),
	1180 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia13000-48X'),
	1181 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3424GT-SS'),
	1182 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3424GT-PoE'),
	1183 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3248G-PSR2'),
	1184 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3248G2'),
	1185 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3124GT-PSR2'),
	1186 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia3124GT2'),
	1187 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia18020'),
	1188 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia18008'),
	1189 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia18005'),
	1190 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia8007'),
	1191 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia8004'),
	1192 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia6148G-PSR'),
	1193 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%Apresia6148GT-PSR'),
	1194 => array ('chapter_id' => 12, 'dict_value' => 'Hitachi Cable%GPASS%VXC-1024FE'),
	1301 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-BR1410A'),
	1302 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-BR1310G'),
	1303 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1252AG'),
	1304 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1252G'),
	1305 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1242AG'),
	1306 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1242G'),
	1307 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1231G'),
	1308 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1232AG'),
	1309 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1131AG'),
	1310 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1131G'),
	1311 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1121G'),
	1312 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP521G'),
	1313 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-WLC2106'),
	1314 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-WLC526'),
	1315 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-WLC4402'),
	1317 => array ('chapter_id' => 13, 'dict_value' => 'SUSE Enterprise%GSKIP%SLES11'),
	1318 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows Server 2008'),
	1319 => array ('chapter_id' => 13, 'dict_value' => 'SlackWare%GSKIP%Slackware 13.0'),
	1320 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 9.10'),
	1321 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5328C-EI-24S'),
	1323 => array ('chapter_id' => 1, 'dict_value' => 'Voice/video'),
	1324 => array ('chapter_id' => 28, 'dict_value' => 'Cisco%GPASS%MCS 7816'),
	1325 => array ('chapter_id' => 28, 'dict_value' => 'Cisco%GPASS%MCS 7825'),
	1326 => array ('chapter_id' => 28, 'dict_value' => 'Cisco%GPASS%MCS 7835'),
	1327 => array ('chapter_id' => 17, 'dict_value' => '[[ Cisco%GPASS%2901 | http://www.cisco.com/en/US/products/ps10539/index.html]]'),
	1328 => array ('chapter_id' => 17, 'dict_value' => '[[ Cisco%GPASS%2911 | http://www.cisco.com/en/US/products/ps10540/index.html]]'),
	1329 => array ('chapter_id' => 17, 'dict_value' => '[[ Cisco%GPASS%2921 | http://www.cisco.com/en/US/products/ps10543/index.html]]'),
	1330 => array ('chapter_id' => 17, 'dict_value' => '[[ Cisco%GPASS%2951 | http://www.cisco.com/en/US/products/ps10544/index.html]]'),
	1331 => array ('chapter_id' => 13, 'dict_value' => 'ALT_Linux%GSKIP%ALTLinux 5'),
	1332 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 12 | http://docs.fedoraproject.org/release-notes/f12/en-US/html/]]'),
	1333 => array ('chapter_id' => 13, 'dict_value' => 'Gentoo%GSKIP%Gentoo 10.0'),
	1334 => array ('chapter_id' => 13, 'dict_value' => 'Gentoo%GSKIP%Gentoo 10.1'),
	1335 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5328C-EI'),
	1336 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5328C-PWR-EI'),
	1337 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5352C-EI'),
	1338 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5352C-PWR-EI'),
	1339 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5328C-SI'),
	1340 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5328C-PWR-SI'),
	1341 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5352C-SI'),
	1342 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5352C-PWR-SI'),
	1343 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5324TP-SI'),
	1344 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5324TP-PWR-SI'),
	1345 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5348TP-SI'),
	1346 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5348TP-PWR-SI'),
	1347 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24PC-L'),
	1348 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2350-48TD'),
	1349 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2910-48G J9147A'),
	1350 => array ('chapter_id' => 14, 'dict_value' => 'ExtremeXOS 10'),
	1351 => array ('chapter_id' => 14, 'dict_value' => 'ExtremeXOS 11'),
	1352 => array ('chapter_id' => 14, 'dict_value' => 'ExtremeXOS 12'),
	1353 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X480-24x | http://extremenetworks.com/products/summit-X480.aspx]]'),
	1354 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X480-48t | http://extremenetworks.com/products/summit-X480.aspx]]'),
	1355 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X480-48x | http://extremenetworks.com/products/summit-X480.aspx]]'),
	1356 => array ('chapter_id' => 12, 'dict_value' => '[[Extreme Networks%GPASS%Summit X650 | http://extremenetworks.com/products/summit-x650.aspx]]'),
	1357 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S9303'),
	1358 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S9306'),
	1359 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S9312'),
	1360 => array ('chapter_id' => 14, 'dict_value' => 'Huawei VRP 5.3'),
	1361 => array ('chapter_id' => 14, 'dict_value' => 'Huawei VRP 5.5'),
	1362 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%FCX 648 | http://www.brocade.com/sites/dotcom/products-solutions/products/ethernet-switches-routers/enterprise-mobility/product-details/fcx-series-data-center/index.page ]]'),
	1363 => array ('chapter_id' => 14, 'dict_value' => 'IronWare 5'),
	1364 => array ('chapter_id' => 14, 'dict_value' => 'IronWare 7'),
	1365 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 4.2'),
	1366 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 9'),
	1367 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 10'),
	1368 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX80 | http://www.juniper.net/products-services/routing/mx-series/mx80]]'),
	1369 => array ('chapter_id' => 14, 'dict_value' => 'Huawei VRP 5.7'),
	1370 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-48PST-L'),
	1371 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8024L2'),
	1372 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8124PL2'),
	1373 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8126L2'),
	1374 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8150L2'),
	1375 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8612XL3'),
	1376 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8708L2'),
	1377 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8824M'),
	1378 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8848M'),
	1379 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8926EM'),
	1380 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%8950EM'),
	1381 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R910'),
	1382 => array ('chapter_id' => 18, 'dict_value' => 'Dell PowerVault%GPASS%MD1220'),
	1383 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48TD-L'),
	1384 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-24TD-L'),
	1385 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48FPD-L'),
	1386 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48LPD-L'),
	1387 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-24PD-L'),
	1388 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48TS-L'),
	1389 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-24TS-L'),
	1390 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48TS-S'),
	1391 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-24TS-S'),
	1392 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48FPS-L'),
	1393 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-48LPS-L'),
	1394 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-24PS-L'),
	1395 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 6.0 (squeeze) | http://debian.org/releases/squeeze/]]'),
	1396 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V6'),
	1397 => array ('chapter_id' => 1, 'dict_value' => 'Power supply chassis'),
	1398 => array ('chapter_id' => 1, 'dict_value' => 'Power supply'),
	1400 => array ('chapter_id' => 34, 'dict_value' => 'Cisco%GPASS%RPS 2300'),
	1401 => array ('chapter_id' => 34, 'dict_value' => 'D-Link%GPASS%DPS-800'),
	1402 => array ('chapter_id' => 34, 'dict_value' => 'D-Link%GPASS%DPS-900'),
	1403 => array ('chapter_id' => 35, 'dict_value' => 'Cisco%GPASS%RPS 675'),
	1404 => array ('chapter_id' => 35, 'dict_value' => 'Cisco%GPASS%C3K-PWR-750WAC'),
	1405 => array ('chapter_id' => 35, 'dict_value' => 'Cisco%GPASS%C3K-PWR-1150WAC'),
	1406 => array ('chapter_id' => 35, 'dict_value' => 'D-Link%GPASS%DPS-200'),
	1407 => array ('chapter_id' => 35, 'dict_value' => 'D-Link%GPASS%DPS-500'),
	1408 => array ('chapter_id' => 35, 'dict_value' => 'D-Link%GPASS%DPS-510'),
	1409 => array ('chapter_id' => 35, 'dict_value' => 'D-Link%GPASS%DPS-600'),
	1410 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 5.0'),
	1411 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 5.1'),
	1412 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 5548P | http://cisco.com/en/US/products/ps11215/index.html]]'),
	1413 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 2224TP | http://cisco.com/en/US/products/ps11045/index.html]]'),
	1414 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 2248TP | http://cisco.com/en/US/products/ps10783/index.html]]'),
	1415 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 2232PP | http://cisco.com/en/US/products/ps10784/index.html]]'),
	1416 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 8.x'),
	1417 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL3.x | https://www.scientificlinux.org/]]'),
	1418 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL4.x | https://www.scientificlinux.org/]]'),
	1419 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL5.1 | https://www.scientificlinux.org/]]'),
	1420 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL5.2 | https://www.scientificlinux.org/]]'),
	1421 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL5.3 | https://www.scientificlinux.org/]]'),
	1422 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL5.4 | https://www.scientificlinux.org/]]'),
	1423 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2600-8-PWR'),
	1467 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1141N'),
	1468 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1262N'),
	1470 => array ('chapter_id' => 12, 'dict_value' => '[[Force10%GPASS%S55 | http://www.force10networks.com/products/s55.asp]]'),
	1471 => array ('chapter_id' => 12, 'dict_value' => '[[Force10%GPASS%S60 | http://www.force10networks.com/products/s60.asp]]'),
	1472 => array ('chapter_id' => 12, 'dict_value' => '[[Force10%GPASS%S4810 | http://www.force10networks.com/products/s4810.asp]]'),
	1473 => array ('chapter_id' => 31, 'dict_value' => 'IBM%GPASS%BladeCenter S'),
	1474 => array ('chapter_id' => 31, 'dict_value' => 'IBM%GPASS%BladeCenter H%L1,14V%'),
	1475 => array ('chapter_id' => 31, 'dict_value' => 'IBM%GPASS%BladeCenter E%L1,14V%'),
	1476 => array ('chapter_id' => 31, 'dict_value' => 'IBM%GPASS%BladeCenter T'),
	1477 => array ('chapter_id' => 31, 'dict_value' => 'IBM%GPASS%BladeCenter HT'),
	1478 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HS12'),
	1479 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HS20'),
	1480 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HS21'),
	1481 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HS21 XM'),
	1482 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HS22'),
	1483 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HS22V'),
	1484 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%HX5'),
	1485 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%JS12'),
	1486 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%JS20'),
	1487 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%JS21'),
	1488 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%JS22'),
	1489 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%JS23'),
	1490 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%JS43'),
	1491 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%LS20'),
	1492 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%LS21'),
	1493 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%LS22'),
	1494 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%LS41'),
	1495 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%LS42'),
	1496 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%PS700'),
	1497 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%PS701'),
	1498 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%PS702'),
	1499 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%PS703'),
	1500 => array ('chapter_id' => 29, 'dict_value' => 'No'),
	1501 => array ('chapter_id' => 29, 'dict_value' => 'Yes'),
	1502 => array ('chapter_id' => 1, 'dict_value' => 'Server chassis'),
	1503 => array ('chapter_id' => 1, 'dict_value' => 'Network chassis'),
	1504 => array ('chapter_id' => 1, 'dict_value' => 'VM'),
	1505 => array ('chapter_id' => 1, 'dict_value' => 'VM Cluster'),
	1506 => array ('chapter_id' => 1, 'dict_value' => 'VM Resource Pool'),
	1507 => array ('chapter_id' => 1, 'dict_value' => 'VM Virtual Switch'),
	1508 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESX 3.5'),
	1509 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 3.5'),
	1510 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESX 4.0'),
	1511 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 4.0'),
	1512 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESX 4.1'),
	1513 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 4.1'),
	1514 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 4.0'),
	1515 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 5.0'),
	1516 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 5.5'),
	1517 => array ('chapter_id' => 31, 'dict_value' => 'Dell PowerEdge%GPASS%1855%L1,10V%'),
	1518 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%1955'),
	1519 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M605'),
	1520 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M610'),
	1521 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M610x'),
	1522 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M710%L2,1%'),
	1523 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M805%L2,1%'),
	1524 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M905%L2,1%'),
	1525 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M910%L2,1%'),
	1526 => array ('chapter_id' => 26, 'dict_value' => 'Brocade (blade)%GPASS%McDATA 3014'),
	1527 => array ('chapter_id' => 26, 'dict_value' => 'Brocade (blade)%GPASS%McDATA 4314'),
	1528 => array ('chapter_id' => 26, 'dict_value' => 'Brocade (blade)%GPASS%McDATA 4416'),
	1529 => array ('chapter_id' => 26, 'dict_value' => 'Brocade (blade)%GPASS%M4424'),
	1530 => array ('chapter_id' => 26, 'dict_value' => 'Brocade (blade)%GPASS%M5424'),
	1531 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect (blade)%GPASS%5316M'),
	1532 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect (blade)%GPASS%M6220'),
	1533 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect (blade)%GPASS%M8024'),
	1534 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%Catalyst 3130G'),
	1535 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%Catalyst 3130X'),
	1536 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6148-GE-TX'),
	1537 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6148A-GE-45AF'),
	1538 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6148A-GE-TX'),
	1539 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6408A-GBIC'),
	1540 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6416-GBIC'),
	1541 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6516A-GBIC'),
	1542 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6548-GE-TX'),
	1543 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6548-GE-45AF'),
	1544 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6704-10GE'),
	1545 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6708-10G-3C'),
	1546 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6708-10G-3CXL'),
	1547 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6716-10GT-3C'),
	1548 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6716-10GT-3CXL'),
	1549 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6724-SFP'),
	1550 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6748-GE-TX'),
	1551 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6748-SFP'),
	1552 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-SUP720-3B'),
	1553 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-XSUP720-3BXL'),
	1554 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-SUP32-GE-3B'),
	1555 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-SUP32-10GE-3B'),
	1556 => array ('chapter_id' => 32, 'dict_value' => 'VMware%GPASS%Standard vSwitch'),
	1557 => array ('chapter_id' => 32, 'dict_value' => 'VMware%GPASS%Distributed vSwitch'),
	1558 => array ('chapter_id' => 32, 'dict_value' => 'Cisco%GPASS%Nexus 1000V'),
	1559 => array ('chapter_id' => 33, 'dict_value' => 'NS-OS 4.0'),
	1560 => array ('chapter_id' => 1, 'dict_value' => 'Rack'),
	1561 => array ('chapter_id' => 1, 'dict_value' => 'Row'),
	1562 => array ('chapter_id' => 1, 'dict_value' => 'Location'),
	1563 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%PS704'),
	1564 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%QS21'),
	1565 => array ('chapter_id' => 11, 'dict_value' => 'IBM BladeCenter%GPASS%QS22'),
	1566 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%SMC6110L2'),
	1567 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%SMC6128L2'),
	1568 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%SMC6128PL2'),
	1569 => array ('chapter_id' => 12, 'dict_value' => 'SMC%GPASS%SMC6152L2'),
	1570 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2610-24/12-PoE J9086A'),
	1571 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2910-24G'),
	1572 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-48TT-L'),
	1573 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-48TT-S'),
	1574 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560E-48TD'),
	1575 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560E-24TD'),
	1576 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560X-24T'),
	1577 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560X-48T'),
	1578 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560X-24P'),
	1579 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560X-48P'),
	1580 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560X-48PF'),
	1581 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-24T'),
	1582 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-48T'),
	1583 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-24P'),
	1584 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-48P'),
	1585 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-48PF'),
	1586 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-12S'),
	1587 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3750X-24S'),
	1589 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1261N'),
	1590 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-48TC-L'),
	1591 => array ('chapter_id' => 14, 'dict_value' => 'Force10 SFTOS 2'),
	1592 => array ('chapter_id' => 14, 'dict_value' => 'Force10 FTOS 6'),
	1593 => array ('chapter_id' => 14, 'dict_value' => 'Force10 FTOS 7'),
	1594 => array ('chapter_id' => 14, 'dict_value' => 'Force10 FTOS 8'),
	1595 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 13 | http://docs.fedoraproject.org/release-notes/f13/en-US/html/]]'),
	1596 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 14 | http://docs.fedoraproject.org/release-notes/f14/en-US/html/]]'),
	1597 => array ('chapter_id' => 16, 'dict_value' => 'JunOS 10'),
	1598 => array ('chapter_id' => 16, 'dict_value' => 'JunOS 11'),
	1599 => array ('chapter_id' => 16, 'dict_value' => 'JunOS 12'),
	1600 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2910-48G-PoE+ J9148A'),
	1601 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7328Sv2'),
	1602 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7224v2'),
	1605 => array ('chapter_id' => 12, 'dict_value' => 'HP GbE2c w/SFP'),
	1606 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2360-48TD'),
	1607 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560E-12D'),
	1608 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 5.0'),
	1609 => array ('chapter_id' => 17, 'dict_value' => 'Fortinet%GPASS%Fortigate 310B'),
	1610 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7124S'),
	1611 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%3348'),
	1612 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-48'),
	1613 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2309TP-EI'),
	1614 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2309TP-SI'),
	1615 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2318TP-EI'),
	1616 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2318TP-SI'),
	1617 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2326TP-EI'),
	1618 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2326TP-SI'),
	1619 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2352P-EI'),
	1620 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2309TP-PWR-EI'),
	1621 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2326TP-PWR-EI'),
	1622 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%5224'),
	1623 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%6024F'),
	1624 => array ('chapter_id' => 12, 'dict_value' => 'Linksys%GPASS%SRW2048'),
	1625 => array ('chapter_id' => 30, 'dict_value' => 'HP ProCurve%GPASS%5406zl-48G PoE+ J9447A%L4,2H%'),
	1626 => array ('chapter_id' => 30, 'dict_value' => 'HP ProCurve%GPASS%5412zl-96G PoE+ J9448A%L7,2H%'),
	1627 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl Management Module J8726A'),
	1628 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 24 1Gb-PoE J8702A'),
	1629 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 20 1Gb + 4 Mini-GBIC J8705A'),
	1630 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 24 Mini-GBIC J8706A'),
	1631 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 4 10GbE X2 J8707A'),
	1632 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 4 10GbE CX4 J8708A'),
	1633 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 24 1Gb-PoE+ J9307A'),
	1634 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 20 1Gb-PoE+ + 4 Mini-GBIC J9308A'),
	1635 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 4 10GbE SFP+ J9309A'),
	1636 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve (blade)%GPASS%5400zl 24 100Mb PoE+ J9478A'),
	1637 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6600-24G J9263A'),
	1638 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6600-24G-4XG J9264A'),
	1639 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6600-24XG J9265A'),
	1640 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6600-48G J9451A'),
	1641 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%6600-48G-4XG J9452A'),
	1643 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 6.0'),
	1644 => array ('chapter_id' => 1, 'dict_value' => 'serial console server'),
	1645 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6150 | http://www.moxa.com/product/NPort_6150.htm]]'),
	1646 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6610-8 | http://www.moxa.com/product/NPort_6650.htm]]'),
	1647 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6610-16 | http://www.moxa.com/product/NPort_6650.htm]]'),
	1648 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6610-32 | http://www.moxa.com/product/NPort_6650.htm]]'),
	1649 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6650-8 | http://www.moxa.com/product/NPort_6650.htm]]'),
	1650 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6650-16 | http://www.moxa.com/product/NPort_6650.htm]]'),
	1651 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6650-32 | http://www.moxa.com/product/NPort_6650.htm]]'),
	1652 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%CN2510-8 | http://www.moxa.com/product/CN2510.htm]]'),
	1653 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%CN2510-16 | http://www.moxa.com/product/CN2510.htm]]'),
	1654 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%CN2610-8 | http://www.moxa.com/product/CN2610.htm]]'),
	1655 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%CN2610-16 | http://www.moxa.com/product/CN2610.htm]]'),
	1656 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%CN2650-8 | http://www.moxa.com/product/CN2610.htm]]'),
	1657 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%CN2650-16 | http://www.moxa.com/product/CN2610.htm]]'),
	1658 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6250 | http://www.moxa.com/product/NPort_6250.htm]]'),
	1659 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort 6450 | http://www.moxa.com/product/NPort_6450.htm]]'),
	1660 => array ('chapter_id' => 36, 'dict_value' => '[[Moxa%GPASS%NPort S8458 | http://www.moxa.com/product/NPort_S8458_Series.htm]]'),
	1665 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL6.x | https://www.scientificlinux.org/]]'),
	1666 => array ('chapter_id' => 13, 'dict_value' => '[[SciLin%GSKIP%SL5.x | https://www.scientificlinux.org/]]'),
	1667 => array ('chapter_id' => 13, 'dict_value' => '[[CentOS%GSKIP%CentOS V6 | http://www.centos.org/]]'),
	1672 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R510'),
	1673 => array ('chapter_id' => 37, 'dict_value' => 'Cisco Aironet IOS 12.3'),
	1674 => array ('chapter_id' => 37, 'dict_value' => 'Cisco Aironet IOS 12.4'),
	1675 => array ('chapter_id' => 14, 'dict_value' => 'Arista EOS 4'),
	1676 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C1100'),
	1677 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C2100'),
	1678 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C5125'),
	1679 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C5220'),
	1680 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C6100'),
	1681 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C6105'),
	1682 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C6145'),
	1683 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge C%GPASS%C6220'),
	1684 => array ('chapter_id' => 31, 'dict_value' => 'Dell PowerEdge C%GPASS%C410x%L1,10V%'),
	1685 => array ('chapter_id' => 31, 'dict_value' => 'Dell PowerEdge C%GPASS%C5000%L1,12V%'),
	1686 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R210'),
	1687 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R310'),
	1688 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R415'),
	1689 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R515'),
	1690 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R620'),
	1691 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R715'),
	1692 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R720'),
	1693 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R720xd'),
	1694 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R810'),
	1695 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R815'),
	1696 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M620'),
	1697 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M710HD'),
	1698 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M915%L2,1%'),
	1699 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect (blade)%GPASS%M6348'),
	1700 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect (blade)%GPASS%M8428'),
	1701 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 16 | http://docs.fedoraproject.org/en-US/Fedora/16/html/Release_Notes/]]'),
	1702 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%8024'),
	1703 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%8024F'),
	1704 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 10.04 LTS'),
	1705 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 10.10'),
	1706 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 11.04'),
	1707 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 11.10'),
	1708 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 12.04 LTS'),
	1709 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 7 (wheezy) | http://debian.org/releases/wheezy/]]'),
	1710 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24TC-L'),
	1711 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2520-24-PoE J9138A'),
	1712 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R210 II'),
	1713 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.6 | http://www.openbsd.org/46.html]]'),
	1714 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.7 | http://www.openbsd.org/47.html]]'),
	1715 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.8 | http://www.openbsd.org/48.html]]'),
	1716 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 4.9 | http://www.openbsd.org/49.html]]'),
	1717 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.0 | http://www.openbsd.org/50.html]]'),
	1718 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.1 | http://www.openbsd.org/51.html]]'),
	1719 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2924M-XL'),
	1720 => array ('chapter_id' => 12, 'dict_value' => 'Allied Telesis%GPASS%AT9924T'),
	1721 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560E-12SD'),
	1722 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7148S'),
	1723 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7124SX'),
	1724 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7148SX'),
	1725 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7124FX'),
	1726 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7048T-A'),
	1727 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050T-64'),
	1728 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050T-52'),
	1729 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050Q-16'),
	1730 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050S-64'),
	1731 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050S-52'),
	1732 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 17 | http://docs.fedoraproject.org/en-US/Fedora/17/html/Release_Notes/]]'),
	1733 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 12.x'),
	1734 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 9.x'),
	1735 => array ('chapter_id' => 31, 'dict_value' => 'Cisco%GPASS%UCS 5108 Blade Chassis%L4,2H%'),
	1736 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B200 M1'),
	1737 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B200 M2'),
	1738 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B200 M3'),
	1739 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B230 M1'),
	1740 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B230 M2'),
	1741 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B250 M1'),
	1742 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B250 M2'),
	1743 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B440 M2'),
	1744 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B420 M3'),
	1745 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B22  M3'),
	1746 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C200 M2'),
	1747 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C210 M2'),
	1748 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C250 M2'),
	1749 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C260 M2'),
	1750 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C460 M2'),
	1751 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C22  M3'),
	1752 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C220 M3'),
	1753 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C24  M3'),
	1754 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M3'),
	1755 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS 6120 Fabric Interconnect'),
	1756 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS 6140 Fabric Interconnect'),
	1757 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS 6248 Fabric Interconnect'),
	1758 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS 6296 Fabric Interconnect'),
	1759 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS XR 4.2'),
	1760 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-EI-24S'),
	1761 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-EI-MC-AC'),
	1762 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-PWR-EI'),
	1763 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-HI'),
	1764 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-PWR-EI'),
	1765 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-48TP-PWR-SI'),
	1766 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-52C-EI'),
	1767 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52P-PWR-LI'),
	1768 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700S-28P-LI'),
	1769 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE5850-48T4S2Q-EI'),
	1770 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S6700-24-EI'),
	1771 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S6700-48-EI'),
	1772 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6850-48S4Q-EI'),
	1773 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6850-48T4Q-EI'),
	1774 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S7703'),
	1775 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S7706'),
	1776 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S7712'),
	1777 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S9703'),
	1778 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S9706'),
	1779 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S9712'),
	1780 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE12804'),
	1781 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE12808'),
	1782 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE12812'),
	1783 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-52'),
	1784 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-24P'),
	1785 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-10'),
	1786 => array ('chapter_id' => 14, 'dict_value' => 'Marvell ROS 1.1'),
	1787 => array ('chapter_id' => 1, 'dict_value' => 'Management interface'),
	1788 => array ('chapter_id' => 38, 'dict_value' => 'Cisco%GPASS%UCS Domain'),
	1789 => array ('chapter_id' => 38, 'dict_value' => 'Generic%GPASS%Switch stack'),
	1790 => array ('chapter_id' => 38, 'dict_value' => 'VMware%GPASS%vSphere instance'),
	1791 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%5524'),
	1792 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%5548'),
	1793 => array ('chapter_id' => 12, 'dict_value' => 'TP-Link%GPASS%TL-SG5426'),
	1794 => array ('chapter_id' => 12, 'dict_value' => 'NETGEAR%GPASS%GSM7352Sv2'),
	1795 => array ('chapter_id' => 25, 'dict_value' => 'Motorola%GPASS%RFS 4000'),
	1796 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2948G-L3'),
	1797 => array ('chapter_id' => 12, 'dict_value' => 'D-Link%GPASS%DGS-1210-10P'),
	1798 => array ('chapter_id' => 12, 'dict_value' => 'D-Link%GPASS%DGS-1210-16'),
	1799 => array ('chapter_id' => 12, 'dict_value' => 'D-Link%GPASS%DGS-1210-24'),
	1800 => array ('chapter_id' => 12, 'dict_value' => 'D-Link%GPASS%DGS-1210-48'),
	1801 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X670-48x'),
	1802 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X670V-48x'),
	1803 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X670V-48t'),
	1804 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560V2-24TS'),
	1805 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560V2-48TS'),
	1806 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560V2-24PS'),
	1807 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560V2-48PS'),
	1808 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560V2-24TS-SD'),
	1809 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 5.2'),
	1810 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5240'),
	1811 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5820'),
	1812 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows Server 2008 R2'),
	1813 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 12.10'),
	1814 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX100 S7 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx100/index.html]]'),
	1815 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX200 S7 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx200/index.html]]'),
	1816 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX300 S6 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx300/index.html]]'),
	1817 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX300 S7 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx300/index.html]]'),
	1818 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX350 S7 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx350/index.html]]'),
	1819 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX500 S7 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx500/index.html]]'),
	1820 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX600 S6 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx600/index.html]]'),
	1821 => array ('chapter_id' => 11, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY RX900 S2 | http://www.fujitsu.com/fts/products/computing/servers/primergy/rack/rx900/index.html]]'),
	1822 => array ('chapter_id' => 31, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY BX400 S1%L1,9V% | http://www.fujitsu.com/fts/products/computing/servers/primergy/blades/bx400/index.html]]'),
	1823 => array ('chapter_id' => 31, 'dict_value' => '[[Fujitsu%GSKIP%PRIMERGY BX900 S2%L2,9V% | http://www.fujitsu.com/fts/products/computing/servers/primergy/blades/bx900s2/index.html]]'),
	1824 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3690 X5 | http://www-03.ibm.com/systems/x/hardware/enterprise/x3690x5/index.html]]'),
	1825 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3850 X5 | http://www-03.ibm.com/systems/x/hardware/enterprise/x3850x5/index.html]]'),
	1826 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3950 X5 | http://www-03.ibm.com/systems/x/hardware/enterprise/x3850x5/index.html]]'),
	1827 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3750 M4 | http://www-03.ibm.com/systems/x/hardware/rack/x3750m4/index.html]]'),
	1828 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3650 M4 | http://www-03.ibm.com/systems/x/hardware/rack/x3650m4/index.html]]'),
	1829 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3630 M4 | http://www-03.ibm.com/systems/x/hardware/rack/x3630m4/index.html]]'),
	1830 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3550 M4 | http://www-03.ibm.com/systems/x/hardware/rack/x3550m4/index.html]]'),
	1831 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3530 M4 | http://www-03.ibm.com/systems/x/hardware/rack/x3530m4/index.html]]'),
	1832 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3250 M4 | http://www-03.ibm.com/systems/x/hardware/rack/x3250m4/index.html]]'),
	1833 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3755 M3 | http://www-03.ibm.com/systems/x/hardware/rack/x3755m3/index.html]]'),
	1834 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3650 M3 | http://www-03.ibm.com/systems/x/hardware/rack/x3650m3/index.html]]'),
	1835 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3630 M3 | http://www-03.ibm.com/systems/x/hardware/rack/x3630m3/index.html]]'),
	1836 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3620 M3 | http://www-03.ibm.com/systems/x/hardware/rack/x3620m3/index.html]]'),
	1837 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3550 M3 | http://www-03.ibm.com/systems/x/hardware/rack/x3550m3/index.html]]'),
	1838 => array ('chapter_id' => 11, 'dict_value' => '[[IBM xSeries%GPASS%x3250 M3 | http://www-03.ibm.com/systems/x/hardware/rack/x3250m3/index.html]]'),
	1839 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent%GPASS%AutoView 3008 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentAutoViewAppliances.aspx]]'),
	1840 => array ('chapter_id' => 21, 'dict_value' => '[[Avocent%GPASS%AutoView 3016 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/DigitalKVMAppliances/Pages/AvocentAutoViewAppliances.aspx]]'),
	1841 => array ('chapter_id' => 23, 'dict_value' => '[[Avocent%GPASS%ECS19PWRUSB | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/LCDConsoleTrays/Pages/AvocentLCDConsoleTray.aspx]]'),
	1842 => array ('chapter_id' => 23, 'dict_value' => '[[Avocent%GPASS%ECS19UWRUSB | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/LCDConsoleTrays/Pages/AvocentLCDConsoleTray.aspx]]'),
	1843 => array ('chapter_id' => 23, 'dict_value' => '[[Avocent%GPASS%ECS17KMMP | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/LCDConsoleTrays/Pages/AvocentLCDConsoleTray.aspx]]'),
	1844 => array ('chapter_id' => 23, 'dict_value' => '[[Avocent%GPASS%ECS17KMM | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/LCDConsoleTrays/Pages/AvocentLCDConsoleTray.aspx]]'),
	1845 => array ('chapter_id' => 23, 'dict_value' => '[[Avocent%GPASS%AP17KMMP | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/LCDConsoleTrays/Pages/AvocentLCDConsoleTray.aspx]]'),
	1846 => array ('chapter_id' => 23, 'dict_value' => '[[Avocent%GPASS%LCD17 | http://www.emersonnetworkpower.com/en-US/Products/InfrastructureManagement/LCDConsoleTrays/Pages/AvocentLCDConsoleTray.aspx]]'),
	1847 => array ('chapter_id' => 21, 'dict_value' => '[[APC%GPASS%AP5201 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP5201]]'),
	1848 => array ('chapter_id' => 21, 'dict_value' => '[[APC%GPASS%AP5202 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP5202]]'),
	1849 => array ('chapter_id' => 35, 'dict_value' => '[[Cisco%GPASS%RPS 2300 | http://www.cisco.com/en/US/products/ps7130/index.html]]'),
	1850 => array ('chapter_id' => 19, 'dict_value' => '[[NEC%GPASS%LL009F | http://www.nec.com/en/global/prod/tapestorage/index_009.html]]'),
	1851 => array ('chapter_id' => 19, 'dict_value' => '[[NEC%GPASS%T30A | http://www.nec.com/en/global/prod/tapestorage/index_t30a.html]]'),
	1852 => array ('chapter_id' => 19, 'dict_value' => '[[NEC%GPASS%T60A | http://www.nec.com/en/global/prod/tapestorage/index_t60a.html]]'),
	1853 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES F16F-R4031 | http://www.infortrend.com/global/products/models/ES%20F16F-R4031]]'),
	1854 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES F16F-R4840 | http://www.infortrend.com/global/products/models/ES%20F16F-R4840]]'),
	1855 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES F16F-S4031 | http://www.infortrend.com/global/products/models/ES%20F16F-S4031]]'),
	1856 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES F16F-S4840 | http://www.infortrend.com/global/products/models/ES%20F16F-S4840]]'),
	1857 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S24F-G1440 | http://www.infortrend.com/global/products/models/ES%20S24F-G1440]]'),
	1858 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S24F-G1840 | http://www.infortrend.com/global/products/models/ES%20S24F-G1840]]'),
	1859 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S24F-R1440 | http://www.infortrend.com/global/products/models/ES%20S24F-R1440]]'),
	1860 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S24F-R1840 | http://www.infortrend.com/global/products/models/ES%20S24F-R1840]]'),
	1861 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S16F-G1840 | http://www.infortrend.com/global/products/models/ES%20S16F-G1840]]'),
	1862 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S16F-R1840 | http://www.infortrend.com/global/products/models/ES%20S16F-R1840]]'),
	1863 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S12F-G1842 | http://www.infortrend.com/global/products/models/ES%20S12F-G1842]]'),
	1864 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S12F-R1840 | http://www.infortrend.com/global/products/models/ES%20S12F-R1840]]'),
	1865 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A08F-G2422 | http://www.infortrend.com/global/products/models/ES%20A08F-G2422]]'),
	1866 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A12F-G2422 | http://www.infortrend.com/global/products/models/ES%20A12F-G2422]]'),
	1867 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A12E-G2121 | http://www.infortrend.com/global/products/models/ES%20A12E-G2121]]'),
	1868 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A08S-C2133 | http://www.infortrend.com/global/products/models/ES%20A08S-C2133]]'),
	1869 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A08S-C2134 | http://www.infortrend.com/global/products/models/ES%20A08S-C2134]]'),
	1870 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A16S-G2130 | http://www.infortrend.com/global/products/models/ES%20A16S-G2130]]'),
	1871 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A08S-G2130 | http://www.infortrend.com/global/products/models/ES%20A08S-G2130]]'),
	1872 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A12S-G2130 | http://www.infortrend.com/global/products/models/ES%20A12S-G2130]]'),
	1873 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S16U-G1440 | http://www.infortrend.com/global/products/models/ES%20S16U-G1440]]'),
	1874 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S12U-G1440 | http://www.infortrend.com/global/products/models/ES%20S12U-G1440]]'),
	1875 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A24U-G2421 | http://www.infortrend.com/global/products/models/ES%20A24U-G2421]]'),
	1876 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A08U-G2421 | http://www.infortrend.com/global/products/models/ES%20A08U-G2421]]'),
	1877 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A12U-G2421 | http://www.infortrend.com/global/products/models/ES%20A12U-G2421]]'),
	1878 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A04U-G2421 | http://www.infortrend.com/global/products/models/ES%20A04U-G2421]]'),
	1879 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES F16F-J4000-R | http://www.infortrend.com/global/products/models/ES%20F16F-J4000-R]]'),
	1880 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES B12S-J1000-R | http://www.infortrend.com/global/products/models/ES%20B12S-J1000-R]]'),
	1881 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES B12S-J1000-S | http://www.infortrend.com/global/products/models/ES%20B12S-J1000-S]]'),
	1882 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES A16F-J2430-G | http://www.infortrend.com/global/products/models/ES%20A16F-J2430-G]]'),
	1883 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S16S-J1000-R1 | http://www.infortrend.com/global/products/models/ES%20S16S-J1000-R1]]'),
	1884 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S16S-J1000-S1 | http://www.infortrend.com/global/products/models/ES%20S16S-J1000-S1]]'),
	1885 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S12S-J1000-G | http://www.infortrend.com/global/products/models/ES%20S12S-J1000-G]]'),
	1886 => array ('chapter_id' => 18, 'dict_value' => '[[Infortrend%GPASS%ES S12S-J1002-R | http://www.infortrend.com/global/products/models/ES%20S12S-J1002-R]]'),
	1887 => array ('chapter_id' => 12, 'dict_value' => '[[IBM%GPASS%RackSwitch G8052 | http://www-03.ibm.com/systems/networking/switches/rack/g8052/]]'),
	1888 => array ('chapter_id' => 12, 'dict_value' => '[[IBM%GPASS%RackSwitch G8264 | http://www-03.ibm.com/systems/networking/switches/rack/g8264/]]'),
	1889 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ICX-6610-48-PE | http://www.brocade.com/products/all/switches/product-details/icx-6610-switch/index.page]]'),
	1890 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ICX-6650-48-E-ADV | http://www.brocade.com/products/all/switches/product-details/icx-6650-switch/index.page]]'),
	1891 => array ('chapter_id' => 12, 'dict_value' => '[[Fortinet%GPASS%Fortigate 3140B| http://www.fortinet.com/products/fortigate/3140B.html]]'),
	1892 => array ('chapter_id' => 12, 'dict_value' => '[[Fortinet%GPASS%Fortigate 300C | http://www.fortinet.com/products/fortigate/300C.html]]'),
	1893 => array ('chapter_id' => 12, 'dict_value' => '[[Fortinet%GPASS%Fortigate 800C | http://www.fortinet.com/products/fortigate/800C.html]]'),
	1894 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24TC-S'),
	1895 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24LT-L'),
	1896 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-48PST-S'),
	1897 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24PC-S'),
	1898 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-24LC-S'),
	1899 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-8TC-S'),
	1900 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960PD-8TT-L'),
	1901 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 15.0'),
	1902 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F48FPS-L'),
	1903 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F48LPS-L'),
	1904 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F24PS-L'),
	1905 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F48TS-L'),
	1906 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F24TS-L'),
	1907 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F48TS-S'),
	1908 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960S-F24TS-S'),
	1909 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-18TP-EI'),
	1910 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-18TP-SI'),
	1911 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-26TP-EI'),
	1912 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-26TP-PWR-EI'),
	1913 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-26TP-SI'),
	1914 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-52P-EI'),
	1915 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-52P-PWR-EI'),
	1916 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-9TP-EI'),
	1917 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-9TP-PWR-EI'),
	1918 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2700-9TP-SI'),
	1919 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2710-52P-PWR-SI'),
	1920 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S2710-52P-SI'),
	1921 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-26C-HI'),
	1922 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-EI'),
	1923 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-EI-MC'),
	1924 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-PWR-SI'),
	1925 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-28TP-SI'),
	1926 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-52P-EI'),
	1927 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-52P-EI-24S'),
	1928 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-52P-EI-48S'),
	1929 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-52P-PWR-EI'),
	1930 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-52P-PWR-SI'),
	1931 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S3700-52P-SI'),
	1932 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-10P-LI'),
	1933 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-10P-PWR-LI'),
	1934 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-24TP-PWR-SI'),
	1935 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-24TP-SI'),
	1936 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-26X-SI-12S'),
	1937 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-EI'),
	1938 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-EI-24S'),
	1939 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-HI-24S'),
	1940 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-PWR-SI'),
	1941 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28C-SI'),
	1942 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28P-LI'),
	1943 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28P-PWR-LI'),
	1944 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28X-LI'),
	1945 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28X-PWR-LI'),
	1946 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-48TP-SI'),
	1947 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52C-EI'),
	1948 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52C-PWR-EI'),
	1949 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52C-PWR-SI'),
	1950 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52C-SI'),
	1951 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52P-LI'),
	1952 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52X-LI'),
	1953 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52X-PWR-LI'),
	1954 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700S-52P-LI'),
	1955 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-28C-EI'),
	1956 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-28C-LI'),
	1957 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-28C-PWR-EI'),
	1958 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-28C-PWR-LI'),
	1959 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-52C-LI'),
	1960 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-52C-PWR-EI'),
	1961 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5710-52C-PWR-LI'),
	1962 => array ('chapter_id' => 12, 'dict_value' => 'Force10%GPASS%S4820T'),
	1963 => array ('chapter_id' => 16, 'dict_value' => 'Cisco IOS 15.1'),
	1964 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1041N'),
	1965 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-AP1042N'),
	1966 => array ('chapter_id' => 12, 'dict_value' => 'Linksys%GPASS%SRW224G4'),
	1967 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2520-8-PoE J9137A'),
	1968 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%K6%L3,2H%'),
	1969 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%K10%L5,2H%'),
	1970 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%SSA130'),
	1971 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%SSA150'),
	1972 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%SSA180'),
	1973 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%S1%L1,1H%'),
	1974 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%S3%L3,1H%'),
	1975 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%S4%L4,1H%'),
	1976 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%S6%L6,1H%'),
	1977 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%S8%L8,1H%'),
	1978 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%A4H124-24'),
	1979 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%A4H124-24P'),
	1980 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%A4H124-24FX'),
	1981 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%A4H124-48'),
	1982 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%A4H124-48P'),
	1983 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%A4H254-8F8T'),
	1984 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5G124-24'),
	1985 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5G124-24P2'),
	1986 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5G124-48'),
	1987 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5G124-48P2'),
	1988 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5K125-24'),
	1989 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5K125-24P2'),
	1990 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5K125-48'),
	1991 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%B5K125-48P2'),
	1992 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5G124-24'),
	1993 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5G124-24P2'),
	1994 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5G124-48'),
	1995 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5G124-48P2'),
	1996 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5K125-24'),
	1997 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5K125-24P2'),
	1998 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5K125-48'),
	1999 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5K125-48P2'),
	2000 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%C5K175-24'),
	2001 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%7124-24'),
	2002 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%7124-24T'),
	2003 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%7124-48'),
	2004 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%7124-48T'),
	2005 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08G20G2-08'),
	2006 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08G20G2-08P'),
	2007 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08G20G4-24'),
	2008 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08G20G4-24P'),
	2009 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08G20G4-48'),
	2010 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08G20G4-48P'),
	2011 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08H20G4-24'),
	2012 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08H20G4-24P'),
	2013 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08H20G4-48'),
	2014 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%08H20G4-48P'),
	2015 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%D2G124-12'),
	2016 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%D2G124-12P'),
	2017 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%G3G124-24'),
	2018 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%G3G124-24P'),
	2019 => array ('chapter_id' => 12, 'dict_value' => 'Enterasys%GPASS%G3G170-24'),
	2020 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%N1%L1,1H%'),
	2021 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%N3%L3,1H%'),
	2022 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%N5%L5,1H%'),
	2023 => array ('chapter_id' => 30, 'dict_value' => 'Enterasys%GPASS%N7%L1,7V%'),
	2024 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%877'),
	2025 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%878'),
	2026 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst 4948E | http://www.cisco.com/en/US/products/ps10947/index.html]]'),
	2027 => array ('chapter_id' => 14, 'dict_value' => 'Huawei VRP 8.5'),
	2028 => array ('chapter_id' => 14, 'dict_value' => 'Cisco NX-OS 6.1'),
	2029 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst C2960CG-8TC-L | http://www.cisco.com/en/US/products/ps6406/index.html]]'),
	2030 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME-3400EG-2CS-A'),
	2031 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M520'),
	2032 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M820%L2,1%'),
	2033 => array ('chapter_id' => 30, 'dict_value' => 'F5%GPASS%VIPRION 4480%L4,1H%'),
	2034 => array ('chapter_id' => 30, 'dict_value' => 'F5%GPASS%VIPRION 4800%L1,8V%'),
	2035 => array ('chapter_id' => 12, 'dict_value' => 'F5 (blade)%GPASS%VIPRION 2100'),
	2036 => array ('chapter_id' => 12, 'dict_value' => 'F5 (blade)%GPASS%VIPRION 4200'),
	2037 => array ('chapter_id' => 12, 'dict_value' => 'F5 (blade)%GPASS%VIPRION 4300'),
	2038 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Catalyst WS-CBS3012-IBM/-I | http://www.cisco.com/en/US/products/ps8766/index.html]]'),
	2039 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB1000U'),
	2040 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB1100'),
	2041 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB1100Hx2'),
	2042 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB1100AH'),
	2043 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB1100AHx2'),
	2044 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB1200'),
	2045 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB2011L-RM'),
	2046 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB2011iL-RM'),
	2047 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%RB2011UAS-RM'),
	2048 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1016-12G'),
	2049 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1036-8G-2S+'),
	2050 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1036-12G-4S'),
	2051 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7150S-24'),
	2052 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7150S-52'),
	2053 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7150S-64'),
	2054 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7100S'),
	2055 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050T-36'),
	2056 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050QX-32'),
	2057 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050SX-128'),
	2058 => array ('chapter_id' => 12, 'dict_value' => '[[TP-Link%GPASS%TL-SL5428E | http://www.tp-link.com/en/products/details/?model=TL-SL5428E]]'),
	2059 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3560CG-8PC-S'),
	2060 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 18 | http://docs.fedoraproject.org/en-US/Fedora/18/html/Release_Notes/]]'),
	2061 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 19 | http://docs.fedoraproject.org/en-US/Fedora/19/html/Release_Notes/]]'),
	2062 => array ('chapter_id' => 12, 'dict_value' => 'MikroTik%GPASS%CRS125-24G-1S-RM'),
	2063 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows Server 2012'),
	2064 => array ('chapter_id' => 13, 'dict_value' => 'MicroSoft%GSKIP%Windows Server 2012 R2'),
	2065 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X770'),
	2066 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7504'),
	2067 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7508'),
	2068 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7304'),
	2069 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7308'),
	2070 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7316'),
	2071 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7250QX-64'),
	2072 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1012'),
	2073 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1016'),
	2074 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1024'),
	2075 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1035'),
	2076 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1036'),
	2077 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5248'),
	2078 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-3290'),
	2079 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-3295'),
	2080 => array ('chapter_id' => 14, 'dict_value' => 'Huawei VRP 5.11'),
	2081 => array ('chapter_id' => 14, 'dict_value' => 'Huawei VRP 5.12'),
	2082 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 15.1'),
	2083 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%ASR 9001 | http://cisco.com/en/US/products/ps12074/index.html]]'),
	2084 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%ASR 9922 | http://cisco.com/en/US/products/ps11755/index.html]]'),
	2085 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 6001 | http://www.cisco.com/en/US/products/ps12869/index.html]]'),
	2086 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 6004 | http://www.cisco.com/en/US/products/ps12807/index.html]]'),
	2087 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE5810-48T4S-EI'),
	2088 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE5810-24T4S-EI'),
	2089 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-3780'),
	2090 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-3922'),
	2091 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF302-08MP'),
	2092 => array ('chapter_id' => 12, 'dict_value' => '3Com%GPASS%4510G 24-port'),
	2093 => array ('chapter_id' => 12, 'dict_value' => 'Linksys%GPASS%SRW248G4'),
	2094 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 1924'),
	2095 => array ('chapter_id' => 12, 'dict_value' => 'Allied Telesis%GPASS%AT-GS950/24'),
	2096 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2910-24G-PoE J9146A'),
	2097 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%8132'),
	2098 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%8132F'),
	2099 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%8164'),
	2100 => array ('chapter_id' => 12, 'dict_value' => 'Dell PowerConnect%GPASS%8164F'),
	2101 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.2 | http://www.openbsd.org/52.html]]'),
	2102 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.3 | http://www.openbsd.org/53.html]]'),
	2103 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.4 | http://www.openbsd.org/54.html]]'),
	2104 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 10.x'),
	2105 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 5.1'),
	2106 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 5.5'),
	2107 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 13.04'),
	2108 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 13.10'),
	2109 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 14.04 LTS'),
	2110 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48FPD-L'),
	2111 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48LPD-L'),
	2112 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-24PD-L'),
	2113 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48TD-L'),
	2114 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-24TD-L'),
	2115 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48FPS-L'),
	2116 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48LPS-L'),
	2117 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-24PS-L'),
	2118 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-24PSQ-L'),
	2119 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48TS-L'),
	2120 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-24TS-L'),
	2121 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-48TS-LL'),
	2122 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960X-24TS-LL'),
	2123 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-48FPD-I'),
	2124 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-48LPD-I'),
	2125 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-24PD-I'),
	2126 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-48TD-I'),
	2127 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-24TD-I'),
	2128 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-48FPS-I'),
	2129 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-48LPS-I'),
	2130 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-24PS-I'),
	2131 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-48TS-I'),
	2132 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960XR-24TS-I'),
	2133 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 48PST-L'),
	2134 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 24PC-L'),
	2135 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 24LC-L'),
	2136 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 48TC-L'),
	2137 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 24TC-L'),
	2138 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 48PST-S'),
	2139 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 24PC-S'),
	2140 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 24LC-S'),
	2141 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 24TC-S'),
	2142 => array ('chapter_id' => 14, 'dict_value' => 'Cisco IOS 15.2'),
	2143 => array ('chapter_id' => 13, 'dict_value' => 'Red Hat Enterprise%GSKIP%RHEL V7'),
	2144 => array ('chapter_id' => 38, 'dict_value' => 'Cisco%GPASS%Wireless Controller'),
	2145 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-3297'),
	2146 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-3930'),
	2147 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R420'),
	2148 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-24PX | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	2149 => array ('chapter_id' => 12, 'dict_value' => '[[Juniper%GPASS%EX4200-48PX | http://www.juniper.net/products_and_services/ex_series/index.html]]'),
	2150 => array ('chapter_id' => 25, 'dict_value' => 'Cisco%GPASS%AIR-LAP1142N'),
	2151 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 11'),
	2152 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 12'),
	2153 => array ('chapter_id' => 9999, 'dict_value' => '[[Alcatel-Lucent%GPASS%1642 EMC | http://www.alcatel-lucent.com/products/1642-edge-multiplexer-compact]]'),
	2154 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%Z9000'),
	2155 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%Z9500'),
	2156 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N4032'),
	2157 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N4032F'),
	2158 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N4064'),
	2159 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N4064F'),
	2160 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N3024'),
	2161 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N3024F'),
	2162 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N3024P'),
	2163 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N3048'),
	2164 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N3048P'),
	2165 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N2024'),
	2166 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N2024P'),
	2167 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N2048'),
	2168 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%N2048P'),
	2169 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5220F-24T2XW'),
	2170 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5220F-20S2XW'),
	2171 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5459-48GT-4X2Q'),
	2172 => array ('chapter_id' => 12, 'dict_value' => 'NEC%GPASS%PF5459-48XP-4Q'),
	2173 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1009-8G-1S'),
	2174 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1009-8G-1S-1S+'),
	2175 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1016-12S-1S+'),
	2176 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%1910-24G'),
	2177 => array ('chapter_id' => 13, 'dict_value' => '[[Univention%GSKIP%Univention Corporate Server 3.2 (borgfeld) | http://docs.univention.de/release-notes-3.2-2-de.html]]'),
	2178 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP8941 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP8941]]'),
	2179 => array ('chapter_id' => 27, 'dict_value' => '[[APC%GPASS%AP8959EU3 | http://www.apc.com/products/resource/include/techspec_index.cfm?base_sku=AP8959EU3]]'),
	2180 => array ('chapter_id' => 13, 'dict_value' => '[[PROXMOX%GSKIP%Proxmox VE 3.0 | http://pve.proxmox.com/wiki/Roadmap#Proxmox_VE_3.0]]'),
	2181 => array ('chapter_id' => 13, 'dict_value' => '[[PROXMOX%GSKIP%Proxmox VE 3.1 | http://pve.proxmox.com/wiki/Roadmap#Proxmox_VE_3.1]]'),
	2182 => array ('chapter_id' => 13, 'dict_value' => '[[PROXMOX%GSKIP%Proxmox VE 3.2 | http://pve.proxmox.com/wiki/Roadmap#Proxmox_VE_3.2]]'),
	2183 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5512-X'),
	2184 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5515-X'),
	2185 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5525-X'),
	2186 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5545-X'),
	2187 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5555-X'),
	2188 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASA 5585-X'),
	2189 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-24T'),
	2190 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-48T'),
	2191 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 2000S | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2192 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 2200S | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2193 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 3900 | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2194 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 4000S | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2195 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 4200V | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2196 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 5000S | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2197 => array ('chapter_id' => 12, 'dict_value' => '[[F5%GPASS%BIG-IP 5200V | http://www.f5.com/pdf/products/big-ip-platforms-datasheet.pdf]]'),
	2198 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXII-108'),
	2199 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXII-116'),
	2200 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXII-132'),
	2201 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-108'),
	2202 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-116'),
	2203 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-132'),
	2204 => array ('chapter_id' => 23, 'dict_value' => 'Dell%GPASS%18.5in LED KMM'),
	2205 => array ('chapter_id' => 36, 'dict_value' => 'Raritan%GPASS%Dominion SX4'),
	2206 => array ('chapter_id' => 36, 'dict_value' => 'Raritan%GPASS%Dominion SX8'),
	2207 => array ('chapter_id' => 36, 'dict_value' => 'Raritan%GPASS%Dominion SXA-8'),
	2208 => array ('chapter_id' => 36, 'dict_value' => 'Raritan%GPASS%Dominion SXA-16'),
	2209 => array ('chapter_id' => 36, 'dict_value' => 'Raritan%GPASS%Dominion SXA-16-DL'),
	2210 => array ('chapter_id' => 36, 'dict_value' => 'Raritan%GPASS%Dominion SXA-16-DLM'),
	2211 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%CGS-2520-24TC'),
	2212 => array ('chapter_id' => 12, 'dict_value' => 'Linksys%GPASS%SRW2024P'),
	2213 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%2920-48G J9728A'),
	2214 => array ('chapter_id' => 12, 'dict_value' => '[[Edge-Core%GPASS%AS6700-32X | http://www.edge-core.com/ProdDtl.asp?sno=435&AS6700-32X%20with%20ONIE]]'),
	2215 => array ('chapter_id' => 12, 'dict_value' => '[[Edge-Core%GPASS%AS6701-32X | http://www.edge-core.com/ProdDtl.asp?sno=435&AS6700-32X%20with%20ONIE]]'),
	2216 => array ('chapter_id' => 12, 'dict_value' => '[[Edge-Core%GPASS%AS5610-52X | http://www.edge-core.com/ProdDtl.asp?sno=436&AS5610-52X%20with%20ONIE]]'),
	2217 => array ('chapter_id' => 12, 'dict_value' => '[[Edge-Core%GPASS%AS5600-52X | http://www.edge-core.com/ProdDtl.asp?sno=423&AS5600-52X%20with%20ONIE]]'),
	2218 => array ('chapter_id' => 12, 'dict_value' => '[[Edge-Core%GPASS%AS4600-54T | http://www.edge-core.com/ProdDtl.asp?sno=425&AS4600-54T%20with%20ONIE]]'),
	2219 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 2960-Plus 48TC-S'),
	2220 => array ('chapter_id' => 31, 'dict_value' => 'Cisco%GPASS%UCS 5108 AC2 Blade Chassis%L4,2H%'),
	2221 => array ('chapter_id' => 31, 'dict_value' => 'Cisco%GPASS%UCS 5108 DC2 Blade Chassis%L4,2H%'),
	2222 => array ('chapter_id' => 31, 'dict_value' => 'Cisco%GPASS%UCS 5108 HVDC Blade Chassis%L4,2H%'),
	2223 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B260 M4'),
	2224 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B460 M4'),
	2225 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B200 M4'),
	2226 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE7850-32Q-EI'),
	2227 => array ('chapter_id' => 30, 'dict_value' => 'Cisco%GPASS%Catalyst 6807-XL%L7,1H%'),
	2228 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%VS-S2T-10G'),
	2229 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%VS-S2T-10G-XL'),
	2230 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6908-10G-2T'),
	2231 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6908-10G-2TXL'),
	2232 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6904-40G-2T'),
	2233 => array ('chapter_id' => 12, 'dict_value' => 'Cisco (blade)%GPASS%WS-X6904-40G-2TXL'),
	2234 => array ('chapter_id' => 13, 'dict_value' => '[[PROXMOX%GSKIP%Proxmox VE 3.3 | http://pve.proxmox.com/wiki/Roadmap#Proxmox_VE_3.3]]'),
	2235 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 9504 | http://www.cisco.com/c/en/us/products/switches/nexus-9504-switch/index.html]]'),
	2236 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 9508 | http://www.cisco.com/c/en/us/products/switches/nexus-9508-switch/index.html]]'),
	2237 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 9516 | http://www.cisco.com/c/en/us/products/switches/nexus-9516-switch/index.html]]'),
	2238 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%1910-48G'),
	2239 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ICX-6430-48 | http://www.brocade.com/products/all/switches/product-details/icx-6430-and-6450-switches/index.page]]'),
	2240 => array ('chapter_id' => 12, 'dict_value' => '[[Brocade%GPASS%ICX-6450-48 | http://www.brocade.com/products/all/switches/product-details/icx-6430-and-6450-switches/index.page]]'),
	2241 => array ('chapter_id' => 12, 'dict_value' => '[[IBM%GPASS%RackSwitch G8000 | http://www-03.ibm.com/systems/networking/switches/rack/g8000/]]'),
	2242 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%1810G-24'),
	2243 => array ('chapter_id' => 17, 'dict_value' => 'Huawei%GPASS%NE20E-S4'),
	2244 => array ('chapter_id' => 17, 'dict_value' => 'Huawei%GPASS%NE20E-S8'),
	2245 => array ('chapter_id' => 17, 'dict_value' => 'Huawei%GPASS%NE20E-S16'),
	2246 => array ('chapter_id' => 17, 'dict_value' => 'Huawei%GPASS%NE40E-X3'),
	2247 => array ('chapter_id' => 17, 'dict_value' => 'Huawei%GPASS%NE40E-X8'),
	2248 => array ('chapter_id' => 17, 'dict_value' => 'Huawei%GPASS%NE40E-X16'),
	2249 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX5 | http://www.juniper.net/products-services/routing/mx-series/mx5]]'),
	2250 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX10 | http://www.juniper.net/products-services/routing/mx-series/mx10]]'),
	2251 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX40 | http://www.juniper.net/products-services/routing/mx-series/mx40]]'),
	2252 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX104 | http://www.juniper.net/products-services/routing/mx-series/mx104]]'),
	2253 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX2010 | http://www.juniper.net/products-services/routing/mx-series/mx2010]]'),
	2254 => array ('chapter_id' => 17, 'dict_value' => '[[Juniper%GPASS%MX2020 | http://www.juniper.net/products-services/routing/mx-series/mx2020]]'),
	2255 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7280SE-64'),
	2256 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7280SE-68'),
	2257 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7280SE-72'),
	2258 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050SX-64'),
	2259 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050SX-72'),
	2260 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050SX-96'),
	2261 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050TX-48'),
	2262 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050TX-64'),
	2263 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050TX-72'),
	2264 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050TX-96'),
	2265 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050TX-128'),
	2266 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7050QX-32S'),
	2267 => array ('chapter_id' => 12, 'dict_value' => 'Arista%GPASS%7010T-48'),
	2268 => array ('chapter_id' => 13, 'dict_value' => 'RH Fedora%GSKIP%Fedora 20'),
	2269 => array ('chapter_id' => 13, 'dict_value' => 'OpenSUSE%GSKIP%openSUSE 13.x'),
	2270 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%892'),
	2271 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%891'),
	2272 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%888'),
	2273 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%887V'),
	2274 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%887VA'),
	2275 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%887VA-W'),
	2276 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%886VA'),
	2277 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%886VA-W'),
	2278 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%881'),
	2279 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%880 3G'),
	2280 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%880G'),
	2281 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%867VAE'),
	2282 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%866VAE'),
	2283 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%861'),
	2284 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%819'),
	2285 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%812 CiFi'),
	2286 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%800M'),
	2287 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%C892FSP'),
	2288 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%C881W'),
	2289 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-5101'),
	2290 => array ('chapter_id' => 12, 'dict_value' => 'Pica8%GPASS%P-5401'),
	2291 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%S5000'),
	2292 => array ('chapter_id' => 12, 'dict_value' => 'Dell%GPASS%S6000'),
	2293 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X430-8p'),
	2294 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X430-24p'),
	2295 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X430-24t'),
	2296 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X430-48t'),
	2297 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-8t'),
	2298 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-8p'),
	2299 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24t'),
	2300 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24tDC'),
	2301 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24p'),
	2302 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24x'),
	2303 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-48t'),
	2304 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-48tDC'),
	2305 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-48p'),
	2306 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24t-10G'),
	2307 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24p-10G'),
	2308 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X440-24x-10G'),
	2309 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-24t'),
	2310 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-48t'),
	2311 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-24x'),
	2312 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-48x'),
	2313 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-24p'),
	2314 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-48p'),
	2315 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-24t-10GE4'),
	2316 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-48t-10GE4'),
	2317 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-24x-10GE4'),
	2318 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-48x-10GE4'),
	2319 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-24p-10GE4'),
	2320 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-48p-10GE4'),
	2321 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-24t-GE4'),
	2322 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-48t-GE4'),
	2323 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-24p-GE4'),
	2324 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X460-G2-48p-GE4'),
	2325 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X670-G2-48x-4q'),
	2326 => array ('chapter_id' => 12, 'dict_value' => 'Extreme Networks%GPASS%Summit X670-G2-72x'),
	2327 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3548 | http://www.cisco.com/c/en/us/products/switches/nexus-3548-switch/index.html]]'),
	2328 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3524 | http://www.cisco.com/c/en/us/products/switches/nexus-3524-switch/index.html]]'),
	2329 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3172 | http://www.cisco.com/c/en/us/products/switches/nexus-3172-switch/index.html]]'),
	2330 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3164Q | http://www.cisco.com/c/en/us/products/switches/nexus-3164q-switch/index.html]]'),
	2331 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3132Q | http://www.cisco.com/c/en/us/products/switches/nexus-3132q-switch/index.html]]'),
	2332 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3064 | http://www.cisco.com/c/en/us/products/switches/nexus-3064-switch/index.html]]'),
	2333 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3048 | http://www.cisco.com/c/en/us/products/switches/nexus-3048-switch/index.html]]'),
	2334 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 3016 | http://www.cisco.com/c/en/us/products/switches/nexus-3016-switch/index.html]]'),
	2335 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-50'),
	2336 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-50P'),
	2337 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-50FP'),
	2338 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-26'),
	2339 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-26P'),
	2340 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-26FP'),
	2341 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-18'),
	2342 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-10FP'),
	2343 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-08'),
	2344 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG200-08P'),
	2345 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF200-24'),
	2346 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF200-24P'),
	2347 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF200-24FP'),
	2348 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF200-48'),
	2349 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF200-48P'),
	2350 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG220-50P'),
	2351 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG220-50'),
	2352 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG220-26P'),
	2353 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG220-26'),
	2354 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF220-48P'),
	2355 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF220-48'),
	2356 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF220-24P'),
	2357 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF220-24'),
	2358 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF302-08PP'),
	2359 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF302-08MPP'),
	2360 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-10PP'),
	2361 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-10MPP'),
	2362 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-24PP'),
	2363 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-48PP'),
	2364 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-28PP'),
	2365 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-08'),
	2366 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-48P'),
	2367 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-10MP'),
	2368 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-10P'),
	2369 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-28P'),
	2370 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-28'),
	2371 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-20'),
	2372 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF302-08P'),
	2373 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-24'),
	2374 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF302-08'),
	2375 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF300-24MP'),
	2376 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-10SFP'),
	2377 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-28MP'),
	2378 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-52P'),
	2379 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG300-52MP'),
	2380 => array ('chapter_id' => 13, 'dict_value' => 'SUSE Enterprise%GSKIP%SLES12'),
	2381 => array ('chapter_id' => 12, 'dict_value' => 'MikroTik%GPASS%CRS226-24G-2S+RM'),
	2382 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE5850-48T4S2Q-HI'),
	2384 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL120'),
	2385 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge (blade)%GPASS%M630'),
	2386 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R430'),
	2387 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R530'),
	2388 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R630'),
	2389 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R730'),
	2390 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R730xd'),
	2391 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3210'),
	2392 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3220'),
	2393 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3240'),
	2394 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS3270'),
	2395 => array ('chapter_id' => 12, 'dict_value' => 'Juniper%GPASS%EX2200-24P-4G'),
	2396 => array ('chapter_id' => 12, 'dict_value' => 'HP ProCurve%GPASS%E2620-24-PoE J9625A'),
	2397 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 13'),
	2398 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 14'),
	2399 => array ('chapter_id' => 14, 'dict_value' => 'JunOS 15'),
	2400 => array ('chapter_id' => 16, 'dict_value' => 'JunOS 13'),
	2401 => array ('chapter_id' => 16, 'dict_value' => 'JunOS 14'),
	2402 => array ('chapter_id' => 16, 'dict_value' => 'JunOS 15'),
	2403 => array ('chapter_id' => 13, 'dict_value' => 'SUSE Enterprise%GSKIP%SLES9'),
	2404 => array ('chapter_id' => 13, 'dict_value' => '[[CentOS%GSKIP%CentOS V7 | http://www.centos.org/]]'),
	2405 => array ('chapter_id' => 13, 'dict_value' => '[[Debian%GSKIP%Debian 8 (Jessie) | http://debian.org/releases/jessie/]]'),
	2406 => array ('chapter_id' => 13, 'dict_value' => '[[Gentoo%GSKIP%Gentoo | http://gentoo.org]]'),
	2407 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF500-24'),
	2408 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF500-24P'),
	2409 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF500-24MP'),
	2410 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF500-48'),
	2411 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF500-48P'),
	2412 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SF500-48MP'),
	2413 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500-28'),
	2414 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500-28P'),
	2415 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500-28MPP'),
	2416 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500-52'),
	2417 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500-52P'),
	2418 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500-52MP'),
	2419 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500X-24'),
	2420 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500X-24P'),
	2421 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500X-24MPP'),
	2422 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500X-48'),
	2423 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500X-48P'),
	2424 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500X-48MP'),
	2425 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%SG500XG-8F8T'),
	2426 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9332PQ'),
	2427 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9372PX'),
	2428 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9372PX-E'),
	2429 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9372TX'),
	2430 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9372TX-E'),
	2431 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9396PX'),
	2432 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 9396TX'),
	2433 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 93120TX'),
	2434 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Nexus 93128TX'),
	2435 => array ('chapter_id' => 11, 'dict_value' => 'Dell PowerEdge%GPASS%R220'),
	2436 => array ('chapter_id' => 18, 'dict_value' => 'EMC VNXe1600'),
	2437 => array ('chapter_id' => 18, 'dict_value' => 'EMC VNXe3200'),
	2438 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-200'),
	2439 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-500'),
	2440 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-3020'),
	2441 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-3050'),
	2442 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-3060'),
	2443 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-5020'),
	2444 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-5050'),
	2445 => array ('chapter_id' => 24, 'dict_value' => 'Palo Alto Networks%GPASS%PA-5060'),
	2446 => array ('chapter_id' => 13, 'dict_value' => 'VMWare Hypervisor%GSKIP%VMware ESXi 6.0'),
	2447 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-216'),
	2448 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-232'),
	2449 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-416'),
	2450 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-432'),
	2451 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-464'),
	2452 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-808'),
	2453 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-832'),
	2454 => array ('chapter_id' => 21, 'dict_value' => 'Raritan%GPASS%Dominion KXIII-864'),
	2455 => array ('chapter_id' => 21, 'dict_value' => 'TrippLite%GPASS%B051-000'),
	2456 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS2220'),
	2457 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS2240-2'),
	2458 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS2240-4'),
	2459 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS2520'),
	2460 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS2552'),
	2461 => array ('chapter_id' => 18, 'dict_value' => 'NetApp%GPASS%FAS2554'),
	2462 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-24G-4SFP+ (JG932A)'),
	2463 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-24G-SFP-4SFP+ (JG933A)'),
	2464 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-48G-4SFP+ (JG934A)'),
	2465 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-24G-PoE+-4SFP+ (JG936A)'),
	2466 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-48G-PoE+-4SFP+ (JG937A)'),
	2467 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-24G-2SFP+-2XGT (JG938A)'),
	2468 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-48G-2SFP+-2XGT (JG939A)'),
	2469 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-24G-PoE+-2SFP+-2XGT (JG940A)'),
	2470 => array ('chapter_id' => 12, 'dict_value' => 'HP EI%GPASS%5130-48G-PoE+-2SFP+-2XGT (JG941A)'),
	2471 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%CCR1072-1G-8S+'),
	2472 => array ('chapter_id' => 17, 'dict_value' => 'MikroTik%GPASS%3011UiAS-RM'),
	2473 => array ('chapter_id' => 16, 'dict_value' => 'OpenWrt 14'),
	2474 => array ('chapter_id' => 16, 'dict_value' => 'OpenWrt 15'),
	2475 => array ('chapter_id' => 16, 'dict_value' => 'RouterOS 6'),
	2476 => array ('chapter_id' => 37, 'dict_value' => 'OpenWrt 14'),
	2477 => array ('chapter_id' => 37, 'dict_value' => 'OpenWrt 15'),
	2478 => array ('chapter_id' => 37, 'dict_value' => 'RouterOS 6'),
	2479 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 7702 | http://www.cisco.com/c/en/us/products/switches/nexus-7700-2-slot-switch/index.html]]'),
	2480 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 7706 | http://www.cisco.com/c/en/us/products/switches/nexus-7700-6-slot-switch/index.html]]'),
	2481 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 7710 | http://www.cisco.com/c/en/us/products/switches/nexus-7700-10-slot-switch/index.html]]'),
	2482 => array ('chapter_id' => 12, 'dict_value' => '[[Cisco%GPASS%Nexus 7718 | http://www.cisco.com/c/en/us/products/switches/nexus-7700-18-slot-switch/index.html]]'),
	2483 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28X-LI-24S'),
	2484 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28P-LI-24S'),
	2485 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-52X-LI-48CS'),
	2486 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5701-28X-LI'),
	2487 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5701-28X-LI-24S'),
	2488 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28TP-LI'),
	2489 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5700-28TP-PWR-LI'),
	2490 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5701-28TP-PWR-LI'),
	2491 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-32P-EI'),
	2492 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-32X-EI'),
	2493 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-32X-EI-24S'),
	2494 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-36C-EI'),
	2495 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-36C-PWR-EI'),
	2496 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-36PC-EI'),
	2497 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-36C-EI-28S'),
	2498 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-50X-EI'),
	2499 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-50X-EI-46S'),
	2500 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-52X-EI'),
	2501 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-52P-EI'),
	2502 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-56C-EI-48S'),
	2503 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-56C-EI'),
	2504 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-56PC-EI'),
	2505 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S5720-56C-PWR-EI'),
	2506 => array ('chapter_id' => 12, 'dict_value' => 'Juniper%GPASS%QFX10000'),
	2507 => array ('chapter_id' => 12, 'dict_value' => 'Juniper%GPASS%QFX5200'),
	2508 => array ('chapter_id' => 12, 'dict_value' => 'Juniper%GPASS%QFX5100'),
	2509 => array ('chapter_id' => 12, 'dict_value' => 'Juniper%GPASS%QFX3600'),
	2510 => array ('chapter_id' => 12, 'dict_value' => 'Juniper%GPASS%QFX3500'),
	2511 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SB7800'),
	2512 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SB7890'),
	2513 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SB7700'),
	2514 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SB7790'),
	2515 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%CS7500'),
	2516 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%CS7510'),
	2517 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%CS7520'),
	2518 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6710'),
	2519 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6005'),
	2520 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6012'),
	2521 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6015'),
	2522 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6018'),
	2523 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6025'),
	2524 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6036'),
	2525 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6506'),
	2526 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6512'),
	2527 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6518'),
	2528 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX6536'),
	2529 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1710'),
	2530 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1410'),
	2531 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SX1024(52)'),
	2532 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SN2700'),
	2533 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SN2410'),
	2534 => array ('chapter_id' => 12, 'dict_value' => 'Mellanox%GPASS%SN2100'),
	2535 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%XM2'),
	2536 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%XM12'),
	2537 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%XG12'),
	2538 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%XGS2'),
	2539 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%XGS12-HS'),
	2540 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%XGS12-SD'),
	2541 => array ('chapter_id' => 30, 'dict_value' => 'Ixia%GPASS%400Tv2'),
	2542 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-P02'),
	2543 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-P02S'),
	2544 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-LB9A'),
	2545 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-LB9'),
	2546 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-LY4A'),
	2547 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-LY4B'),
	2548 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T1048-LY4C'),
	2549 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T3048-LY9'),
	2550 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T3048-LY8'),
	2551 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T3040-LY3'),
	2552 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T3048-LY2R'),
	2553 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T3048-LY2'),
	2554 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T3064-LY1R'),
	2555 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T5032-LY6'),
	2556 => array ('chapter_id' => 12, 'dict_value' => 'Quanta%GPASS%T5016-LB8D'),
	2557 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE8860-4C-EI'),
	2558 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B420 M4'),
	2559 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS B440 M1'),
	2560 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 15.10'),
	2561 => array ('chapter_id' => 13, 'dict_value' => 'Ubuntu%GSKIP%Ubuntu 16.04 LTS'),
	2562 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C22  M3(LFF)'),
	2563 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C220 M3(LFF)'),
	2564 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C24  M3(LFF)'),
	2565 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M3(16 drive)'),
	2566 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C220 M4'),
	2567 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C220 M4(LFF)'),
	2568 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M4'),
	2569 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M4(16 drive)'),
	2570 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M4(LFF)'),
	2571 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M4S'),
	2572 => array ('chapter_id' => 13, 'dict_value' => 'Solaris%GSKIP%Solaris 11'),
	2573 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C420 M3'),
	2574 => array ('chapter_id' => 24, 'dict_value' => 'Cisco%GPASS%ASR 920'),
	2575 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C460 M4'),
	2576 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS-Mini 6324 Fabric Interconnect'),
	2577 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS 6332 Fabric Interconnect'),
	2578 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%UCS 6332-16UP Fabric Interconnect'),
	2579 => array ('chapter_id' => 11, 'dict_value' => 'Cisco%GPASS%UCS C240 M3(LFF)'),
	2580 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%1905 | http://www.cisco.com/c/en/us/products/routers/1905-serial-integrated-services-router-isr/index.html]]'),
	2581 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%1921 | http://www.cisco.com/c/en/us/products/routers/1921-integrated-services-router-isr/index.html]]'),
	2582 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%1941 | http://www.cisco.com/c/en/us/products/routers/1941-integrated-services-router-isr/index.html]]'),
	2583 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%1941W | http://www.cisco.com/c/en/us/products/routers/1941w-integrated-services-router-isr/index.html]]'),
	2584 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%3925 | http://www.cisco.com/c/en/us/products/routers/3925-integrated-services-router-isr/index.html]]'),
	2585 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%3925E | http://www.cisco.com/c/en/us/products/routers/3925e-integrated-services-router-isr/index.html]]'),
	2586 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%3945 | http://www.cisco.com/c/en/us/products/routers/3945-integrated-services-router-isr/index.html]]'),
	2587 => array ('chapter_id' => 17, 'dict_value' => '[[Cisco%GPASS%3945E | http://www.cisco.com/c/en/us/products/routers/3945e-integrated-services-router-isr/index.html]]'),
	2588 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE7855-32Q-EI'),
	2589 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6870-48S6CQ-EI'),
	2590 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6870-24S6CQ-EI'),
	2591 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6860-48S8CQ-EI'),
	2592 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6850U-24S2Q-HI'),
	2593 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6850U-48S6Q-HI'),
	2594 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6851-48S6Q-HI'),
	2595 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6855-48T6Q-HI'),
	2596 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6850-48T6Q-HI'),
	2597 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6855-48S6Q-HI'),
	2598 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6850-48S6Q-HI'),
	2599 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6810-48S4Q-EI'),
	2600 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6810-48S4Q-LI'),
	2601 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6810-48S-LI'),
	2602 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6810-24S2Q-LI'),
	2603 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE6810-32T16S4Q-LI'),
	2604 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE5855-24T4S2Q-EI'),
	2605 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%CE5855-48T4S2Q-EI'),
	2606 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S6720-30C-EI-24S'),
	2607 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S6720-54C-EI-48S'),
	2608 => array ('chapter_id' => 12, 'dict_value' => 'Huawei%GPASS%S6720S-26Q-EI-24S'),
	2609 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.5 | http://www.openbsd.org/55.html]]'),
	2610 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.6 | http://www.openbsd.org/56.html]]'),
	2611 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.7 | http://www.openbsd.org/57.html]]'),
	2612 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.8 | http://www.openbsd.org/58.html]]'),
	2613 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 5.9 | http://www.openbsd.org/59.html]]'),
	2614 => array ('chapter_id' => 13, 'dict_value' => '[[OpenBSD%GSKIP%OpenBSD 6.0 | http://www.openbsd.org/60.html]]'),
	2615 => array ('chapter_id' => 11, 'dict_value' => 'HP ProLiant%GPASS%DL980'),
	2616 => array ('chapter_id' => 13, 'dict_value' => 'FreeBSD%GSKIP%FreeBSD 11.x'),
	2617 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 5.6'),
	2618 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 6.0'),
	2619 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 6.1'),
	2620 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 6.2'),
	2621 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 6.5'),
	2622 => array ('chapter_id' => 13, 'dict_value' => 'Xen Hypervisor%GSKIP%XenServer 7.0'),
	2623 => array ('chapter_id' => 18, 'dict_value' => 'HP StorageWorks P6300'),
	2624 => array ('chapter_id' => 12, 'dict_value' => 'Ubiquiti EdgeSwitch ES-48-LITE'),
	2625 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%4221'),
	2626 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%4321'),
	2627 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%4331'),
	2628 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%4351'),
	2629 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%4431'),
	2630 => array ('chapter_id' => 17, 'dict_value' => 'Cisco%GPASS%4451'),
	2631 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-24TS'),
	2632 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48TS'),
	2633 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-24PS'),
	2634 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48PS'),
	2635 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48FS'),
	2636 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-24TD'),
	2637 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48TD'),
	2638 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-24PD'),
	2639 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-24PDM'),
	2640 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48PD'),
	2641 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48FD'),
	2642 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48TQ'),
	2643 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48PQ'),
	2644 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48FQ'),
	2645 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-48FQM'),
	2646 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-8X24UQ'),
	2647 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-12x48UQ'),
	2648 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-12X48UR'),
	2649 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3650-12X48UZ'),
	2650 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-24P'),
	2651 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-48P'),
	2652 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-48F'),
	2653 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-24U'),
	2654 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-48U'),
	2655 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-24XU'),
	2656 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-12X48U'),
	2657 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-12S'),
	2658 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-24S'),
	2659 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-12XS'),
	2660 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-24XS'),
	2661 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 3850-48XS'),
	2662 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%Catalyst 4510R+E'),
	2663 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3600X-24TS-M'),
	2664 => array ('chapter_id' => 12, 'dict_value' => 'Cisco%GPASS%ME 3600X-24FS-M'),

# Any new "default" dictionary records must go above this line (i.e., with
# dict_key code less, than 50000). This is necessary to keep AUTO_INCREMENT
# and dictionary updates working properly.
	49999 => array ('chapter_id' => 13, 'dict_value' => '[[RH Fedora%GSKIP%Fedora 15 | http://docs.fedoraproject.org/release-notes/f15/en-US/html/]]'),
);

?>
