/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

abstract class StringHelper {
    static final ByteList NEW_LINE = new ByteList(new byte[]{10}, false);
    static final ByteList COMMA_SPACE = new ByteList(new byte[]{44, 32}, false);
    static final char[] S20 = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final DateTimeFormatter ASN_DATE_NO_ZONE = DateTimeFormat.forPattern((String)"MMM dd HH:mm:ss yyyy").withLocale(Locale.US).withZone(DateTimeZone.UTC);

    StringHelper() {
    }

    static RubyString newString(Ruby runtime, byte[] bytes) {
        ByteList byteList = new ByteList(bytes, false);
        return RubyString.newString((Ruby)runtime, (ByteList)byteList);
    }

    static RubyString newUTF8String(Ruby runtime, ByteList bytes) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF8((CharSequence)bytes), (Encoding)UTF8Encoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    static RubyString newUTF8String(Ruby runtime, CharSequence chars) {
        ByteList byteList = new ByteList(RubyEncoding.encodeUTF8((CharSequence)chars), (Encoding)UTF8Encoding.INSTANCE, false);
        return new RubyString(runtime, runtime.getString(), byteList);
    }

    static RubyString newStringFrozen(Ruby runtime, ByteList bytes) {
        RubyString str = RubyString.newStringShared((Ruby)runtime, (ByteList)bytes);
        str.setFrozen(true);
        return str;
    }

    static RubyString newStringFrozen(Ruby runtime, CharSequence chars) {
        RubyString str = RubyString.newString((Ruby)runtime, (CharSequence)chars);
        str.setFrozen(true);
        return str;
    }

    static byte[] readX509PEM(ThreadContext context2, IRubyObject arg) {
        RubyString str = StringHelper.readPossibleDERInput(context2, arg);
        ByteList bytes = str.getByteList();
        return StringHelper.readX509PEM(bytes.unsafeBytes(), bytes.getBegin(), bytes.getRealSize());
    }

    static byte[] readX509PEM(byte[] bytes, int offset, int length) {
        InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(bytes, offset, length));
        try {
            byte[] readBytes = PEMInputOutput.readX509PEM(in);
            if (readBytes != null) {
                return readBytes;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    static RubyString readPossibleDERInput(ThreadContext context2, IRubyObject arg) {
        return StringHelper.readInput(context2, OpenSSL.to_der_if_possible(context2, arg));
    }

    static RubyString readInput(ThreadContext context2, IRubyObject arg) {
        if (arg instanceof RubyIO) {
            IRubyObject result = arg instanceof RubyFile ? ((RubyFile)arg.dup()).read(context2) : ((RubyIO)arg).read(context2);
            if (result instanceof RubyString) {
                return (RubyString)result;
            }
            throw context2.runtime.newArgumentError("IO `" + arg.inspect() + "' contained no data");
        }
        return arg.asString();
    }

    static void gsub(Ruby runtime, ByteList str, byte match, byte replace) {
        int begin = str.getBegin();
        int slen = str.getRealSize();
        byte[] bytes = str.getUnsafeBytes();
        for (int i2 = begin; i2 < begin + slen; ++i2) {
            if (bytes[i2] != match) continue;
            bytes[i2] = replace;
        }
    }

    static StringBuilder appendGMTDateTime(StringBuilder text, DateTime time2) {
        String date = ASN_DATE_NO_ZONE.print(time2.getMillis());
        int len = text.length();
        text.append(date).append(' ').append("GMT");
        if (date.charAt(4) == '0') {
            text.setCharAt(len + 4, ' ');
        }
        return text;
    }

    static StringBuilder lowerHexBytes(byte[] bytes, int offset) {
        int len = bytes.length;
        StringBuilder hex = new StringBuilder(len * 3);
        for (int i2 = offset; i2 < bytes.length; ++i2) {
            String h = Integer.toHexString(bytes[i2] & 0xFF);
            if (h.length() == 1) {
                hex.append('0');
            }
            hex.append(h).append(':');
        }
        if (hex.length() > 0) {
            hex.setLength(hex.length() - 1);
        }
        return hex;
    }

    static void appendLowerHexValue(StringBuilder text, byte[] hex, int indent, int rowLength) {
        int len;
        int print;
        StringBuilder hexStr = StringHelper.lowerHexBytes(hex, 0);
        for (int left = len = hexStr.length(); left > 0; left -= print) {
            print = rowLength;
            if (left < rowLength) {
                print = left;
            }
            int start = len - left;
            text.append(S20, 0, indent).append(hexStr, start, start + print).append('\n');
        }
    }

    static <T extends CharSequence> ArrayList<T> split(T string, char separator) {
        ArrayList<CharSequence> split = new ArrayList<CharSequence>(8);
        int last = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != separator) continue;
            split.add(string.subSequence(last, i2));
            last = ++i2;
        }
        if (last == 0) {
            split.add(string);
        } else {
            split.add(string.subSequence(last, string.length()));
        }
        return split;
    }

    public static String[] split(String string, char separator) {
        ArrayList<String> split = StringHelper.split(string, separator);
        return split.toArray(new String[split.size()]);
    }
}

