/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.DefaultSocketConfigurator;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.NullTrustManager;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ConnectionParams;
import com.rabbitmq.client.impl.DefaultExceptionHandler;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.FrameHandlerFactory;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ConnectionFactory
implements Cloneable {
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASS = "guest";
    public static final String DEFAULT_VHOST = "/";
    public static final int DEFAULT_CHANNEL_MAX = 0;
    public static final int DEFAULT_FRAME_MAX = 0;
    public static final int DEFAULT_HEARTBEAT = 0;
    public static final String DEFAULT_HOST = "localhost";
    public static final int USE_DEFAULT_PORT = -1;
    public static final int DEFAULT_AMQP_PORT = 5672;
    public static final int DEFAULT_AMQP_OVER_SSL_PORT = 5671;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_HANDSHAKE_TIMEOUT = 10000;
    public static final int DEFAULT_SHUTDOWN_TIMEOUT = 10000;
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1";
    private String username = "guest";
    private String password = "guest";
    private String virtualHost = "/";
    private String host = "localhost";
    private int port = -1;
    private int requestedChannelMax = 0;
    private int requestedFrameMax = 0;
    private int requestedHeartbeat = 0;
    private int connectionTimeout = 0;
    private int handshakeTimeout = 10000;
    private int shutdownTimeout = 10000;
    private Map<String, Object> _clientProperties = AMQConnection.defaultClientProperties();
    private SocketFactory factory = SocketFactory.getDefault();
    private SaslConfig saslConfig = DefaultSaslConfig.PLAIN;
    private ExecutorService sharedExecutor;
    private ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private SocketConfigurator socketConf = new DefaultSocketConfigurator();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private boolean automaticRecovery = false;
    private boolean topologyRecovery = true;
    private long networkRecoveryInterval = 5000L;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public static int portOrDefault(int port, boolean ssl) {
        if (port != -1) {
            return port;
        }
        if (ssl) {
            return 5671;
        }
        return 5672;
    }

    public int getPort() {
        return ConnectionFactory.portOrDefault(this.port, this.isSSL());
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public void setUri(URI uri) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        String path;
        String userInfo;
        int port;
        String host;
        if (!"amqp".equals(uri.getScheme().toLowerCase())) {
            if ("amqps".equals(uri.getScheme().toLowerCase())) {
                this.setPort(5671);
                this.useSslProtocol();
            } else {
                throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uri.getScheme());
            }
        }
        if ((host = uri.getHost()) != null) {
            this.setHost(host);
        }
        if ((port = uri.getPort()) != -1) {
            this.setPort(port);
        }
        if ((userInfo = uri.getRawUserInfo()) != null) {
            String[] userPass = userInfo.split(":");
            if (userPass.length > 2) {
                throw new IllegalArgumentException("Bad user info in AMQP URI: " + userInfo);
            }
            this.setUsername(this.uriDecode(userPass[0]));
            if (userPass.length == 2) {
                this.setPassword(this.uriDecode(userPass[1]));
            }
        }
        if ((path = uri.getRawPath()) != null && path.length() > 0) {
            if (path.indexOf(47, 1) != -1) {
                throw new IllegalArgumentException("Multiple segments in path of AMQP URI: " + path);
            }
            this.setVirtualHost(this.uriDecode(uri.getPath().substring(1)));
        }
    }

    public void setUri(String uriString) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.setUri(new URI(uriString));
    }

    private String uriDecode(String s) {
        try {
            return URLDecoder.decode(s.replace("+", "%2B"), "US-ASCII");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("TCP connection timeout cannot be negative");
        }
        this.connectionTimeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    public void setHandshakeTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("handshake timeout cannot be negative");
        }
        this.handshakeTimeout = timeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this._clientProperties = clientProperties;
    }

    public SaslConfig getSaslConfig() {
        return this.saslConfig;
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.saslConfig = saslConfig;
    }

    public SocketFactory getSocketFactory() {
        return this.factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    public SocketConfigurator getSocketConfigurator() {
        return this.socketConf;
    }

    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.socketConf = socketConfigurator;
    }

    public void setSharedExecutor(ExecutorService executor) {
        this.sharedExecutor = executor;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("exception handler cannot be null!");
        }
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isSSL() {
        return this.getSocketFactory() instanceof SSLSocketFactory;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(DEFAULT_SSL_PROTOCOL);
    }

    public void useSslProtocol(String protocol) throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(protocol, new NullTrustManager());
    }

    public void useSslProtocol(String protocol, TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext c = SSLContext.getInstance(protocol);
        c.init(null, new TrustManager[]{trustManager}, null);
        this.useSslProtocol(c);
    }

    public void useSslProtocol(SSLContext context) {
        this.setSocketFactory(context.getSocketFactory());
    }

    public boolean isAutomaticRecoveryEnabled() {
        return this.automaticRecovery;
    }

    public void setAutomaticRecoveryEnabled(boolean automaticRecovery) {
        this.automaticRecovery = automaticRecovery;
    }

    public boolean isTopologyRecoveryEnabled() {
        return this.topologyRecovery;
    }

    public void setTopologyRecoveryEnabled(boolean topologyRecovery) {
        this.topologyRecovery = topologyRecovery;
    }

    protected FrameHandlerFactory createFrameHandlerFactory() throws IOException {
        return new FrameHandlerFactory(this.connectionTimeout, this.factory, this.socketConf, this.isSSL());
    }

    public Connection newConnection(Address[] addrs) throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, addrs);
    }

    public Connection newConnection(ExecutorService executor, Address[] addrs) throws IOException, TimeoutException {
        FrameHandlerFactory fhFactory = this.createFrameHandlerFactory();
        ConnectionParams params = this.params(executor);
        if (this.isAutomaticRecoveryEnabled()) {
            AutorecoveringConnection conn = new AutorecoveringConnection(params, fhFactory, addrs);
            conn.init();
            return conn;
        }
        IOException lastException = null;
        for (Address addr : addrs) {
            try {
                FrameHandler handler = fhFactory.create(addr);
                AMQConnection conn = new AMQConnection(params, handler);
                conn.start();
                return conn;
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        throw lastException != null ? lastException : new IOException("failed to connect");
    }

    public ConnectionParams params(ExecutorService executor) {
        ConnectionParams result = new ConnectionParams(this.username, this.password, executor, this.virtualHost, this.getClientProperties(), this.requestedFrameMax, this.requestedChannelMax, this.requestedHeartbeat, this.shutdownTimeout, this.saslConfig, this.networkRecoveryInterval, this.topologyRecovery, this.exceptionHandler, this.threadFactory);
        result.setHandshakeTimeout(this.handshakeTimeout);
        return result;
    }

    public Connection newConnection() throws IOException, TimeoutException {
        return this.newConnection(this.sharedExecutor, new Address[]{new Address(this.getHost(), this.getPort())});
    }

    public Connection newConnection(ExecutorService executor) throws IOException, TimeoutException {
        return this.newConnection(executor, new Address[]{new Address(this.getHost(), this.getPort())});
    }

    public ConnectionFactory clone() {
        try {
            return (ConnectionFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public long getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(int networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(long networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }
}

