/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.util.Map;
import java.util.Properties;
import kafka.common.InvalidConfigException;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple16;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class LogConfig$
implements Serializable {
    public static final LogConfig$ MODULE$;
    private final String SegmentBytesProp;
    private final String SegmentMsProp;
    private final String SegmentJitterMsProp;
    private final String SegmentIndexBytesProp;
    private final String FlushMessagesProp;
    private final String FlushMsProp;
    private final String RetentionBytesProp;
    private final String RententionMsProp;
    private final String MaxMessageBytesProp;
    private final String IndexIntervalBytesProp;
    private final String DeleteRetentionMsProp;
    private final String FileDeleteDelayMsProp;
    private final String MinCleanableDirtyRatioProp;
    private final String CleanupPolicyProp;
    private final String UncleanLeaderElectionEnableProp;
    private final String MinInSyncReplicasProp;
    private final Set<String> ConfigNames;

    static {
        new LogConfig$();
    }

    public String SegmentBytesProp() {
        return this.SegmentBytesProp;
    }

    public String SegmentMsProp() {
        return this.SegmentMsProp;
    }

    public String SegmentJitterMsProp() {
        return this.SegmentJitterMsProp;
    }

    public String SegmentIndexBytesProp() {
        return this.SegmentIndexBytesProp;
    }

    public String FlushMessagesProp() {
        return this.FlushMessagesProp;
    }

    public String FlushMsProp() {
        return this.FlushMsProp;
    }

    public String RetentionBytesProp() {
        return this.RetentionBytesProp;
    }

    public String RententionMsProp() {
        return this.RententionMsProp;
    }

    public String MaxMessageBytesProp() {
        return this.MaxMessageBytesProp;
    }

    public String IndexIntervalBytesProp() {
        return this.IndexIntervalBytesProp;
    }

    public String DeleteRetentionMsProp() {
        return this.DeleteRetentionMsProp;
    }

    public String FileDeleteDelayMsProp() {
        return this.FileDeleteDelayMsProp;
    }

    public String MinCleanableDirtyRatioProp() {
        return this.MinCleanableDirtyRatioProp;
    }

    public String CleanupPolicyProp() {
        return this.CleanupPolicyProp;
    }

    public String UncleanLeaderElectionEnableProp() {
        return this.UncleanLeaderElectionEnableProp;
    }

    public String MinInSyncReplicasProp() {
        return this.MinInSyncReplicasProp;
    }

    public Set<String> ConfigNames() {
        return this.ConfigNames;
    }

    public LogConfig fromProps(Properties props) {
        int x$1 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.SegmentSize())).toString()))).toInt();
        long x$2 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.SegmentMsProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.SegmentMs())).toString()))).toLong();
        long x$3 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.SegmentJitterMsProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.SegmentJitterMs())).toString()))).toLong();
        int x$4 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.SegmentIndexBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MaxIndexSize())).toString()))).toInt();
        long x$5 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.FlushMessagesProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FlushInterval())).toString()))).toLong();
        long x$6 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.FlushMsProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FlushMs())).toString()))).toLong();
        long x$7 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.RetentionBytesProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.RetentionSize())).toString()))).toLong();
        long x$8 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.RententionMsProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.RetentionMs())).toString()))).toLong();
        int x$9 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MaxMessageSize())).toString()))).toInt();
        int x$10 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.IndexIntervalBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.IndexInterval())).toString()))).toInt();
        long x$11 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.FileDeleteDelayMsProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.FileDeleteDelayMs())).toString()))).toInt();
        long x$12 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.DeleteRetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)Defaults$.MODULE$.DeleteRetentionMs())).toString()))).toLong();
        double x$13 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.MinCleanableDirtyRatioProp(), ((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.MinCleanableDirtyRatio())).toString()))).toDouble();
        String string = props.getProperty(this.CleanupPolicyProp(), Defaults$.MODULE$.Compact() ? "compact" : "delete").trim().toLowerCase();
        String string2 = "delete";
        boolean x$14 = string != null ? !string.equals(string2) : string2 != null;
        boolean x$15 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)Defaults$.MODULE$.UncleanLeaderElectionEnable())).toString()))).toBoolean();
        int x$16 = new StringOps(Predef$.MODULE$.augmentString(props.getProperty(this.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString()))).toInt();
        return new LogConfig(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$4, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    public LogConfig fromProps(Properties defaults, Properties overrides) {
        Properties props = new Properties(defaults);
        props.putAll((Map<?, ?>)overrides);
        return this.fromProps(props);
    }

    public void validateNames(Properties props) {
        JavaConversions$.MODULE$.enumerationAsScalaIterator(props.keys()).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object name) {
                Predef$.MODULE$.require(JavaConversions$.MODULE$.setAsJavaSet(LogConfig$.MODULE$.ConfigNames()).contains(name), (Function0)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final Object name$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Unknown configuration \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
            }
        });
    }

    public void validate(Properties props) {
        this.validateNames(props);
        this.validateMinInSyncReplicas(props);
        this.fromProps(new LogConfig(this.apply$default$1(), this.apply$default$2(), this.apply$default$3(), this.apply$default$4(), this.apply$default$5(), this.apply$default$6(), this.apply$default$7(), this.apply$default$8(), this.apply$default$9(), this.apply$default$10(), this.apply$default$11(), this.apply$default$12(), this.apply$default$13(), this.apply$default$14(), this.apply$default$15(), this.apply$default$16()).toProps(), props);
    }

    private void validateMinInSyncReplicas(Properties props) {
        String minIsr = props.getProperty(this.MinInSyncReplicasProp());
        if (minIsr != null && new StringOps(Predef$.MODULE$.augmentString(minIsr)).toInt() < 1) {
            throw new InvalidConfigException(new StringBuilder().append((Object)"Wrong value ").append((Object)minIsr).append((Object)" of min.insync.replicas in topic configuration; ").append((Object)" Valid values are at least 1").toString());
        }
    }

    public LogConfig apply(int segmentSize, long segmentMs, long segmentJitterMs, long flushInterval, long flushMs, long retentionSize, long retentionMs, int maxMessageSize, int maxIndexSize, int indexInterval, long fileDeleteDelayMs, long deleteRetentionMs, double minCleanableRatio, boolean compact2, boolean uncleanLeaderElectionEnable, int minInSyncReplicas) {
        return new LogConfig(segmentSize, segmentMs, segmentJitterMs, flushInterval, flushMs, retentionSize, retentionMs, maxMessageSize, maxIndexSize, indexInterval, fileDeleteDelayMs, deleteRetentionMs, minCleanableRatio, compact2, uncleanLeaderElectionEnable, minInSyncReplicas);
    }

    public Option<Tuple16<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>> unapply(LogConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple16((Object)BoxesRunTime.boxToInteger((int)x$0.segmentSize()), (Object)BoxesRunTime.boxToLong((long)x$0.segmentMs()), (Object)BoxesRunTime.boxToLong((long)x$0.segmentJitterMs()), (Object)BoxesRunTime.boxToLong((long)x$0.flushInterval()), (Object)BoxesRunTime.boxToLong((long)x$0.flushMs()), (Object)BoxesRunTime.boxToLong((long)x$0.retentionSize()), (Object)BoxesRunTime.boxToLong((long)x$0.retentionMs()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxMessageSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.maxIndexSize()), (Object)BoxesRunTime.boxToInteger((int)x$0.indexInterval()), (Object)BoxesRunTime.boxToLong((long)x$0.fileDeleteDelayMs()), (Object)BoxesRunTime.boxToLong((long)x$0.deleteRetentionMs()), (Object)BoxesRunTime.boxToDouble((double)x$0.minCleanableRatio()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.compact()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.uncleanLeaderElectionEnable()), (Object)BoxesRunTime.boxToInteger((int)x$0.minInSyncReplicas())));
    }

    public int $lessinit$greater$default$1() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public long $lessinit$greater$default$2() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public long $lessinit$greater$default$3() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public long $lessinit$greater$default$4() {
        return Defaults$.MODULE$.FlushInterval();
    }

    public long $lessinit$greater$default$5() {
        return Defaults$.MODULE$.FlushMs();
    }

    public long $lessinit$greater$default$6() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long $lessinit$greater$default$7() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public int $lessinit$greater$default$8() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int $lessinit$greater$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public int $lessinit$greater$default$10() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public long $lessinit$greater$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public long $lessinit$greater$default$12() {
        return Defaults$.MODULE$.DeleteRetentionMs();
    }

    public double $lessinit$greater$default$13() {
        return Defaults$.MODULE$.MinCleanableDirtyRatio();
    }

    public boolean $lessinit$greater$default$14() {
        return Defaults$.MODULE$.Compact();
    }

    public boolean $lessinit$greater$default$15() {
        return Defaults$.MODULE$.UncleanLeaderElectionEnable();
    }

    public int $lessinit$greater$default$16() {
        return Defaults$.MODULE$.MinInSyncReplicas();
    }

    public int apply$default$1() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public long apply$default$2() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public long apply$default$3() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public long apply$default$4() {
        return Defaults$.MODULE$.FlushInterval();
    }

    public long apply$default$5() {
        return Defaults$.MODULE$.FlushMs();
    }

    public long apply$default$6() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long apply$default$7() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public int apply$default$8() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int apply$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public int apply$default$10() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public long apply$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public long apply$default$12() {
        return Defaults$.MODULE$.DeleteRetentionMs();
    }

    public double apply$default$13() {
        return Defaults$.MODULE$.MinCleanableDirtyRatio();
    }

    public boolean apply$default$14() {
        return Defaults$.MODULE$.Compact();
    }

    public boolean apply$default$15() {
        return Defaults$.MODULE$.UncleanLeaderElectionEnable();
    }

    public int apply$default$16() {
        return Defaults$.MODULE$.MinInSyncReplicas();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LogConfig$() {
        MODULE$ = this;
        this.SegmentBytesProp = "segment.bytes";
        this.SegmentMsProp = "segment.ms";
        this.SegmentJitterMsProp = "segment.jitter.ms";
        this.SegmentIndexBytesProp = "segment.index.bytes";
        this.FlushMessagesProp = "flush.messages";
        this.FlushMsProp = "flush.ms";
        this.RetentionBytesProp = "retention.bytes";
        this.RententionMsProp = "retention.ms";
        this.MaxMessageBytesProp = "max.message.bytes";
        this.IndexIntervalBytesProp = "index.interval.bytes";
        this.DeleteRetentionMsProp = "delete.retention.ms";
        this.FileDeleteDelayMsProp = "file.delete.delay.ms";
        this.MinCleanableDirtyRatioProp = "min.cleanable.dirty.ratio";
        this.CleanupPolicyProp = "cleanup.policy";
        this.UncleanLeaderElectionEnableProp = "unclean.leader.election.enable";
        this.MinInSyncReplicasProp = "min.insync.replicas";
        this.ConfigNames = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SegmentBytesProp(), this.SegmentMsProp(), this.SegmentJitterMsProp(), this.SegmentIndexBytesProp(), this.FlushMessagesProp(), this.FlushMsProp(), this.RetentionBytesProp(), this.RententionMsProp(), this.MaxMessageBytesProp(), this.IndexIntervalBytesProp(), this.FileDeleteDelayMsProp(), this.DeleteRetentionMsProp(), this.MinCleanableDirtyRatioProp(), this.CleanupPolicyProp(), this.UncleanLeaderElectionEnableProp(), this.MinInSyncReplicasProp()}));
    }
}

