/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals.c14n;

import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nokogiri.internals.c14n.CanonicalFilter;
import nokogiri.internals.c14n.CanonicalizationException;
import nokogiri.internals.c14n.Canonicalizer11_OmitComments;
import nokogiri.internals.c14n.Canonicalizer11_WithComments;
import nokogiri.internals.c14n.Canonicalizer20010315ExclOmitComments;
import nokogiri.internals.c14n.Canonicalizer20010315ExclWithComments;
import nokogiri.internals.c14n.Canonicalizer20010315OmitComments;
import nokogiri.internals.c14n.Canonicalizer20010315WithComments;
import nokogiri.internals.c14n.CanonicalizerPhysical;
import nokogiri.internals.c14n.CanonicalizerSpi;
import org.w3c.dom.Node;

public class Canonicalizer {
    public static final String ENCODING = "UTF8";
    public static final String XPATH_C14N_WITH_COMMENTS_SINGLE_NODE = "(.//. | .//@* | .//namespace::*)";
    public static final String ALGO_ID_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String ALGO_ID_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String ALGO_ID_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String ALGO_ID_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String ALGO_ID_C14N11_OMIT_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String ALGO_ID_C14N11_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
    public static final String ALGO_ID_C14N_PHYSICAL = "http://santuario.apache.org/c14n/physical";
    private static Map<String, Class<? extends CanonicalizerSpi>> canonicalizerHash = null;
    private final CanonicalizerSpi canonicalizerSpi;

    private Canonicalizer(String string) throws CanonicalizationException {
        try {
            Class<? extends CanonicalizerSpi> clazz = canonicalizerHash.get(string);
            this.canonicalizerSpi = clazz.newInstance();
            this.canonicalizerSpi.reset = true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{string};
            throw new CanonicalizationException("signature.Canonicalizer.UnknownCanonicalizer", objectArray, exception);
        }
    }

    public static final Canonicalizer getInstance(String string) throws CanonicalizationException {
        if (canonicalizerHash == null) {
            canonicalizerHash = new ConcurrentHashMap<String, Class<? extends CanonicalizerSpi>>();
            Canonicalizer.registerDefaultAlgorithms();
        }
        return new Canonicalizer(string);
    }

    public static void register(String string, String string2) throws CanonicalizationException, ClassNotFoundException {
        Class<? extends CanonicalizerSpi> clazz = canonicalizerHash.get(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new CanonicalizationException("algorithm.alreadyRegistered", objectArray);
        }
        canonicalizerHash.put(string, Class.forName(string2));
    }

    public static void register(String string, Class<? extends CanonicalizerSpi> clazz) throws CanonicalizationException, ClassNotFoundException {
        Class<? extends CanonicalizerSpi> clazz2 = canonicalizerHash.get(string);
        if (clazz2 != null) {
            Object[] objectArray = new Object[]{string, clazz2};
            throw new CanonicalizationException("algorithm.alreadyRegistered", objectArray);
        }
        canonicalizerHash.put(string, clazz);
    }

    private static void registerDefaultAlgorithms() {
        canonicalizerHash.put(ALGO_ID_C14N_OMIT_COMMENTS, Canonicalizer20010315OmitComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_WITH_COMMENTS, Canonicalizer20010315WithComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_EXCL_OMIT_COMMENTS, Canonicalizer20010315ExclOmitComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_EXCL_WITH_COMMENTS, Canonicalizer20010315ExclWithComments.class);
        canonicalizerHash.put(ALGO_ID_C14N11_OMIT_COMMENTS, Canonicalizer11_OmitComments.class);
        canonicalizerHash.put(ALGO_ID_C14N11_WITH_COMMENTS, Canonicalizer11_WithComments.class);
        canonicalizerHash.put(ALGO_ID_C14N_PHYSICAL, CanonicalizerPhysical.class);
    }

    public final String getURI() {
        return this.canonicalizerSpi.engineGetURI();
    }

    public boolean getIncludeComments() {
        return this.canonicalizerSpi.engineGetIncludeComments();
    }

    public byte[] canonicalizeSubtree(Node node, CanonicalFilter canonicalFilter) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(node, canonicalFilter);
    }

    public byte[] canonicalizeSubtree(Node node, String string, CanonicalFilter canonicalFilter) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(node, string, canonicalFilter);
    }

    public void setWriter(OutputStream outputStream) {
        this.canonicalizerSpi.setWriter(outputStream);
    }

    public String getImplementingCanonicalizerClass() {
        return this.canonicalizerSpi.getClass().getName();
    }

    public void notReset() {
        this.canonicalizerSpi.reset = false;
    }
}

