/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Properties;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;

public final class ChangeExecListenerUtils {
    private ChangeExecListenerUtils() {
    }

    public static ChangeExecListener getChangeExecListener(Database database, ResourceAccessor resourceAccessor, String changeExecListenerClass, String changeExecListenerPropertiesFile) throws Exception {
        ChangeExecListener changeExecListener = null;
        if (changeExecListenerClass != null) {
            Logger logger = LogFactory.getInstance().getLog();
            logger.debug("Setting ChangeExecListener: " + changeExecListenerClass);
            ClassLoader classLoader = resourceAccessor.toClassLoader();
            Class<?> clazz = Class.forName(changeExecListenerClass, true, classLoader);
            Properties properties = ChangeExecListenerUtils.loadProperties(changeExecListenerPropertiesFile);
            Constructor<?> cons = ChangeExecListenerUtils.getConstructor(clazz, Database.class, Properties.class);
            if (cons != null) {
                logger.debug("Create " + clazz.getSimpleName() + "(Database, Properties)");
                changeExecListener = (ChangeExecListener)cons.newInstance(database, properties);
            } else {
                cons = ChangeExecListenerUtils.getConstructor(clazz, Properties.class, Database.class);
                if (cons != null) {
                    logger.debug("Create " + clazz.getSimpleName() + "(Properties, Database)");
                    changeExecListener = (ChangeExecListener)cons.newInstance(properties, database);
                } else {
                    cons = ChangeExecListenerUtils.getConstructor(clazz, Database.class);
                    if (cons != null) {
                        logger.debug("Create " + clazz.getSimpleName() + "(Database)");
                        changeExecListener = (ChangeExecListener)cons.newInstance(database);
                    } else {
                        cons = ChangeExecListenerUtils.getConstructor(clazz, Properties.class);
                        if (cons != null) {
                            logger.debug("Create " + clazz.getSimpleName() + "(Properties)");
                            changeExecListener = (ChangeExecListener)cons.newInstance(properties);
                        } else {
                            logger.debug("Create " + clazz.getSimpleName() + "()");
                            changeExecListener = (ChangeExecListener)clazz.newInstance();
                        }
                    }
                }
            }
        }
        return changeExecListener;
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... params) {
        try {
            return clazz.getConstructor(params);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String propertiesFile) throws IOException {
        if (propertiesFile != null) {
            File file = new File(propertiesFile);
            if (file.exists()) {
                Properties properties = new Properties();
                FileInputStream inputStream = new FileInputStream(propertiesFile);
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
                return properties;
            }
            throw new FileNotFoundException(propertiesFile);
        }
        return null;
    }
}

