/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.x509store.Name;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Name
extends RubyObject {
    private static final long serialVersionUID = -226196051911335103L;
    private static ObjectAllocator X509NAME_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Name(runtime, klass);
        }
    };
    public static final int COMPAT = 0;
    public static final int RFC2253 = 17892119;
    public static final int ONELINE = 8520479;
    public static final int MULTILINE = 44302342;
    private final List<ASN1ObjectIdentifier> oids = new ArrayList<ASN1ObjectIdentifier>();
    private final List<ASN1Encodable> values = new ArrayList<ASN1Encodable>();
    private final List<RubyInteger> types = new ArrayList<RubyInteger>();
    private transient X500Name name;

    public static void createX509Name(Ruby runtime, RubyModule _X509) {
        RubyClass _Name = _X509.defineClassUnder("Name", runtime.getObject(), X509NAME_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("NameError", _OpenSSLError, _OpenSSLError.getAllocator());
        _Name.defineAnnotatedMethods(X509Name.class);
        _Name.includeModule((IRubyObject)runtime.getComparable());
        _Name.setConstant("COMPAT", (IRubyObject)runtime.newFixnum(0));
        _Name.setConstant("RFC2253", (IRubyObject)runtime.newFixnum(17892119));
        _Name.setConstant("ONELINE", (IRubyObject)runtime.newFixnum(8520479));
        _Name.setConstant("MULTILINE", (IRubyObject)runtime.newFixnum(44302342));
        RubyFixnum UTF8_STRING = runtime.newFixnum(12);
        _Name.setConstant("DEFAULT_OBJECT_TYPE", (IRubyObject)UTF8_STRING);
        RubyFixnum PRINTABLE_STRING = runtime.newFixnum(19);
        RubyFixnum IA5_STRING = runtime.newFixnum(22);
        ThreadContext context2 = runtime.getCurrentContext();
        RubyHash hash2 = new RubyHash(runtime, (IRubyObject)UTF8_STRING);
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, new byte[]{67}), (IRubyObject)PRINTABLE_STRING);
        byte[] countryName = new byte[]{99, 111, 117, 110, 116, 114, 121, 78, 97, 109, 101};
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, countryName), (IRubyObject)PRINTABLE_STRING);
        byte[] serialNumber = new byte[]{115, 101, 114, 105, 97, 108, 78, 117, 109, 98, 101, 114};
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, serialNumber), (IRubyObject)PRINTABLE_STRING);
        byte[] dnQualifier = new byte[]{100, 110, 81, 117, 97, 108, 105, 102, 105, 101, 114};
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, dnQualifier), (IRubyObject)PRINTABLE_STRING);
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, new byte[]{68, 67}), (IRubyObject)IA5_STRING);
        byte[] domainComponent = new byte[]{100, 111, 109, 97, 105, 110, 67, 111, 109, 112, 111, 110, 101, 110, 116};
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, domainComponent), (IRubyObject)IA5_STRING);
        byte[] emailAddress = new byte[]{101, 109, 97, 105, 108, 65, 100, 100, 114, 101, 115, 115};
        hash2.op_aset(context2, (IRubyObject)StringHelper.newString(runtime, emailAddress), (IRubyObject)IA5_STRING);
        _Name.setConstant("OBJECT_TYPE_TEMPLATE", (IRubyObject)hash2);
    }

    static X509Name newName(Ruby runtime) {
        return new X509Name(runtime, X509Name._Name(runtime));
    }

    static X509Name newName(Ruby runtime, X500Principal principal) {
        X509Name name2 = X509Name.newName(runtime);
        name2.fromASN1Sequence(principal.getEncoded());
        return name2;
    }

    static X509Name newName(Ruby runtime, X500Name realName) {
        X509Name name2 = X509Name.newName(runtime);
        name2.fromASN1Sequence((ASN1Sequence)realName.toASN1Primitive());
        return name2;
    }

    @Deprecated
    public static X509Name create(Ruby runtime, X500Name realName) {
        return X509Name.newName(runtime, realName);
    }

    static RubyClass _Name(Ruby runtime) {
        return X509._X509(runtime).getClass("Name");
    }

    public X509Name(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    private void fromASN1Sequence(byte[] encoded) {
        try {
            this.fromASN1Sequence((ASN1Sequence)new ASN1InputStream(encoded).readObject());
        }
        catch (IOException e) {
            throw X509Name.newNameError(this.getRuntime(), e.getClass().getName() + ":" + e.getMessage());
        }
    }

    void fromASN1Sequence(ASN1Sequence seq) {
        this.oids.clear();
        this.values.clear();
        this.types.clear();
        if (seq != null) {
            Enumeration e = seq.getObjects();
            while (e.hasMoreElements()) {
                ASN1Object element = (ASN1Object)e.nextElement();
                if (element instanceof RDN) {
                    this.fromRDNElement((RDN)element);
                    continue;
                }
                if (element instanceof ASN1Sequence) {
                    this.fromASN1Sequence((ASN1Encodable)element);
                    continue;
                }
                this.fromASN1Set(element);
            }
        }
    }

    private void fromRDNElement(RDN rdn) {
        Ruby runtime = this.getRuntime();
        for (AttributeTypeAndValue tv : rdn.getTypesAndValues()) {
            this.oids.add(tv.getType());
            ASN1Encodable val = tv.getValue();
            this.addValue(val);
            this.addType(runtime, val);
        }
    }

    private void fromASN1Set(ASN1Object element) {
        ASN1Set typeAndValue = ASN1Set.getInstance((Object)element);
        for (int i2 = 0; i2 < typeAndValue.size(); ++i2) {
            this.fromASN1Sequence(typeAndValue.getObjectAt(i2));
        }
    }

    private void fromASN1Sequence(ASN1Encodable element) {
        ASN1Sequence typeAndValue = ASN1Sequence.getInstance((Object)element);
        this.oids.add((ASN1ObjectIdentifier)typeAndValue.getObjectAt(0));
        ASN1Encodable val = typeAndValue.getObjectAt(1);
        this.addValue(val);
        this.addType(this.getRuntime(), val);
    }

    private void addValue(ASN1Encodable value2) {
        if (value2 instanceof ASN1String) {
            this.values.add(value2);
        } else {
            OpenSSL.warn(this.getRuntime().getCurrentContext(), (Object)((Object)this) + " addValue() value not an ASN1 string = '" + value2 + "' (" + (value2 == null ? "" : value2.getClass().getName()) + ")");
            this.values.add(value2);
        }
    }

    private void addType(Ruby runtime, ASN1Encodable value2) {
        this.name = null;
        Integer type = ASN1.typeId(value2);
        if (type == null) {
            OpenSSL.warn(runtime.getCurrentContext(), (Object)((Object)this) + " addType() could not resolve type for: " + value2 + " (" + (value2 == null ? "" : value2.getClass().getName()) + ")");
            this.types.add((RubyInteger)runtime.getNil());
        } else {
            this.types.add((RubyInteger)runtime.newFixnum(type.intValue()));
        }
    }

    private void addEntry(ASN1ObjectIdentifier oid2, RubyString value2, RubyInteger type) throws IOException {
        this.name = null;
        this.oids.add(oid2);
        ASN1Primitive convertedValue = X509Name.getNameEntryConverted().getConvertedValue(oid2, value2.toString());
        this.values.add((ASN1Encodable)convertedValue);
        this.types.add(type);
    }

    private static X509NameEntryConverter getNameEntryConverted() {
        return new X509DefaultEntryConverter();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2) {
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject str_or_dn) {
        return this.initialize(context2, str_or_dn, context2.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject dn, IRubyObject template) {
        Ruby runtime = context2.runtime;
        if (dn instanceof RubyArray) {
            RubyArray ary = (RubyArray)dn;
            RubyClass _Name = X509Name._Name(runtime);
            if (template.isNil()) {
                template = _Name.getConstant("OBJECT_TYPE_TEMPLATE");
            }
            for (int i2 = 0; i2 < ary.size(); ++i2) {
                IRubyObject entry2;
                IRubyObject obj = ary.eltOk((long)i2);
                if (!(obj instanceof RubyArray)) {
                    throw runtime.newTypeError(obj, runtime.getArray());
                }
                RubyArray arr = (RubyArray)obj;
                IRubyObject entry0 = arr.size() > 0 ? arr.eltOk(0L) : context2.nil;
                IRubyObject entry1 = arr.size() > 1 ? arr.eltOk(1L) : context2.nil;
                IRubyObject iRubyObject = entry2 = arr.size() > 2 ? arr.eltOk(2L) : context2.nil;
                if (entry2.isNil()) {
                    entry2 = template.callMethod(context2, "[]", entry0);
                }
                if (entry2.isNil()) {
                    entry2 = _Name.getConstant("DEFAULT_OBJECT_TYPE");
                }
                this.add_entry(context2, entry0, entry1, entry2);
            }
        } else {
            IRubyObject enc = OpenSSL.to_der_if_possible(context2, dn);
            this.fromASN1Sequence(enc.asString().getBytes());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context2, IRubyObject oid2, IRubyObject value2) {
        return this.add_entry(context2, oid2, value2, null);
    }

    @JRubyMethod
    public IRubyObject add_entry(ThreadContext context2, IRubyObject oid2, IRubyObject value2, IRubyObject type) {
        ASN1ObjectIdentifier objectId;
        Ruby runtime = context2.runtime;
        RubyString oidStr = oid2.asString();
        if (type == null || type.isNil()) {
            type = X509Name.getDefaultType(context2, oidStr);
        }
        try {
            objectId = ASN1.getObjectID(runtime, oidStr.toString());
        }
        catch (IllegalArgumentException e) {
            throw X509Name.newNameError(runtime, "invalid field name: " + oidStr, e);
        }
        if (objectId == null) {
            throw X509Name.newNameError(runtime, "invalid field name");
        }
        try {
            this.addEntry(objectId, value2.asString(), (RubyInteger)type);
        }
        catch (IOException e) {
            throw X509Name.newNameError(runtime, "invalid value", e);
        }
        return this;
    }

    private static IRubyObject getDefaultType(ThreadContext context2, RubyString oid2) {
        IRubyObject template = X509Name._Name(context2.runtime).getConstant("OBJECT_TYPE_TEMPLATE");
        if (template instanceof RubyHash) {
            return ((RubyHash)template).op_aref(context2, (IRubyObject)oid2);
        }
        return template.callMethod(context2, "[]", (IRubyObject)oid2);
    }

    @JRubyMethod(name={"to_s"}, rest=true)
    public IRubyObject to_s(IRubyObject[] args) {
        Iterator<ASN1Encodable> valuesIter;
        Iterator<ASN1ObjectIdentifier> oidsIter;
        Ruby runtime = this.getRuntime();
        int flag = 0;
        if (args.length > 0 && !args[0].isNil()) {
            flag = RubyNumeric.fix2int((IRubyObject)args[0]);
        }
        if (flag == 17892119) {
            ArrayList<ASN1ObjectIdentifier> reverseOids = new ArrayList<ASN1ObjectIdentifier>(this.oids);
            ArrayList<ASN1Encodable> reverseValues = new ArrayList<ASN1Encodable>(this.values);
            Collections.reverse(reverseOids);
            Collections.reverse(reverseValues);
            oidsIter = reverseOids.iterator();
            valuesIter = reverseValues.iterator();
        } else {
            oidsIter = this.oids.iterator();
            valuesIter = this.values.iterator();
        }
        StringBuilder str = new StringBuilder(48);
        String sep = "";
        block5: while (oidsIter.hasNext()) {
            ASN1ObjectIdentifier oid2 = oidsIter.next();
            String oName = X509Name.name(runtime, oid2);
            if (oName == null) {
                oName = oid2.toString();
            }
            ASN1Encodable value2 = valuesIter.next();
            switch (flag) {
                case 17892119: {
                    str.append(sep).append(oName).append('=').append(value2);
                    sep = ",";
                    continue block5;
                }
                case 8520479: {
                    str.append(sep).append(oName).append(" = ").append(value2);
                    sep = ",";
                    continue block5;
                }
                case 44302342: {
                    String ln2;
                    Integer nid = ASN1.oid2nid(runtime, oid2);
                    if (nid != null && (ln2 = ASN1.nid2ln(runtime, nid)) != null) {
                        oName = ln2;
                    }
                    str.append(sep).append(oName).append(" = ").append(value2);
                    sep = "\n";
                    continue block5;
                }
            }
            str.append('/').append(oName).append('=').append(value2);
        }
        return runtime.newString(str.toString());
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return ObjectSupport.inspect((RubyBasicObject)this, Collections.EMPTY_LIST);
    }

    @JRubyMethod
    public RubyArray to_a() {
        Ruby runtime = this.getRuntime();
        RubyArray entries = runtime.newArray(this.oids.size());
        Iterator<ASN1ObjectIdentifier> oidsIter = this.oids.iterator();
        Iterator<ASN1Encodable> valuesIter = this.values.iterator();
        Iterator<RubyInteger> typesIter = this.types.iterator();
        while (oidsIter.hasNext()) {
            ASN1ObjectIdentifier oid2 = oidsIter.next();
            String oName = X509Name.name(runtime, oid2);
            if (oName == null) {
                oName = oid2.toString();
            }
            String value2 = valuesIter.next().toString();
            IRubyObject type = (IRubyObject)typesIter.next();
            IRubyObject[] entry = new IRubyObject[]{runtime.newString(oName), runtime.newString(value2), type};
            entries.append((IRubyObject)runtime.newArrayNoCopy(entry));
        }
        return entries;
    }

    private static String name(Ruby runtime, ASN1ObjectIdentifier oid2) {
        return ASN1.oid2name(runtime, oid2, true);
    }

    @Deprecated
    org.bouncycastle.asn1.x509.X509Name getRealName() {
        Vector<String> strValues = new Vector<String>();
        for (ASN1Encodable value2 : this.values) {
            strValues.add(value2.toString());
        }
        return new org.bouncycastle.asn1.x509.X509Name(new Vector<ASN1ObjectIdentifier>(this.oids), strValues);
    }

    final X500Name getX500Name() {
        if (this.name != null) {
            return this.name;
        }
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        for (int i2 = 0; i2 < this.oids.size(); ++i2) {
            builder.addRDN(this.oids.get(i2), this.values.get(i2));
        }
        this.name = builder.build();
        return this.name;
    }

    @JRubyMethod(name={"cmp", "<=>"})
    public RubyFixnum cmp(IRubyObject other) {
        if (this.equals(other)) {
            return RubyFixnum.zero((Ruby)this.getRuntime());
        }
        if (other instanceof X509Name) {
            X509Name that = (X509Name)other;
            X500Name thisName = this.getX500Name();
            X500Name thatName = that.getX500Name();
            int cmp2 = thisName.toString().compareTo(thatName.toString());
            return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)cmp2);
        }
        return RubyFixnum.one((Ruby)this.getRuntime());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof X509Name) {
            X509Name that = (X509Name)((Object)other);
            X500Name thisName = this.getX500Name();
            X500Name thatName = that.getX500Name();
            return thisName.equals((Object)thatName);
        }
        return false;
    }

    public int hashCode() {
        try {
            return Name.hash(this.getX500Name());
        }
        catch (IOException e) {
            OpenSSL.debugStackTrace(this.getRuntime(), e);
            return 0;
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(this.getRuntime(), e);
            return 0;
        }
    }

    @JRubyMethod(name={"eql?"})
    public RubyBoolean eql_p(ThreadContext context2, IRubyObject other) {
        if (!(other instanceof X509Name)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.equals(other));
    }

    public IRubyObject eql_p(IRubyObject obj) {
        return this.eql_p(this.getRuntime().getCurrentContext(), obj);
    }

    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod
    public RubyString to_der(ThreadContext context2) {
        DLSequence seq;
        Ruby runtime = context2.runtime;
        if (this.oids.size() > 0) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            ASN1ObjectIdentifier lastOid = null;
            for (int i2 = 0; i2 != this.oids.size(); ++i2) {
                ASN1ObjectIdentifier oid2 = this.oids.get(i2);
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add((ASN1Encodable)oid2);
                v.add(this.values.get(i2));
                if (lastOid == null) {
                    sVec.add((ASN1Encodable)new DLSequence(v));
                } else {
                    vec.add((ASN1Encodable)new DLSet(sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add((ASN1Encodable)new DLSequence(v));
                }
                lastOid = oid2;
            }
            vec.add((ASN1Encodable)new DLSet(sVec));
            seq = new DLSequence(vec);
        } else {
            seq = new DLSequence();
        }
        try {
            return StringHelper.newString(runtime, seq.getEncoded("DER"));
        }
        catch (IOException e) {
            throw X509Name.newNameError(runtime, e);
        }
    }

    private ASN1Primitive convert(ASN1ObjectIdentifier oid2, String value2, int type) {
        Class<? extends ASN1Encodable> clazz = ASN1.typeClass(type);
        try {
            Constructor<? extends ASN1Encodable> ctor;
            if (clazz != null && null != (ctor = clazz.getConstructor(String.class))) {
                return (ASN1Primitive)ctor.newInstance(value2);
            }
            return new X509DefaultEntryConverter().getConvertedValue(oid2, value2);
        }
        catch (NoSuchMethodException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (InstantiationException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (IllegalAccessException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (IllegalArgumentException e) {
            throw X509Name.newNameError(this.getRuntime(), e);
        }
        catch (InvocationTargetException e) {
            throw X509Name.newNameError(this.getRuntime(), e.getTargetException());
        }
        catch (RuntimeException e) {
            OpenSSL.debugStackTrace(this.getRuntime(), e);
            throw X509Name.newNameError(this.getRuntime(), e);
        }
    }

    private static RaiseException newNameError(Ruby runtime, String msg, Throwable e) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("NameError"), msg, e);
    }

    private static RaiseException newNameError(Ruby runtime, Throwable e) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("NameError"), e);
    }

    private static RaiseException newNameError(Ruby runtime, String message) {
        return Utils.newError(runtime, X509._X509(runtime).getClass("NameError"), message);
    }
}

