/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.util;

import com.sun.org.apache.xerces.internal.xs.StringList;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Vector;

public final class StringListImpl
extends AbstractList
implements StringList {
    public static final StringListImpl EMPTY_LIST = new StringListImpl(new String[0], 0);
    private final String[] fArray;
    private final int fLength;
    private final Vector fVector;

    public StringListImpl(Vector v) {
        this.fVector = v;
        this.fLength = v == null ? 0 : v.size();
        this.fArray = null;
    }

    public StringListImpl(String[] array, int length) {
        this.fArray = array;
        this.fLength = length;
        this.fVector = null;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public boolean contains(String item) {
        if (this.fVector != null) {
            return this.fVector.contains(item);
        }
        if (item == null) {
            for (int i = 0; i < this.fLength; ++i) {
                if (this.fArray[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.fLength; ++i) {
                if (!item.equals(this.fArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String item(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        if (this.fVector != null) {
            return (String)this.fVector.elementAt(index);
        }
        return this.fArray[index];
    }

    public Object get(int index) {
        if (index >= 0 && index < this.fLength) {
            if (this.fVector != null) {
                return this.fVector.elementAt(index);
            }
            return this.fArray[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public Object[] toArray() {
        if (this.fVector != null) {
            return this.fVector.toArray();
        }
        Object[] a = new Object[this.fLength];
        this.toArray0(a);
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (this.fVector != null) {
            return this.fVector.toArray(a);
        }
        if (a.length < this.fLength) {
            Class<?> arrayClass = a.getClass();
            Class<?> componentType = arrayClass.getComponentType();
            a = (Object[])Array.newInstance(componentType, this.fLength);
        }
        this.toArray0(a);
        if (a.length > this.fLength) {
            a[this.fLength] = null;
        }
        return a;
    }

    private void toArray0(Object[] a) {
        if (this.fLength > 0) {
            System.arraycopy(this.fArray, 0, a, 0, this.fLength);
        }
    }
}

