/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class Territories {
    private static final String ISO3166_1 = "ISO3166-1:alpha2";
    private static final String ISO3166_2 = "ISO3166-2";
    private static DataSet dataSet;
    private static volatile Map<String, GeoPropertyIndex<Boolean>> iso3166Cache;

    private Territories() {
    }

    public static synchronized Set<String> getKnownIso3166Codes() {
        return iso3166Cache.keySet();
    }

    public static synchronized boolean isIso3166Code(String string, LatLon latLon) {
        GeoPropertyIndex<Boolean> geoPropertyIndex = iso3166Cache.get(string);
        if (geoPropertyIndex == null) {
            Main.warn(I18n.tr("Unknown territory id: {0}", string));
            return false;
        }
        return geoPropertyIndex.get(latLon);
    }

    public static synchronized DataSet getDataSet() {
        return new DataSet(dataSet);
    }

    public static synchronized void initialize() {
        iso3166Cache = new HashMap<String, GeoPropertyIndex<Boolean>>();
        try (CachedFile cachedFile = new CachedFile("resource://data/boundaries.osm");
             InputStream inputStream = cachedFile.getInputStream();){
            dataSet = OsmReader.parseDataSet(inputStream, null);
            ArrayList<Way> arrayList = new ArrayList<Way>(dataSet.getWays());
            arrayList.addAll(dataSet.getRelations());
            for (OsmPrimitive osmPrimitive : arrayList) {
                String string = osmPrimitive.get(ISO3166_1);
                String string2 = osmPrimitive.get(ISO3166_2);
                if (string == null && string2 == null) continue;
                DefaultGeoProperty defaultGeoProperty = osmPrimitive instanceof Way ? new DefaultGeoProperty(Collections.singleton((Way)osmPrimitive)) : new DefaultGeoProperty((Relation)osmPrimitive);
                GeoPropertyIndex<Boolean> geoPropertyIndex = new GeoPropertyIndex<Boolean>(defaultGeoProperty, 24);
                if (string != null) {
                    iso3166Cache.put(string, geoPropertyIndex);
                }
                if (string2 == null) continue;
                iso3166Cache.put(string2, geoPropertyIndex);
            }
        }
        catch (IOException | IllegalDataException exception) {
            throw new JosmRuntimeException(exception);
        }
    }
}

