/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.metaobject;

import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.GetPropertyResult;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.SetPropertyResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeDynamicObject
extends AbstractDynamicObject {
    private static final DynamicObject[] NONE = new DynamicObject[0];
    private DynamicObject[] objects = NONE;
    private DynamicObject[] updateObjects = NONE;

    protected void setObjects(DynamicObject ... objects) {
        this.objects = objects;
        this.updateObjects = objects;
    }

    protected void setObjectsForUpdate(DynamicObject ... objects) {
        this.updateObjects = objects;
    }

    @Override
    public boolean hasProperty(String name) {
        for (DynamicObject object : this.objects) {
            if (!object.hasProperty(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getProperty(String name, GetPropertyResult result) {
        for (DynamicObject object : this.objects) {
            object.getProperty(name, result);
            if (!result.isFound()) continue;
            return;
        }
    }

    @Override
    public void setProperty(String name, Object value, SetPropertyResult result) {
        for (DynamicObject object : this.updateObjects) {
            object.setProperty(name, value, result);
            if (!result.isFound()) continue;
            return;
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = this.objects.length - 1; i >= 0; --i) {
            DynamicObject object = this.objects[i];
            properties.putAll(object.getProperties());
        }
        properties.put("properties", properties);
        return properties;
    }

    @Override
    public boolean hasMethod(String name, Object ... arguments) {
        for (DynamicObject object : this.objects) {
            if (!object.hasMethod(name, arguments)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invokeMethod(String name, InvokeMethodResult result, Object ... arguments) {
        for (DynamicObject object : this.objects) {
            object.invokeMethod(name, result, arguments);
            if (!result.isFound()) continue;
            return;
        }
    }
}

