/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.cache.TaskOutputPacker;

public class ZipTaskOutputPacker
implements TaskOutputPacker {
    private static final Pattern PROPERTY_PATH = Pattern.compile("property-([^/]+)(?:/(.*))?");

    public void pack(TaskOutputsInternal taskOutputs, OutputStream output) throws IOException {
        final ZipOutputStream zipOutput = new ZipOutputStream(output);
        block6: for (TaskOutputFilePropertySpec spec : taskOutputs.getFileProperties()) {
            CacheableTaskOutputFilePropertySpec propertySpec = (CacheableTaskOutputFilePropertySpec)spec;
            String propertyName = propertySpec.getPropertyName();
            switch (propertySpec.getOutputType()) {
                case DIRECTORY: {
                    final String propertyRoot = "property-" + propertyName + "/";
                    zipOutput.putNextEntry(new ZipEntry(propertyRoot));
                    new DirectoryFileTree(propertySpec.getOutputFile()).visit(new FileVisitor(){

                        public void visitDir(FileVisitDetails dirDetails) {
                            String path = dirDetails.getRelativePath().getPathString();
                            try {
                                zipOutput.putNextEntry(new ZipEntry(propertyRoot + path + "/"));
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }

                        public void visitFile(FileVisitDetails fileDetails) {
                            String path = fileDetails.getRelativePath().getPathString();
                            try {
                                zipOutput.putNextEntry(new ZipEntry(propertyRoot + path));
                                fileDetails.copyTo(zipOutput);
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                    continue block6;
                }
                case FILE: {
                    try {
                        zipOutput.putNextEntry(new ZipEntry("property-" + propertyName));
                        Files.copy((File)propertySpec.getOutputFile(), (OutputStream)zipOutput);
                        continue block6;
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
            throw new AssertionError();
        }
        zipOutput.finish();
    }

    public void unpack(TaskOutputsInternal taskOutputs, InputStream input) throws IOException {
        ZipEntry entry;
        ImmutableMap propertySpecs = Maps.uniqueIndex(taskOutputs.getFileProperties(), (Function)new Function<TaskFilePropertySpec, String>(){

            public String apply(TaskFilePropertySpec propertySpec) {
                return propertySpec.getPropertyName();
            }
        });
        ZipInputStream zipInput = new ZipInputStream(input);
        while ((entry = zipInput.getNextEntry()) != null) {
            String name = entry.getName();
            Matcher matcher = PROPERTY_PATH.matcher(name);
            if (!matcher.matches()) continue;
            String propertyName = matcher.group(1);
            CacheableTaskOutputFilePropertySpec propertySpec = (CacheableTaskOutputFilePropertySpec)propertySpecs.get(propertyName);
            if (propertySpec == null) {
                throw new IllegalStateException(String.format("No output property '%s' registered", propertyName));
            }
            String path = matcher.group(2);
            File outputFile = Strings.isNullOrEmpty((String)path) ? propertySpec.getOutputFile() : new File(propertySpec.getOutputFile(), path);
            if (entry.isDirectory()) {
                if (propertySpec.getOutputType() != CacheableTaskOutputFilePropertySpec.OutputType.DIRECTORY) {
                    throw new IllegalStateException("Property should be an output directory property: " + propertyName);
                }
                FileUtils.forceMkdir((File)outputFile);
                continue;
            }
            Files.createParentDirs((File)outputFile);
            Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)zipInput);
        }
    }
}

