/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import java.io.InputStream;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public final class UnsafeMemoryInput
extends ByteBufferInput {
    private long bufaddress;

    public UnsafeMemoryInput() {
        this.varIntsEnabled = false;
    }

    public UnsafeMemoryInput(int n) {
        super(n);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(byte[] byArray) {
        super(byArray);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(ByteBuffer byteBuffer) {
        super(byteBuffer, 0, byteBuffer.position());
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(long l, int n) {
        super(l, n);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(InputStream inputStream) {
        super(inputStream);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(InputStream inputStream, int n) {
        super(inputStream, n);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    @Override
    public void setBuffer(ByteBuffer byteBuffer, int n, int n2) {
        super.setBuffer(byteBuffer, n, n2);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufaddress = ((DirectBuffer)((Object)this.niobuffer)).address();
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        int n = UnsafeUtil.unsafe().getInt(this.bufaddress + (long)this.position);
        this.position += 4;
        return n;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        float f = UnsafeUtil.unsafe().getFloat(this.bufaddress + (long)this.position);
        this.position += 4;
        return f;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        short s = UnsafeUtil.unsafe().getShort(this.bufaddress + (long)this.position);
        this.position += 2;
        return s;
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        long l = UnsafeUtil.unsafe().getLong(this.bufaddress + (long)this.position);
        this.position += 8;
        return l;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        this.niobuffer.position(this.position);
        return super.readBoolean();
    }

    @Override
    public byte readByte() throws KryoException {
        this.niobuffer.position(this.position);
        return super.readByte();
    }

    @Override
    public char readChar() throws KryoException {
        this.niobuffer.position(this.position);
        return super.readChar();
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        double d = UnsafeUtil.unsafe().getDouble(this.bufaddress + (long)this.position);
        this.position += 8;
        return d;
    }

    @Override
    public int readInt(boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            return this.readInt();
        }
        return super.readInt(bl);
    }

    @Override
    public long readLong(boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            return this.readLong();
        }
        return super.readLong(bl);
    }

    @Override
    public final int[] readInts(int n, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            int n2 = n << 2;
            int[] nArray = new int[n];
            this.readBytes(nArray, UnsafeUtil.intArrayBaseOffset, 0L, n2);
            return nArray;
        }
        return super.readInts(n, bl);
    }

    @Override
    public final long[] readLongs(int n, boolean bl) throws KryoException {
        if (!this.varIntsEnabled) {
            int n2 = n << 3;
            long[] lArray = new long[n];
            this.readBytes(lArray, UnsafeUtil.longArrayBaseOffset, 0L, n2);
            return lArray;
        }
        return super.readLongs(n, bl);
    }

    @Override
    public final float[] readFloats(int n) throws KryoException {
        int n2 = n << 2;
        float[] fArray = new float[n];
        this.readBytes(fArray, UnsafeUtil.floatArrayBaseOffset, 0L, n2);
        return fArray;
    }

    @Override
    public final short[] readShorts(int n) throws KryoException {
        int n2 = n << 1;
        short[] sArray = new short[n];
        this.readBytes(sArray, UnsafeUtil.shortArrayBaseOffset, 0L, n2);
        return sArray;
    }

    @Override
    public final char[] readChars(int n) throws KryoException {
        int n2 = n << 1;
        char[] cArray = new char[n];
        this.readBytes(cArray, UnsafeUtil.charArrayBaseOffset, 0L, n2);
        return cArray;
    }

    @Override
    public final double[] readDoubles(int n) throws KryoException {
        int n2 = n << 2;
        double[] dArray = new double[n];
        this.readBytes(dArray, UnsafeUtil.doubleArrayBaseOffset, 0L, n2);
        return dArray;
    }

    public final void readBytes(Object object, long l, long l2) throws KryoException {
        if (!object.getClass().isArray()) {
            throw new KryoException("Only bulk reads of arrays is supported");
        }
        this.readBytes(object, 0L, l, (int)l2);
    }

    private final void readBytes(Object object, long l, long l2, int n) throws KryoException {
        int n2 = Math.min(this.limit - this.position, n);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(null, this.bufaddress + (long)this.position, object, l + l2, n2);
            this.position += n2;
            if ((n -= n2) == 0) break;
            l2 += (long)n2;
            n2 = Math.min(n, this.capacity);
            this.require(n2);
        }
    }
}

