/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.client.api.XmlParser;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.XmlContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import org.jetbrains.android.inspections.klint.DomPsiConverter;
import org.jetbrains.android.inspections.klint.IntellijLintUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DomPsiParser
extends XmlParser {
    private final LintClient myClient;
    private AccessToken myReadLock;

    public DomPsiParser(LintClient client) {
        this.myClient = client;
    }

    @Override
    public void dispose(@NonNull XmlContext context, @NonNull Document document) {
        if (context.document != null) {
            this.myReadLock.finish();
            this.myReadLock = null;
            context.document = null;
        }
    }

    @Override
    public int getNodeStartOffset(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        return textRange.getStartOffset();
    }

    @Override
    public int getNodeEndOffset(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        return textRange.getEndOffset();
    }

    @Override
    @Nullable
    public Document parseXml(@NonNull XmlContext context) {
        assert (this.myReadLock == null);
        this.myReadLock = ApplicationManager.getApplication().acquireReadActionLock();
        Document document = this.parse(context);
        if (document == null) {
            this.myReadLock.finish();
            this.myReadLock = null;
        }
        return document;
    }

    @Nullable
    private Document parse(XmlContext context) {
        assert (ApplicationManager.getApplication().isReadAccessAllowed());
        PsiFile psiFile = IntellijLintUtils.getPsiFile(context);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        try {
            return DomPsiConverter.convert(xmlFile);
        }
        catch (Throwable t) {
            this.myClient.log(t, "Failed converting PSI parse tree to DOM for file %1$s", context.file.getPath());
            return null;
        }
    }

    @Override
    @NonNull
    public Location getLocation(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create(context.file, start, end);
    }

    @Override
    @NonNull
    public Location getLocation(@NonNull XmlContext context, @NonNull Node node, int startDelta, int endDelta) {
        TextRange textRange = DomPsiConverter.getTextRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset() + startDelta);
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getStartOffset() + endDelta);
        return Location.create(context.file, start, end);
    }

    @Override
    @NonNull
    public Location getNameLocation(@NonNull XmlContext context, @NonNull Node node) {
        TextRange textRange = DomPsiConverter.getTextNameRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create(context.file, start, end);
    }

    @Override
    @NonNull
    public Location getValueLocation(@NonNull XmlContext context, @NonNull Attr node) {
        TextRange textRange = DomPsiConverter.getTextValueRange(node);
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create(context.file, start, end);
    }

    @Override
    @NonNull
    public Location.Handle createLocationHandle(@NonNull XmlContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    private static class LocationHandle
    implements Location.Handle {
        private final File myFile;
        private final Node myNode;
        private Object myClientData;

        public LocationHandle(File file, Node node) {
            this.myFile = file;
            this.myNode = node;
        }

        @Override
        @NonNull
        public Location resolve() {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (Location)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Location>(){

                    public Location compute() {
                        return this.resolve();
                    }
                });
            }
            TextRange textRange = DomPsiConverter.getTextRange(this.myNode);
            DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
            DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
            return Location.create(this.myFile, start, end);
        }

        @Override
        public void setClientData(@Nullable Object clientData) {
            this.myClientData = clientData;
        }

        @Override
        @Nullable
        public Object getClientData() {
            return this.myClientData;
        }
    }
}

