/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class ToastDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("ShowToast", "Toast created but not shown", "`Toast.makeText()` creates a `Toast` but does *not* show it. You must call `show()` on the resulting object to actually make the `Toast` appear.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ToastDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("makeText");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod uMethod) {
        UMethod surroundingDeclaration;
        UExpression duration;
        PsiMethod method = uMethod.getPsi();
        if (!JavaEvaluator.isMemberInClass((PsiMember)method, "android.widget.Toast")) {
            return;
        }
        List<UExpression> args = call.getValueArguments();
        if (args.size() == 3 && (duration = args.get(2)) instanceof ULiteralExpression) {
            context.report(ISSUE, duration, context.getUastLocation(duration), "Expected duration `Toast.LENGTH_SHORT` or `Toast.LENGTH_LONG`, a custom duration value is not supported");
        }
        if ((surroundingDeclaration = UastUtils.getParentOfType((UElement)call, true, UMethod.class, UBlockExpression.class, ULambdaExpression.class)) == null) {
            return;
        }
        ShowFinder finder = new ShowFinder(call);
        surroundingDeclaration.accept(finder);
        if (!finder.isShowCalled()) {
            context.report(ISSUE, call, context.getUastNameLocation(call), "Toast created but not shown: did you forget to call `show()` ?");
        }
    }

    private static class ShowFinder
    extends AbstractUastVisitor {
        private final UCallExpression mTarget;
        private boolean mFound;
        private boolean mSeenTarget;

        private ShowFinder(UCallExpression target) {
            this.mTarget = target;
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            if (node.equals(this.mTarget)) {
                this.mSeenTarget = true;
            } else if ((this.mSeenTarget || this.mTarget.equals(node.getReceiver())) && "show".equals(node.getMethodName())) {
                this.mFound = true;
            }
            return super.visitCallExpression(node);
        }

        @Override
        public boolean visitReturnExpression(UReturnExpression node) {
            if (UastUtils.isChildOf(this.mTarget, node.getReturnExpression(), true)) {
                this.mFound = true;
            }
            return super.visitReturnExpression(node);
        }

        private boolean isShowCalled() {
            return this.mFound;
        }
    }
}

