/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.PermissionRequirement;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.JavaContext;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiVariable;
import java.util.List;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

public class PermissionFinder {
    @NonNull
    private final JavaContext mContext;
    @NonNull
    private final Operation mOperation;

    @Nullable
    public static Result findRequiredPermissions(@NonNull Operation operation, @NonNull JavaContext context, @NonNull UElement parameter) {
        return new PermissionFinder(context, operation).search(parameter);
    }

    private PermissionFinder(@NonNull JavaContext context, @NonNull Operation operation) {
        this.mContext = context;
        this.mOperation = operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Result search(@NonNull UElement node) {
        PsiVariable variable2;
        UExpression lastAssignment;
        if (UastLiteralUtils.isNullLiteral(node)) {
            return null;
        }
        if (node instanceof UIfExpression) {
            Result result;
            UIfExpression expression2 = (UIfExpression)node;
            if (expression2.getThenExpression() != null && (result = this.search(expression2.getThenExpression())) != null) {
                return result;
            }
            if (expression2.getElseExpression() == null || (result = this.search(expression2.getElseExpression())) == null) return null;
            return result;
        }
        if (UastExpressionUtils.isTypeCast(node)) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)node;
            UExpression operand2 = cast.getOperand();
            return this.search(operand2);
        }
        if (node instanceof UParenthesizedExpression) {
            UParenthesizedExpression parens = (UParenthesizedExpression)node;
            UExpression expression3 = parens.getExpression();
            if (expression3 == null) return null;
            return this.search(expression3);
        }
        if (UastExpressionUtils.isConstructorCall(node) && this.mOperation == Operation.ACTION) {
            UExpression action;
            List<UExpression> expressions2;
            String type2;
            UCallExpression call = (UCallExpression)node;
            UReferenceExpression classReference2 = call.getClassReference();
            String string = type2 = classReference2 != null ? UastUtils.getQualifiedName(classReference2) : null;
            if (!"android.content.Intent".equals(type2) || (expressions2 = call.getValueArguments()).isEmpty() || (action = expressions2.get(0)) == null) return null;
            return this.search(action);
        }
        if (!(node instanceof UReferenceExpression)) return null;
        PsiElement resolved = ((UReferenceExpression)node).resolve();
        if (resolved instanceof PsiField) {
            UField field = (UField)this.mContext.getUastContext().convertElementWithParent(resolved, UField.class);
            if (field == null) {
                return null;
            }
            if (this.mOperation == Operation.ACTION) {
                UAnnotation annotation = field.findAnnotation("android.support.annotation.RequiresPermission");
                if (annotation != null) {
                    return this.getPermissionRequirement(field, annotation);
                }
            } else if (this.mOperation == Operation.READ || this.mOperation == Operation.WRITE) {
                String fqn = this.mOperation == Operation.READ ? "android.support.annotation.RequiresPermission.Read" : "android.support.annotation.RequiresPermission.Write";
                UAnnotation annotation = field.findAnnotation(fqn);
                if (annotation != null) {
                    UNamedExpression o;
                    List<UNamedExpression> attributes = annotation.getAttributeValues();
                    UNamedExpression uNamedExpression = o = attributes.size() == 1 ? attributes.get(0) : null;
                    if (o == null || !(o.getExpression() instanceof UAnnotation)) return this.getPermissionRequirement(field, annotation);
                    annotation = (UAnnotation)((Object)o.getExpression());
                    if ("android.support.annotation.RequiresPermission".equals(annotation.getQualifiedName())) {
                        return this.getPermissionRequirement(field, annotation);
                    }
                }
            } else assert (false) : this.mOperation;
        }
        if (!(resolved instanceof PsiVariable) || (lastAssignment = UastLintUtils.findLastAssignment(variable2 = (PsiVariable)resolved, node, this.mContext)) == null) return null;
        return this.search(lastAssignment);
    }

    @NonNull
    private Result getPermissionRequirement(@NonNull PsiField field, @NonNull UAnnotation annotation) {
        String name;
        PermissionRequirement requirement = PermissionRequirement.create(annotation);
        PsiClass containingClass = field.getContainingClass();
        String string = name = containingClass != null ? containingClass.getName() + "." + field.getName() : field.getName();
        assert (name != null);
        return new Result(this.mOperation, requirement, name);
    }

    public static class Result {
        @NonNull
        public final PermissionRequirement requirement;
        @NonNull
        public final String name;
        @NonNull
        public final Operation operation;

        public Result(@NonNull Operation operation, @NonNull PermissionRequirement requirement, @NonNull String name) {
            this.operation = operation;
            this.requirement = requirement;
            this.name = name;
        }
    }

    public static enum Operation {
        CALL,
        ACTION,
        READ,
        WRITE;


        public String prefix() {
            switch (this) {
                case ACTION: {
                    return "by intent";
                }
                case READ: {
                    return "to read";
                }
                case WRITE: {
                    return "to write";
                }
            }
            return "by";
        }
    }
}

