/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class GetSignaturesDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("PackageManagerGetSignatures", "Potential Multiple Certificate Exploit", "Improper validation of app signatures could lead to issues where a malicious app submits itself to the Play Store with both its real certificate and a fake certificate and gains access to functionality or information it shouldn't have due to another application only checking for the fake certificate and ignoring the rest. Please make sure to validate all signatures returned by this method.", Category.SECURITY, 8, Severity.INFORMATIONAL, new Implementation(GetSignaturesDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://bluebox.com/technical/android-fake-id-vulnerability/");
    private static final String PACKAGE_MANAGER_CLASS = "android.content.pm.PackageManager";
    private static final String GET_PACKAGE_INFO = "getPackageInfo";
    private static final int GET_SIGNATURES_FLAG = 64;

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_PACKAGE_INFO);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.methodMatches(method, PACKAGE_MANAGER_CLASS, true, "java.lang.String", "int")) {
            return;
        }
        List<UExpression> arguments = node.getValueArguments();
        UExpression second = arguments.get(1);
        Object number = ConstantEvaluator.evaluate(context, second);
        if (number instanceof Number) {
            int flagValue = ((Number)number).intValue();
            GetSignaturesDetector.maybeReportIssue(flagValue, context, node, second);
        }
    }

    private static void maybeReportIssue(int flagValue, JavaContext context, UCallExpression node, UExpression last) {
        if ((flagValue & 0x40) != 0) {
            context.report(ISSUE, node, context.getUastLocation(last), "Reading app signatures from getPackageInfo: The app signatures could be exploited if not validated properly; see issue explanation for details.");
        }
    }
}

