/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.lang.reflect.Method;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.vintage.engine.discovery.TestClassCollector;

class MethodSelectorResolver
extends DiscoverySelectorResolver<MethodSelector> {
    MethodSelectorResolver() {
        super(MethodSelector.class);
    }

    @Override
    void resolve(MethodSelector selector, TestClassCollector collector) {
        Class testClass = selector.getJavaClass();
        Method testMethod = selector.getJavaMethod();
        Description methodDescription = Description.createTestDescription((Class)testClass, (String)testMethod.getName());
        collector.addFiltered(testClass, RunnerTestDescriptorAwareFilter.adapter(Filter.matchMethodDescription((Description)methodDescription)));
    }
}

